/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.statistics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.statistics.IStatPrint;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.Map;
import java.util.SortedMap;

public class SheetStatPrinter
implements IStatPrint {
    private Sheet sheet;
    private static final int SUMMARY_START_ROW = 0;
    private static final String NUMBER_PATTERN = "0.00;-0.00";
    private long durationFactor;
    private long rateFactor;

    public SheetStatPrinter(Sheet sheet, long durationFactor, long rateFactor) {
        this.sheet = sheet;
        this.durationFactor = durationFactor;
        this.rateFactor = rateFactor;
    }

    @Override
    public void print(MetricRegistry registry) {
        this.sheet.getColRange(0, 0).setColumnWidth(200);
        this.sheet.getColRange(1, 1).setColumnWidth(140);
        this.sheet.getColRange(2, 3).setColumnWidth(200);
        this.sheet.getColRange(4, 9).setColumnWidth(140);
        this.sheet.getColRange(10, 11).setColumnWidth(220);
        this.sheet.getColRange(11, 12).setColumnWidth(140);
        this.sheet.getColRange(12, 16).setColumnWidth(140);
        this.createSummaryHeader();
        int formulaHeaderStart = this.fillSummary(1, registry.getMeters());
        if (formulaHeaderStart == 1) {
            formulaHeaderStart = 2;
        }
        this.createFormulaHeader(formulaHeaderStart);
        this.fillFormulaDetail(formulaHeaderStart + 1, registry.getTimers());
    }

    private void createSummaryHeader() {
        this.sheet.getCell(0, 0, true).setValue(new Variant((Object)"\u516c\u5f0f\u7edf\u8ba1\u6c47\u603b\\\u6267\u884c\u901f\u7387"));
        this.sheet.getCell(0, 1, true).setValue(new Variant((Object)"\u516c\u5f0f\u6267\u884c\u6570\uff08\u6b21\uff09"));
        this.sheet.getCell(0, 2, true).setValue(new Variant((Object)"\u5e73\u5747\u6bd4\u4f8b(\u6b21/s)"));
        this.sheet.getCell(0, 3, true).setValue(new Variant((Object)"\u8fd11\u5206\u949f\u901f\u7387(\u6b21/s)"));
        this.sheet.getCell(0, 4, true).setValue(new Variant((Object)"\u8fd15\u5206\u949f\u901f\u7387(\u6b21/s)"));
        this.sheet.getCell(0, 5, true).setValue(new Variant((Object)"\u8fd115\u5206\u949f\u901f\u7387(\u6b21/s)"));
    }

    private void createFormulaHeader(int rowStart) {
        this.sheet.getCell(rowStart, 0, true).setValue(new Variant((Object)"\u516c\u5f0f\u540d\\\u6307\u6807"));
        this.sheet.getCell(rowStart, 1, true).setValue(new Variant((Object)"\u6267\u884c\u6b21\u6570\uff08\u6b21\uff09"));
        this.sheet.getCell(rowStart, 2, true).setValue(new Variant((Object)"\u7d2f\u8ba1\u8017\u65f6\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 3, true).setValue(new Variant((Object)"\u5e73\u5747\u6bd4\u4f8b(\u6b21/s)"));
        this.sheet.getCell(rowStart, 4, true).setValue(new Variant((Object)"\u8fd11\u5206\u949f\u901f\u7387(\u6b21/s)"));
        this.sheet.getCell(rowStart, 5, true).setValue(new Variant((Object)"\u8fd15\u5206\u949f\u901f\u7387(\u6b21/s)"));
        this.sheet.getCell(rowStart, 6, true).setValue(new Variant((Object)"\u8fd115\u5206\u949f\u901f\u7387(\u6b21/s)"));
        this.sheet.getCell(rowStart, 7, true).setValue(new Variant((Object)"\u6700\u5c0f\u65f6\u95f4\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 8, true).setValue(new Variant((Object)"\u6700\u5927\u65f6\u95f4\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 9, true).setValue(new Variant((Object)"\u5e73\u5747\u65f6\u95f4\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 10, true).setValue(new Variant((Object)"\u5dee\u5206\uff08StdDev\uff09\u6267\u884c\u65f6\u95f4\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 11, true).setValue(new Variant((Object)"\u4e2d\u4f4d\u6570\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 12, true).setValue(new Variant((Object)"75%\u70b9\u6307\u6570\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 13, true).setValue(new Variant((Object)"95%\u70b9\u6307\u6570\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 14, true).setValue(new Variant((Object)"98%\u70b9\u6307\u6570\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 15, true).setValue(new Variant((Object)"99%\u70b9\u6307\u6570\uff08ms\uff09"));
        this.sheet.getCell(rowStart, 16, true).setValue(new Variant((Object)"99.9%\u70b9\u6307\u6570\uff08ms\uff09"));
    }

    private int fillSummary(int rowStart, SortedMap<String, Meter> meters) {
        if (null != meters && !meters.isEmpty()) {
            for (Map.Entry<String, Meter> entry : meters.entrySet()) {
                Meter meter = entry.getValue();
                Cell cell = this.sheet.getCell(rowStart, 0, true);
                StyleAttributes sa = Styles.getDefaultSA();
                sa.setNumberFormat(NUMBER_PATTERN);
                sa.setFontSize(12);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant((Object)entry.getKey()));
                cell = this.sheet.getCell(rowStart, 1, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(meter.getCount())));
                cell = this.sheet.getCell(rowStart, 2, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(meter.getMeanRate())));
                cell = this.sheet.getCell(rowStart, 3, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(meter.getOneMinuteRate())));
                cell = this.sheet.getCell(rowStart, 4, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(meter.getFiveMinuteRate())));
                cell = this.sheet.getCell(rowStart, 5, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(meter.getFifteenMinuteRate()));
                ++rowStart;
            }
        }
        return rowStart;
    }

    private int fillFormulaDetail(int rowStart, SortedMap<String, Timer> timers) {
        if (null != timers && !timers.isEmpty()) {
            for (Map.Entry<String, Timer> entry : timers.entrySet()) {
                Timer timer = entry.getValue();
                Snapshot snapshot = timer.getSnapshot();
                StyleAttributes sa = Styles.getDefaultSA();
                sa.setNumberFormat(NUMBER_PATTERN);
                sa.setFontSize(12);
                Cell cell = this.sheet.getCell(rowStart, 0, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant((Object)entry.getKey()));
                cell = this.sheet.getCell(rowStart, 1, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(timer.getCount())));
                cell = this.sheet.getCell(rowStart, 2, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(timer.getCount()) * this.convertDuration(snapshot.getMean())));
                cell = this.sheet.getCell(rowStart, 3, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(timer.getMeanRate())));
                cell = this.sheet.getCell(rowStart, 4, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(timer.getOneMinuteRate())));
                cell = this.sheet.getCell(rowStart, 5, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(timer.getFiveMinuteRate())));
                cell = this.sheet.getCell(rowStart, 6, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertRate(timer.getFifteenMinuteRate())));
                cell = this.sheet.getCell(rowStart, 7, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.getMin())));
                cell = this.sheet.getCell(rowStart, 8, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.getMax())));
                cell = this.sheet.getCell(rowStart, 9, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.getMean())));
                cell = this.sheet.getCell(rowStart, 10, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.getStdDev())));
                cell = this.sheet.getCell(rowStart, 11, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.getMedian())));
                cell = this.sheet.getCell(rowStart, 12, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.get75thPercentile())));
                cell = this.sheet.getCell(rowStart, 13, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.get95thPercentile())));
                cell = this.sheet.getCell(rowStart, 14, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.get98thPercentile())));
                cell = this.sheet.getCell(rowStart, 15, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.get99thPercentile())));
                cell = this.sheet.getCell(rowStart, 16, true);
                cell.setSSA((ShareStyleAttributes)sa);
                cell.setValue(new Variant(this.convertDuration(snapshot.get999thPercentile())));
                ++rowStart;
            }
        }
        return rowStart;
    }

    protected double convertDuration(double duration) {
        return duration / (double)this.durationFactor;
    }

    protected double convertRate(double rate) {
        return rate * (double)this.rateFactor;
    }
}

