/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import org.jdom2.Namespace;

class KmlUtil {
    KmlUtil() {
    }

    static int toScreenValue(double storeValue) {
        return (int)(storeValue * 4.0 / 3.0);
    }

    static double toStoreValue(double screenValue) {
        return screenValue * 3.0 / 4.0;
    }

    static int toStoreHoriSplit(int split) {
        return 285 + 15 * split;
    }

    static int toScreenHoriSplit(int split) {
        return (split - 285) / 15;
    }

    static int toStoreVertSplit(int split) {
        return 510 + 15 * split;
    }

    static int toScreenVertSplit(int split) {
        return (split - 510) / 15;
    }

    static String getLocalName(String qName) {
        int index = qName.indexOf(":");
        if (index != -1) {
            qName = qName.substring(index + 1);
        }
        return qName;
    }

    static String getNSName(String name, Namespace ns) {
        String pre = ns.getPrefix();
        if (StringUtil.isEmptyString((String)pre)) {
            return name;
        }
        return ns.getPrefix() + ":" + name;
    }

    static String toXmlString(String str) {
        if (str == null) {
            return null;
        }
        String ret = str.replace("&", "&amp;");
        ret = ret.replace("\"", "&quot;");
        ret = ret.replace("<", "&lt;");
        ret = ret.replace(">", "&gt;");
        ret = ret.replace("\r", "&#x000D;");
        ret = ret.replace("\n", "&#x000A;");
        return ret;
    }

    static String toBookString(String str) {
        if (str == null) {
            return null;
        }
        String ret = str.replaceAll("&quot;", "\"");
        ret = ret.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("&amp;", "&");
        return ret;
    }

    static String intArrayToString(int[] ia) {
        if (ia == null || ia.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ia.length; ++i) {
            sb.append(ia[i]);
            if (i == ia.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    static String sortedObjectArrayToString(SortedObjectArray ia) {
        if (ia == null || ia.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ia.size(); ++i) {
            sb.append(ia.get(i));
            if (i == ia.size() - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    static int[] stringToIntArray(String str) {
        String[] sa;
        if (!StringUtil.isEmptyString((String)str) && (sa = str.split(",")).length > 0) {
            int[] ia = new int[sa.length];
            for (int i = 0; i < ia.length; ++i) {
                ia[i] = Integer.parseInt(sa[i]);
            }
            return ia;
        }
        return null;
    }
}

