/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;

public class ExprArray
implements IExprNode {
    public static final int MAX_ARGS = 255;
    private static final ExprArray[] _arrays = new ExprArray[256];
    private int _args;

    private ExprArray(int args) {
        this._args = args;
    }

    public static ExprArray getInstance(int args) throws SyntaxErrorException {
        if (args > 255) {
            ExprErr.goError((long)8L, (Object)("too many params: " + args));
        }
        return _arrays[args];
    }

    public int getParameterCount() {
        return this._args;
    }

    @Override
    public int getExprType() {
        return 8192;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) {
        ObjectStack stack = ctx.getCurrentExprStack();
        Variant[] a = new Variant[this._args];
        for (int i = this._args - 1; i >= 0; --i) {
            a[i] = (Variant)stack.pop();
        }
        Variant var = new Variant((Object)a, 527);
        stack.push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return "";
    }

    public String toString() {
        return "Array:" + this._args;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ExprArray._arrays[i] = new ExprArray(i);
        }
    }
}

