/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.expr.Parser;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlockBuffer;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.ComposingReference;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.Global;
import com.kingdee.bos.ctrl.excel.model.struct.IBookProvider;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.ISelectMode;
import com.kingdee.bos.ctrl.excel.model.struct.ISheet;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetProxy;
import com.kingdee.bos.ctrl.excel.model.struct.SortedCellBlockNodeShadowSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UnknownMethodManager;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellValueChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlock3DNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.excel.model.struct.undo.UndoManager;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class Book
implements Comparable,
ISelectMode {
    public static final int CellDisplayMode_Formula = 1;
    public static final int CellDisplayMode_Value = 0;
    public static final int CellDisplayMode_NotYetConfigged = 2;
    public static final String REPORT_PRINTINFO = "reportPrintInfo";
    public static final String PRINT_SCHEMEINFO = "printSchemeInfo";
    private boolean _autoCalculate = true;
    private boolean _autoCalcCurrentCell = true;
    private boolean _loading = false;
    private String _bookName;
    private ShareStyleAttributes _ssa;
    private SortedUserObjectArray _userObjects;
    private Comment _comment;
    private BookProtection _protection;
    private UndoManager _undoMan;
    private Dependents _deps;
    private SortedCellBlockNodeShadowSpanArray _3DBlockDeps;
    private SortedNamedObjectNodeArray _names;
    private ObjectArray _sheets;
    private Map<String, Integer> sheetNamesIndex = new WeakHashMap<String, Integer>();
    private ConcurrentHashMap _prevSheets;
    private int _activeIndex;
    private CellBlockBuffer _blockBuffer;
    private boolean _isSkipListeners;
    private boolean _isGroup;
    private ObjectArray _graphListeners;
    private ObjectArray _sheetListeners;
    private ObjectArray _sheetPropertyListeners;
    private ObjectArray _bookListeners;
    private ObjectArray _bookPropertyListeners;
    private IUserObjectProvider _protectedUOProvider;
    private IBookProvider _provider;
    private int _cellDisplayMode = 2;
    private ComposingReference composingReference;
    private CellActionAfterListener cellActionAfterListener;
    private CellValueChangeListener cellValueChangeListener;
    private String copyUUID = "";
    private int fileVersion;
    private boolean isAutoPaint = true;
    private boolean isClipBook = false;
    private volatile boolean isCalc = false;

    public boolean isAutoPaint() {
        return this.isAutoPaint && !this.isCalc;
    }

    public void setAutoPaint(boolean bAutoPaint) {
        this.isAutoPaint = bAutoPaint;
    }

    public boolean isClipBook() {
        return this.isClipBook;
    }

    public void setClipBook(boolean ClipBook) {
        this.isClipBook = ClipBook;
    }

    public boolean isCalc() {
        return this.isCalc;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(int fileVersion) {
        this.fileVersion = fileVersion;
    }

    public void setCellDisplayMode(int cellDisplayMode) {
        this._cellDisplayMode = cellDisplayMode;
        this.fireBookPropertyChange(null, null, "Global_Repaint");
    }

    public int getCellDisplayMode() {
        return this._cellDisplayMode;
    }

    public String getCopyUUID() {
        return this.copyUUID == null ? "" : this.copyUUID;
    }

    public void setCopyUUID(String copyUUID) {
        this.copyUUID = copyUUID;
    }

    Book(IBookProvider provider) throws IllegalArgumentException {
        if (provider == null || provider.getSheetCount() < 0) {
            throw new IllegalArgumentException("need right provider");
        }
        this._provider = provider;
        this._bookName = this._provider.getBookName();
        this.initBookssa();
        this.init(this._bookName);
        int initSheetCount = this._provider.getSheetCount();
        this._sheets = new ObjectArray(initSheetCount);
        for (int i = 0; i < initSheetCount; ++i) {
            this._sheets.append((Object)this._provider.getSheetProxy(i));
        }
        if (initSheetCount > 0) {
            int activeIndex = this._provider.getActiveSheetIndex();
            this.getSheet(activeIndex).getSheetOption().setSelected(true);
            this._activeIndex = activeIndex;
        }
        boolean oldLoading = this.isLoading();
        boolean oldCalc = this.isAutoCalculate();
        boolean oldEnable = this.getUndoManager().isEnable();
        this.setAutoCalculate(false);
        this.getUndoManager().enable(false);
        provider.initBookOptions(this);
        if (this._deps.isExtendMode()) {
            this.setAutoCalculate(false);
            this.getSheet(this._provider.getActiveSheetIndex()).getSheetOption().setCellDisplayMode(1);
        } else {
            this.setAutoCalculate(oldCalc);
        }
        this.getUndoManager().enable(oldEnable);
        this.setLoading(oldLoading);
    }

    Book(String bookName) throws IllegalArgumentException {
        this(bookName, Global.getIntProperity("InitSheetCount", 1));
    }

    Book(String bookName, int initSheetCount) throws IllegalArgumentException {
        this._bookName = bookName;
        this.initBookssa();
        this.init(bookName);
        this._sheets = new ObjectArray(initSheetCount);
        for (int i = 0; i < initSheetCount; ++i) {
            this._sheets.append((Object)new Sheet(this, this.getNewSheetName(null, false)));
        }
        if (initSheetCount > 0) {
            this.getSheet(0).getSheetOption().setSelected(true);
            this._activeIndex = 0;
        }
    }

    private void init(String bookName) {
        this._deps = new Dependents();
        this._3DBlockDeps = new SortedCellBlockNodeShadowSpanArray();
        this._names = new SortedNamedObjectNodeArray();
        this._undoMan = new UndoManager();
        this._prevSheets = new ConcurrentHashMap();
    }

    SortedCellBlockNodeShadowSpanArray get3DBlockDeps() {
        return this._3DBlockDeps;
    }

    CellBlockBuffer getCellBlockBuffer() {
        if (this._blockBuffer == null) {
            this._blockBuffer = new CellBlockBuffer();
        }
        return this._blockBuffer.getEmptyBuffer();
    }

    public void clear() {
        this._sheets.clear();
        this._deps.clear();
        this._undoMan.discardAllEdits();
        this._3DBlockDeps.clear();
        if (this._userObjects != null) {
            this._userObjects.clear();
        }
        this._userObjects = null;
        this._comment = null;
        this._provider = null;
    }

    private void initBookssa() {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)Styles.getDefaultSSA());
        sa.setFontSize(12);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.NORMAL);
        this._ssa = Styles.getSSA((StyleAttributes)sa);
    }

    public boolean setA1Style(boolean bA1Style) {
        boolean old = this._deps.isA1Style();
        if (old != bA1Style) {
            this._deps.setA1Style(bA1Style);
            int size = this.getSheetCount();
            for (int i = 0; i < size; ++i) {
                Sheet sheet = this.getSheet(i);
                Sheet.ICellsIterator ri = sheet.getCellsIterator(null, false, true);
                while (ri.hasNext()) {
                    ri.next().updateFormula();
                }
            }
        }
        return old;
    }

    public boolean isAutoCalculate() {
        return this._autoCalculate;
    }

    public void setCalculate(boolean autoCalculate) {
        this._autoCalcCurrentCell = this._autoCalculate = autoCalculate;
    }

    public boolean setAutoCalculate(boolean autoCalculate) {
        boolean old = this._autoCalculate;
        this._autoCalcCurrentCell = this._autoCalculate = autoCalculate;
        return old;
    }

    public boolean isCalcCurrentCell() {
        return this._autoCalcCurrentCell;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (obj instanceof Book) {
            return this._bookName.compareTo(((Book)obj)._bookName);
        }
        return -1;
    }

    public int hashCode() {
        return this._bookName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Book) {
            Book cmpBook = (Book)obj;
            return this._bookName.equals(cmpBook._bookName);
        }
        return false;
    }

    public String toString() {
        String str = this.getName() + ":" + this.getActiveSheet() + "{";
        int count = this.getSheetCount();
        for (int i = 0; i < count; ++i) {
            str = str + this.getSheetName(i) + ",";
        }
        str = str + "}";
        return str;
    }

    public void startGroup() {
        this._isGroup = true;
    }

    public void endGroup() {
        this._isGroup = false;
        this.activeSheet(this._activeIndex);
    }

    public void setSkipListeners(boolean b) {
        this._isSkipListeners = b;
    }

    public boolean isSkipListeners() {
        return this._isSkipListeners;
    }

    public String getName() {
        return this._bookName;
    }

    public ShareStyleAttributes getSSA() {
        return this._ssa;
    }

    public Dependents getDeps() {
        return this._deps;
    }

    public BookProtection getProtection() {
        if (this._protection == null) {
            this._protection = new BookProtection(this);
        }
        return this._protection;
    }

    public UndoManager getUndoManager() {
        return this._undoMan;
    }

    public synchronized String getNewSheetName(String seedName, boolean copySign) {
        String newName = seedName;
        if (StringUtil.isEmptyString((String)seedName)) {
            String sheetNamePrefix = Global.getStringProperity("SheetNamePrefix", "Sheet");
            int num = this.getSheetCount() + 1;
            newName = sheetNamePrefix + num;
            while (this.getSheetIndexByName(newName) >= 0) {
                newName = sheetNamePrefix + ++num;
            }
        } else {
            int dup = 2;
            int rightIndex = seedName.lastIndexOf(41);
            int leftIndex = seedName.lastIndexOf(40);
            if (leftIndex >= 0 && rightIndex > leftIndex - 1 && rightIndex == seedName.length() - 1) {
                try {
                    dup = Integer.parseInt(seedName.substring(leftIndex + 1, rightIndex));
                    seedName = seedName.substring(0, leftIndex);
                }
                catch (Exception e) {
                    dup = 2;
                }
            }
            int seedLen = seedName.length();
            while (this.getSheetIndexByName(newName) >= 0) {
                String tail = copySign ? "(" + dup + ")" : String.valueOf(dup);
                int tLen = tail.length();
                newName = seedLen + tLen > 31 ? seedName.substring(0, 31 - tLen) + tail : seedName + tail;
                ++dup;
            }
        }
        return newName;
    }

    public Sheet getSheetByName(String sheetName) throws SyntaxErrorException {
        int index = this.getSheetIndexByName(sheetName);
        if (index < 0) {
            ExprErr.goError((long)512L, (Object)this.getSheet(0));
        }
        return this.getSheet(index);
    }

    public void pendingSheet(String sheetName, ICalculable node) {
        ObjectArray al = (ObjectArray)this._prevSheets.get(sheetName);
        if (al == null) {
            al = new ObjectArray();
            this._prevSheets.put(sheetName, al);
        }
        Object prev = null;
        int size = al.size();
        if (size > 0) {
            prev = al.get(size - 1);
        }
        if (node != prev) {
            al.append((Object)node);
        }
    }

    public void updatePendingSheet() {
        if (this._prevSheets.isEmpty()) {
            return;
        }
        boolean queue = this.isAutoCalculate();
        Iterator mi = this._prevSheets.entrySet().iterator();
        while (mi.hasNext()) {
            ObjectArray al = (ObjectArray)mi.next().getValue();
            for (int i = al.size() - 1; i >= 0; --i) {
                ((ICalculable)al.get(i)).updateExpr(queue);
            }
        }
        this._prevSheets.clear();
    }

    public void updateExpr(boolean queue) {
        for (int i = this.getSheetCount() - 1; i >= 0; --i) {
            this.getSheet(i).updateExpr(queue);
        }
    }

    public void resumeUnknownMethod() {
        UnknownMethodManager um = this.getDeps().getUnknownMethodManager();
        if (um.isEmpty()) {
            return;
        }
        um.clear();
        for (int i = this.getSheetCount() - 1; i >= 0; --i) {
            this.getSheet(i).resumeUnknownMethod(um);
        }
    }

    public String getSheetName(int index) {
        return this.getISheet(index).getSheetName();
    }

    public int getSheetIndexByName(String sheetName) {
        if (StringUtil.isEmptyString((String)sheetName)) {
            return -1;
        }
        int index = -1;
        for (int i = this.getSheetCount() - 1; i >= 0; --i) {
            Integer indexInMap = this.sheetNamesIndex.get(sheetName);
            if (null == indexInMap && !this.getSheetName(i).equalsIgnoreCase(Parser.getSheetName(sheetName))) continue;
            if (null != indexInMap) {
                index = indexInMap;
                break;
            }
            index = i;
            this.sheetNamesIndex.put(sheetName, index);
            break;
        }
        return index;
    }

    public int getSheetIndexByID(String id) {
        if (StringUtil.isEmptyString((String)id)) {
            return -1;
        }
        int index = -1;
        for (int i = this.getSheetCount() - 1; i >= 0; --i) {
            if (this.getSheet(i).getID().compareToIgnoreCase(id) != 0) continue;
            index = i;
            break;
        }
        return index;
    }

    public ISheet getISheet(int index) {
        if (index < 0) {
            return null;
        }
        Object o = this._sheets.get(index);
        if (o instanceof ISheet) {
            return (ISheet)o;
        }
        Sheet sheet = new Sheet(this, this.getNewSheetName(null, false));
        this._sheets.set(index, (Object)sheet);
        return sheet;
    }

    public Sheet getSheet(int index) {
        if (this.checkSheetIndex(index)) {
            Object o = this._sheets.get(index);
            if (o instanceof SheetProxy) {
                SheetProxy si = (SheetProxy)o;
                Sheet sheet = new Sheet(this, si.getSheetName());
                this._sheets.set(index, (Object)sheet);
                this._provider.loadSheet(sheet, si.getZipBytes());
                sheet.getSheetOption().setSelected(si.isSelected());
                sheet.getSheetOption().setHide(si.isHide());
                sheet.getSheetOption().setTabColor(si.getTabColor());
                sheet.getSheetOption().setSheetType(si.getSheetType());
                sheet.setID(si.getID());
                return sheet;
            }
            if (o instanceof Sheet) {
                return (Sheet)this._sheets.get(index);
            }
            Sheet sheet = new Sheet(this, this.getNewSheetName(null, false));
            this._sheets.set(index, (Object)sheet);
            return sheet;
        }
        return null;
    }

    public Sheet getSheet(String name) {
        return this.getSheet(this.getSheetIndexByName(name));
    }

    public Sheet getSheetByID(String id) {
        return this.getSheet(this.getSheetIndexByID(id));
    }

    public Sheet getActiveSheet() {
        return this.getSheet(this._activeIndex);
    }

    public int indexToVisibleIndex(int index) {
        if (!this.checkSheetIndex(index)) {
            return -1;
        }
        if (this.getISheet(index).isHide()) {
            return -2;
        }
        int vindex = index;
        for (int i = 0; i < index; ++i) {
            if (!this.getISheet(i).isHide()) continue;
            --vindex;
        }
        return vindex;
    }

    public int visibleIndexToIndex(int index) {
        if (!this.checkSheetIndex(index)) {
            return -1;
        }
        int vindex = 0;
        int size = this.getSheetCount();
        for (int i = 0; i < size; ++i) {
            ISheet sheet = this.getISheet(i);
            if (sheet.isHide()) continue;
            if (index == vindex) {
                return i;
            }
            ++vindex;
        }
        return -2;
    }

    public int getActiveSheetIndex() {
        return this._activeIndex;
    }

    public int getSheetCount() {
        return this._sheets.size();
    }

    public int getVisibleSheetCount() {
        int vsize = 0;
        int size = this.getSheetCount();
        for (int i = 0; i < size; ++i) {
            ISheet sheet = this.getISheet(i);
            if (sheet.isHide()) continue;
            ++vsize;
        }
        return vsize;
    }

    public int getVisibleActiveSheetIndex() {
        return this.indexToVisibleIndex(this.getActiveSheetIndex());
    }

    public Sheet getVisibleSheet(int index) {
        int i = this.visibleIndexToIndex(index);
        return this.getSheet(i);
    }

    public ISheet getVisibleISheet(int index) {
        int i = this.visibleIndexToIndex(index);
        return this.getISheet(i);
    }

    public void exchangeSheetIndex(int index1, int index2) {
        ISheet s1 = this.getISheet(index1);
        ISheet s2 = this.getISheet(index2);
        if (s1 != null && s2 != null) {
            this._sheets.set(index1, (Object)s2);
            this._sheets.set(index2, (Object)s1);
            this.updateSheetIndex();
            if (this._activeIndex == index1) {
                this._activeIndex = index2;
            } else if (this._activeIndex == index2) {
                this._activeIndex = index1;
            }
        }
    }

    public Range getRange(String name, boolean withDefined) {
        int index = name.indexOf(33);
        if (index > 0) {
            String tname = name.substring(0, index);
            Sheet sheet = this.getSheet(tname);
            if (sheet != null) {
                return sheet.getRange(name.substring(index + 1), withDefined);
            }
            return null;
        }
        return this.getActiveSheet().getRange(name, withDefined);
    }

    public Range getSelectionRange() {
        Sheet active = this.getActiveSheet();
        return new Range(this, this.getSelectSheets().getCopy(), active.getSheetOption().getSelection().toSortedBlocks().toArray());
    }

    public Range getActiveSelectionRange() {
        return this.getActiveSheet().getSelectionRange();
    }

    public Range getActiveCellRange() {
        Sheet active = this.getActiveSheet();
        return active.getActiveCellRange();
    }

    public SortedSheetArray getSelectSheets() {
        SortedSheetArray array = new SortedSheetArray();
        int count = this.getSheetCount();
        for (int i = 0; i < count; ++i) {
            if (!this.getISheet(i).isSelected()) continue;
            array.insert(this.getSheet(i));
        }
        return array;
    }

    public SortedSheetArray getSheetsArray(Sheet sheet, Sheet sheet2) {
        int to;
        int from = this.getSheetIndexByName(sheet.getSheetName());
        if (from > (to = this.getSheetIndexByName(sheet2.getSheetName()))) {
            int tmp = from;
            from = to;
            to = tmp;
        }
        SortedSheetArray sa = new SortedSheetArray();
        while (from <= to) {
            sa.insert(this.getSheet(from));
            ++from;
        }
        return sa;
    }

    public Object getUserObjectValue(String key) {
        UserObject uo;
        if (this._userObjects != null && (uo = this._userObjects.getUserObject(key)) != null) {
            return uo.getValue();
        }
        return null;
    }

    public UserObject getUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.getUserObject(key);
        }
        return null;
    }

    public Comment getComment() {
        return this._comment;
    }

    public boolean isAllSheetSelected() {
        for (int i = this.getSheetCount() - 1; i >= 0; --i) {
            ISheet sheet = this.getISheet(i);
            if (sheet.isHide() || sheet.isSelected()) continue;
            return false;
        }
        return true;
    }

    public int makeValidActiveIndex(int index) {
        int i;
        int count = this.getSheetCount();
        if (count <= 0) {
            return -1;
        }
        if (index >= count) {
            index = count - 1;
        } else if (index < 0) {
            index = 0;
        }
        for (i = index; i < count; ++i) {
            if (!this.sheetCanActive(this.getISheet(i))) continue;
            return i;
        }
        for (i = index - 1; i > 0; --i) {
            if (!this.sheetCanActive(this.getISheet(i))) continue;
            return i;
        }
        ISheet sheet = this.getISheet(0);
        if (!this.sheetCanActive(sheet)) {
            sheet.setSelected(true);
            sheet.setHide(false);
        }
        return 0;
    }

    private boolean sheetCanActive(ISheet sheet) {
        if (!sheet.isHide()) {
            sheet.setSelected(true);
            return true;
        }
        if (sheet.isSelected()) {
            sheet.setSelected(false);
        }
        return false;
    }

    public void activeSheet(int index) {
        this.fireBookChange(this.getActiveSheet(), "Sheet_Deactive");
        this._activeIndex = this.makeValidActiveIndex(index);
        this.fireBookChange(this.getSheet(this._activeIndex), "Sheet_Active");
    }

    public void activeSheet(String sheetName) {
        this.activeSheet(this.getSheetIndexByName(sheetName));
    }

    public void activeSheet(Sheet sheet) {
        this.activeSheet(sheet.getSheetName());
    }

    public void setActiveSheet(int index) {
        this.activeSheet(index);
    }

    public void setActiveSheet(String sheetName) {
        this.activeSheet(sheetName);
    }

    public void setActiveSheet(Sheet sheet) {
        this.activeSheet(sheet);
    }

    public boolean justInsertSheet(int index, Sheet sheet, boolean bActive) {
        if (!this.getProtection().allowOperatorStruct()) {
            return false;
        }
        if (sheet == null) {
            sheet = new Sheet(this, this.getNewSheetName(null, false));
        } else {
            sheet.setBook(this);
            if (StringUtil.isEmptyString((String)sheet.getSheetName()) || this.getISheet(this.getSheetIndexByName(sheet.getSheetName())) != null) {
                String newName = this.getNewSheetName(sheet.getSheetName(), true);
                sheet.setName(newName);
            }
        }
        if (index >= this._sheets.size()) {
            this._sheets.append((Object)sheet);
        } else {
            this._sheets.insert(index < 0 ? 0 : index, (Object)sheet);
        }
        if (index <= this._activeIndex) {
            ++this._activeIndex;
        }
        this.updateSheetIndex();
        if (bActive) {
            this.activeSheet(index);
        } else {
            sheet.getSheetOption().setSelected(false);
        }
        return true;
    }

    public void fireBookChange(Sheet sheet, boolean isCopy) {
        this.fireBookChange(sheet, "Sheet_Insert");
        if (isCopy) {
            this.fireBookChange(sheet, "Sheet_Copy");
        }
    }

    public boolean insertSheet(int index, Sheet sheet, boolean bActive) {
        if (!this.getProtection().allowOperatorStruct()) {
            return false;
        }
        if (sheet == null) {
            sheet = new Sheet(this, this.getNewSheetName(null, false));
        } else {
            sheet.setBook(this);
            if (StringUtil.isEmptyString((String)sheet.getSheetName()) || this.getISheet(this.getSheetIndexByName(sheet.getSheetName())) != null) {
                String newName = this.getNewSheetName(sheet.getSheetName(), true);
                sheet.setName(newName);
            }
        }
        if (index >= this._sheets.size()) {
            this._sheets.append((Object)sheet);
        } else {
            this._sheets.insert(index < 0 ? 0 : index, (Object)sheet);
        }
        if (index <= this._activeIndex) {
            ++this._activeIndex;
        }
        this.updateSheetIndex();
        this.fireBookChange(sheet, "Sheet_Insert");
        if (bActive && !sheet.isHide()) {
            this.activeSheet(index);
        } else {
            sheet.getSheetOption().setSelected(false);
        }
        return true;
    }

    public boolean insertSheet(int index, Sheet sheet) {
        return this.insertSheet(index, sheet, true);
    }

    public boolean addSheet(Sheet sheet) {
        return this.insertSheet(this.getSheetCount(), sheet);
    }

    public boolean addSheet(Sheet sheet, boolean bActive) {
        return this.insertSheet(this.getSheetCount(), sheet, bActive);
    }

    public boolean removeSheet(int index) {
        return this.removeSheet(index, true);
    }

    public boolean removeSheet(int index, boolean bActive) {
        if (!this.getProtection().allowOperatorStruct()) {
            return false;
        }
        if (this.isAutoCalculate()) {
            this.calcQueue();
        }
        ISheet removedSheet = this.getISheet(index);
        this._sheets.remove((Object)removedSheet);
        if (index <= this._activeIndex) {
            --this._activeIndex;
            int n = this._activeIndex = this._activeIndex < 0 ? 0 : this._activeIndex;
        }
        if (removedSheet instanceof Sheet) {
            ((Sheet)removedSheet).queue(false);
            ((Sheet)removedSheet).removeRelatedEdits();
            this.fireBookChange((Sheet)removedSheet, "Sheet_Remove");
            this.updateSheetChanging((Sheet)removedSheet);
        }
        this.updateSheetIndex();
        if (bActive && !this._isGroup) {
            this.activeSheet(this._activeIndex);
        }
        return false;
    }

    public boolean removeSheet(String name) {
        return this.removeSheet(this.getSheetIndexByName(name));
    }

    public boolean removeSheet(Sheet sheet) {
        return this.removeSheet(sheet.getSheetName());
    }

    public boolean hideSheet(Sheet sheet) {
        return this.hideSheet(sheet.getSheetName());
    }

    public boolean hideSheet(String sheetName) {
        return this.hideSheet(this.getSheetIndexByName(sheetName));
    }

    public boolean hideSheet(int index) {
        return this.hideSheet(index, true);
    }

    public boolean hideSheet(int index, boolean bActive) {
        if (!this.getProtection().allowOperatorStruct()) {
            return false;
        }
        ISheet hidedSheet = this.getISheet(index);
        hidedSheet.setHide(true);
        hidedSheet.setSelected(false);
        if (hidedSheet instanceof Sheet) {
            ((Sheet)hidedSheet).removeRelatedEdits();
            this.fireBookChange((Sheet)hidedSheet, "Sheet_Hide");
        }
        if (bActive && !this._isGroup) {
            this.activeSheet(this._activeIndex);
        }
        return false;
    }

    public boolean unhideSheet(Sheet sheet) {
        return this.unhideSheet(sheet.getSheetName());
    }

    public boolean unhideSheet(String sheetName) {
        return this.unhideSheet(this.getSheetIndexByName(sheetName));
    }

    public boolean unhideSheet(int index) {
        return this.unhideSheet(index, true);
    }

    public boolean unhideSheet(int index, boolean bActive) {
        if (!this.getProtection().allowOperatorStruct()) {
            return false;
        }
        ISheet sheet = this.getISheet(index);
        if (sheet != null && sheet.isHide()) {
            sheet.setHide(false);
            if (bActive && !this._isGroup) {
                this.activeSheet(index);
            }
        }
        if (sheet instanceof Sheet) {
            this.fireBookChange((Sheet)sheet, "Sheet_UnHide");
        }
        return true;
    }

    public boolean unhideAllSheets() {
        if (!this.getProtection().allowOperatorStruct()) {
            return false;
        }
        int size = this.getSheetCount();
        for (int i = 0; i < size; ++i) {
            ISheet sheet = this.getISheet(i);
            if (!sheet.isHide()) continue;
            sheet.setHide(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calc() {
        this.isCalc = true;
        LinkedList<Sheet> sourceSheets = new LinkedList<Sheet>();
        try {
            this._names.removeEmptyName();
            this._deps.getQueryManager().clear();
            int size = this.getSheetCount();
            for (int i = 0; i < size; ++i) {
                Sheet sheet = this.getSheet(i);
                if (!sheet.isEnableCalculation()) continue;
                sheet.queue(false);
                sourceSheets.add(sheet);
            }
            this.resumeUnknownMethod();
            this._deps.calc();
        }
        finally {
            this.isCalc = false;
            boolean oldState = this._isSkipListeners;
            this._isSkipListeners = false;
            for (Sheet sheet : sourceSheets) {
                this.fireSheetChange(sheet, null, SheetChangeEvent.Calculation_Finish);
            }
            this._isSkipListeners = oldState;
        }
    }

    public void calcQueue() {
        if (this.isAutoCalculate()) {
            this.resumeUnknownMethod();
            this._deps.calc();
        } else if (!this.isLoading()) {
            this._deps.clearCalcList();
        }
    }

    public UserObject setUserObject(String key, Object obj) {
        UserObject uo = new UserObject(key, obj);
        if (this._userObjects == null) {
            this._userObjects = new SortedUserObjectArray();
        }
        return (UserObject)this._userObjects.insert(uo);
    }

    public UserObject removeUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.removeByKey(key);
        }
        return null;
    }

    public void setComment(Comment comment) {
        this._comment = comment;
    }

    public Sheet.ICellsIterator getRangeCellsIterator(Range rg, boolean bDescend, boolean forContentCell) {
        return new RangeCellsIterator(rg, bDescend, forContentCell);
    }

    public void setUserObjectsProvider(IUserObjectProvider provider) {
        this._protectedUOProvider = provider;
    }

    public IUserObjectProvider getUserObjectsProvider() {
        return this._protectedUOProvider;
    }

    public void addGraphChangeListener(GraphChangeListener l) {
        if (l != null) {
            if (this._graphListeners == null) {
                this._graphListeners = new ObjectArray();
            }
            this._graphListeners.append((Object)l);
        }
    }

    public void removeGraphChangeListener(GraphChangeListener l) {
        if (l != null) {
            this._graphListeners.remove((Object)l);
        }
    }

    public void addSheetChangeListener(SheetChangeListener sheetListener) {
        if (sheetListener != null) {
            if (this._sheetListeners == null) {
                this._sheetListeners = new ObjectArray();
            }
            this._sheetListeners.append((Object)sheetListener);
        }
    }

    public void removeSheetChangeListener(SheetChangeListener sheetListener) {
        if (this._sheetListeners != null) {
            this._sheetListeners.remove((Object)sheetListener);
        }
    }

    public void addBookChangeListener(BookChangeListener bookListener) {
        if (bookListener != null) {
            if (this._bookListeners == null) {
                this._bookListeners = new ObjectArray();
            }
            this._bookListeners.append((Object)bookListener);
        }
    }

    public void removeBookChangeListener(BookChangeListener bookListener) {
        if (this._bookListeners != null) {
            this._bookListeners.remove((Object)bookListener);
        }
    }

    public void addSheetPropertyChangeListener(SheetPropertyChangeListener l) {
        if (l != null) {
            if (this._sheetPropertyListeners == null) {
                this._sheetPropertyListeners = new ObjectArray();
            }
            this._sheetPropertyListeners.append((Object)l);
        }
    }

    public void removeSheetPropertyChangeListener(SheetPropertyChangeListener l) {
        if (this._sheetPropertyListeners != null) {
            this._sheetPropertyListeners.remove((Object)l);
        }
    }

    public void addBookPropertyChangeListener(BookPropertyChangeListener l) {
        if (l != null) {
            if (this._bookPropertyListeners == null) {
                this._bookPropertyListeners = new ObjectArray();
            }
            this._bookPropertyListeners.append((Object)l);
        }
    }

    public void removeBookPropertyChangeListener(BookPropertyChangeListener l) {
        if (this._bookPropertyListeners != null) {
            this._bookPropertyListeners.remove((Object)l);
        }
    }

    private void updateSheetIndex() {
        this.sheetNamesIndex.clear();
        for (int i = this._sheets.size() - 1; i >= 0; --i) {
            ISheet sheet = this.getISheet(i);
            if (!(sheet instanceof Sheet)) continue;
            ((Sheet)sheet).updateSheetIndex();
        }
    }

    private void updateSheetChanging(Sheet sheet) {
        SortedNamedObjectNodeArray sao = sheet.getNames();
        int size = sao.size();
        for (int i = 0; i < size; ++i) {
            NamedObjectNode no = sao.getObjectNode(i);
            if (!no.isVisible()) continue;
            no.queue(true);
        }
    }

    private boolean checkSheetIndex(int index) {
        return index >= 0 && index < this.getSheetCount();
    }

    public CellBlockNode setDependent(ICalculable refer, CellBlock3DNode cbReferTo) {
        if (refer instanceof Sheet.ParserHelper) {
            return null;
        }
        return this._3DBlockDeps.setDependent(refer, cbReferTo);
    }

    public SortedNamedObjectNodeArray getNames() {
        return this._names;
    }

    public SortedUserObjectArray getUserObjects() {
        return this._userObjects;
    }

    public void fireGraphChange(GraphChangedEvent e) {
        if (!this._isSkipListeners && this._graphListeners != null) {
            int size = this._graphListeners.size();
            if (size <= 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((GraphChangeListener)this._graphListeners.get(i)).changed(e);
            }
        }
    }

    public void fireGraphPropertyChange(GraphPropertyChangedEvent e) {
        if (!this._isSkipListeners && this._graphListeners != null) {
            int size = this._graphListeners.size();
            if (size <= 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((GraphChangeListener)this._graphListeners.get(i)).propertyChanged(e);
            }
        }
    }

    public void fireSheetChange(Sheet sheet, SortedCellBlockArray blocks, long states) {
        if (!this._isSkipListeners && this._sheetListeners != null) {
            int size = this._sheetListeners.size();
            if (size <= 0) {
                return;
            }
            SheetChangeEvent e = new SheetChangeEvent(sheet, blocks, states);
            for (int i = 0; i < size; ++i) {
                ((SheetChangeListener)this._sheetListeners.get(i)).changed(e);
            }
        }
    }

    void fireBookChange(Sheet sheet, String type) {
        if (!this._isSkipListeners && this._bookListeners != null) {
            int size = this._bookListeners.size();
            if (size <= 0) {
                return;
            }
            BookChangeEvent e = new BookChangeEvent(sheet, type, this._isGroup);
            for (int i = 0; i < size; ++i) {
                ((BookChangeListener)this._bookListeners.get(i)).changed(e);
            }
        }
    }

    void fireBookPropertyChange(Object oldValue, Object newValue, String type) {
        if (!this._isSkipListeners && this._bookPropertyListeners != null) {
            int size = this._bookPropertyListeners.size();
            if (size <= 0) {
                return;
            }
            BookPropertyChangeEvent e = new BookPropertyChangeEvent(this, oldValue, newValue, type);
            for (int i = 0; i < size; ++i) {
                ((BookPropertyChangeListener)this._bookPropertyListeners.get(i)).changed(e);
            }
        }
    }

    void fireSheetPropertyChange(Sheet sheet, Object oldValue, Object newValue, String type) {
        if (!this._isSkipListeners && this._sheetPropertyListeners != null) {
            int size = this._sheetPropertyListeners.size();
            if (size <= 0) {
                return;
            }
            SheetPropertyChangeEvent e = new SheetPropertyChangeEvent(sheet, oldValue, newValue, type);
            for (int i = 0; i < size; ++i) {
                ((SheetPropertyChangeListener)this._sheetPropertyListeners.get(i)).changed(e);
            }
        }
    }

    public void clearEmptyCells() {
        int count = this.getSheetCount();
        for (int i = 0; i < count; ++i) {
            this.getSheet(i).clearEmptyCells();
        }
    }

    public boolean isLoading() {
        return this._loading;
    }

    public boolean setLoading(boolean loading) {
        boolean old = this._loading;
        this._loading = loading;
        return old;
    }

    public Sheet getExtSheet() {
        int size = this.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = this.getSheet(i);
            if (sheet.getSheetType() != 1) continue;
            return sheet;
        }
        return null;
    }

    public Sheet getFilterSheet() {
        int size = this.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = this.getSheet(i);
            if (sheet.getSheetType() != 2) continue;
            return sheet;
        }
        return null;
    }

    public ComposingReference getComposingReference(boolean create) {
        if (create && this.composingReference == null) {
            this.composingReference = new ComposingReference(this);
        }
        return this.composingReference;
    }

    public CellActionAfterListener getCellActionAfterListener() {
        return this.cellActionAfterListener;
    }

    public void setCellActionAfterListener(CellActionAfterListener cellActionAfterListener) {
        this.cellActionAfterListener = cellActionAfterListener;
    }

    public CellValueChangeListener getCellValueChangeListener() {
        return this.cellValueChangeListener;
    }

    public void setCellValueChangeListener(CellValueChangeListener cellValueChangeListener) {
        this.cellValueChangeListener = cellValueChangeListener;
    }

    public void invalidateSheetNamesIndex(String sheetName) {
        this.sheetNamesIndex.remove(sheetName);
    }

    public static interface IUserObjectProvider {
        public String[] getKeepKeys();

        public String getString(String var1, Object var2);

        public Object getObject(String var1, String var2);
    }

    public static class Manager {
        private static final HashMap _books = new HashMap();

        public static synchronized Book getNewBook() {
            return Manager.getNewBook(null);
        }

        public static synchronized Book getNewBook(String bookName) {
            Book book = new Book(Manager.getNewBookName(bookName));
            return book;
        }

        public static synchronized Book getNewBookWithProvider(IBookProvider provider) {
            Book book = new Book(provider);
            return book;
        }

        public static synchronized Book getNewBook(String bookName, int initSheetCount) {
            Book book = new Book(Manager.getNewBookName(bookName), initSheetCount);
            return book;
        }

        public static synchronized String getNewBookName(String seedName) {
            String newName;
            if (StringUtil.isEmptyString((String)seedName)) {
                String bookNamePrefix = Global.getStringProperity("BookNamePrefix", "Book");
                int num = _books.size() + 1;
                newName = Manager.getNewBookName(bookNamePrefix + num);
            } else {
                newName = seedName;
                int dup = 2;
                while (_books.containsKey(newName)) {
                    newName = seedName + dup++;
                }
            }
            return newName;
        }
    }

    private class RangeCellsIterator
    implements Sheet.ICellsIterator {
        Sheet.ICellsIterator[] _iters;
        int _curIndex = 0;
        Range rg;
        boolean bDescend;
        boolean forContentCell;

        RangeCellsIterator(Range rg, boolean bDescend, boolean forContentCell) {
            int ssize = rg._sheets.size();
            int rsize = rg.size();
            this.rg = rg;
            this.bDescend = bDescend;
            this.forContentCell = forContentCell;
            this._iters = new Sheet.ICellsIterator[ssize * rsize];
            for (int si = 0; si < ssize; ++si) {
                Sheet sheet = rg._sheets.getSheet(si);
                for (int ri = 0; ri < rsize; ++ri) {
                    this._iters[si * rsize + ri] = sheet.getCellsIterator(rg.getBlock(ri), bDescend, forContentCell);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this._iters[this._curIndex].hasNext()) {
                return true;
            }
            ++this._curIndex;
            if (this._curIndex > this._iters.length - 1) {
                return false;
            }
            return this._iters[this._curIndex].hasNext();
        }

        @Override
        public Cell next() {
            return this._iters[this._curIndex].next();
        }

        @Override
        public boolean hasData() {
            boolean flag = false;
            RangeCellsIterator ri = new RangeCellsIterator(this.rg, this.bDescend, this.forContentCell);
            while (ri.hasNext()) {
                Cell cell = ri.next();
                if (cell.isEmptyContent2()) continue;
                flag = true;
                break;
            }
            return flag;
        }
    }
}

