/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.io.clipboard.ClipboardTransferHandler;
import com.kingdee.bos.ctrl.excel.io.clipboard.StringWalker;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.CellFinder;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.MessageType;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetActionColRow_Paste;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_AttributeSpan;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Clear;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Content;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Fill;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsDel;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsertConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsertConditionalFormatFurther;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsertEmObject;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsertValidation;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Merge;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Named;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Paste;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Replace;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Scale;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_StringPaste;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_Style;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_UpdateAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.Size;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.ObjectCache;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class Range
extends SortedCellBlockArray
implements Sheet.ICellsIterator {
    public static final String Protected_Cause = "Cause";
    public static final String Protected_OtherCause = "OtherCause";
    public static final String Protected_Sheet = "Sheet";
    public static final String Protected_Range = "Range";
    public static final String OtherCause_CellLocked = "OtherCause_CellLock";
    public static final String OtherCause_Overlapped = "OtherCause_Overlapped";
    public static final String OtherCause_MultiSelection = "OtherCause_MultiSelection";
    public static final String OtherCause_MergeLimit = "OtherCause_MergeLimit";
    public static final String OtherCause_Mixed = "OtherCause_Mixed";
    private static final long serialVersionUID = -2744478727424604283L;
    protected static CellBlock _invalidRect = CellBlock.getNewCellBlock(0, 0);
    private boolean isHeadLess = GraphicsEnvironment.isHeadless();
    public static final String ALERT_STR_KEY = "PasteAreaAreDifferent";
    public static final String ALERT_MESSAGE_STR = "\u590d\u5236\u533a\u57df\u4e0e\u7c98\u8d34\u533a\u57df\u5f62\u72b6\u4e0d\u540c\uff0c\u65e0\u6cd5\u7c98\u8d34\u3002";
    public static final String ALERT_DETECTION_TEXT = "\u62a5\u8868\u8bbe\u8ba1\u671f\u4e0d\u5efa\u8bae\u8bbe\u7f6e\u5168\u8868\u6837\u5f0f\uff0c\u907f\u514d\u8bbe\u7f6e\u6837\u5f0f\u7684\u5355\u5143\u683c\u8fc7\u591a\u5bfc\u81f4\u670d\u52a1\u5b95\u673a\uff0c\u5efa\u8bae\u9009\u4e2d\u5408\u9002\u533a\u57df\u8fdb\u884c\u8bbe\u7f6e\u3002";
    protected Book _book;
    protected SortedSheetArray _sheets;
    private boolean ignoreProtected = false;
    private Sheet.ICellsIterator it;
    boolean _isMergeLimit = false;

    public Range(Book book, Sheet sheet, CellBlock block) {
        this(book, sheet);
        this.insert(block);
    }

    public Range(Book book, Sheet sheet, Object[] array) {
        this(book, sheet);
        this.addAll(array);
    }

    public Range(Book book, SortedSheetArray sheets, Object[] array) {
        this(book, sheets);
        this.addAll(array);
    }

    public Range(Book book, SortedSheetArray sheets, CellBlock cb) {
        this(book, sheets);
        this.insert(cb);
    }

    private Range(Book book, SortedSheetArray sheets) {
        this._book = book;
        this._sheets = sheets;
    }

    private Range(Book book, Sheet sheet) {
        this._book = book;
        this._sheets = new SortedSheetArray();
        this._sheets.insert(sheet);
        this.it = this.getIterator(false);
    }

    public SortedSheetArray getRangeSheets() {
        return this._sheets;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._sheets.getSheet(0).getSyntaxName());
        if (this._sheets.size() > 1) {
            sb.append(':');
            sb.append(this._sheets.getSheet(this._sheets.size() - 1).getSyntaxName());
        }
        sb.append('!');
        String sheetPrefix = sb.toString();
        sb.setLength(0);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            sb.append(sheetPrefix);
            sb.append(SheetBaseMath.getBlockA1Name(this.getBlock(i), true));
            if (i == size - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    protected boolean actionBreak(MessageType type, HashMap info) {
        return true;
    }

    public boolean isProtected(HashMap state) {
        if (this.isIgnoreProtected()) {
            return false;
        }
        if (state != null) {
            boolean ret = this.actionBreak(Sheet.WARNNING, state);
            if (ret) {
                this.select();
            }
            return ret;
        }
        return false;
    }

    private boolean isExceedRowColLimit(boolean yDir) {
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock block = this.getBlock(i);
                if (!sheet.isExceedRowColLimit(block, yDir)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRangeLocked(Sheet sheet, SortedCellBlockArray result) {
        if (result.isEmpty()) {
            return false;
        }
        StyleAttributes sa = Styles.getEmptySA();
        new Range(this._book, sheet, result.toArray()).getStyle(sa);
        return sa.get(ShareStyleAttributes.PROTECTION_LOCKED) == ShareStyleAttributes.UNKOWN_VALUE || sa.isLocked();
    }

    public HashMap getSelectionProtectState() {
        HashMap state = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock block = this.getBlock(i);
                if (sheet.allowSelectBlock(block)) continue;
                state = Protection.getProtectState(sheet, block, 1);
                break block0;
            }
        }
        return state;
    }

    public HashMap getBaseProtectState() {
        HashMap<String, Object> state = null;
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected()) continue;
            state = new HashMap<String, Object>();
            state.put(Protected_Cause, new ArrayList());
            state.put(Protected_Sheet, sheet);
            state.put(Protected_Range, this);
            return state;
        }
        return state;
    }

    public HashMap getMergeLimitProtectState() {
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            MergeBlocks merger = this._sheets.getSheet(sh).getSheetOption().getMerger(false);
            if (merger == null) continue;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                CellBlock cb = this.getBlock(i);
                int touched = 0;
                int contained = 0;
                SortedCellBlockArray blocks = merger.getTouchedBlocks(cb);
                if (blocks != null) {
                    touched = blocks.size();
                }
                if (touched != 0 && (blocks = merger.getContainedBlocks(cb)) != null) {
                    contained = blocks.size();
                }
                if (touched == contained) continue;
                HashMap<String, Object> state = new HashMap<String, Object>();
                state.put(Protected_OtherCause, OtherCause_MergeLimit);
                state.put(Protected_Sheet, this._book.getActiveSheet());
                state.put(Protected_Range, this);
                return state;
            }
        }
        return null;
    }

    public HashMap getMultiBlockProtectState() {
        HashMap<String, Object> state = null;
        if (!this.isSingleBlock()) {
            state = new HashMap<String, Object>();
            state.put(Protected_OtherCause, OtherCause_MultiSelection);
            state.put(Protected_Sheet, this._book.getActiveSheet());
            state.put(Protected_Range, this);
        }
        return state;
    }

    public HashMap getOverLappedBlockProtectState() {
        HashMap<String, Object> state = null;
        if (this.isOverlapped()) {
            state = new HashMap<String, Object>();
            state.put(Protected_OtherCause, OtherCause_Overlapped);
            state.put(Protected_Sheet, this._book.getActiveSheet());
            state.put(Protected_Range, this);
        }
        return state;
    }

    public HashMap getMixedBlockProtectState() {
        HashMap<String, Object> state = null;
        if (this.isMixedBlocks()) {
            state = new HashMap<String, Object>();
            state.put(Protected_OtherCause, OtherCause_Mixed);
            state.put(Protected_Sheet, this._book.getActiveSheet());
            state.put(Protected_Range, this);
        }
        return state;
    }

    public HashMap getHyperLinkProtectState() {
        return this.getEditProtectStateImpl(128);
    }

    public HashMap getSortProtectState() {
        HashMap state = this.getMultiBlockProtectState();
        if (state != null) {
            return state;
        }
        return this.getEditProtectStateImpl(1024);
    }

    public HashMap getColStyleProtectState() {
        return this.getStyleProtectStateImpl(8);
    }

    public HashMap getRowStyleProtectState() {
        return this.getStyleProtectStateImpl(16);
    }

    public HashMap getCellStyleProtectState() {
        return this.getStyleProtectStateImpl(4);
    }

    public HashMap getCommontProtectState() {
        return this.getCommontProtectStateImpl(32768);
    }

    public HashMap getCellLockedProtectState() {
        HashMap<String, Object> state = null;
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected()) continue;
            state = new HashMap<String, Object>();
            state.put(Protected_Cause, new ArrayList());
            state.put(Protected_Sheet, sheet);
            state.put(Protected_Range, this);
            return state;
        }
        return state;
    }

    public HashMap getEditProtectState() {
        return this.getEditProtectStateImpl(Integer.MAX_VALUE);
    }

    public HashMap getPasteProtectState() {
        HashMap state = this.getMixedBlockProtectState();
        if (state != null) {
            return state;
        }
        state = this.getOverLappedBlockProtectState();
        if (state != null) {
            return state;
        }
        state = this.getMergeLimitProtectState();
        if (state != null) {
            return state;
        }
        return this.getEditProtectStateImpl(Integer.MAX_VALUE);
    }

    public HashMap getMergerProtectState() {
        return this.getBaseProtectState();
    }

    public HashMap getInsertProtectState() {
        HashMap state = this.getMixedBlockProtectState();
        if (state != null) {
            return state;
        }
        state = this.getOverLappedBlockProtectState();
        if (state != null) {
            return state;
        }
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected()) continue;
            if (this.isCellBlocks()) {
                state = new HashMap();
                state.put(Protected_Cause, new ArrayList());
                state.put(Protected_Sheet, sheet);
                state.put(Protected_Range, this);
                return state;
            }
            if (this.isRowBlocks()) {
                if (pro.hasOperation(64)) continue;
                state = new HashMap();
                state.put(Protected_Cause, new ArrayList());
                state.put(Protected_Sheet, sheet);
                state.put(Protected_Range, this);
                return state;
            }
            if (pro.hasOperation(32)) continue;
            state = new HashMap();
            state.put(Protected_Cause, new ArrayList());
            state.put(Protected_Sheet, sheet);
            state.put(Protected_Range, this);
            return state;
        }
        return state;
    }

    public HashMap getDeleteProtectState() {
        HashMap state = this.getMixedBlockProtectState();
        if (state != null) {
            return state;
        }
        state = this.getOverLappedBlockProtectState();
        if (state != null) {
            return state;
        }
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected()) continue;
            if (this.isCellBlocks()) {
                state = new HashMap();
                state.put(Protected_Cause, new ArrayList());
                state.put(Protected_Sheet, sheet);
                state.put(Protected_Range, this);
                return state;
            }
            if (this.isRowBlocks()) {
                if (pro.hasOperation(512) && !this.isRangeLocked(sheet, this)) continue;
                state = new HashMap();
                state.put(Protected_Cause, new ArrayList());
                state.put(Protected_Sheet, sheet);
                state.put(Protected_Range, this);
                return state;
            }
            if (pro.hasOperation(256) && !this.isRangeLocked(sheet, this)) continue;
            state = new HashMap();
            state.put(Protected_Cause, new ArrayList());
            state.put(Protected_Sheet, sheet);
            state.put(Protected_Range, this);
            return state;
        }
        return state;
    }

    public HashMap getCopyState() {
        int size = this.size();
        if (size > 1) {
            int i;
            HashMap state = this.getMixedBlockProtectState();
            if (state != null) {
                return state;
            }
            state = this.getOverLappedBlockProtectState();
            if (state != null) {
                return state;
            }
            int columns = 1;
            CellBlock firstBlock = this.getBlock(0);
            for (i = 1; i < size && firstBlock.equalsRow(this.getBlock(i)); ++i) {
                ++columns;
            }
            if (size % columns != 0) {
                return this.getMultiBlockProtectState();
            }
            for (i = columns; i < size; i += columns) {
                CellBlock first = this.getBlock(i);
                if (!first.equalsCol(firstBlock)) {
                    return this.getMultiBlockProtectState();
                }
                for (int j = i + 1; j < i + columns; ++j) {
                    CellBlock cb = this.getBlock(j);
                    if (cb.equalsRow(first) && cb.equalsCol(this.getBlock(j % columns))) continue;
                    return this.getMultiBlockProtectState();
                }
            }
        }
        return null;
    }

    private HashMap getCommontProtectStateImpl(int oper) {
        HashMap<String, Object> state = null;
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected() || pro.hasOperation(oper)) continue;
            state = new HashMap<String, Object>();
            state.put(Protected_Cause, new ArrayList());
            state.put(Protected_Sheet, sheet);
            state.put(Protected_Range, this);
            return state;
        }
        return state;
    }

    private HashMap getStyleProtectStateImpl(int oper) {
        HashMap<String, Object> state = null;
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected() || pro.hasOperation(oper)) continue;
            state = new HashMap<String, Object>();
            state.put(Protected_Cause, new ArrayList());
            state.put(Protected_Sheet, sheet);
            state.put(Protected_Range, this);
            return state;
        }
        return state;
    }

    private HashMap getEditProtectStateImpl(int oper) {
        ArrayList allImpactEditblocks = null;
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro == null || !pro.isProtected()) continue;
            if (!pro.hasOperation(oper)) {
                HashMap<String, Object> state = new HashMap<String, Object>();
                state.put(Protected_Cause, new ArrayList());
                state.put(Protected_Sheet, sheet);
                state.put(Protected_Range, this);
                return state;
            }
            SortedCellBlockArray result = new SortedCellBlockArray();
            result.copyFrom(this);
            if (this.isRangeLocked(sheet, result)) {
                HashMap<String, Object> state = new HashMap<String, Object>();
                state.put(Protected_Cause, new ArrayList());
                state.put(Protected_Sheet, sheet);
                state.put(Protected_Range, this);
                return state;
            }
            ArrayList impactEditblocks = pro.getImpactEditblocks(result);
            if (impactEditblocks == null) continue;
            if (allImpactEditblocks == null) {
                allImpactEditblocks = new ArrayList();
            }
            allImpactEditblocks.addAll(impactEditblocks);
        }
        if (allImpactEditblocks != null) {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put(Protected_Cause, allImpactEditblocks);
            state.put(Protected_Sheet, this._book.getActiveSheet());
            state.put(Protected_Range, this);
            return state;
        }
        return null;
    }

    public boolean select() {
        if (this.getSelectionProtectState() != null) {
            return false;
        }
        Sheet sheet = this._sheets.getSheet(0);
        Selection sel = sheet.getSheetOption().getSelection();
        sel.changeSelection(CellBlock.getNewCellBlock(this.getBlock(0)), 2);
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            sel.changeSelection(CellBlock.getNewCellBlock(this.getBlock(i)), 1);
        }
        int newIndex = this._book.getSheetIndexByName(sheet.getSheetName());
        int count = this._book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            this._book.getISheet(i).setSelected(false);
        }
        this._book.getISheet(newIndex).setSelected(true);
        if (this._book.getActiveSheetIndex() != newIndex) {
            this._book.setActiveSheet(newIndex);
        }
        this._book.fireSheetChange(this._book.getActiveSheet(), null, SheetChangeEvent.Changed_RangeSelect);
        return true;
    }

    public void getStyle(StyleAttributes sa) {
        this.getStyle(sa, null);
    }

    public void getStyle(StyleAttributes sa, StyleAttributes saInnerBorder) {
        boolean includeBorder;
        sa.clearAttributes();
        long allBits = ShareStyleAttributes.getAllBits();
        long allInnerBorderBits = ShareStyleAttributes.getAllInnerBorderBits();
        boolean bl = includeBorder = saInnerBorder != null;
        if (includeBorder) {
            saInnerBorder.clearAttributes();
        } else {
            allBits ^= ShareStyleAttributes.getAllBorderBits();
        }
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                this.getStyle(sheet, this.getBlock(i), sa, saInnerBorder, includeBorder);
                if (sa.isAllMixed(allBits) && (!includeBorder || includeBorder && saInnerBorder.isAllMixed(allInnerBorderBits))) break block0;
            }
        }
        sa.clearDirtyFlag();
        if (includeBorder) {
            saInnerBorder.clearDirtyFlag();
        }
    }

    public int getStyle(Sheet sheet, CellBlock cb, StyleAttributes sa, StyleAttributes saInnerBorder, boolean includeBorder) {
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        SortedAttributeSpanArray mixRowSpans = sheet.getRowSpans().getSpecifiedAttributeSpansClone(row, row2);
        SortedAttributeSpanArray mixColSpans = sheet.getColSpans().getSpecifiedAttributeSpansClone(col, col2);
        int mixed = this.mixCellsStyleExceptBorder(sheet, cb, sa, mixRowSpans, mixColSpans);
        if (sa.isAllMixed(ShareStyleAttributes.getBitsExceptOuterBorder()) && !includeBorder) {
            return mixed;
        }
        if (includeBorder) {
            Borders bdrs = sheet.getBorders();
            bdrs.getMixedOuterBorders(cb, sa);
            if (saInnerBorder != null) {
                bdrs.getMixedInnerBorders(cb, saInnerBorder);
            }
        }
        sa.append((ShareStyleAttributes)sheet.getStyle(), false);
        sa.clearDirtyFlag();
        return mixed;
    }

    private int mixCellsStyleExceptBorder(Sheet sheet, CellBlock cb, StyleAttributes sa, SortedAttributeSpanArray mixRowSpans, SortedAttributeSpanArray mixColSpans) {
        int mixed;
        long bitsExceptBorder = ShareStyleAttributes.getBitsExceptOuterBorder();
        int row = cb.getRow();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, false);
        if (!ci.hasNext()) {
            mixed = sa.mix((ShareStyleAttributes)sheet.getCellStyle(row, col), true);
        } else {
            SortedRowArray rowObjs = new SortedRowArray();
            int r = -1;
            ArrayList<Style> clls = new ArrayList<Style>();
            while (ci.hasNext()) {
                Cell cll = ci.next();
                clls.add(cll.getStyle());
                if (cll.getRow() == r) continue;
                rowObjs.insert(cll.getRowObject());
                r = cll.getRow();
            }
            ShareStyleAttributes[] styles = new ShareStyleAttributes[clls.size()];
            clls.toArray(styles);
            mixed = sa.mix(styles, true);
            if (!sa.isAllMixed(bitsExceptBorder)) {
                MergeBlocks merger;
                boolean maybeHasFullColumn;
                int width = cb.getWidth();
                int height = cb.getHeight();
                int[] aCol = null;
                boolean bl = maybeHasFullColumn = rowObjs.size() == height;
                if (!maybeHasFullColumn && (merger = sheet.getMerger(false)) != null) {
                    boolean bl2 = maybeHasFullColumn = merger.getContainedBlocks(cb) != null;
                }
                if (maybeHasFullColumn) {
                    aCol = new int[width];
                }
                int rowStart = -1;
                int rowEnd = -1;
                int rs = rowObjs.size();
                for (int r2 = 0; r2 < rs; ++r2) {
                    Row rowObj = rowObjs.getAt(r2);
                    int pos = rowObj.search(col);
                    if (pos >= 0) {
                        CellBlock mb = null;
                        int pos2 = rowObj.search(col2);
                        if (pos2 >= 0 && pos2 - pos + 1 == width || (mb = rowObj.getAt(pos).getMerge(false)) != null && mb.getWidth() == width) {
                            int rr = rowObj.getRow();
                            if (rowStart < 0) {
                                rowStart = rr;
                                rowEnd = rr;
                            } else {
                                rowEnd = rr;
                            }
                            if (mb != null && mb.getHeight() == height && aCol != null) {
                                int cEnd = mb.getCol2();
                                for (int c = mb.getCol(); c <= cEnd; ++c) {
                                    aCol[c - col] = height;
                                }
                            }
                        } else if (rowStart >= 0) {
                            mixRowSpans.setSpanAttribute(new Span(rowStart, rowEnd), null, new Integer(Integer.MIN_VALUE), null, null, null, false);
                            rowStart = -1;
                        }
                    }
                    if (!maybeHasFullColumn) continue;
                    Sheet.ICellsIterator i = rowObj.getCellsIterator(col, col2, false, false);
                    while (i.hasNext()) {
                        int n = i.next().getCol() - col;
                        aCol[n] = aCol[n] + 1;
                    }
                }
                if (rowStart >= 0) {
                    mixRowSpans.setSpanAttribute(new Span(rowStart, rowEnd), null, new Integer(Integer.MIN_VALUE), null, null, null, false);
                }
                if (maybeHasFullColumn) {
                    int colStart = -1;
                    int colEnd = -1;
                    for (int i = 0; i < width; ++i) {
                        int h = aCol[i];
                        if (h >= height) {
                            if (colStart < 0) {
                                colEnd = colStart = col + i;
                                continue;
                            }
                            colEnd = col + i;
                            continue;
                        }
                        if (colStart < 0) continue;
                        mixColSpans.setSpanAttribute(new Span(colStart, colEnd), null, new Integer(Integer.MIN_VALUE), null, null, null, false);
                        colStart = -1;
                    }
                    if (colStart >= 0) {
                        mixColSpans.setSpanAttribute(new Span(colStart, colEnd), null, new Integer(Integer.MIN_VALUE), null, null, null, false);
                    }
                }
            }
        }
        if (!sa.isAllMixed(bitsExceptBorder)) {
            SortedAttributeSpanArray.AttributeSpan span;
            int i;
            int count = mixRowSpans.size();
            for (i = 0; i < count; ++i) {
                span = mixRowSpans.getAttributeSpan(i);
                if (span.getLength() == Integer.MIN_VALUE) continue;
                mixed += sa.mix(span.getSSA(), true);
                if (sa.isAllMixed(bitsExceptBorder)) break;
            }
            if (!sa.isAllMixed(bitsExceptBorder)) {
                count = mixColSpans.size();
                for (i = 0; i < count; ++i) {
                    span = mixColSpans.getAttributeSpan(i);
                    if (span.getLength() == Integer.MIN_VALUE) continue;
                    mixed += sa.mix(span.getSSA(), true);
                    if (sa.isAllMixed(bitsExceptBorder)) break;
                }
            }
        }
        return mixed;
    }

    public boolean setStyle(StyleAttributes sa, StyleAttributes saInnerBorder) {
        if (this.isProtected(this.getCellStyleProtectState())) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            CellBlock block = this.getBlock(i);
            if (null == block || !block.isWholeSheet() || !this.getActiveSheet().isExecuteReportDetection()) continue;
            return this.getActiveSheet().doReportDetection(ALERT_DETECTION_TEXT);
        }
        return new SheetAction_Style(this, sa, saInnerBorder).run();
    }

    public boolean isHasFormula() {
        Cell cll = this.getFirstCell();
        return cll == null ? false : cll.hasFormula();
    }

    public boolean[][] isHasFormulas() {
        Sheet sheet = this.getActiveSheet();
        CellBlock cb = this.getBlock(0);
        boolean[][] arrays = new boolean[cb.getHeight()][cb.getWidth()];
        for (int i = arrays.length - 1; i >= 0; --i) {
            Arrays.fill(arrays[i], false);
        }
        int row = cb.getRow();
        int col = cb.getCol();
        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            arrays[cll.getRow() - row][cll.getCol() - col] = cll.hasFormula();
        }
        return arrays;
    }

    public String getFormula() {
        Cell cll = this.getFirstCell();
        return cll == null ? "" : cll.getFormula();
    }

    public Comment getComment() {
        Cell cll = this.getFirstCell();
        return cll == null ? null : cll.getComment();
    }

    public HyperLink getHyerLink() {
        Cell cll = this.getFirstCell();
        return cll == null ? null : cll.getHyperLink();
    }

    public String[][] getFormulas() {
        Sheet sheet = this.getActiveSheet();
        CellBlock cb = this.getBlock(0);
        String[][] arrays = new String[cb.getHeight()][cb.getWidth()];
        int row = cb.getRow();
        int col = cb.getCol();
        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            arrays[cll.getRow() - row][cll.getCol() - col] = cll.getFormula();
        }
        return arrays;
    }

    public boolean setFormula(String formula) {
        if (this.isProtected(this.getEditProtectState())) {
            return false;
        }
        return new SheetAction_Content(this, formula, Cell.FORMULA).run() && new SheetAction_UpdateAutoFilter(this, SheetChangeEvent.Changed_AutoFilter).run();
    }

    public String getText() {
        Cell cll = this.getFirstCell();
        return cll == null ? "" : cll.getText();
    }

    public Variant getValue() {
        Cell cll = this.getFirstCell();
        return cll == null ? Variant.nullVariant : cll.getValue();
    }

    private Sheet getActiveSheet() {
        return this._sheets.size() > 1 ? this._book.getActiveSheet() : this._sheets.getSheet(0);
    }

    private Cell getFirstCell() {
        CellBlock cb = this.getBlock(0);
        return this.getActiveSheet().getCell(cb.getRow(), cb.getCol(), false);
    }

    public Variant[][] getValues() {
        Sheet sheet = this.getActiveSheet();
        CellBlock cb = this.getBlock(0);
        Variant[][] arrays = new Variant[cb.getHeight()][cb.getWidth()];
        for (int i = arrays.length - 1; i >= 0; --i) {
            Arrays.fill(arrays[i], Variant.nullVariant);
        }
        int row = cb.getRow();
        int col = cb.getCol();
        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            arrays[cll.getRow() - row][cll.getCol() - col] = cll.getValue();
        }
        return arrays;
    }

    public boolean setValue(Variant value) {
        if (this.isProtected(this.getEditProtectState())) {
            return false;
        }
        return new SheetAction_Content(this, value, Cell.VALUE).run();
    }

    public Object getUserObject(String key) {
        Cell cll = this.getFirstCell();
        return cll == null ? null : cll.getUserObjectValue(key);
    }

    public Object[][] getUserObjects(String key) {
        Sheet sheet = this.getActiveSheet();
        CellBlock cb = this.getBlock(0);
        Object[][] arrays = new Variant[cb.getHeight()][cb.getWidth()];
        int row = cb.getRow();
        int col = cb.getCol();
        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            arrays[cll.getRow() - row][cll.getCol() - col] = cll.getUserObjectValue(key);
        }
        return arrays;
    }

    public boolean isCellLocked() {
        Sheet sheet = this.getActiveSheet();
        CellBlock cb = this.getBlock(0);
        return sheet.getCellStyle(cb.getRow(), cb.getCol()).isLocked();
    }

    public boolean setCellLocked(boolean bLocked) {
        if (this.isProtected(this.getCellLockedProtectState())) {
            return false;
        }
        StyleAttributes sa = Styles.getEmptySA();
        StyleAttributes saInner = Styles.getEmptySA();
        sa.setLocked(bLocked);
        return new SheetAction_Style(this, sa, saInner).run();
    }

    public boolean setDiagonalHeader(DiagonalHeader header) {
        if (this.isProtected(this.getEditProtectState())) {
            return false;
        }
        return new SheetAction_Content(this, (Object)header, Cell.DIAGONAL).run();
    }

    public boolean setHyperLink(HyperLink link) {
        if (this.isProtected(this.getHyperLinkProtectState())) {
            return false;
        }
        return new SheetAction_Content(this, link, Cell.HYPERLINK).run();
    }

    public boolean setComment(Comment comment) {
        if (this.isProtected(this.getCommontProtectState())) {
            return false;
        }
        return new SheetAction_Content(this, comment, Cell.COMMENT, SheetChangeEvent.Changed_Commont).run();
    }

    public boolean setUserObject(String key, Object value) {
        if (this.isProtected(this.getEditProtectState())) {
            return false;
        }
        return new SheetAction_Content(this, new UserObject(key, value), Cell.USEROBJECT).run();
    }

    public boolean removeAllUserObjects() {
        if (this.isProtected(this.getEditProtectState())) {
            return false;
        }
        return new SheetAction_Content(this, null, Cell.USEROBJECT).run();
    }

    public boolean merge() {
        if (this.isProtected(this.getMergerProtectState())) {
            return false;
        }
        return new SheetAction_Merge(this).run();
    }

    public boolean hasInnerBorder(boolean bHorizontal) {
        boolean has = false;
        block0: for (int i = this.size() - 1; i >= 0; --i) {
            CellBlock cb = this.getBlock(i);
            if ((bHorizontal ? cb.getHeight() : cb.getWidth()) <= 1) continue;
            has = true;
            for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
                Sheet sheet = this._sheets.getSheet(sh);
                if (!sheet.isMerged(cb)) continue;
                has = false;
                break block0;
            }
        }
        return has;
    }

    public Integer getColumnWidth() {
        Integer width = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            SortedAttributeSpanArray colSpans = sheet.getColSpans();
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock cb = this.getBlock(i);
                if (width == null) {
                    width = colSpans.getLength(cb.getColSpan());
                    continue;
                }
                if (width.equals(colSpans.getLength(cb.getColSpan()))) continue;
                width = null;
                break block0;
            }
        }
        return width;
    }

    public Integer getOriginalColumnWidth() {
        Integer width = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            SortedAttributeSpanArray colSpans = sheet.getColSpans();
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock cb = this.getBlock(i);
                if (width == null) {
                    width = colSpans.getOriginalLength(cb.getColSpan());
                    continue;
                }
                if (width.equals(colSpans.getOriginalLength(cb.getColSpan()))) continue;
                width = null;
                break block0;
            }
        }
        return width;
    }

    public boolean setColumnWidth(int width) {
        if (this.isProtected(this.getColStyleProtectState())) {
            return false;
        }
        return this.setSpanAttribute(new Integer(width), null, null, null, false);
    }

    public Integer getOutlineGroupLevel() {
        Integer groupLevel = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock cb = this.getBlock(i);
                if (groupLevel == null) {
                    groupLevel = this.getOutlineGroupLevel(sheet, cb);
                    continue;
                }
                if (groupLevel.equals(this.getOutlineGroupLevel(sheet, cb))) continue;
                groupLevel = null;
                break block0;
            }
        }
        return groupLevel;
    }

    private Integer getOutlineGroupLevel(Sheet sheet, CellBlock cb) {
        if (cb.isRow()) {
            return sheet.getRowSpans().getOutlineGroupLevel(cb.getRowSpan());
        }
        if (cb.isCol()) {
            return sheet.getColSpans().getOutlineGroupLevel(cb.getColSpan());
        }
        return ObjectCache.getInteger((int)0);
    }

    public Boolean getOutlineGroupCollapse() {
        Boolean collapse = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 1; --i) {
                CellBlock cb = this.getBlock(i);
                if (collapse == null) {
                    collapse = this.getOutlineGroupCollapse(sheet, cb);
                    continue;
                }
                if (collapse.equals(this.getOutlineGroupCollapse(sheet, cb))) continue;
                collapse = null;
                break block0;
            }
        }
        return collapse;
    }

    private Boolean getOutlineGroupCollapse(Sheet sheet, CellBlock cb) {
        if (cb.isRow()) {
            return sheet.getRowSpans().getOutlineGroupCollapse(cb.getRowSpan());
        }
        if (cb.isCol()) {
            return sheet.getColSpans().getOutlineGroupCollapse(cb.getColSpan());
        }
        return Boolean.FALSE;
    }

    public boolean setColumnOutlineGroupLevel(int groupLevel) {
        return this.setSpanAttribute(null, null, new Integer(groupLevel), null, false);
    }

    public boolean setColumnOutlineGroupCollapse(boolean collapse) {
        return this.setSpanAttribute(null, null, null, new Boolean(collapse), false);
    }

    public boolean setRowOutlineGroupLevel(int groupLevel) {
        return this.setSpanAttribute(null, null, new Integer(groupLevel), null, true);
    }

    public boolean setRowOutlineGroupCollapse(boolean collapse) {
        return this.setSpanAttribute(null, null, null, new Boolean(collapse), true);
    }

    public Integer getRowHeight() {
        Integer height = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock cb = this.getBlock(i);
                if (height == null) {
                    height = rowSpans.getLength(cb.getRowSpan());
                    continue;
                }
                if (height.equals(rowSpans.getLength(cb.getRowSpan()))) continue;
                height = null;
                break block0;
            }
        }
        return height;
    }

    public Integer getOriginalRowHeight() {
        Integer height = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock cb = this.getBlock(i);
                if (height == null) {
                    height = rowSpans.getOriginalLength(cb.getRowSpan());
                    continue;
                }
                if (height.equals(rowSpans.getOriginalLength(cb.getRowSpan()))) continue;
                height = null;
                break block0;
            }
        }
        return height;
    }

    public boolean setRowHeight(int height) {
        if (this.isProtected(this.getRowStyleProtectState())) {
            return false;
        }
        return this.setSpanAttribute(new Integer(height), null, null, null, true);
    }

    public Boolean getHidden() {
        Boolean hidden = null;
        block0: for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock cb = this.getBlock(i);
                if (hidden == null) {
                    hidden = this.getHidden(sheet, cb);
                    continue;
                }
                if (hidden.equals(this.getHidden(sheet, cb))) continue;
                hidden = null;
                break block0;
            }
        }
        return hidden;
    }

    private Boolean getHidden(Sheet sheet, CellBlock cb) {
        if (cb.isRow()) {
            return sheet.getRowSpans().getHidden(cb.getRowSpan());
        }
        if (cb.isCol()) {
            return sheet.getColSpans().getHidden(cb.getColSpan());
        }
        return Boolean.FALSE;
    }

    public boolean setHidden(boolean hidden, boolean bRow) {
        if (bRow ? this.isProtected(this.getRowStyleProtectState()) : this.isProtected(this.getColStyleProtectState())) {
            return false;
        }
        return this.setSpanAttribute(null, !hidden, null, null, bRow);
    }

    public boolean setRowHidden(boolean hidden) {
        return this.setHidden(hidden, true);
    }

    public boolean setColumnHidden(boolean hidden) {
        return this.setHidden(hidden, false);
    }

    public boolean insert() {
        return this.insert(false);
    }

    public boolean insert(boolean yDir) {
        return this.insert(yDir, this.getInsertType());
    }

    private InsertType getInsertType() {
        InsertType type = null;
        if (this._sheets.size() > 0) {
            Sheet sheet = this._sheets.getSheet(0);
            type = sheet.getSheetOption().getInsertType();
        }
        return type == null ? InsertType.FLLOW_UP_STYLE : type;
    }

    public boolean insert(boolean yDir, InsertType insType) {
        boolean fill;
        if (this.isProtected(this.getInsertProtectState())) {
            return false;
        }
        if (this.isExceedRowColLimit(yDir)) {
            // empty if block
        }
        if (this.isBreakMergeBlocks(yDir)) {
            return false;
        }
        boolean bl = fill = insType != InsertType.NOSTYLE;
        if (fill) {
            this._book.getUndoManager().startGroup();
        }
        boolean ret = new SheetAction_InsDel(this, true, yDir).run();
        if (fill) {
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock dst;
                CellBlock src;
                CellBlock cb = this.getBlock(i);
                if (yDir) {
                    if (insType == InsertType.FLLOW_UP_STYLE) {
                        if (cb.getRow() <= 0) continue;
                        src = (CellBlock)cb.clone();
                        dst = (CellBlock)cb.clone();
                        src.offset(-1, 0);
                        src.setRow2(src.getRow());
                        dst.setRow(src.getRow());
                        ret |= new Range(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
                        continue;
                    }
                    if (cb.getRow2() >= 1048575) continue;
                    src = (CellBlock)cb.clone();
                    dst = (CellBlock)cb.clone();
                    src.offset(1, 0);
                    src.setRow(src.getRow2());
                    dst.setRow2(src.getRow());
                    ret |= new Range(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
                    continue;
                }
                if (insType == InsertType.FLLOW_UP_STYLE) {
                    if (cb.getCol() <= 0) continue;
                    src = (CellBlock)cb.clone();
                    dst = (CellBlock)cb.clone();
                    src.offset(0, -1);
                    src.setCol2(src.getCol());
                    dst.setCol(src.getCol());
                    ret |= new Range(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
                    continue;
                }
                if (cb.getCol2() >= 16383) continue;
                src = (CellBlock)cb.clone();
                dst = (CellBlock)cb.clone();
                src.offset(0, 1);
                src.setCol(src.getCol2());
                dst.setCol2(src.getCol());
                ret |= new Range(this._book, this._sheets, src).fill(dst, FillType.FORMAT, null);
            }
            this._book.getUndoManager().endGroup();
        }
        return ret;
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean yDir) {
        if (this.isProtected(this.getDeleteProtectState())) {
            return false;
        }
        if (this.isBreakMergeBlocks(yDir)) {
            return false;
        }
        return new SheetAction_InsDel(this, false, yDir).run();
    }

    public boolean clear(boolean formula, boolean value, boolean format, boolean comment) {
        return this.clear(formula, value, format, comment, null);
    }

    public boolean clear(boolean formulaAndValue, boolean format, boolean comment, String[] userKeys) {
        return this.clear(formulaAndValue, formulaAndValue, format, comment, userKeys);
    }

    public boolean clear(boolean formula, boolean value, boolean format, boolean comment, String[] userKeys) {
        if (!(formula || value || format || comment || userKeys != null)) {
            return false;
        }
        this.isProtected(this.getEditProtectState());
        return new SheetAction_Clear(this, formula, value, format, comment, userKeys).run() && new SheetAction_UpdateAutoFilter(this, SheetChangeEvent.Changed_AutoFilter).run();
    }

    public FillType getPossibleFillType(CellBlock dst) {
        FillType resultType = new FillType(1792);
        CellBlock src = this.getBlock(0);
        boolean yDir = src.getWidth() == dst.getWidth();
        int srcRow = src.getRow();
        int srcCol = src.getCol();
        Sheet sheet = this._book.getActiveSheet();
        int srcHeight = Math.min(sheet.getMaxRowIndex() + 1, src.getHeight());
        int srcWidth = Math.min(sheet.getMaxColIndex() + 1, src.getWidth());
        if (yDir) {
            for (int i = 0; i < srcWidth; ++i) {
                sheet.getTrendFactor(srcRow, srcCol + i, srcHeight, true, FillType.DEFAULT, resultType);
            }
        } else {
            for (int i = 0; i < srcHeight; ++i) {
                sheet.getTrendFactor(srcRow + i, srcCol, srcWidth, false, FillType.DEFAULT, resultType);
            }
        }
        return resultType;
    }

    public Size replace(SortedObjectArray sa, CellFinder.ICellReplacer rpl) {
        Size replaced = new Size();
        if (sa.size() == 0) {
            return replaced;
        }
        SheetAction_Replace action = new SheetAction_Replace(this, sa, rpl);
        if (action.run()) {
            replaced = action.getReplaced();
        }
        return replaced;
    }

    public boolean fill(CellBlock dst, FillType type, FillType resultType) {
        return this.fill(dst, type, resultType, null);
    }

    public boolean fill(CellBlock dst, FillType type, FillType resultType, String[] userKeys) {
        if (this._sheets.size() == 0) {
            return this.fill(this._book.getActiveSheet(), dst, type, resultType, userKeys);
        }
        boolean flag = true;
        for (int i = 0; i < this._sheets.size(); ++i) {
            flag = flag && this.fill(this._sheets.getSheet(i), dst, type, resultType, userKeys);
        }
        return flag;
    }

    private boolean fill(Sheet sheet, CellBlock dst, FillType type, FillType resultType, String[] userKeys) {
        boolean ret;
        SortedCellBlockArray mergeBlocks;
        CellBlock src = this.getBlock(0);
        CellBlock pureDst = null;
        boolean fill = dst.contains(src);
        boolean clear = src.contains(dst);
        CellBlock bound = fill ? dst : src;
        SortedCellBlockArray srcMergeBlocks = null;
        boolean merge = false;
        boolean unmerge = false;
        boolean checked = !(!fill && !clear || !dst.equalsRow(src) && !dst.equalsCol(src));
        boolean isProtected = false;
        if (checked) {
            MergeBlocks merger = sheet.getMerger(false);
            if (merger != null && (mergeBlocks = merger.getTouchedBlocks(bound)) != null) {
                checked = bound.contains(mergeBlocks.getBounds());
            }
            if (checked) {
                if (clear) {
                    pureDst = dst;
                } else {
                    SortedCellBlockArray sa = new SortedCellBlockArray();
                    src.split(dst, sa);
                    pureDst = sa.getBlock(0);
                }
                Range dstRange = sheet.getRange(pureDst);
                isProtected = this.isProtected(dstRange.getEditProtectState());
                if (isProtected) {
                    checked = false;
                } else if (merger != null) {
                    srcMergeBlocks = merger.getTouchedBlocks(src);
                    merge = srcMergeBlocks != null;
                    boolean bl = unmerge = merger.getTouchedBlocks(pureDst) != null;
                }
            }
        }
        if (!checked) {
            return false;
        }
        if (merge || unmerge) {
            this._book.getUndoManager().startGroup();
            if (unmerge) {
                sheet.getRange(pureDst).merge();
            }
        }
        if (clear) {
            ret = new Range(this._book, this._book.getActiveSheet(), dst).clear(true, true, true, false);
        } else {
            ret = new SheetAction_Fill(this, dst, type, resultType, userKeys).run();
            if (merge) {
                mergeBlocks = new SortedCellBlockArray();
                mergeBlocks.copyFrom(srcMergeBlocks);
                int mergeCount = mergeBlocks.size();
                int dr = -src.getRow();
                int dc = -src.getCol();
                for (int m = 0; m < mergeCount; ++m) {
                    mergeBlocks.getBlock(m).offset(dr, dc);
                }
                int dstRow = pureDst.getRow();
                int dstCol = pureDst.getCol();
                int dstRow2 = pureDst.getRow2();
                int dstCol2 = pureDst.getCol2();
                if (dst.equalsCol(src)) {
                    boolean positive = pureDst.getRow() > src.getRow();
                    int step = src.getHeight();
                    int end = (int)Math.ceil((double)pureDst.getHeight() / (double)step);
                    int row = positive ? pureDst.getRow() - step : pureDst.getRow2() + 1;
                    int col = pureDst.getCol();
                    block1: for (int m = 0; m < mergeCount; ++m) {
                        CellBlock cb = CellBlock.getNewCellBlock(mergeBlocks.getBlock(m));
                        cb.offset(row, col);
                        for (int i = 0; i < end; ++i) {
                            cb.offset((positive ? 1 : -1) * step, 0);
                            if ((positive ? cb.limitRowCol2(dstRow2, dstCol2) : cb.limitRowCol(dstRow, dstCol)) && cb.isRowColReversed()) continue block1;
                        }
                    }
                } else {
                    boolean positive = pureDst.getCol() > src.getCol();
                    int step = src.getWidth();
                    int end = (int)Math.ceil((double)pureDst.getWidth() / (double)step);
                    int col = positive ? pureDst.getCol() - step : pureDst.getCol2() + 1;
                    int row = pureDst.getRow();
                    block3: for (int m = 0; m < mergeCount; ++m) {
                        CellBlock cb = CellBlock.getNewCellBlock(mergeBlocks.getBlock(m));
                        cb.offset(row, col);
                        for (int i = 0; i < end; ++i) {
                            cb.offset(0, (positive ? 1 : -1) * step);
                            if ((positive ? cb.limitRowCol2(dstRow2, dstCol2) : cb.limitRowCol(dstRow, dstCol)) && cb.isRowColReversed()) continue block3;
                        }
                    }
                }
            }
        }
        if (merge || unmerge) {
            this._book.getUndoManager().endGroup();
        }
        return ret;
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean withSheetName) {
        return this.getName(withSheetName, false, false);
    }

    public String getName(boolean bFull, boolean abs, boolean onlyNamed) {
        String name = null;
        Sheet sheet = this._sheets.getSheet(0);
        if (this._sheets.size() == 1) {
            name = sheet.getNames().getName(this, sheet, sheet);
            if (name == null) {
                name = this._book.getNames().getName(this, sheet, sheet);
            }
            if (name == null && !onlyNamed) {
                name = bFull ? sheet.getSyntaxName() + '!' : "";
                name = name + SheetBaseMath.getBlocksName(this, sheet.getDeps().isA1Style(), abs);
            }
        } else {
            Sheet sheet2 = this._sheets.getSheet(this._sheets.size() - 1);
            name = this._book.getNames().getName(this, sheet, sheet2);
            if (name == null && !onlyNamed) {
                name = bFull ? '\'' + sheet.getSyntaxName() + ':' + sheet2.getSyntaxName() + '\'' + '!' : "";
                name = name + SheetBaseMath.getBlocksName(this, sheet.getDeps().isA1Style(), abs);
            }
        }
        return name;
    }

    public boolean setScale(int scale) {
        return new SheetAction_Scale(this, scale).run();
    }

    public boolean setName(String name, String refersTo) throws SyntaxErrorException {
        Sheet sheet;
        NamedObjectNode no = null;
        if (!StringUtil.isEmptyString((String)name)) {
            IExprNode[] nodes;
            Dependents deps = this._book.getDeps();
            boolean old = deps.isA1Style();
            deps.setA1Style(true);
            Expr expr = this._book.getActiveSheet().getExpr(null, name);
            deps.setA1Style(old);
            if (expr != null && !expr.isSyntaxError() && expr.getExprOps().getNodes().length == 1 && (nodes = expr.getParameters()) != null && nodes[0] instanceof NamedObjectNode) {
                no = (NamedObjectNode)nodes[0];
            }
        }
        if (no == null) {
            throw new SyntaxErrorException(1L, (Object)"name");
        }
        if (no.isLocal()) {
            this._book.getNames().updateExpr(no.getName());
        }
        Expr expr = null;
        if (!StringUtil.isEmptyString((String)refersTo) && (expr = (sheet = this._book.getActiveSheet()).getExpr(no, refersTo)).isSyntaxError()) {
            if (refersTo.charAt(0) != '=') {
                expr = sheet.getExpr(no, '\"' + refersTo + '\"');
            }
            if (expr.isSyntaxError()) {
                throw new SyntaxErrorException(1L, (Object)"refersTo");
            }
        }
        return new SheetAction_Named(this, no, expr).run();
    }

    public void calc() {
        this.calc(true);
    }

    public void calc(boolean clearQueryManager) {
        int size = this.size();
        Dependents deps = this._book.getDeps();
        if (clearQueryManager) {
            deps.getQueryManager().clear();
        }
        boolean queueRefer = this._book.isAutoCalculate();
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            if (!sheet.isEnableCalculation()) continue;
            for (int i = 0; i < size; ++i) {
                CellBlock cb = this.getBlock(i);
                int r2 = cb.getRow2();
                for (int r = cb.getRow(); r <= r2; ++r) {
                    int c2 = cb.getCol2();
                    for (int c = cb.getCol(); c <= c2; ++c) {
                        Cell cell = sheet.getCell(r, c, false);
                        if (cell == null) continue;
                        cell.queue(deps, queueRefer);
                    }
                }
            }
        }
        this._book.resumeUnknownMethod();
        deps.calc();
    }

    public boolean copy() {
        if (!this.isProtected(this.getCopyState())) {
            ClipboardTransferHandler.exportToClipboard(this._book, this, KDClipboard.createUUID());
            KDClipboard.setCut(false);
            return true;
        }
        return false;
    }

    public boolean copyTo(Sheet srcSheet, Range dstRange, PasteMode pasteMode) {
        ClipboardTransferHandler.getClipDstBook(srcSheet, (SortedCellBlockArray)this);
        Book book = KDClipboard.getClipboardBook();
        dstRange.paste(book, pasteMode, null);
        return true;
    }

    public boolean cut() {
        if (this.isProtected(this.getCopyState())) {
            return false;
        }
        if (this.isProtected(this.getEditProtectState())) {
            return false;
        }
        boolean bRet = false;
        bRet = ClipboardTransferHandler.exportToClipboard(this._book, this, KDClipboard.createUUID());
        if (bRet) {
            KDClipboard.setCut(true);
        }
        return bRet;
    }

    public boolean paste(PasteMode mode) {
        return this.paste(mode, null);
    }

    public boolean paste(PasteMode mode, String[] userKeys) {
        return this.paste(mode, userKeys, 0);
    }

    public boolean isMergeLimit() {
        return this._isMergeLimit;
    }

    public boolean paste(PasteMode mode, String[] userKeys, int cf) {
        boolean ret = false;
        if (ClipboardTransferHandler.isClipboardDataAvailable()) {
            Object data = ClipboardTransferHandler.importFromClipboard(this._book, cf);
            ret = this.paste(data, mode, userKeys);
        }
        return ret;
    }

    private boolean paste(Object data, PasteMode mode, String[] userKeys) {
        boolean ret = false;
        if (data != null) {
            if (data instanceof Book) {
                Book srcBook = (Book)data;
                if (KDClipboard.isCut()) {
                    KDClipboard.setCut(false);
                }
                CellBlock blockInfo = CellBlock.getNewCellBlock(0, 0);
                SortedCellBlockArray pasteBlocks = this.makePasteBlocks(srcBook.getSheet(0), blockInfo);
                if (this.getMergeLimitProtectState() != null) {
                    this._isMergeLimit = true;
                    if (!this.isHeadLess) {
                        MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText(ALERT_STR_KEY, ALERT_MESSAGE_STR), (String)MultiLanguageKeys.getLocalText("warning", "\u8b66\u544a"), (int)-1, (int)2);
                    }
                    return false;
                }
                if (pasteBlocks != null) {
                    Protection pro;
                    if (!KDClipboard.isOffset()) {
                        mode = mode.noOffset();
                    }
                    if ((pro = this._book.getActiveSheet().getSheetOption().getProtection(false)) != null && !pro.allowFormattingCells()) {
                        mode = PasteMode.FORMULASANDVALUES;
                    }
                    if (!this.checkPasteValidity(srcBook, mode)) {
                        if (!this.isHeadLess) {
                            MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText(ALERT_STR_KEY, ALERT_MESSAGE_STR), (String)MultiLanguageKeys.getLocalText("warning", "\u8b66\u544a"), (int)-1, (int)2);
                        }
                        return false;
                    }
                    if (this.getBlock(0) != null) {
                        CellBlock cb = this.getBlock(0);
                        SheetAction_Paste paste = null;
                        paste = null != cb && (cb.isCol() || cb.isRow()) ? new SheetActionColRow_Paste(this, srcBook, pasteBlocks, blockInfo, mode, userKeys) : new SheetAction_Paste(this, srcBook, pasteBlocks, blockInfo, mode, userKeys);
                        ret = paste.run();
                        if (paste.isIgnoredProtectedCell()) {
                            this.actionBreak(Sheet.WARNNING, this.getPasteProtectState());
                        }
                    }
                } else if (!this.isHeadLess) {
                    MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText(ALERT_STR_KEY, ALERT_MESSAGE_STR), (String)MultiLanguageKeys.getLocalText("warning", "\u8b66\u544a"), (int)-1, (int)2);
                }
            } else {
                StringWalker.SeperateResult sr = StringWalker.separate2Array((String)data);
                int rows = sr.getRowCount();
                int cols = sr.getColCount();
                this.adjustPasteRange(rows, cols);
                if (this.isProtected(this.getPasteProtectState())) {
                    return false;
                }
                ret = new SheetAction_StringPaste(this, (String)data).run();
            }
        }
        return ret;
    }

    private boolean checkPasteValidity(Book srcBook, PasteMode mode) {
        Sheet dstSheet = this._book.getActiveSheet();
        Sheet srcSheet = srcBook.getActiveSheet();
        CellBlock cb = this.getBlock(0);
        boolean justPasteValue = mode == PasteMode.VALUES;
        MergeBlocks allDstMerger = dstSheet.getMerger(false);
        if (allDstMerger == null) {
            return true;
        }
        SortedCellBlockArray dstMerger = allDstMerger.getTouchedBlocks(cb);
        int offsetY = cb.getRow();
        int offsetX = cb.getCol();
        if (justPasteValue && dstMerger != null && dstMerger.size() > 0) {
            MergeBlocks srcMerger = srcSheet.getMerger(false);
            if (srcMerger == null) {
                return false;
            }
            if (srcMerger.size() != dstMerger.size()) {
                return false;
            }
            int size = dstMerger.size();
            for (int i = 0; i < size; ++i) {
                CellBlock srcBlock = srcMerger.getBlock(i);
                CellBlock dstBlock = dstMerger.getBlock(i);
                if (srcBlock.getCol() == dstBlock.getCol() - offsetX && srcBlock.getCol2() == dstBlock.getCol2() - offsetX && srcBlock.getRow() == dstBlock.getRow() - offsetY && srcBlock.getRow2() == dstBlock.getRow2() - offsetY) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean makePasteBlocks(SortedCellBlockArray srcBlocks, SortedCellBlockArray pasteBlocks, CellBlock blockInfo) {
        int i;
        int blockCols = srcBlocks.getBlocksColumnNum();
        blockInfo.setCol(blockCols);
        int blockRows = srcBlocks.size() / blockCols;
        blockInfo.setRow(blockRows);
        int cols = 0;
        int rows = 0;
        for (i = 0; i < blockCols; ++i) {
            cols += srcBlocks.getBlock(i).getWidth();
        }
        blockInfo.setCol2(cols);
        for (i = 0; i < blockRows; ++i) {
            rows += srcBlocks.getBlock(i * blockCols).getHeight();
        }
        blockInfo.setRow2(rows);
        int row2 = 0;
        int col2 = 0;
        int size = pasteBlocks.size();
        for (int i2 = 0; i2 < size; ++i2) {
            CellBlock cb = pasteBlocks.getBlock(i2);
            if (cb.getWidth() < cols) {
                col2 = cb.getCol() + cols - 1;
                if (col2 > 16383) {
                    return false;
                }
                cb.setCol2(col2);
            }
            if (cb.getHeight() < rows) {
                row2 = cb.getRow() + rows - 1;
                if (row2 > 1048575) {
                    return false;
                }
                cb.setRow2(row2);
            }
            if (cb.getWidth() % cols == 0 && cb.getHeight() % rows == 0) continue;
            return false;
        }
        return true;
    }

    private SortedCellBlockArray makePasteBlocks(Sheet srcSheet, CellBlock blockInfo) {
        int i;
        if (KDClipboard.getSourceSheets() != null && KDClipboard.getSourceSheets().getSheet(0) == this._book.getActiveSheet() && KDClipboard.getSourceSelection().getBlock(0).equals(this.getBlock(0))) {
            return null;
        }
        SortedCellBlockArray srcSelection = srcSheet.getSheetOption().getSelection().toSortedBlocks();
        int blockCols = srcSelection.getBlocksColumnNum();
        blockInfo.setCol(blockCols);
        int blockRows = srcSelection.size() / blockCols;
        blockInfo.setRow(blockRows);
        if (srcSelection.isSingleBlock()) {
            CellBlock block = srcSelection.getBlock(0);
            MergeBlocks mb = srcSheet.getSheetOption().getMerger(false);
            if (block.isSingleCell() || mb != null && mb.isMerged(block)) {
                block.setRowCol(0, 0, Math.max(0, srcSheet.getMaxRowIndex()), Math.max(0, srcSheet.getMaxColIndex()));
            }
        }
        int cols = 0;
        int rows = 0;
        for (i = 0; i < blockCols; ++i) {
            cols += srcSelection.getBlock(i).getWidth();
        }
        blockInfo.setCol2(cols);
        for (i = 0; i < blockRows; ++i) {
            rows += srcSelection.getBlock(i * blockCols).getHeight();
        }
        blockInfo.setRow2(rows);
        if (!this.adjustPasteRange(rows, cols)) {
            return null;
        }
        return srcSelection;
    }

    private boolean adjustPasteRange(int rows, int cols) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            CellBlock cb = this.getBlock(i);
            if (cb.getWidth() < cols) {
                int col = cb.getCol() + cols - 1;
                if (col > 16383) {
                    return false;
                }
                cb.setCol2(col);
            } else if (cb.isRow()) {
                cb.setCol2(cb.getCol() + cols - 1);
            }
            if (cb.getHeight() < rows) {
                int row = cb.getRow() + rows - 1;
                if (row > 1048575) {
                    return false;
                }
                cb.setRow2(row);
            } else if (cb.isCol()) {
                cb.setRow2(cb.getRow() + rows - 1);
            }
            if (cb.getWidth() % cols == 0 && cb.getHeight() % rows == 0) continue;
            return false;
        }
        return true;
    }

    protected boolean hasDiffMerge() {
        return false;
    }

    public boolean sort(int[] keys, boolean[] orders, boolean bRowsSort, boolean matchCase) {
        if (this.isProtected(this.getSortProtectState()) || this.hasDiffMerge()) {
            return false;
        }
        Sheet sheet = this._book.getActiveSheet();
        CellBlock block = this.getBlock(0);
        Object[] groups = null;
        CellComparator cpr = new CellComparator(keys, orders, bRowsSort, matchCase);
        groups = this.getSortedGroups(sheet, block, cpr);
        if (groups == null) {
            return false;
        }
        Sheet sortSheet = null;
        Book sortBook = Book.Manager.getNewBook("_Sort_", 1);
        sortBook.setAutoCalculate(false);
        sortBook.getUndoManager().enable(false);
        sortSheet = sortBook.getSheet(0);
        if (bRowsSort) {
            int srcCol = block.getCol();
            int srcCol2 = block.getCol2();
            int srcRow = block.getRow();
            boolean allRow = block.isRow();
            if (block.isCol()) {
                sheet.copyAttributeSpan(false, srcCol, srcCol2, sortSheet, srcCol);
            }
            for (int i = 0; i < groups.length; ++i) {
                Row rowObj = (Row)groups[i];
                int row = rowObj.getRow();
                int pos = rowObj.getProperPos(srcCol, false);
                int pos2 = rowObj.getProperPos(srcCol2, true);
                if (allRow) {
                    sheet.copyAttributeSpan(true, row, row, sortSheet, srcRow + i);
                }
                while (pos <= pos2) {
                    Cell cllSrc = rowObj.getAt(pos);
                    Cell cllDst = sortSheet.getCell(srcRow + i, cllSrc.getCol(), true);
                    cllDst.copyFrom(cllSrc, PasteMode.ALL, false, new String[0], false);
                    ++pos;
                }
            }
        } else {
            int srcRow = block.getRow();
            int srcRow2 = block.getRow2();
            int srcCol = block.getCol();
            boolean allCol = block.isCol();
            for (int i = 0; i < groups.length; ++i) {
                int col = ((Column)groups[i]).getCol();
                if (allCol) {
                    sheet.copyAttributeSpan(false, col, col, sortSheet, srcCol + i);
                }
                Sheet.ICellsIterator iter = sheet.getCellsIterator(srcRow, col, srcRow2, col, false, false);
                while (iter.hasNext()) {
                    Cell cllSrc = iter.next();
                    Cell cllDst = sortSheet.getCell(cllSrc.getRow(), srcCol + i, true);
                    cllDst.copyFrom(cllSrc, PasteMode.ALL, false, new String[0], false);
                }
            }
        }
        SortedCellBlockArray sortBlocks = new SortedCellBlockArray();
        sortBlocks.insert(block);
        int h = block.getHeight();
        int w = block.getWidth();
        return new SheetAction_Paste(this, sortSheet.getBook(), sortBlocks, CellBlock.getNewCellBlock(1, 1, h, w), PasteMode.ALL, new String[0], SheetChangeEvent.Changed_Range_Sort).run();
    }

    private Object[] getSortedGroups(Sheet sheet, CellBlock block, CellComparator cpr) {
        int size;
        int i;
        int pos2;
        SortedRowArray _rows = sheet.getRows();
        SortedColumnArray _cols = sheet.getCols();
        boolean rowsSort = cpr.isRowsSort();
        int pos = rowsSort ? _rows.getProperPos(block.getRow(), false) : _cols.getProperPos(block.getCol(), false);
        int n = pos2 = rowsSort ? _rows.getProperPos(block.getRow2(), true) : _cols.getProperPos(block.getCol2(), true);
        if (pos > pos2) {
            return null;
        }
        Object[] groups = new Object[pos2 - pos + 1];
        Object[] groupsBak = new Object[groups.length];
        if (rowsSort) {
            i = 0;
            while (pos <= pos2) {
                groups[i] = _rows.getAt(pos);
                ++pos;
                ++i;
            }
        } else {
            i = 0;
            while (pos <= pos2) {
                groups[i] = _cols.getAt(pos);
                ++pos;
                ++i;
            }
        }
        KDToolkit.arraycopy((Object[])groups, (int)0, (Object[])groupsBak, (int)0, (int)groups.length);
        int start = rowsSort ? _rows.getProperPos(block.getRow(), false) : _cols.getProperPos(block.getCol(), false);
        int n2 = size = rowsSort ? Math.abs(start - _rows.getProperPos(block.getRow2(), true)) + 1 : Math.abs(start - _cols.getProperPos(block.getCol2(), true)) + 1;
        if (size == groups.length) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i2 = 0; i2 < size; ++i2) {
                if (rowsSort) {
                    if (SheetBaseMath.getRowHeight(sheet, start + i2) <= 0) continue;
                    list.add(groups[i2]);
                    groups[i2] = null;
                    continue;
                }
                if (SheetBaseMath.getColWidth(sheet, start + i2) <= 0) continue;
                list.add(groups[i2]);
                groups[i2] = null;
            }
            Object[] instead = list.toArray();
            Arrays.sort(instead, cpr);
            int j = 0;
            for (int i3 = 0; i3 < groups.length; ++i3) {
                if (groups[i3] != null) continue;
                groups[i3] = instead[j];
                ++j;
            }
        }
        return Arrays.equals(groups, groupsBak) ? null : groups;
    }

    private boolean setSpanAttribute(Integer length, Boolean visible, Integer groupLevel, Boolean collapse, boolean bRow) {
        return new SheetAction_AttributeSpan(this, null, length, visible, groupLevel, collapse, bRow).run();
    }

    private boolean isBreakMergeBlocks(boolean yDir) {
        for (int sh = this._sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = this._sheets.getSheet(sh);
            for (int i = this.size() - 1; i >= 0; --i) {
                CellBlock block = this.getBlock(i);
                if (!sheet.isBreakMergeBlocks(block, yDir)) continue;
                HashMap<String, Object> state = new HashMap<String, Object>();
                state.put(Protected_OtherCause, OtherCause_MergeLimit);
                state.put(Protected_Sheet, sheet);
                state.put(Protected_Range, this);
                this.actionBreak(Sheet.WARNNING, state);
                return true;
            }
        }
        return false;
    }

    public boolean isIgnoreProtected() {
        return this.ignoreProtected;
    }

    public void setIgnoreProtected(boolean ignoreProtected) {
        this.ignoreProtected = ignoreProtected;
    }

    public boolean insertEmbedObject(EmbedObject obj) {
        return new SheetAction_InsertEmObject(this, obj).run();
    }

    public boolean insertValidataion(MessagedValidate mv) {
        return new SheetAction_InsertValidation(this, mv).run();
    }

    public boolean insertConditionalformat(Condition[] conditions, ShareStyleAttributes[] ss) {
        return new SheetAction_InsertConditionalFormat(this, conditions, ss).run();
    }

    public boolean insertConditionalformatFurther(Object fObject, int type) {
        return new SheetAction_InsertConditionalFormatFurther(this, fObject, type).run();
    }

    public Sheet.ICellsIterator getIterator(boolean bDescend) {
        return this.getIterator(bDescend, true, true);
    }

    public Sheet.ICellsIterator getIterator(boolean bDescend, boolean skip, boolean forContentCell) {
        this.it = new RangeCellsIterator(bDescend, skip, forContentCell);
        return this.it;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public Cell next() {
        return this.it.next();
    }

    @Override
    public boolean hasData() {
        return this.it.hasData();
    }

    public Sheet getCurrentSheet() {
        return ((RangeCellsIterator)this.it).getCurrentSheet();
    }

    private class RangeCellsIterator
    implements Sheet.ICellsIterator {
        private int sheetIndex;
        private boolean skipUncreate;
        private boolean bDescend;
        private boolean forContentCell;
        private int cellBlockIndex = 0;
        private Sheet.ICellsIterator cSheetCellsIterator;

        public RangeCellsIterator(boolean bDescend, boolean skipUnCreate, boolean forContentCell) {
            this.skipUncreate = skipUnCreate;
            this.bDescend = bDescend;
            this.forContentCell = forContentCell;
            this.sheetIndex = bDescend ? Range.this._sheets.size() - 1 : 0;
            this.cSheetCellsIterator = Range.this._sheets.getSheet(this.sheetIndex).getCellsIterator(Range.this.getBlock(this.cellBlockIndex), bDescend, forContentCell, this.skipUncreate);
        }

        @Override
        public boolean hasNext() {
            if (!this.cSheetCellsIterator.hasNext()) {
                if (this.cellBlockIndex < Range.this.size() - 1) {
                    ++this.cellBlockIndex;
                    this.cSheetCellsIterator = Range.this._sheets.getSheet(this.sheetIndex).getCellsIterator(Range.this.getBlock(this.cellBlockIndex), this.bDescend, this.forContentCell, this.skipUncreate);
                } else if (this.bDescend && this.sheetIndex >= 0) {
                    --this.sheetIndex;
                    this.cellBlockIndex = 0;
                    this.cSheetCellsIterator = Range.this._sheets.getSheet(this.sheetIndex).getCellsIterator(Range.this.getBlock(this.cellBlockIndex), this.bDescend, this.forContentCell, this.skipUncreate);
                } else if (!this.bDescend && this.sheetIndex < Range.this._sheets.size() - 1) {
                    ++this.sheetIndex;
                    this.cellBlockIndex = 0;
                    this.cSheetCellsIterator = Range.this._sheets.getSheet(this.sheetIndex).getCellsIterator(Range.this.getBlock(this.cellBlockIndex), this.bDescend, this.forContentCell, this.skipUncreate);
                }
            }
            return this.cSheetCellsIterator.hasNext();
        }

        @Override
        public Cell next() {
            return this.cSheetCellsIterator.next();
        }

        @Override
        public boolean hasData() {
            boolean flag = false;
            RangeCellsIterator ri = new RangeCellsIterator(this.bDescend, this.skipUncreate, this.forContentCell);
            while (ri.hasNext()) {
                Cell cell = ri.next();
                if (cell.isEmptyContent2()) continue;
                flag = true;
                break;
            }
            return flag;
        }

        public Sheet getCurrentSheet() {
            return Range.this._sheets.getSheet(this.sheetIndex);
        }
    }

    class CellCompare
    implements Comparable {
        Cell _cell;

        CellCompare(Cell cell) {
            this._cell = cell;
        }

        Cell getCell() {
            return this._cell;
        }

        public int compareTo(Object obj) {
            int cmp = -1;
            if (obj instanceof CellCompare) {
                Cell cll = ((CellCompare)obj).getCell();
                try {
                    cmp = this._cell.getValue().compareTo(cll.getValue());
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            }
            return cmp;
        }
    }

    static class CellComparator
    implements Comparator {
        private int[] _keys;
        private boolean[] _orders;
        private boolean _bRowsSort;
        private boolean _matchCase;

        public CellComparator(int[] keys, boolean[] orders, boolean bRowsSort, boolean matchCase) {
            this._keys = keys;
            this._orders = orders;
            this._bRowsSort = bRowsSort;
            this._matchCase = matchCase;
        }

        public boolean isRowsSort() {
            return this._bRowsSort;
        }

        public int compare(Object o1, Object o2) {
            int cmp = 0;
            boolean ascent = false;
            if (this._bRowsSort) {
                Row row = (Row)o1;
                Row row2 = (Row)o2;
                try {
                    for (int i = 0; i < this._keys.length; ++i) {
                        int col = this._keys[i];
                        ascent = this._orders[i];
                        cmp = this.compare(row.getCell(col, false), row2.getCell(col, false), ascent);
                        if (cmp != 0) break;
                    }
                }
                catch (SyntaxErrorException e) {
                    cmp = ascent ? -1 : 1;
                }
            } else {
                Column colObj = (Column)o1;
                Column colObj2 = (Column)o2;
                Sheet sheet = colObj.getSheet();
                try {
                    for (int i = 0; i < this._keys.length; ++i) {
                        int row = this._keys[i];
                        ascent = this._orders[i];
                        Row rowObj = sheet.getRow(row, false);
                        if (rowObj != null) {
                            int col = colObj.getCol();
                            int col2 = colObj2.getCol();
                            cmp = this.compare(rowObj.getCell(col, false), rowObj.getCell(col2, false), ascent);
                        }
                        if (cmp == 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (SyntaxErrorException e) {
                    cmp = ascent ? -1 : 1;
                }
            }
            return cmp;
        }

        private int compare(Cell cll, Cell cll2, boolean ascent) throws SyntaxErrorException {
            if (Cell.isEmptyCell(cll)) {
                return cll2 == null ? 0 : 1;
            }
            if (Cell.isEmptyCell(cll2)) {
                return -1;
            }
            Variant var = cll.getValue();
            Variant var2 = cll2.getValue();
            if (var.isString() && !var2.isString()) {
                return ascent ? 1 : -1;
            }
            if (!var.isString() && var2.isString()) {
                return ascent ? -1 : 1;
            }
            int cmp = this._matchCase ? var.compareTo(var2) : var.compareToIgnoreCase(var2);
            return ascent ? cmp : cmp * -1;
        }
    }
}

