/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.borders;

import com.kingdee.bos.ctrl.common.variant.WeakHashSet;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Border;
import com.kingdee.bos.ctrl.excel.model.struct.borders.BorderSpan;
import com.kingdee.bos.ctrl.excel.model.struct.borders.BordersSpan;
import com.kingdee.bos.ctrl.excel.model.struct.borders.SortedBorderSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.borders.SortedBordersSpanArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.util.Iterator;

public class Borders
implements Cloneable {
    private static final WeakHashSet _bdrs = new WeakHashSet();
    private Sheet _sheet;
    private SortedBordersSpanArray _rows;
    private SortedBordersSpanArray _cols;

    public static Border getBorder(PenStyle ps, LineStyle ls, Color clr) {
        Border bdr = new Border(ps, ls, clr);
        Object obj = _bdrs.get((Object)bdr);
        if (obj == null) {
            bdr.setUID(Styles.getUID());
            _bdrs.add((Object)bdr);
        } else {
            bdr = (Border)obj;
        }
        return bdr;
    }

    public static Border getBorderFromSSA(ShareStyleAttributes ssa, Styles.Position pos) {
        return Borders.getBorder(ssa.getBorderPenStyle(pos), ssa.getBorderLineStyle(pos), ssa.getBorderColor(pos));
    }

    public Borders(Sheet sheet) {
        this._sheet = sheet;
        this._rows = new SortedBordersSpanArray(sheet, false);
        this._cols = new SortedBordersSpanArray(sheet, true);
    }

    public Object clone() {
        Borders bdrs = null;
        try {
            bdrs = (Borders)super.clone();
            bdrs._rows = (SortedBordersSpanArray)((Object)this._rows.clone());
            bdrs._cols = (SortedBordersSpanArray)((Object)this._cols.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return bdrs;
    }

    public boolean isEmpty() {
        return this._rows.isEmpty() && this._cols.isEmpty();
    }

    public void clear() {
        this._rows.clear();
        this._cols.clear();
    }

    public int getMaxIndex(boolean yDir) {
        int end;
        int limit;
        SortedBordersSpanArray root2;
        SortedBordersSpanArray root;
        if (yDir) {
            root = this._rows;
            root2 = this._cols;
            limit = 1048575;
        } else {
            root = this._cols;
            root2 = this._rows;
            limit = 16383;
        }
        int max = -1;
        if (!root.isEmpty() && (end = ((BordersSpan)root.getLast()).getEnd()) < limit) {
            max = end;
        }
        for (int i = root2.size() - 1; i > -1; --i) {
            int end2;
            BorderSpan bs = (BorderSpan)root2.getBordersSpan(i).getBorderArray().getLast();
            if (bs == null || (end2 = bs.getEnd()) >= limit) continue;
            max = Math.max(max, end2);
        }
        if (yDir && this._sheet.getRow(max, false) == null) {
            max = -1;
        }
        if (!yDir && this._sheet.getColumn(max, false) == null) {
            max = -1;
        }
        return max;
    }

    private int getPos(CellBlock cb, Styles.Position dir) {
        int pos;
        switch (dir.getIndex()) {
            case 0: {
                pos = cb.getCol() - 1;
                break;
            }
            case 1: {
                pos = cb.getRow() - 1;
                break;
            }
            case 2: {
                pos = cb.getCol2();
                break;
            }
            default: {
                pos = cb.getRow2();
            }
        }
        return pos;
    }

    private boolean mixOneSide(CellBlock cb, StyleAttributes sa, Styles.Position dir) {
        SortedBordersSpanArray root;
        boolean vert;
        if (dir == Styles.Position.LEFT || dir == Styles.Position.RIGHT) {
            vert = true;
            root = this._cols;
        } else {
            vert = false;
            root = this._rows;
        }
        int pos = root.searchSpan(this.getPos(cb, dir));
        if (pos >= 0) {
            SortedBorderSpanArray bdrArray = root.getBordersSpan(pos).getBorderArray();
            return this.mixOneSide(sa, dir, bdrArray, vert ? cb.getRow() : cb.getCol(), vert ? cb.getRow2() : cb.getCol2());
        }
        this.fillSA(sa, dir, this._sheet.getDefaultBorder(vert));
        return false;
    }

    private boolean mixOneSide(StyleAttributes sa, Styles.Position dir, SortedBorderSpanArray array, int from, int to) {
        int clrIndex = ShareStyleAttributes.getBorderColorIndex((Styles.Position)dir);
        int psIndex = ShareStyleAttributes.getBorderPenStyleIndex((Styles.Position)dir);
        int lsIndex = ShareStyleAttributes.getBorderLineStyleIndex((Styles.Position)dir);
        boolean clrMixed = sa.isMixedAttribute(clrIndex);
        boolean psMixed = sa.isMixedAttribute(psIndex);
        boolean lsMixed = sa.isMixedAttribute(lsIndex);
        boolean allMixed = false;
        Iterator i = array.iterator(from, to, true);
        while (i.hasNext()) {
            Border bdr = ((BorderSpan)i.next()).getBorder();
            if (!clrMixed) {
                boolean bl = clrMixed = sa.putMix(clrIndex, (Object)bdr.getColor()) == 2;
            }
            if (!psMixed) {
                boolean bl = psMixed = sa.putMix(psIndex, (Object)bdr.getPenStyle()) == 2;
            }
            if (!lsMixed) {
                boolean bl = lsMixed = sa.putMix(lsIndex, (Object)bdr.getLineStyle()) == 2;
            }
            if (!clrMixed || !psMixed || !lsMixed) continue;
            allMixed = true;
            break;
        }
        return allMixed;
    }

    public void fillSA(StyleAttributes sa, Styles.Position pos, Border bdr) {
        sa.setBorderColor(pos, bdr.getColor());
        sa.setBorderPenStyle(pos, bdr.getPenStyle());
        sa.setBorderLineStyle(pos, bdr.getLineStyle());
    }

    public Border getCellBorder(int row, int col, boolean vert) {
        SortedBorderSpanArray bdrArray;
        SortedBordersSpanArray root = vert ? this._cols : this._rows;
        int pos = root.searchSpan(vert ? col : row);
        if (pos >= 0 && (pos = (bdrArray = root.getBordersSpan(pos).getBorderArray()).searchSpan(vert ? row : col)) >= 0) {
            return bdrArray.getBorderSpan(pos).getBorder();
        }
        return this._sheet.getDefaultBorder(vert);
    }

    public void getCellBorders(int row, int col, StyleAttributes sa) {
        this.fillSA(sa, Styles.Position.LEFT, this.getCellBorder(row, col - 1, true));
        this.fillSA(sa, Styles.Position.TOP, this.getCellBorder(row - 1, col, false));
        this.fillSA(sa, Styles.Position.RIGHT, this.getCellBorder(row, col, true));
        this.fillSA(sa, Styles.Position.BOTTOM, this.getCellBorder(row, col, false));
        sa.clearDirtyFlag();
    }

    public void getMergeCellBorders(int row, int col, StyleAttributes sa, CellBlock mergeBlock) {
        this.fillSA(sa, Styles.Position.LEFT, this.getCellBorder(row, col - 1, true));
        this.fillSA(sa, Styles.Position.TOP, this.getCellBorder(row - 1, col, false));
        if (mergeBlock == null) {
            this.fillSA(sa, Styles.Position.RIGHT, this.getCellBorder(row, col, true));
            this.fillSA(sa, Styles.Position.BOTTOM, this.getCellBorder(row, col, false));
        } else {
            row = mergeBlock.getRow2();
            col = mergeBlock.getCol2();
            this.fillSA(sa, Styles.Position.RIGHT, this.getCellBorder(row, col, true));
            this.fillSA(sa, Styles.Position.BOTTOM, this.getCellBorder(row, col, false));
        }
        sa.clearDirtyFlag();
    }

    public void getMixedOuterBorders(CellBlock cb, StyleAttributes sa) {
        if (cb.isSingleCell()) {
            this.getCellBorders(cb.getRow(), cb.getCol(), sa);
        } else {
            this.mixOneSide(cb, sa, Styles.Position.LEFT);
            this.mixOneSide(cb, sa, Styles.Position.TOP);
            this.mixOneSide(cb, sa, Styles.Position.RIGHT);
            this.mixOneSide(cb, sa, Styles.Position.BOTTOM);
            sa.clearDirtyFlag();
        }
    }

    public void getMixedInnerBorders(CellBlock cb, StyleAttributes sa) {
        block4: {
            SortedBorderSpanArray bdrArray;
            Iterator i;
            if (cb.isSingleCell()) {
                return;
            }
            if (cb.getWidth() > 1) {
                i = this._cols.iterator(cb.getCol(), cb.getCol2() - 1, true);
                while (i.hasNext() && !this.mixOneSide(sa, Styles.Position.INNER_V, bdrArray = ((BordersSpan)i.next()).getBorderArray(), cb.getRow(), cb.getRow2())) {
                }
            }
            if (cb.getHeight() <= 1) break block4;
            i = this._rows.iterator(cb.getRow(), cb.getRow2() - 1, true);
            while (i.hasNext() && !this.mixOneSide(sa, Styles.Position.INNER_H, bdrArray = ((BordersSpan)i.next()).getBorderArray(), cb.getCol(), cb.getCol2())) {
            }
        }
    }

    public SortedBordersSpanArray getRoot(boolean vert) {
        return vert ? this._cols : this._rows;
    }

    public static void setOneBorder(SortedBordersSpanArray dstRoot, Span spMaster, Span spMinor, Border bdr, SortedBordersSpanArray rootBak) {
        boolean bState = rootBak != null;
        spMaster = dstRoot.makeContinuousSpanList(spMaster);
        int iEnd = spMaster.getEnd();
        for (int i = spMaster.getStart(); i <= iEnd; ++i) {
            BordersSpan bss = dstRoot.getBordersSpan(i);
            BordersSpan bssBak = null;
            if (bState) {
                bssBak = (BordersSpan)dstRoot.createDefaultSpan(bss);
                rootBak.insert(bssBak);
            }
            SortedBorderSpanArray bssBorders = bss.getBorderArray();
            Span span = bssBorders.makeContinuousSpanList(spMinor);
            int minorPos = span.getStart();
            BorderSpan bs = bssBorders.getBorderSpan(minorPos);
            if (bState) {
                bssBak.getBorderArray().fillSpans(bssBorders.getArray(), minorPos, span.getEnd() + 1, false);
                bs = (BorderSpan)bs.clone();
                bssBorders.getArray()[minorPos] = bs;
            }
            if (span.getExtent() > 1) {
                bssBorders.removeByPos(minorPos + 1, span.getEnd(), false);
            }
            bs.setEnd(spMinor.getEnd());
            bs.setBorder(bdr);
            bssBorders.merge(minorPos, minorPos, true);
        }
        dstRoot.merge(spMaster, true);
        if (bState) {
            rootBak.merge(spMaster, false);
        }
    }

    public Borders setBySA(CellBlock cb, StyleAttributes sa, StyleAttributes saInner, boolean bState) {
        Border bdr;
        Styles.Position pos;
        Borders state = bState ? new Borders(this._sheet) : null;
        Span rowSpan = cb.getRowSpan();
        Span colSpan = cb.getColSpan();
        Span sp = new Span(0, 0);
        if (sa.isDirtyBorder()) {
            pos = Styles.Position.LEFT;
            if (sa.isDirtyBorder(pos)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int col = cb.getCol();
                Borders.setOneBorder(this._cols, sp.setPos(col - 1, col - 1), rowSpan, bdr, bState ? state._cols : null);
            }
            if (sa.isDirtyBorder(pos = Styles.Position.TOP)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int row = cb.getRow();
                Borders.setOneBorder(this._rows, sp.setPos(row - 1, row - 1), colSpan, bdr, bState ? state._rows : null);
            }
            if (sa.isDirtyBorder(pos = Styles.Position.RIGHT)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int col2 = cb.getCol2();
                Borders.setOneBorder(this._cols, sp.setPos(col2, col2), rowSpan, bdr, bState ? state._cols : null);
            }
            if (sa.isDirtyBorder(pos = Styles.Position.BOTTOM)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int row2 = cb.getRow2();
                Borders.setOneBorder(this._rows, sp.setPos(row2, row2), colSpan, bdr, bState ? state._rows : null);
            }
        }
        if (saInner.isDirtyBorder()) {
            pos = Styles.Position.INNER_V;
            if (saInner.isDirtyBorder(pos) && cb.getWidth() > 1) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)saInner, pos);
                Borders.setOneBorder(this._cols, sp.setPos(cb.getCol(), cb.getCol2() - 1), rowSpan, bdr, bState ? state._cols : null);
            }
            if (saInner.isDirtyBorder(pos = Styles.Position.INNER_H) && cb.getHeight() > 1) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)saInner, pos);
                Borders.setOneBorder(this._rows, sp.setPos(cb.getRow(), cb.getRow2() - 1), colSpan, bdr, bState ? state._rows : null);
            }
        }
        return state;
    }

    private boolean setRoot(SortedBordersSpanArray src, boolean vert, Borders state) {
        SortedBordersSpanArray dst;
        boolean changed = false;
        SortedBordersSpanArray sortedBordersSpanArray = dst = vert ? this._cols : this._rows;
        SortedBordersSpanArray dstBak = state == null ? null : (vert ? state._cols : state._rows);
        Iterator iMaster = src.iterator(null, false);
        while (iMaster.hasNext()) {
            BordersSpan bss = (BordersSpan)iMaster.next();
            Iterator iMinor = bss.getBorderArray().iterator(null, false);
            while (iMinor.hasNext()) {
                BorderSpan bs = (BorderSpan)iMinor.next();
                Borders.setOneBorder(dst, bss, bs, bs.getBorder(), dstBak);
                changed = true;
            }
        }
        return changed;
    }

    public boolean set(Borders bdrs) {
        boolean changed = this.setRoot(bdrs._cols, true, null);
        return changed |= this.setRoot(bdrs._rows, false, null);
    }

    public boolean exist(int row, int col, int row2, int col2, boolean vert) {
        int p2;
        int p;
        SortedBorderSpanArray bsArray;
        int pos;
        boolean exist = false;
        int pos2 = this._cols.getProperPos(col2, true);
        for (pos = this._cols.getProperPos(vert ? col - 1 : col, false); pos <= pos2; ++pos) {
            bsArray = this._cols.getBordersSpan(pos).getBorderArray();
            p = bsArray.getProperPos(row, false);
            if (p > (p2 = bsArray.getProperPos(vert ? 1048575 : row2, true))) continue;
            exist = true;
            break;
        }
        if (!exist) {
            pos2 = this._rows.getProperPos(row2, true);
            for (pos = this._rows.getProperPos(vert ? row : row - 1, false); pos <= pos2; ++pos) {
                bsArray = this._rows.getBordersSpan(pos).getBorderArray();
                p = bsArray.getProperPos(col, false);
                if (p > (p2 = bsArray.getProperPos(vert ? col2 : 16383, true))) continue;
                exist = true;
                break;
            }
        }
        if (!exist) {
            Iterator iter = this._cols.iterator(col, 16383, false);
            while (iter.hasNext() && !exist) {
                Span span = (Span)iter.next();
                if (span.getEnd() <= col) continue;
                exist = true;
            }
            if (!exist) {
                iter = this._rows.iterator(row, 1048575, false);
                while (iter.hasNext() && !exist) {
                    Span span = (Span)iter.next();
                    if (span.getEnd() <= row) continue;
                    exist = true;
                }
            }
        }
        return exist;
    }

    public Borders insdel(CellBlock cb, boolean insert, boolean vert, boolean bState) {
        Borders state;
        int minorTo;
        int minorFrom;
        int masterTo;
        int masterFrom;
        SortedBordersSpanArray root2;
        SortedBordersSpanArray root;
        int col2;
        int row2;
        int col;
        int row = cb.getRow();
        if (!this.exist(row, col = cb.getCol(), row2 = cb.getRow2(), col2 = cb.getCol2(), vert)) {
            return null;
        }
        if (vert) {
            root = this._cols;
            root2 = this._rows;
            masterFrom = col;
            masterTo = col2;
            minorFrom = row;
            minorTo = row2;
        } else {
            root = this._rows;
            root2 = this._cols;
            masterFrom = row;
            masterTo = row2;
            minorFrom = col;
            minorTo = col2;
        }
        Borders borders = state = bState ? new Borders(this._sheet) : null;
        SortedBordersSpanArray stateRoot = bState ? (vert ? state._cols : state._rows) : null;
        Span spPos = new Span(0, 0);
        Span spMaster = root.makeContinuousSpanList(spPos.setPos(masterFrom - 1, masterTo));
        int iEnd = spMaster.getEnd() + 1;
        for (int i = spMaster.getStart(); i < iEnd; ++i) {
            ObjectArray out;
            BordersSpan bss = root.getBordersSpan(i);
            SortedBorderSpanArray bssBorders = bss.getBorderArray();
            ObjectArray objectArray = out = insert ? bssBorders.insertSpace(minorFrom, minorTo, bState) : bssBorders.deleteSpace(minorFrom, minorTo, bState);
            if (out == null) continue;
            int jEnd = out.size();
            for (int j = 0; j < jEnd; ++j) {
                BorderSpan bs = (BorderSpan)out.get(j);
                Borders.setOneBorder(stateRoot, bss, bs, bs.getBorder(), null);
            }
        }
        root.merge(spPos, true);
        SortedBordersSpanArray offset = new SortedBordersSpanArray(this._sheet, !vert);
        spMaster = root2.makeContinuousSpanList(spPos.setPos(minorFrom, vert ? 1048575 : 16383));
        int iEnd2 = spMaster.getEnd() + 1;
        for (int i = spMaster.getStart(); i < iEnd2; ++i) {
            Span spMinor;
            BordersSpan bss = root2.getBordersSpan(i);
            SortedBorderSpanArray bssBorders = bss.getBorderArray();
            Object[] out = bssBorders.removeByPos((spMinor = bssBorders.makeContinuousSpanList(spPos.setPos(masterFrom, masterTo))).getStart(), spMinor.getEnd(), true);
            if (out == null) continue;
            for (int j = 0; j < out.length; ++j) {
                BorderSpan bs = (BorderSpan)out[j];
                Borders.setOneBorder(offset, bss, bs, bs.getBorder(), null);
            }
        }
        if (bState) {
            if (vert) {
                state._rows = offset;
            } else {
                state._cols = offset;
            }
            offset = (SortedBordersSpanArray)((Object)offset.clone());
        }
        if (insert) {
            offset.insertSpace(minorFrom - 1, minorTo - 1, false);
        } else {
            offset.deleteSpace(minorFrom - 1, minorTo - 1, false);
        }
        this.setRoot(offset, !vert, null);
        return state;
    }

    private Borders gatherBorders(CellBlock cb, boolean vAround, boolean hAround) {
        Borders bdrs = new Borders(this._sheet);
        boolean bGot = this.gatherBorders(bdrs, cb, true, vAround);
        return (bGot |= this.gatherBorders(bdrs, cb, false, hAround)) ? bdrs : null;
    }

    private boolean gatherBorders(Borders bdrs, CellBlock cb, boolean vert, boolean around) {
        int minorTo;
        int minorFrom;
        int masterTo;
        int masterFrom;
        SortedBordersSpanArray dstRoot;
        SortedBordersSpanArray srcRoot;
        if (vert) {
            srcRoot = this._cols;
            dstRoot = bdrs._cols;
            masterFrom = cb.getCol();
            if (around) {
                --masterFrom;
            }
            masterTo = cb.getCol2();
            minorFrom = cb.getRow();
            minorTo = cb.getRow2();
        } else {
            srcRoot = this._rows;
            dstRoot = bdrs._rows;
            masterFrom = cb.getRow();
            if (around) {
                --masterFrom;
            }
            masterTo = cb.getRow2();
            minorFrom = cb.getCol();
            minorTo = cb.getCol2();
        }
        boolean bGot = false;
        Span[] abss = srcRoot.getSpecifiedSpans(masterFrom, masterTo);
        if (abss != null) {
            for (int i = 0; i < abss.length; ++i) {
                BordersSpan bss = (BordersSpan)abss[i];
                Span[] abs = bss.getBorderArray().getSpecifiedSpans(minorFrom, minorTo);
                if (abs == null) continue;
                bGot = true;
                for (int j = 0; j < abs.length; ++j) {
                    BorderSpan bs = (BorderSpan)abs[j];
                    Borders.setOneBorder(dstRoot, bss, bs, bs.getBorder(), null);
                }
            }
        }
        return bGot;
    }

    public boolean clearBorders(CellBlock cb, boolean vAround, boolean hAround, Borders bdrsState) {
        boolean bGot = this.clearBorders(bdrsState, cb, true, vAround);
        return bGot |= this.clearBorders(bdrsState, cb, false, hAround);
    }

    private boolean clearBorders(Borders bdrs, CellBlock cb, boolean vert, boolean around) {
        int minorTo;
        int minorFrom;
        int masterTo;
        int masterFrom;
        SortedBordersSpanArray srcRoot;
        boolean bState = bdrs != null;
        SortedBordersSpanArray dstRoot = null;
        if (vert) {
            srcRoot = this._cols;
            if (bState) {
                dstRoot = bdrs._cols;
            }
            masterFrom = cb.getCol();
            if (around) {
                --masterFrom;
            }
            masterTo = cb.getCol2();
            minorFrom = cb.getRow();
            minorTo = cb.getRow2();
        } else {
            srcRoot = this._rows;
            if (bState) {
                dstRoot = bdrs._rows;
            }
            masterFrom = cb.getRow();
            if (around) {
                --masterFrom;
            }
            masterTo = cb.getRow2();
            minorFrom = cb.getCol();
            minorTo = cb.getCol2();
        }
        boolean bGot = false;
        if (srcRoot.getSpans(masterFrom, masterTo) != null) {
            Span masterSpan = srcRoot.makeContinuousSpanList(new Span(masterFrom, masterTo));
            for (int i = masterSpan.getStart(); i <= masterSpan.getEnd(); ++i) {
                BordersSpan bss = srcRoot.getBordersSpan(i);
                SortedBorderSpanArray bsa = bss.getBorderArray();
                if (bsa.getSpans(minorFrom, minorTo) == null) continue;
                bGot = true;
                Span minorSpan = bsa.makeContinuousSpanList(new Span(minorFrom, minorTo));
                Object[] spans = bsa.removeByPos(minorSpan.getStart(), minorSpan.getEnd(), bState);
                bsa.merge(minorSpan.getStart() - 1, minorSpan.getStart() + 1, true);
                if (!bState) continue;
                for (int j = 0; j < spans.length; ++j) {
                    BorderSpan bs = (BorderSpan)spans[j];
                    Borders.setOneBorder(dstRoot, bss, bs, bs.getBorder(), null);
                }
            }
            if (bGot) {
                srcRoot.merge(masterSpan.getStart() - 1, masterSpan.getStart() + 1, true);
            }
        }
        return bGot;
    }

    public void offset(int offsetX, int offsetY) {
        this.offset(offsetX, false);
        this.offset(offsetY, true);
    }

    private void offset(int offset, boolean vert) {
        int i;
        if (offset == 0) {
            return;
        }
        SortedBordersSpanArray root = vert ? this._rows : this._cols;
        for (i = root.size() - 1; i > -1; --i) {
            root.getBordersSpan(i).offset(offset);
        }
        root = vert ? this._cols : this._rows;
        for (i = root.size() - 1; i > -1; --i) {
            SortedBorderSpanArray bsa = root.getBordersSpan(i).getBorderArray();
            for (int j = bsa.size() - 1; j > -1; --j) {
                bsa.getBorderSpan(j).offset(offset);
            }
        }
    }

    public boolean paste(CellBlock src, CellBlock dst, boolean vAround, boolean hAround, Borders state) {
        boolean changed = this.clearBorders(dst, vAround, hAround, state);
        Borders bdrsSrc = this.gatherBorders(src, vAround, hAround);
        if (bdrsSrc != null) {
            int offsetX = dst.getCol() - src.getCol();
            int offsetY = dst.getRow() - src.getRow();
            bdrsSrc = (Borders)bdrsSrc.clone();
            bdrsSrc.offset(offsetX, offsetY);
            this.set(bdrsSrc);
            changed = true;
        }
        return changed;
    }

    public void clearInner(CellBlock cb, Borders bdrsBak) {
        if (cb.getHeight() > 1) {
            Borders.setOneBorder(this._rows, new Span(cb.getRow(), cb.getRow2() - 1), cb.getColSpan(), this._sheet.getDefaultBorder(false), bdrsBak == null ? null : bdrsBak._rows);
        }
        if (cb.getWidth() > 1) {
            Borders.setOneBorder(this._cols, new Span(cb.getCol(), cb.getCol2() - 1), cb.getRowSpan(), this._sheet.getDefaultBorder(true), bdrsBak == null ? null : bdrsBak._cols);
        }
    }

    public void clearOuter(CellBlock cb, Borders bdrsBak) {
        Span colSpan = cb.getColSpan();
        Border defaultBdr = this._sheet.getDefaultBorder(false);
        SortedBordersSpanArray rows = bdrsBak == null ? null : bdrsBak._rows;
        int row = cb.getRow() - 1;
        Borders.setOneBorder(this._rows, new Span(row, row), colSpan, defaultBdr, rows);
        row = cb.getRow2();
        Borders.setOneBorder(this._rows, new Span(row, row), colSpan, defaultBdr, rows);
        Span rowSpan = cb.getRowSpan();
        defaultBdr = this._sheet.getDefaultBorder(true);
        SortedBordersSpanArray cols = bdrsBak == null ? null : bdrsBak._cols;
        int col = cb.getCol() - 1;
        Borders.setOneBorder(this._cols, new Span(col, col), rowSpan, defaultBdr, cols);
        col = cb.getCol2();
        Borders.setOneBorder(this._cols, new Span(col, col), rowSpan, defaultBdr, cols);
    }

    public Borders clearInner(CellBlock cb, boolean bState) {
        Borders bdrs = null;
        if (cb.getHeight() > 1) {
            bdrs = bState ? new Borders(this._sheet) : null;
            Borders.setOneBorder(this._rows, new Span(cb.getRow(), cb.getRow2() - 1), cb.getColSpan(), this._sheet.getDefaultBorder(false), bdrs == null ? null : bdrs._rows);
        }
        if (cb.getWidth() > 1) {
            if (bdrs == null) {
                bdrs = bState ? new Borders(this._sheet) : null;
            }
            Borders.setOneBorder(this._cols, new Span(cb.getCol(), cb.getCol2() - 1), cb.getRowSpan(), this._sheet.getDefaultBorder(false), bdrs == null ? null : bdrs._cols);
        }
        return bdrs;
    }

    public SortedObjectArray collectBorderObjs() {
        int j;
        int jEnd;
        SortedBorderSpanArray bsArray;
        int i;
        SortedObjectArray array = new SortedObjectArray();
        int iEnd = this._cols.size();
        for (i = 0; i < iEnd; ++i) {
            bsArray = this._cols.getBordersSpan(i).getBorderArray();
            jEnd = bsArray.size();
            for (j = 0; j < jEnd; ++j) {
                array.insert((Object)bsArray.getBorderSpan(j).getBorder());
            }
        }
        iEnd = this._rows.size();
        for (i = 0; i < iEnd; ++i) {
            bsArray = this._rows.getBordersSpan(i).getBorderArray();
            jEnd = bsArray.size();
            for (j = 0; j < jEnd; ++j) {
                array.insert((Object)bsArray.getBorderSpan(j).getBorder());
            }
        }
        return array;
    }

    public void buildFromSSA() {
        SortedAttributeSpanArray.AttributeSpan as;
        Span spMaster = new Span(0, 0);
        Span spMinor = new Span(0, 0);
        spMinor.setPos(0, 1048575);
        Iterator i = this._sheet.getColSpans().iterator(0, 16383, false);
        while (i.hasNext()) {
            as = (SortedAttributeSpanArray.AttributeSpan)i.next();
            this.buildColBorderFromSSA(as, spMaster, spMinor);
        }
        spMinor.setPos(0, 16383);
        i = this._sheet.getRowSpans().iterator(0, 1048575, false);
        while (i.hasNext()) {
            as = (SortedAttributeSpanArray.AttributeSpan)i.next();
            this.buildRowBorderFromSSA(as, spMaster, spMinor);
        }
        Sheet.ICellsIterator ci = this._sheet.getCellsIterator(null, false, false);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            this.buildCellBorderFromSSA(cll, spMaster, spMinor);
        }
        MergeBlocks merger = this._sheet.getMerger(false);
        if (merger != null) {
            int iEnd = merger.size();
            for (int i2 = 0; i2 < iEnd; ++i2) {
                this.clearInner(merger.getBlock(i2), false);
            }
        }
    }

    private void buildColBorderFromSSA(SortedAttributeSpanArray.AttributeSpan as, Span spMaster, Span spMinor) {
        ShareStyleAttributes ssa = as.getSSA();
        if (ssa.hasBordersAttributes()) {
            Border bdr;
            Styles.Position pos = Styles.Position.LEFT;
            if (ssa.hasBorderAttributes(pos) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, spMaster.setPos(as.getStart() - 1, as.getStart() - 1), spMinor, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.RIGHT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, as, spMinor, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.TOP) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, spMaster.setPos(-1, -1), as, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.BOTTOM) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, spMinor, as, bdr, null);
            }
        }
    }

    private void buildRowBorderFromSSA(SortedAttributeSpanArray.AttributeSpan as, Span spMaster, Span spMinor) {
        ShareStyleAttributes ssa = as.getSSA();
        if (ssa.hasBordersAttributes()) {
            Border bdr;
            Styles.Position pos = Styles.Position.LEFT;
            if (ssa.hasBorderAttributes(pos) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, spMaster.setPos(-1, -1), as, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.RIGHT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, spMinor, as, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.TOP) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, spMaster.setPos(as.getStart() - 1, as.getStart() - 1), spMinor, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.BOTTOM) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, as, spMinor, bdr, null);
            }
        }
    }

    public void buildCellBorderFromSSA(Cell cll, Span spMaster, Span spMinor) {
        ShareStyleAttributes ssa = cll.getSSA2();
        if (ssa.hasBordersAttributes()) {
            Border bdr;
            Styles.Position pos;
            int row = cll.getRow();
            int col = cll.getCol();
            int row2 = row;
            int col2 = col;
            CellBlock mergeBlock = cll.getMerge(false);
            if (mergeBlock != null) {
                row2 = mergeBlock.getRow2();
                col2 = mergeBlock.getCol2();
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.LEFT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, spMaster.setPos(col - 1, col - 1), spMinor.setPos(row, row2), bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.RIGHT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, spMaster.setPos(col2, col2), spMinor.setPos(row, row2), bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.TOP) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, spMaster.setPos(row - 1, row - 1), spMinor.setPos(col, col2), bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.BOTTOM) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, spMaster.setPos(row2, row2), spMinor.setPos(col, col2), bdr, null);
            }
        }
    }

    public void buildCellBorderFromSSA(int row, int col, int row2, int col2, Span spMaster, Span spMinor, ShareStyleAttributes ssa) {
        if (ssa.hasBordersAttributes()) {
            Border bdr;
            Styles.Position pos = Styles.Position.LEFT;
            if (ssa.hasBorder(pos) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, spMaster.setPos(col - 1, col - 1), spMinor.setPos(row, row2), bdr, null);
            }
            if (ssa.hasBorder(pos = Styles.Position.RIGHT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._cols, spMaster.setPos(col2, col2), spMinor.setPos(row, row2), bdr, null);
            }
            if (ssa.hasBorder(pos = Styles.Position.TOP) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, spMaster.setPos(row - 1, row - 1), spMinor.setPos(col, col2), bdr, null);
            }
            if (ssa.hasBorder(pos = Styles.Position.BOTTOM) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                Borders.setOneBorder(this._rows, spMaster.setPos(row2, row2), spMinor.setPos(col, col2), bdr, null);
            }
        }
    }
}

