/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.cformat;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.ArrayList;
import java.util.List;

public class ConditionalFormat {
    private SortedCellBlockArray _blocks;
    private ShareStyleAttributes[] _ssas;
    private Condition[] _conditions;

    public ConditionalFormat() {
    }

    public ConditionalFormat(Condition[] conditions, ShareStyleAttributes[] sas, SortedCellBlockArray blocks) {
        this._conditions = conditions;
        this._blocks = blocks;
        this._ssas = sas;
    }

    public ConditionalFormat getClippedCopy(int left, int top, int right, int bottom) {
        ObjectArray blocks = new ObjectArray();
        for (int i = 0; i < this._blocks.size(); ++i) {
            CellBlock cb = this._blocks.getBlock(i).intersection(top, left, bottom, right);
            if (cb == null) continue;
            blocks.append((Object)cb);
        }
        if (blocks.size() == 0) {
            return null;
        }
        SortedCellBlockArray scba = new SortedCellBlockArray();
        for (int i = 0; i < blocks.size(); ++i) {
            scba.insert(blocks.get(i));
        }
        return new ConditionalFormat(this._conditions, this._ssas, scba);
    }

    public ConditionalFormat cloneSelf() {
        SortedCellBlockArray scba = new SortedCellBlockArray();
        for (int i = 0; i < this._blocks.size(); ++i) {
            scba.insert(((CellBlock)this._blocks.get(i)).clone());
        }
        return new ConditionalFormat(this._conditions, this._ssas, scba);
    }

    public SortedCellBlockArray getBlocks() {
        return this._blocks;
    }

    public void setBlocks(SortedCellBlockArray blocks) {
        this._blocks = blocks;
    }

    public Condition[] getConditions() {
        return this._conditions;
    }

    public void setConditions(Condition[] conditions) {
        this._conditions = conditions;
    }

    public int isMatched(Sheet sheet, Variant var) {
        for (int i = 0; i < this._conditions.length; ++i) {
            if (!this._conditions[i].isMatched(sheet, var)) continue;
            return i;
        }
        return -1;
    }

    public List<Integer> isMatchedOffsetFormulas(Sheet sheet, Variant var, Cell cell, int offset) {
        if (cell != null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = 0; i < this._conditions.length; ++i) {
                if (!this._conditions[i].isMatchedOffsetFormula(sheet, var, cell, offset)) continue;
                result.add(i);
            }
            return result;
        }
        return this.isMatcheds(sheet, var);
    }

    public List<Integer> isMatcheds(Sheet sheet, Variant var, Cell cell) {
        if (cell != null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = 0; i < this._conditions.length; ++i) {
                if (!this._conditions[i].isMatched(sheet, var, cell)) continue;
                result.add(i);
            }
            return result;
        }
        return this.isMatcheds(sheet, var);
    }

    public List<Integer> isMatcheds(Sheet sheet, Variant var) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this._conditions.length; ++i) {
            if (!this._conditions[i].isMatched(sheet, var)) continue;
            result.add(i);
        }
        return result;
    }

    public int isMatchedOffsetFormula(Sheet sheet, Variant var, Cell cell, int offset) {
        if (cell != null) {
            for (int i = 0; i < this._conditions.length; ++i) {
                if (!this._conditions[i].isMatchedOffsetFormula(sheet, var, cell, offset)) continue;
                return i;
            }
        } else {
            return this.isMatched(sheet, var);
        }
        return -1;
    }

    public int isMatched(Sheet sheet, Variant var, Cell cell) {
        if (cell != null) {
            for (int i = 0; i < this._conditions.length; ++i) {
                if (!this._conditions[i].isMatched(sheet, var, cell)) continue;
                return i;
            }
        } else {
            return this.isMatched(sheet, var);
        }
        return -1;
    }

    public ShareStyleAttributes getShareStyleAttributes(int index) {
        if (index < 0 || this._ssas.length - 1 < index) {
            return Styles.getEmptySSA();
        }
        ShareStyleAttributes sa = this._ssas[index];
        return sa;
    }

    public ShareStyleAttributes getMergedShareStyleAttributes(List<Integer> indexs) {
        if (null == indexs || indexs.isEmpty()) {
            return null;
        }
        ShareStyleAttributes[] attributes = new ShareStyleAttributes[indexs.size()];
        for (int i = 0; i < indexs.size(); ++i) {
            ShareStyleAttributes ssa = this.getShareStyleAttributes(indexs.get(i));
            attributes[indexs.size() - i - 1] = null == ssa ? Styles.getEmptySSA() : ssa;
        }
        return Styles.mergeSSA((ShareStyleAttributes[])attributes);
    }

    public ShareStyleAttributes[] getSSAs() {
        return this._ssas;
    }

    public void setSSAs(ShareStyleAttributes[] sas) {
        this._ssas = sas;
    }
}

