/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.cformat.util;

import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalCalcNode;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;

public class Condition {
    private static final String[] Types = new String[]{"Value", "Formula"};
    public static final String Type_Value;
    public static final String Type_Formula;
    private static final String[] Qualifiers;
    public static final String NotBetween;
    public static final String Between;
    public static final String Equal;
    public static final String NotEqual;
    public static final String Greater;
    public static final String Less;
    public static final String GreaterOrEqual;
    public static final String LessOrEqual;
    public static final int Check_Ok = 1;
    public static final int Check_Value_Error = 2;
    public static final int Check_Syntax_Error = 4;
    public static final int Check_No_Condition = 8;
    private String _qualifier = Between;
    private String _min = "";
    private String _max = "";
    private String _type = Type_Value;
    private ConditionalFormat cf;
    private ConditionalCalcNode conditionalCalcNode;
    private Sheet sheet;

    public void setOwner(ConditionalFormat cf) {
        this.cf = cf;
    }

    public ConditionalFormat getOwner() {
        return this.cf;
    }

    public static boolean isOk(int check) {
        return (check & 1) != 0;
    }

    public static boolean isSyntaxError(int check) {
        return (check & 4) != 0;
    }

    public static boolean isValueError(int check) {
        return (check & 2) != 0;
    }

    public static boolean isNoCondition(int check) {
        return (check & 8) != 0;
    }

    public boolean setType(String type) {
        if (this.checkType(type)) {
            this._type = type;
            return true;
        }
        return false;
    }

    public String getType() {
        return this._type;
    }

    public void setTypeIndex(int index) {
        if (index < 0 || index > 6) {
            return;
        }
        this._type = Types[index];
    }

    public int getTypeIndex() {
        for (int i = 0; i < Types.length; ++i) {
            if (!Types[i].equals(this._type)) continue;
            return i;
        }
        return 0;
    }

    public void setQualifierIndex(int index) {
        if (index < 0 || index > 7) {
            return;
        }
        this._qualifier = Qualifiers[index];
    }

    public int getQualifierIndex() {
        for (int i = 0; i < Qualifiers.length; ++i) {
            if (!Qualifiers[i].equals(this._qualifier)) continue;
            return i;
        }
        return 0;
    }

    public boolean setQualifier(String qualifier) {
        if (this.checkQualifier(qualifier)) {
            this._qualifier = qualifier;
            return true;
        }
        return false;
    }

    public String getQualifier() {
        return this._qualifier;
    }

    private boolean checkQualifier(String qualifier) {
        if (NotBetween.equals(qualifier) || Between.equals(qualifier)) {
            return !Type_Formula.equals(this._type);
        }
        return Equal.equals(qualifier) || NotEqual.equals(qualifier) || Greater.equals(qualifier) || Less.equals(qualifier) || GreaterOrEqual.equals(qualifier) || LessOrEqual.equals(qualifier);
    }

    private boolean checkType(String type) {
        return Type_Value.equals(type) || Type_Formula.equals(type);
    }

    public String getMin() {
        return this._min;
    }

    public String getMax() {
        return this._max;
    }

    public int setMinMax(String min, String max, Sheet sheet) {
        this.sheet = sheet;
        if ("".equals(min) && "".equals(max)) {
            return 8;
        }
        Variant vmin = this.makeVariant(sheet, min, false);
        if (vmin.isError() || vmin.isInvalid()) {
            return 4;
        }
        if (Type_Value.equals(this._type) && (NotBetween.equals(this._qualifier) || Between.equals(this._qualifier))) {
            Variant vmax = this.makeVariant(sheet, max, false);
            if (vmax.isError() || vmax.isInvalid()) {
                return 4;
            }
            if (min.equals("") || max.equals("")) {
                return 2;
            }
            this._max = max;
        }
        this._min = min;
        return 1;
    }

    public boolean isMatched(Sheet sheet, Variant var) {
        try {
            Variant vmin = this.makeVariant(sheet, this._min, true);
            if (Type_Formula.equals(this._type)) {
                return vmin.toBoolean();
            }
            Variant vmax = null;
            if (NotBetween.equals(this._qualifier) || Between.equals(this._qualifier)) {
                vmax = this.makeVariant(sheet, this._max, true);
                if (vmin.compareTo(vmax) > 0) {
                    Variant temp = vmin;
                    vmin = vmax;
                    vmax = temp;
                }
                if (NotBetween.equals(this._qualifier)) {
                    return var.compareTo(vmin) < 0 || var.compareTo(vmax) > 0;
                }
                if (Between.equals(this._qualifier)) {
                    return var.compareTo(vmin) >= 0 && var.compareTo(vmax) <= 0;
                }
            }
            if (Equal.equals(this._qualifier)) {
                return var.compareTo(vmin) == 0;
            }
            if (NotEqual.equals(this._qualifier)) {
                return var.compareTo(vmin) != 0;
            }
            if (Greater.equals(this._qualifier)) {
                return var.compareTo(vmin) > 0;
            }
            if (Less.equals(this._qualifier)) {
                return var.compareTo(vmin) < 0;
            }
            if (GreaterOrEqual.equals(this._qualifier)) {
                return var.compareTo(vmin) >= 0;
            }
            if (LessOrEqual.equals(this._qualifier)) {
                return var.compareTo(vmin) <= 0;
            }
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return false;
    }

    public boolean isMatchedOffsetFormula(Sheet sheet, Variant var, Cell cell, int offset) {
        if (cell != null && Type_Formula.equals(this._type)) {
            IExprNode[] parameters;
            Expr expr = sheet.getExpr(null, this._min);
            for (IExprNode node : parameters = expr.getParameters()) {
                CellBlockNode cb;
                if (!(node instanceof CellBlockNode) || (cb = (CellBlockNode)node).isAbsolute()) continue;
                cb.setRow(cb.getRow() + offset);
                cb.setRow2(cb.getRow2() + offset);
            }
            Variant v = sheet.calcExpr(expr, cell);
            try {
                return v.toBoolean();
            }
            catch (SyntaxErrorException e) {
                return false;
            }
        }
        return this.isMatched(sheet, var);
    }

    public boolean isMatched(Sheet sheet, Variant var, Cell cell) {
        if (cell != null && Type_Formula.equals(this._type)) {
            Variant v = sheet.calcFormula(this._min, cell);
            try {
                return v.toBoolean();
            }
            catch (SyntaxErrorException e) {
                return false;
            }
        }
        return this.isMatched(sheet, var);
    }

    private Variant makeVariant(Sheet sheet, String formula, boolean attach) {
        Variant var = null;
        var = formula.startsWith("=") ? (attach ? sheet.calcFormula(formula, this.getConditionalCalcNode()) : sheet.calcFormula(formula)) : Format.parseData((String)formula, (boolean)true);
        return var;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Condition) {
            Condition cv = (Condition)obj;
            boolean b = StringUtil.equals((String)this._type, (String)cv._type);
            boolean b1 = StringUtil.equals((String)this._qualifier, (String)cv._qualifier);
            boolean b2 = StringUtil.equals((String)this._min, (String)cv._min);
            boolean b3 = StringUtil.equals((String)this._max, (String)cv._max);
            return b && b1 && b2 && b3;
        }
        return false;
    }

    public ConditionalCalcNode getConditionalCalcNode() {
        if (this.conditionalCalcNode == null) {
            this.conditionalCalcNode = new ConditionalCalcNode(this.sheet, this.cf);
        }
        return this.conditionalCalcNode;
    }

    public void dissociate() {
        this.cf = null;
        this.sheet = null;
        if (this.conditionalCalcNode != null) {
            this.conditionalCalcNode.dissociate();
            this.conditionalCalcNode = null;
        }
    }

    static {
        int i = 0;
        Type_Value = Types[i++];
        Type_Formula = Types[i++];
        Qualifiers = new String[]{"", "NotBetween", "Equal", "NotEqual", "Greater", "Less", "GreaterOrEqual", "LessOrEqual"};
        i = 0;
        Between = Qualifiers[i++];
        NotBetween = Qualifiers[i++];
        Equal = Qualifiers[i++];
        NotEqual = Qualifiers[i++];
        Greater = Qualifiers[i++];
        Less = Qualifiers[i++];
        GreaterOrEqual = Qualifiers[i++];
        LessOrEqual = Qualifiers[i++];
    }
}

