/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.filter;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class AutoFilterDataItemModel {
    private Sheet sheet;
    private int colIndex;
    public static final int DATA_TYPE_DATE = 1;
    public static final int DATA_TYPE_DATETIME = 2;
    public static final int DATA_TYPE_NUMBER = 3;
    public static final int DATA_TYPE_TEXT = 4;
    private int dataType = 4;
    private boolean hasEmpty = false;
    private boolean hasDate = false;
    private boolean hasDateTime = false;
    private Object[] autoFilterDataItem = null;
    private ArrayList<Integer> beforeFilteAreaList;
    private boolean isMoreThan1W;

    public AutoFilterDataItemModel(Sheet sheet, int colIndex, ArrayList<Integer> beforeFilteAreaList) {
        this.sheet = sheet;
        this.colIndex = colIndex;
        this.beforeFilteAreaList = beforeFilteAreaList;
        this.calcAutoFilterDataItem();
    }

    public void calcAutoFilterDataItem() {
        int maxCount;
        SortedObjectArray sortedObjectArray = new SortedObjectArray();
        int numberCount = 0;
        int textCount = 0;
        int dateCount = 0;
        this.hasEmpty = false;
        this.isMoreThan1W = false;
        for (int i : this.beforeFilteAreaList) {
            if (sortedObjectArray.size() + (this.hasEmpty ? 1 : 0) == 10000) {
                this.isMoreThan1W = true;
                break;
            }
            Cell cell = this.sheet.getCell(i, this.colIndex, false);
            if (cell == null || cell.isEmptyContent2() || StringUtil.isEmptyString((String)cell.getText())) {
                this.hasEmpty = true;
                continue;
            }
            Variant var = cell.getValue();
            int vt = SheetBaseMath.getCellValueType(cell);
            if (vt == SheetBaseMath.DataType_DateTime) {
                ++dateCount;
                this.hasDate = true;
                Object value = var.getValue();
                Calendar calendar = Variant.getGMTCalender();
                if (value instanceof Date) {
                    calendar.setTime((Date)value);
                } else if (value instanceof Calendar) {
                    calendar = (Calendar)value;
                }
                int HH = calendar.get(11);
                int NN = calendar.get(12);
                int SS = calendar.get(13);
                if (HH != 0 || NN != 0 || SS != 0) {
                    this.hasDateTime = true;
                }
            } else if (vt == SheetBaseMath.DataType_Text) {
                ++textCount;
            } else {
                ++numberCount;
            }
            sortedObjectArray.insert((Object)new CellValueModel(cell));
        }
        this.dataType = textCount == (maxCount = Math.max(Math.max(dateCount, textCount), numberCount)) ? 4 : (numberCount == maxCount ? 3 : (this.hasDateTime ? 2 : 1));
        this.autoFilterDataItem = sortedObjectArray.toArray();
    }

    public boolean isHasDate() {
        return this.hasDate;
    }

    public boolean isHasDateTime() {
        return this.hasDate && this.hasDateTime;
    }

    public Object[] getAutoFilterDataItem() {
        return this.autoFilterDataItem;
    }

    public boolean isMoreThan1W() {
        return this.isMoreThan1W;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isHasEmpty() {
        return this.hasEmpty;
    }
}

