/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.splash;

import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

class BufferedImageOpFactory {
    BufferedImageOpFactory() {
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("radius < 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    public static ConvolveOp getPlainBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("radius < 1");
        }
        int size = radius * 2 + 1;
        float weight = 1.0f / (float)(size * size);
        float[] data = new float[size * size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = weight;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel);
    }
}

