/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.metric;

import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.common.mm.metric.TimeAgg;
import com.kingdee.bos.bi.model.common.mm.metric.TimeCycle;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetricDimensionNode
extends AbstractTreeNode
implements Serializable {
    private static final long serialVersionUID = 7709219980062707327L;

    public void setMetricModel(MetricModel mm) {
        super.setModel((AbstractMainModel)mm);
    }

    public MetricModel getMetricModel() {
        return (MetricModel)super.getModel();
    }

    public void setParent(MetricDimensionNode node) {
        super.setParentNode((AbstractTreeNode)node);
    }

    public MetricDimensionNode getParent() {
        return (MetricDimensionNode)super.getParentNode();
    }

    public void addChild(MetricDimensionNode node) {
        super.addChildNode((AbstractTreeNode)node);
    }

    public MetricDimensionNode getChild(int idx) {
        return (MetricDimensionNode)super.getChildNode(idx);
    }

    public static void save(IManagementFacade facade, String id, MetricDimensionNode root) throws BIModelRemoteException {
        String sqlDelete = "delete from T_BI_MM_Metric where FViewID='" + id + "'";
        try {
            facade.executeUpdate(sqlDelete);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        try {
            MetricDimensionNode.saveNode(facade, id, root, 0);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
    }

    private static void saveNode(IManagementFacade facade, String id, MetricDimensionNode node, int idx) throws SQLException {
        MetricDimensionNode parent = node.getParent();
        String parentNumber = parent == null ? null : parent.getMetricModel().getNumber();
        MetricModel mo = node.getMetricModel();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into T_BI_MM_Metric ");
        sb.append("(FViewID, FNumber, FName, FParentNumber, FOrder, ");
        sb.append("FTimeCycle, FTimeAggType, FFormula, FFormulaCalcFlag, FMemo, FFormat) ");
        sb.append("values ('");
        sb.append(id);
        sb.append("','");
        sb.append(mo.getNumber());
        sb.append("','");
        sb.append(mo.getName());
        sb.append("',");
        if (parentNumber == null) {
            sb.append("NULL");
        } else {
            sb.append("'");
            sb.append(parentNumber);
            sb.append("'");
        }
        sb.append(",");
        sb.append(idx);
        sb.append(",'");
        sb.append(mo.getTimeCycle().getName());
        sb.append("','");
        sb.append(mo.getTimeAgg().getName());
        sb.append("',");
        if (StringUtil.isEmptyString((String)mo.getFormula())) {
            sb.append("NULL");
        } else {
            sb.append("'");
            sb.append(mo.getFormula());
            sb.append("'");
        }
        sb.append(",");
        sb.append(mo.isFormulaCalculateAgain() ? 1 : 0);
        sb.append(",'");
        sb.append(mo.getFMemo() == null ? "" : mo.getFMemo());
        sb.append("','");
        sb.append(mo.getFormatString() == null ? "" : mo.getFormatString());
        sb.append("'");
        sb.append(")");
        facade.executeUpdate(sb.toString());
        int c = node.getChildCount();
        for (int i = 0; i < c; ++i) {
            MetricDimensionNode.saveNode(facade, id, node.getChild(i), i);
        }
    }

    public static MetricDimensionNode load(IManagementFacade facade, String id) throws BIModelRemoteException {
        RDRowSet rowset;
        StringBuffer sb = new StringBuffer();
        sb.append("select * from T_BI_MM_Metric where FViewID='");
        sb.append(id);
        sb.append("' order by FParentNumber, FOrder");
        try {
            rowset = facade.executeQuery(sb.toString());
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        rowset.reset();
        if (rowset.isEof()) {
            return null;
        }
        HashMap<String, ArrayList<MetricDimensionNode>> mapForTree = new HashMap<String, ArrayList<MetricDimensionNode>>();
        MetricDimensionNode rootNode = null;
        while (rowset.next()) {
            String number = rowset.getString("FNumber");
            String name = rowset.getString("FName");
            String parentNumber = rowset.getString("FParentNumber");
            String timeCycle = rowset.getString("FTimeCycle");
            String timeAgg = rowset.getString("FTimeAggType");
            String formula = rowset.getString("FFormula");
            int formulaCalculateAgain = rowset.getInt("FFormulaCalcFlag", 0);
            String memo = rowset.getString("FMemo");
            String formatString = rowset.getString("FFormat");
            MetricModel model = new MetricModel();
            model.setNumber(number);
            model.setName(name);
            model.setTimeCycle(TimeCycle.getObj(timeCycle));
            model.setTimeAgg(TimeAgg.getObj(timeAgg));
            model.setFormula(formula);
            model.setFormulaCalculateAgain(formulaCalculateAgain == 1);
            model.setFMemo(memo);
            model.setFormatString(formatString);
            MetricDimensionNode node = new MetricDimensionNode();
            node.setMetricModel(model);
            if (rootNode == null && (parentNumber == null || StringUtil.equals((String)parentNumber, (String)number))) {
                rootNode = node;
                continue;
            }
            ArrayList<MetricDimensionNode> children = (ArrayList<MetricDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<MetricDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (rootNode != null) {
            MetricDimensionNode.buildTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    private static void buildTree(MetricDimensionNode parent, Map mapForTree) {
        String number = parent.getMetricModel().getNumber();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            MetricDimensionNode child = (MetricDimensionNode)children.get(i);
            parent.addChild(child);
            MetricDimensionNode.buildTree(child, mapForTree);
        }
    }
}

