/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.panel;

import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.AbstractProperty;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyDescriptorAdapter
extends AbstractProperty {
    private static final long serialVersionUID = 7518728846821433818L;
    private ExtendedPropertyDescriptor descriptor;

    public PropertyDescriptorAdapter() {
    }

    public PropertyDescriptorAdapter(ExtendedPropertyDescriptor descriptor) {
        this();
        this.setDescriptor(descriptor);
    }

    public void setDescriptor(ExtendedPropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    @Override
    public String getShortDescription() {
        return this.descriptor.getShortDescription();
    }

    @Override
    public Class getType() {
        return this.descriptor.getPropertyType();
    }

    @Override
    public Object clone() {
        PropertyDescriptorAdapter clone = new PropertyDescriptorAdapter(this.descriptor);
        clone.setValue(this.getValue());
        return clone;
    }

    @Override
    public void readFromObject(Object object) {
        this.readFromObject(object, true);
    }

    @Override
    public void readFromObject(Object object, boolean fireEvent) {
        try {
            Method method = this.descriptor.getMappedReadMethod();
            if (method != null) {
                EnumObj[] enums;
                Object value = method.invoke(object, this.descriptor.getKey());
                if (value == null) {
                    value = this.descriptor.getDefaultValue();
                }
                if ((enums = this.descriptor.getEnums()) != null && value instanceof String) {
                    for (EnumObj obj : enums) {
                        if (!obj.getName().equalsIgnoreCase((String)value)) continue;
                        value = obj;
                        break;
                    }
                }
                this.setValue(value == null ? this.descriptor.getDefaultValue() : value, fireEvent);
            }
        }
        catch (Exception e) {
            String message = "Got exception when reading property " + this.getName();
            message = object == null ? message + ", object was 'null'" : message + ", object was " + String.valueOf(object);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public void writeToObject(Object object) {
        try {
            Method method = this.descriptor.getWriteMethod();
            method = this.descriptor.getMappedWriteMethod();
            if (method != null) {
                method.invoke(object, this.descriptor.getKey(), this.getValue());
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof PropertyVetoException) {
                throw new RuntimeException(((InvocationTargetException)e).getTargetException());
            }
            String message = "Got exception when writing property " + this.getName();
            message = object == null ? message + ", object was 'null'" : message + ", object was " + String.valueOf(object);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public boolean isEditable() {
        return this.descriptor.isEditable();
    }

    @Override
    public String getCategory() {
        if (this.descriptor instanceof ExtendedPropertyDescriptor) {
            return this.descriptor.getCategory();
        }
        return null;
    }
}

