/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.kpimonitor;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.mm.kpi.KPIModel;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorModel;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorXmlModel;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.kpimonitor.KPIMonitorMessage;
import com.kingdee.bos.bi.model.security.SecureUtil;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.KPIMonitorException;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class KPIMonitorUtil {
    private static final String SPLIT_DASHBOARD_COLOR = "@//";
    private static final Logger log = LogUtil.getPackageLogger(KPIMonitorUtil.class);
    public static final String KEY_MONITOR_NUMBER = "monitorNumber";
    public static final String KEY_MONITOR_NAME = "monitorName";
    public static final String KEY_FACT = "fmeasurefact";
    public static final String KEY_DOWN_DANGER = "fmeasuredown1";
    public static final String KEY_DOWN_ALERT = "fmeasuredown2";
    public static final String KEY_UP_ALERT = "fmeasureup1";
    public static final String KEY_UP_DANGER = "fmeasureup2";
    public static final String KEY_METRIC_NUMBER = "metricNumber";
    public static final String KEY_EDGE_TYPE_DOWN = "down";
    public static final String KEY_EDGE_TYPE_UP = "up";
    public static final String KEY_EDGE_TYPE_DOUBLE = "double";

    public static Map getKPIMonitorList(Repository rep) throws KPIMonitorException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sql = "select FID,FName,FKPIID from T_BI_KPI_MON where FPublishFlag=1 order by FID ";
        List rs = null;
        try {
            rs = rep.executeQuery(sql);
        }
        catch (RepositoryException e) {
            log.error((Object)e.getMessage());
            map.put("message", e.getMessage());
            throw new KPIMonitorException((Throwable)e);
        }
        map.put("list", rs);
        map.put("message", "ok");
        return map;
    }

    public static KPIModel getKPIModel(Connection cn, String kpiModelId) throws KPIMonitorException {
        KPIModel model = new KPIModel();
        StringBuffer sqlKPI = new StringBuffer();
        sqlKPI.append("select A.FID,A.FAMID,A.FMeasureFact,A.FMeasureUp2,A.FMeasureUp1,A.FMeasureDown2,");
        sqlKPI.append("A.FMeasureDown1,A.FDiscription from T_BI_AM_KPI A where A.FID='").append(kpiModelId).append("'");
        try {
            RDRowSet rs = DBUtil.executeQuery(sqlKPI.toString(), cn);
            if (rs.next()) {
                model.setFAMID(rs.getString("FAMID"));
                model.setFMeasureFact(rs.getString("FMeasureFact"));
                model.setFMeasureUp2(rs.getString("FMeasureUp2"));
                model.setFMeasureUp1(rs.getString("FMeasureUp1"));
                model.setFMeasureDown2(rs.getString("FMeasureDown2"));
                model.setFMeasureDown1(rs.getString("FMeasureDown1"));
                model.setFDiscription(rs.getString("FDiscription"));
            }
        }
        catch (SQLException e) {
            throw new KPIMonitorException((Throwable)e);
        }
        ArrayList<KPIModel.Metric> metricList = new ArrayList<KPIModel.Metric>();
        KPIModel.Metric metric = null;
        StringBuffer sqlKPIMetric = new StringBuffer();
        sqlKPIMetric.append("select B.FMetric, B.FEdgeType from T_BI_KPI_Metric B where B.FID ='");
        sqlKPIMetric.append(kpiModelId);
        sqlKPIMetric.append("'");
        try {
            RDRowSet rs = DBUtil.executeQuery(sqlKPIMetric.toString(), cn);
            while (rs.next()) {
                metric = model.new KPIModel.Metric();
                metric.setFMetric(rs.getString("FMetric"));
                metric.setFEdgeType(rs.getString("FEdgeType"));
                metricList.add(metric);
            }
            model.setMetricList(metricList);
        }
        catch (SQLException e) {
            throw new KPIMonitorException((Throwable)e);
        }
        return model;
    }

    public static MetricMonitorModel getMonitorModel(Connection cn, String metricMonitorId) throws KPIMonitorException {
        MetricMonitorModel monitorModel = new MetricMonitorModel();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FName,FKPIID,FSchema,FDiscription from T_BI_KPI_MON where FID='").append(metricMonitorId).append("'");
        try {
            String xml;
            RDRowSet rs = DBUtil.executeQuery(sql.toString(), cn);
            if (rs.next()) {
                monitorModel.setId(rs.getString("FID"));
                monitorModel.setKPIId(rs.getString("FKPIID"));
                monitorModel.setSchema(rs.getString("FSchema"));
                monitorModel.setDiscription(rs.getString("FDiscription"));
            }
            if (!StringUtil.isEmpty(xml = monitorModel.getSchema())) {
                monitorModel.setXmlModel(MetricMonitorXmlModel.toModel(xml));
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new KPIMonitorException((Throwable)e);
        }
        catch (JDOMException e) {
            log.error((Object)e);
            throw new KPIMonitorException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new KPIMonitorException((Throwable)e);
        }
        return monitorModel;
    }

    public static MetricMonitorXmlModel getXmlModel(Connection cn, String metricMonitorId) throws KPIMonitorException {
        return KPIMonitorUtil.getMonitorModel(cn, metricMonitorId).getXmlModel();
    }

    public static String toXmls(String globalMessage) throws KPIMonitorException {
        Element rootElement = new Element("KPIMonitor");
        rootElement.setAttribute("globalMessage", globalMessage);
        try {
            return XmlUtil.toString(rootElement);
        }
        catch (IOException e) {
            throw new KPIMonitorException("\u8f93\u51faxml\u65f6\u53d1\u751fIO\u9519\u8bef\uff1a" + e);
        }
    }

    public static String toXmls(Map baseInfoMap, List toShowList, Map edgeTypeMap, Map metricFormatMap, String measureFormatString, Map factDatasMap, MetricMonitorXmlModel xmlModel, List nodeList) throws KPIMonitorException, IOException {
        Element rootElement = null;
        Element conditionElement = null;
        Element kpisElement = null;
        Element kpiElement = null;
        Element drillDownElement = null;
        Element dataElement = null;
        Element formatDataElment = null;
        rootElement = new Element("KPIMonitor");
        conditionElement = new Element("condition");
        String servletUrl = (String)baseInfoMap.get("servletUrl");
        String servletType = (String)baseInfoMap.get("servletType");
        String uiid = (String)baseInfoMap.get("uiid");
        String pageId = (String)baseInfoMap.get("pageId");
        String driilShowType = (String)baseInfoMap.get("showType");
        String paramOrg = (String)baseInfoMap.get("defaultOrg");
        String paramYear = (String)baseInfoMap.get("defaultYear");
        String paramPeriod = (String)baseInfoMap.get("defaultPeriod");
        String paramMetric = (String)baseInfoMap.get("defaultMetric");
        String command = (String)baseInfoMap.get("command");
        conditionElement.setAttribute("servletUrl", servletUrl == null ? "/easportal/BIReport" : servletUrl);
        conditionElement.setAttribute("servletType", servletType == null ? "kpiMonitor" : servletType);
        conditionElement.setAttribute("uiid", uiid == null ? "" : uiid);
        conditionElement.setAttribute("pageId", pageId == null ? "" : pageId);
        conditionElement.setAttribute("paramOrg", paramOrg == null ? "" : paramOrg);
        conditionElement.setAttribute("paramYear", paramYear == null ? "" : paramYear);
        conditionElement.setAttribute("paramPeriod", paramPeriod == null ? "" : paramPeriod);
        conditionElement.setAttribute("paramMetric", paramMetric == null ? "" : paramMetric);
        conditionElement.setAttribute("command", command == null ? "" : command);
        kpisElement = new Element("kpis");
        String title = (String)baseInfoMap.get("title");
        String kpiMonitorId = (String)baseInfoMap.get("kpiMonitorId");
        String metricWidth = (String)baseInfoMap.get("metricWidth");
        String metricHeight = (String)baseInfoMap.get("metricHeight");
        String metricAutoFlow = (String)baseInfoMap.get("metricAutoFlow");
        String goodColor = (String)baseInfoMap.get("goodColor");
        String warningColor = (String)baseInfoMap.get("warningColor");
        String dangerColor = (String)baseInfoMap.get("dangerColor");
        String monitorType = (String)baseInfoMap.get("monitorType");
        kpisElement.setAttribute("title", title == null ? "" : title);
        kpisElement.setAttribute("kpiMonitorId", kpiMonitorId);
        kpisElement.setAttribute("width", metricWidth);
        kpisElement.setAttribute("height", metricHeight);
        kpisElement.setAttribute("autoFlow", metricAutoFlow);
        kpisElement.setAttribute("goodColor", goodColor);
        kpisElement.setAttribute("warningColor", warningColor);
        kpisElement.setAttribute("dangerColor", dangerColor);
        kpisElement.setAttribute("monitorType", monitorType);
        List metricList = null;
        metricList = xmlModel.getMetricList();
        MetricMonitorXmlModel.Metric metric = null;
        Map kpiShowMap = null;
        Map kpiDataMap = null;
        int n = toShowList.size();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            kpiShowMap = (Map)toShowList.get(i);
            String kpiMonitorNumber = (String)kpiShowMap.get("kpiMonitorNumber".toLowerCase());
            String kpiMonitorName = (String)kpiShowMap.get("kpiMonitorName".toLowerCase());
            kpiDataMap = (Map)factDatasMap.get(kpiMonitorNumber);
            String message = (String)factDatasMap.get("message");
            String kpiMonitorMessageName = "\u3010" + (String)kpiShowMap.get("kpimonitorname") + "\u3011";
            if (!KPIMonitorUtil.checkCurrentNodeExist(kpiMonitorNumber, nodeList)) {
                String msg = "metric".equalsIgnoreCase(monitorType) ? "#1#\u6307\u6807\u65e0\u6743\u9650!" : "#1#\u7ec4\u7ec7\u65e0\u6743\u9650!";
                message = KPIMonitorMessage.formatMessage(msg, new String[]{kpiMonitorMessageName});
            }
            kpiElement = new Element("kpi");
            drillDownElement = new Element("drilldown");
            dataElement = new Element("data");
            formatDataElment = new Element("formatData");
            if (StringUtil.isEmpty(message) && kpiDataMap != null) {
                message = (String)kpiDataMap.get("message");
                String metricNumber = (String)kpiDataMap.get(KEY_METRIC_NUMBER.toLowerCase());
                int m = metricList.size();
                while (j < m) {
                    metric = (MetricMonitorXmlModel.Metric)metricList.get(j);
                    ++j;
                    if (!metric.getMetricNumber().equals(metricNumber)) continue;
                    if (driilShowType == null) break;
                    if (!metric.getShowType().equals(driilShowType)) continue;
                    j = 0;
                    break;
                }
                String edgeType = (String)edgeTypeMap.get(metricNumber);
                String showType = metric.getShowType();
                String metricFormat = (String)metricFormatMap.get(metricNumber);
                String drillDownOrg = String.valueOf(metric.getDrillDownOrg());
                String drillDownYear = String.valueOf(metric.getDrillDownYear());
                String drillDownPeriod = String.valueOf(metric.getDrillDownPeriod());
                String drillDownDefault = String.valueOf(metric.getDrillDownDefault());
                String point = "";
                String min = "";
                String danger = "";
                String alert = "";
                String max = "";
                Map factDataMap = null;
                factDataMap = KPIMonitorUtil.handleFactData2(kpiDataMap, edgeType);
                String string = message = StringUtil.isEmpty(message) ? (String)factDataMap.get("message") : message;
                if (message == null) {
                    point = (String)factDataMap.get("point");
                    min = (String)factDataMap.get("min");
                    danger = (String)factDataMap.get("alert");
                    alert = (String)factDataMap.get("good");
                    max = (String)factDataMap.get("max");
                    String edgeTypeTemp = (String)factDataMap.get("edgeType");
                    edgeType = edgeTypeTemp == null ? edgeType : edgeTypeTemp;
                    kpiElement.setAttribute(KEY_MONITOR_NUMBER, kpiMonitorNumber);
                    kpiElement.setAttribute(KEY_MONITOR_NAME, kpiMonitorName);
                    kpiElement.setAttribute("showType", showType);
                    kpiElement.setAttribute("edgeType", edgeType);
                    drillDownElement.setAttribute("org", drillDownOrg);
                    drillDownElement.setAttribute("year", drillDownYear);
                    drillDownElement.setAttribute("period", drillDownPeriod);
                    drillDownElement.setAttribute("default", drillDownDefault);
                    dataElement.setAttribute("point", point);
                    dataElement.setAttribute("min", min);
                    dataElement.setAttribute("danger", danger);
                    dataElement.setAttribute("alert", alert);
                    dataElement.setAttribute("max", max);
                    String formatString = StringUtil.isEmpty(metricFormat) ? measureFormatString : metricFormat;
                    DecimalFormat formator = new DecimalFormat(formatString);
                    formatDataElment.setAttribute("fpoint", formator.format(Double.parseDouble(point)));
                    formatDataElment.setAttribute("fmin", formator.format(Double.parseDouble(min)));
                    formatDataElment.setAttribute("fdanger", formator.format(Double.parseDouble(danger)));
                    formatDataElment.setAttribute("falert", formator.format(Double.parseDouble(alert)));
                    formatDataElment.setAttribute("fmax", formator.format(Double.parseDouble(max)));
                    formatDataElment.setAttribute("isPercent", String.valueOf(formatString.indexOf("%") > 0));
                } else {
                    message = "\u3010" + kpiMonitorName + "\u3011" + message;
                }
            } else if (StringUtil.isEmpty(message)) {
                StringBuffer sb = new StringBuffer();
                sb.append("#1#\u65e0\u6570\u636e!");
                message = sb.toString();
            }
            if (message != null) {
                kpiElement.setAttribute("message", KPIMonitorMessage.formatMessage(message, new String[]{kpiMonitorMessageName}));
            }
            kpiElement.addContent((Content)drillDownElement);
            kpiElement.addContent((Content)dataElement);
            kpiElement.addContent((Content)formatDataElment);
            kpisElement.addContent((Content)kpiElement);
        }
        rootElement.addContent((Content)conditionElement);
        rootElement.addContent((Content)kpisElement);
        return XmlUtil.toString(rootElement);
    }

    private static boolean checkCurrentNodeExist(String number, List nodeList) {
        if (nodeList == null) {
            return false;
        }
        for (AbstractTreeNode node : nodeList) {
            if (node == null || !StringUtil.equals(number, node.getModel().getNumber())) continue;
            return true;
        }
        return false;
    }

    public static List getShowList(Connection cn, String kpiMonitorId, String monitorType, Map conditionParamMap) throws KPIMonitorException {
        List<Map> resultList = null;
        StringBuffer sb = new StringBuffer();
        if ("org".equals(monitorType)) {
            sb.append("select FNumber,FName from ").append(KPIMonitorUtil.getOrgTableName(cn, kpiMonitorId));
            sb.append(" where FNumber in ");
            sb.append(conditionParamMap.get("paramShowList"));
            sb.append(" order by FID");
            resultList = KPIMonitorUtil.excuteQuery_NN_List(cn, sb.toString(), new String[]{"FNumber", "FName"}, new String[]{"kpiMonitorNumber", "kpiMonitorName"});
        } else if ("metric".equals(monitorType)) {
            sb.append("select FNumber,FName from ").append(KPIMonitorUtil.getMetricTableName(cn, kpiMonitorId));
            sb.append(" where FNumber in ");
            sb.append(conditionParamMap.get("paramShowList"));
            sb.append(" order by FID");
            List tempList = KPIMonitorUtil.excuteQuery_NN_List(cn, sb.toString(), new String[]{"FNumber", "FName"}, new String[]{"kpiMonitorNumber", "kpiMonitorName"});
            List orderList = (List)conditionParamMap.get("paramMetricOrder");
            String metricNumber = null;
            Map tempMap = null;
            int n = orderList.size();
            block0: for (int i = 0; i < n; ++i) {
                metricNumber = (String)orderList.get(i);
                int m = tempList.size();
                for (int j = 0; j < m; ++j) {
                    tempMap = (Map)tempList.get(j);
                    if (!metricNumber.equals(tempMap.get("kpiMonitorNumber".toLowerCase()))) continue;
                    if (resultList == null) {
                        resultList = new ArrayList();
                    }
                    resultList.add(tempMap);
                    continue block0;
                }
            }
            if (resultList == null) {
                resultList = tempList;
            }
        }
        return resultList == null ? new ArrayList() : resultList;
    }

    public static Map getMeasure5Map(Connection cn, String kpiMonitorId) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        sb.append("select A.FmeasureFact,A.FMeasureDown1,A.FMeasureDown2,A.FMeasureUp1,A.FMeasureUp2 from T_BI_AM_KPI A,");
        sb.append("T_BI_KPI_MON K where A.FID=K.FKPIID and K.FID='").append(kpiMonitorId).append("'");
        return KPIMonitorUtil.excuteQuery_1N(cn, sb.toString(), new String[]{KEY_FACT, KEY_DOWN_DANGER, KEY_DOWN_ALERT, KEY_UP_ALERT, KEY_UP_DANGER});
    }

    public static String getMeasureShowFormatString(Connection cn, AppModel appModel, String fact) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        String measureTableName = DimensionMeta.getTablename(appModel.getPubnumber(), "measure");
        sb.append("select FFormat from ").append(measureTableName);
        sb.append(" where FNumber in ('").append(fact).append("')");
        return KPIMonitorUtil.excuteQuery_11_String(cn, sb.toString());
    }

    public static Map getMeasureShowFormatMap(Connection cn, AppModel appModel, KPIModel kpiModel) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        String measureTableName = DimensionMeta.getTablename(appModel.getPubnumber(), "measure");
        sb.append("select FNumber,FFormat from ").append(measureTableName);
        if (kpiModel != null) {
            sb.append(" where FNumber in ('");
            sb.append(kpiModel.getFMeasureFact()).append("','");
            sb.append(kpiModel.getFMeasureUp1()).append("','");
            sb.append(kpiModel.getFMeasureUp2()).append("','");
            sb.append(kpiModel.getFMeasureDown1()).append("','");
            sb.append(kpiModel.getFMeasureDown2()).append("')");
        }
        return KPIMonitorUtil.excuteQuery_N2(cn, sb.toString(), new String[]{"FNumber", "FFormat"});
    }

    public static Map getMetricShowFormatMap(Connection cn, AppModel appModel, KPIModel kpiModel) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        String metricTableName = DimensionMeta.getTablename(appModel.getPubnumber(), "metric");
        sb.append("select FNumber,FFormat from ").append(metricTableName);
        if (kpiModel != null) {
            sb.append(" where FNumber in(");
            List metricList = kpiModel.getMetricList();
            KPIModel.Metric metric2 = null;
            for (KPIModel.Metric metric2 : metricList) {
                sb.append("'").append(metric2.getFMetric()).append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        return KPIMonitorUtil.excuteQuery_N2(cn, sb.toString(), new String[]{"FNumber", "FFormat"});
    }

    public static Map getMeasureShowFormatMap(Connection cn, AppModel appModel) throws KPIMonitorException {
        StringBuffer sqlMetric = new StringBuffer();
        String measureTableName = DimensionMeta.getTablename(appModel.getPubnumber(), "measure");
        sqlMetric.append("select FNumber,FFormat from ").append(measureTableName);
        return KPIMonitorUtil.excuteQuery_N2(cn, sqlMetric.toString(), new String[]{"FNumber", "FFormat"});
    }

    public static Map getFactDatas(Connection cn, AppModel appModel, Map edgeType, Map measureCache, String kpiMonitorId, String kpiMonitorType, MetricMonitorXmlModel xmlModel, Map filterParamMap) throws KPIMonitorException {
        HashMap<String, String> result = new HashMap<String, String>();
        Map m5 = KPIMonitorUtil.getMeasure5Map(cn, kpiMonitorId);
        String[] measures = new String[m5.size()];
        HashMap<String, String> isSure = new HashMap<String, String>();
        isSure.put(KEY_FACT, KEY_FACT);
        for (Map.Entry entry : edgeType.entrySet()) {
            String type = (String)entry.getValue();
            if (StringUtil.equalsIgnoreCase(type, KEY_EDGE_TYPE_UP)) {
                isSure.put(KEY_UP_DANGER, KEY_UP_DANGER);
                isSure.put(KEY_UP_ALERT, KEY_UP_ALERT);
            } else if (StringUtil.equalsIgnoreCase(type, KEY_EDGE_TYPE_DOWN)) {
                isSure.put(KEY_DOWN_DANGER, KEY_DOWN_DANGER);
                isSure.put(KEY_DOWN_ALERT, KEY_DOWN_ALERT);
            } else {
                isSure.put(KEY_UP_DANGER, KEY_UP_DANGER);
                isSure.put(KEY_UP_ALERT, KEY_UP_ALERT);
                isSure.put(KEY_DOWN_DANGER, KEY_DOWN_DANGER);
                isSure.put(KEY_DOWN_ALERT, KEY_DOWN_ALERT);
            }
            if (isSure.size() != 5) continue;
            break;
        }
        Map.Entry entry2 = null;
        int i = 0;
        String measure = null;
        for (Map.Entry entry2 : m5.entrySet()) {
            measure = (String)entry2.getValue();
            if (!isSure.containsKey(entry2.getKey()) || StringUtil.isEmpty(measure)) continue;
            measures[i++] = measure;
            if (measureCache.containsKey(measure)) continue;
            result.put("message", KPIMonitorMessage.formatMessage("#1#\u6307\u6807 \u3010#2#\u3011\u65e0\u6743\u9650!", new String[]{KPIMonitorMessage.handle(1), KPIMonitorUtil.getKPI((String)entry2.getKey())}));
            return result;
        }
        String numberColum = null;
        String nameColum = null;
        String metricColum = "FMetricNumber";
        if ("org".equals(kpiMonitorType)) {
            numberColum = "FOrgNumber";
            nameColum = "FOrgName";
            filterParamMap.put("paramOrg", filterParamMap.get("paramShowList"));
        } else {
            numberColum = "FMetricNumber";
            nameColum = "FMetricName";
            filterParamMap.put("paramMetric", filterParamMap.get("paramShowList"));
        }
        String sqlFactDatas = KPIMonitorUtil.getFactDatasSQL(cn, kpiMonitorId, filterParamMap);
        String[] colums = null;
        String[] keys = null;
        if (StringUtil.isEmpty((String)m5.get(KEY_DOWN_DANGER)) || StringUtil.isEmpty((String)m5.get(KEY_DOWN_ALERT))) {
            colums = new String[]{numberColum, nameColum, "FM_" + m5.get(KEY_FACT), "FM_" + m5.get(KEY_UP_ALERT), "FM_" + m5.get(KEY_UP_DANGER), metricColum, numberColum};
            keys = new String[]{KEY_MONITOR_NUMBER, KEY_MONITOR_NAME, KEY_FACT, KEY_UP_ALERT, KEY_UP_DANGER, KEY_METRIC_NUMBER};
        } else if (StringUtil.isEmpty((String)m5.get(KEY_UP_ALERT)) || StringUtil.isEmpty((String)m5.get(KEY_UP_DANGER))) {
            colums = new String[]{numberColum, nameColum, "FM_" + m5.get(KEY_FACT), "FM_" + m5.get(KEY_DOWN_DANGER), "FM_" + m5.get(KEY_DOWN_ALERT), metricColum, numberColum};
            keys = new String[]{KEY_MONITOR_NUMBER, KEY_MONITOR_NAME, KEY_FACT, KEY_DOWN_DANGER, KEY_DOWN_ALERT, KEY_METRIC_NUMBER};
        } else {
            colums = new String[]{numberColum, nameColum, "FM_" + m5.get(KEY_FACT), "FM_" + m5.get(KEY_DOWN_DANGER), "FM_" + m5.get(KEY_DOWN_ALERT), "FM_" + m5.get(KEY_UP_ALERT), "FM_" + m5.get(KEY_UP_DANGER), metricColum, numberColum};
            keys = new String[]{KEY_MONITOR_NUMBER, KEY_MONITOR_NAME, KEY_FACT, KEY_DOWN_DANGER, KEY_DOWN_ALERT, KEY_UP_ALERT, KEY_UP_DANGER, KEY_METRIC_NUMBER};
        }
        return KPIMonitorUtil.excuteQuery_NN_Map(cn, sqlFactDatas, colums, keys);
    }

    public static Map getFactDatas(Connection cn, String kpiMonitorId, String kpiMonitorType, MetricMonitorXmlModel xmlModel, Map filterParamMap) throws KPIMonitorException {
        Map m5 = KPIMonitorUtil.getMeasure5Map(cn, kpiMonitorId);
        String numberColum = null;
        String nameColum = null;
        String metricColum = "FMetricNumber";
        if ("org".equals(kpiMonitorType)) {
            numberColum = "FOrgNumber";
            nameColum = "FOrgName";
            filterParamMap.put("paramOrg", filterParamMap.get("paramShowList"));
        } else {
            numberColum = "FMetricNumber";
            nameColum = "FMetricName";
            filterParamMap.put("paramMetric", filterParamMap.get("paramShowList"));
        }
        String sqlFactDatas = KPIMonitorUtil.getFactDatasSQL(cn, kpiMonitorId, filterParamMap);
        String[] colums = null;
        String[] keys = null;
        if (m5.get(KEY_DOWN_DANGER) == null || m5.get(KEY_DOWN_ALERT) == null || StringUtil.isEmpty((String)m5.get(KEY_DOWN_DANGER)) || StringUtil.isEmpty((String)m5.get(KEY_DOWN_ALERT))) {
            colums = new String[]{numberColum, nameColum, "FM_" + m5.get(KEY_FACT), "FM_" + m5.get(KEY_UP_ALERT), "FM_" + m5.get(KEY_UP_DANGER), metricColum, numberColum};
            keys = new String[]{KEY_MONITOR_NUMBER, KEY_MONITOR_NAME, KEY_FACT, KEY_UP_ALERT, KEY_UP_DANGER, KEY_METRIC_NUMBER};
        } else if (m5.get(KEY_UP_ALERT) == null || m5.get(KEY_UP_DANGER) == null || StringUtil.isEmpty((String)m5.get(KEY_UP_ALERT)) || StringUtil.isEmpty((String)m5.get(KEY_UP_DANGER))) {
            colums = new String[]{numberColum, nameColum, "FM_" + m5.get(KEY_FACT), "FM_" + m5.get(KEY_DOWN_DANGER), "FM_" + m5.get(KEY_DOWN_ALERT), metricColum, numberColum};
            keys = new String[]{KEY_MONITOR_NUMBER, KEY_MONITOR_NAME, KEY_FACT, KEY_DOWN_DANGER, KEY_DOWN_ALERT, KEY_METRIC_NUMBER};
        } else {
            colums = new String[]{numberColum, nameColum, "FM_" + m5.get(KEY_FACT), "FM_" + m5.get(KEY_DOWN_DANGER), "FM_" + m5.get(KEY_DOWN_ALERT), "FM_" + m5.get(KEY_UP_ALERT), "FM_" + m5.get(KEY_UP_DANGER), metricColum, numberColum};
            keys = new String[]{KEY_MONITOR_NUMBER, KEY_MONITOR_NAME, KEY_FACT, KEY_DOWN_DANGER, KEY_DOWN_ALERT, KEY_UP_ALERT, KEY_UP_DANGER, KEY_METRIC_NUMBER};
        }
        return KPIMonitorUtil.excuteQuery_NN_Map(cn, sqlFactDatas, colums, keys);
    }

    public static Map getDefaultCondition(HttpServletRequest request, Map caches, AppModel appModel, String metricMonitorId, MetricMonitorXmlModel xmlModel, String currentOrg) throws KPIMonitorException, BIReportException {
        HashMap<String, String> defaultConditionMap = new HashMap<String, String>();
        TreeMap orgCache = (TreeMap)caches.get("org");
        TreeMap yearCache = (TreeMap)caches.get("year");
        TreeMap periodCache = (TreeMap)caches.get("period");
        if (orgCache.size() == 0) {
            throw new BIReportException("\u4e0d\u5b58\u5728\u4efb\u4f55\u7ec4\u7ec7\uff0c\u6216\u8005\u60a8\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u7684\u67e5\u770b\u6743\u9650\uff01");
        }
        if (yearCache.size() == 0) {
            throw new BIReportException("\u4e0d\u5b58\u5728\u4efb\u4f55\u5e74\uff0c\u6216\u8005\u60a8\u6ca1\u6709\u4efb\u4f55\u5e74\u7684\u67e5\u770b\u6743\u9650\uff01");
        }
        if (periodCache.size() == 0) {
            throw new BIReportException("\u4e0d\u5b58\u5728\u4efb\u4f55\u671f\u95f4\uff0c\u6216\u8005\u60a8\u6ca1\u6709\u4efb\u4f55\u671f\u95f4\u7684\u67e5\u770b\u6743\u9650\uff01");
        }
        String paramOrg = null;
        String paramYear = null;
        String paramPeriod = null;
        String defaultOrg = xmlModel.getDefaultOrg();
        String defaultYear = xmlModel.getDefaultYear();
        String defaultPeriod = xmlModel.getDefaultPeriod();
        String newYear = null;
        String newPeriod = null;
        RDRowSet rs = appModel.getLastRowDataByPeriod(BISystem.getContext((HttpServletRequest)request));
        if (rs.next()) {
            newYear = String.valueOf(rs.getInt(0));
            newPeriod = String.valueOf(rs.getInt(1));
        }
        if ("default".equals(defaultOrg)) {
            paramOrg = orgCache.containsKey(currentOrg) ? currentOrg : (String)orgCache.firstKey();
        } else {
            String string = paramOrg = orgCache.containsKey(defaultOrg) ? defaultOrg : (String)orgCache.firstKey();
        }
        paramYear = "default".equals(defaultYear) ? (yearCache.containsKey(newYear) ? newYear : (String)yearCache.lastKey()) : (yearCache.containsKey(defaultYear) ? defaultYear : (String)yearCache.lastKey());
        paramPeriod = "default".equals(defaultPeriod) ? KPIMonitorUtil.getAppropPeriod(newPeriod, periodCache) : KPIMonitorUtil.getAppropPeriod(defaultPeriod, periodCache);
        defaultConditionMap.put("paramOrg", paramOrg);
        defaultConditionMap.put("paramYear", paramYear);
        defaultConditionMap.put("paramPeriod", paramPeriod);
        return defaultConditionMap;
    }

    public static String getAppropPeriod(String targetPeriod, TreeMap periodCache) {
        if (periodCache.containsKey(targetPeriod)) {
            return targetPeriod;
        }
        int p = Integer.parseInt(targetPeriod);
        while (--p > 0) {
            if (!periodCache.containsKey(Integer.toString(p))) continue;
            return Integer.toString(p);
        }
        return (String)periodCache.firstKey();
    }

    public static Map handleFactData(Map factDataMap, String edgeType) {
        String upDanger;
        HashMap<String, String> map = new HashMap<String, String>();
        String message = null;
        String fact = ((BigDecimal)factDataMap.get(KEY_FACT)).toString();
        String downDanger = factDataMap.get(KEY_DOWN_DANGER) == null ? null : ((BigDecimal)factDataMap.get(KEY_DOWN_DANGER)).toString();
        String downAlert = factDataMap.get(KEY_DOWN_ALERT) == null ? null : ((BigDecimal)factDataMap.get(KEY_DOWN_ALERT)).toString();
        String upAlert = factDataMap.get(KEY_UP_ALERT) == null ? null : ((BigDecimal)factDataMap.get(KEY_UP_ALERT)).toString();
        String string = upDanger = factDataMap.get(KEY_UP_DANGER) == null ? null : ((BigDecimal)factDataMap.get(KEY_UP_DANGER)).toString();
        if (KEY_EDGE_TYPE_DOUBLE.equals(edgeType)) {
            if (downDanger != null && downAlert != null && upAlert != null && upDanger != null) {
                double point = Double.parseDouble(fact);
                double min = Double.parseDouble(downDanger);
                double alert = Double.parseDouble(downAlert);
                double good = Double.parseDouble(upAlert);
                double max = Double.parseDouble(upDanger);
                if (min < alert && alert < good && good < max) {
                    double middle = (alert + good) / 2.0;
                    double lack = middle - alert;
                    if (point < middle) {
                        double minimum = min - lack;
                        if (minimum > point) {
                            minimum = point;
                        }
                        map.put("min", Double.toString(minimum));
                        map.put("alert", Double.toString(min));
                        map.put("good", Double.toString(alert));
                        map.put("point", Double.toString(point));
                        map.put("max", Double.toString(middle));
                        map.put("edgeType", KEY_EDGE_TYPE_DOWN);
                    } else {
                        double maxmum = max + lack;
                        if (point > maxmum) {
                            maxmum = point;
                        }
                        map.put("min", Double.toString(middle));
                        map.put("alert", Double.toString(good));
                        map.put("good", Double.toString(max));
                        map.put("point", Double.toString(point));
                        map.put("max", Double.toString(maxmum));
                        map.put("edgeType", KEY_EDGE_TYPE_UP);
                    }
                } else if (min >= alert) {
                    message = "\u3010\u4e0b\u9650\u5371\u9669\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0b\u9650\u4e0d\u826f\u3011\uff01";
                } else if (alert >= good) {
                    message = "\u3010\u4e0b\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u4e0d\u826f\u3011\uff01";
                } else if (good >= max) {
                    message = "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u5371\u9669\u3011\uff01";
                }
            } else if (downDanger == null) {
                message = "\u3010\u4e0b\u9650\u5371\u9669\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            } else if (downAlert == null) {
                message = "\u3010\u4e0b\u9650\u4e0d\u826f\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            } else if (upAlert == null) {
                message = "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            } else if (upDanger == null) {
                message = "\u3010\u4e0a\u9650\u5371\u9669\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            }
        } else if (KEY_EDGE_TYPE_DOWN.equals(edgeType)) {
            double good;
            double point = Double.parseDouble(fact);
            double alert = KEY_EDGE_TYPE_UP.equals(edgeType) ? Double.parseDouble(upAlert) : Double.parseDouble(downDanger);
            double d = good = KEY_EDGE_TYPE_UP.equals(edgeType) ? Double.parseDouble(upDanger) : Double.parseDouble(downAlert);
            if (alert < good) {
                double high = good + (good - alert);
                double low = alert - (good - alert);
                if (point < low) {
                    low = point;
                } else if (point > high) {
                    high = point;
                }
                map.put("min", Double.toString(low));
                map.put("alert", Double.toString(alert));
                map.put("good", Double.toString(good));
                map.put("point", Double.toString(point));
                map.put("max", Double.toString(high));
            } else if (alert > good) {
                message = KEY_EDGE_TYPE_DOWN.equals(edgeType) ? "\u3010\u4e0b\u9650\u5371\u9669\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0b\u9650\u4e0d\u826f\u3011\uff01" : "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u5371\u9669\u3011\uff01";
            }
        } else if (KEY_EDGE_TYPE_UP.equals(edgeType)) {
            double good;
            double point = Double.parseDouble(fact);
            double alert = KEY_EDGE_TYPE_UP.equals(edgeType) ? Double.parseDouble(upAlert) : Double.parseDouble(downDanger);
            double d = good = KEY_EDGE_TYPE_UP.equals(edgeType) ? Double.parseDouble(upDanger) : Double.parseDouble(downAlert);
            if (alert < good) {
                double high = good + (good - alert);
                double low = alert - (good - alert);
                if (point > high) {
                    high = point;
                } else if (point < low) {
                    low = point;
                }
                map.put("min", Double.toString(low));
                map.put("alert", Double.toString(alert));
                map.put("good", Double.toString(good));
                map.put("point", Double.toString(point));
                map.put("max", Double.toString(high));
            } else if (alert > good) {
                message = KEY_EDGE_TYPE_DOWN.equals(edgeType) ? "\u3010\u4e0b\u9650\u5371\u9669\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0b\u9650\u4e0d\u826f\u3011\uff01" : "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u5371\u9669\u3011\uff01";
            }
        } else {
            message = "\u6ca1\u6709\u8bbe\u5b9a\u8fb9\u754c\u7c7b\u578b\uff01";
        }
        if (map.get("point") == null && message == null) {
            message = "\u6570\u636e\u4e0d\u5b58\u5728\u6216\u6709\u8bef\uff01";
        }
        map.put("message", message);
        return map;
    }

    public static Map handleFactData2(Map factDataMap, String edgeType) {
        HashMap<String, String> result = new HashMap<String, String>();
        String message = null;
        BigDecimal fact = (BigDecimal)factDataMap.get(KEY_FACT);
        BigDecimal downDanger = (BigDecimal)factDataMap.get(KEY_DOWN_DANGER);
        BigDecimal downAlert = (BigDecimal)factDataMap.get(KEY_DOWN_ALERT);
        BigDecimal upAlert = (BigDecimal)factDataMap.get(KEY_UP_ALERT);
        BigDecimal upDanger = (BigDecimal)factDataMap.get(KEY_UP_DANGER);
        if (KEY_EDGE_TYPE_DOUBLE.equals(edgeType)) {
            if (downDanger != null && downAlert != null && upAlert != null && upDanger != null) {
                double point = fact.doubleValue();
                double min = downDanger.doubleValue();
                double alert = downAlert.doubleValue();
                double good = upAlert.doubleValue();
                double max = upDanger.doubleValue();
                if (min < alert && alert < good && good < max) {
                    double middle = (alert + good) / 2.0;
                    double lack = middle - alert;
                    if (point < middle) {
                        double minimum = min - lack;
                        if (minimum > point) {
                            minimum = point;
                        }
                        result.put("min", Double.toString(minimum));
                        result.put("alert", Double.toString(min));
                        result.put("good", Double.toString(alert));
                        result.put("point", Double.toString(point));
                        result.put("max", Double.toString(middle));
                        result.put("edgeType", KEY_EDGE_TYPE_DOWN);
                    } else {
                        double maxmum = max + lack;
                        if (point > maxmum) {
                            maxmum = point;
                        }
                        result.put("min", Double.toString(middle));
                        result.put("alert", Double.toString(good));
                        result.put("good", Double.toString(max));
                        result.put("point", Double.toString(point));
                        result.put("max", Double.toString(maxmum));
                        result.put("edgeType", KEY_EDGE_TYPE_UP);
                    }
                } else if (min >= alert) {
                    message = "\u3010\u4e0b\u9650\u5371\u9669\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0b\u9650\u4e0d\u826f\u3011\uff01";
                } else if (alert >= good) {
                    message = "\u3010\u4e0b\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u4e0d\u826f\u3011\uff01";
                } else if (good >= max) {
                    message = "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u5371\u9669\u3011\uff01";
                }
            } else if (downDanger == null) {
                message = "\u3010\u4e0b\u9650\u5371\u9669\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            } else if (downAlert == null) {
                message = "\u3010\u4e0b\u9650\u4e0d\u826f\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            } else if (upAlert == null) {
                message = "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            } else if (upDanger == null) {
                message = "\u3010\u4e0a\u9650\u5371\u9669\u3011\u6570\u636e\u4e3a\u7a7a\uff01";
            }
        } else if (KEY_EDGE_TYPE_DOWN.equals(edgeType)) {
            double good;
            double point = fact.doubleValue();
            double alert = KEY_EDGE_TYPE_UP.equals(edgeType) ? upAlert.doubleValue() : downDanger.doubleValue();
            double d = good = KEY_EDGE_TYPE_UP.equals(edgeType) ? upDanger.doubleValue() : downAlert.doubleValue();
            if (alert < good) {
                double high = good + (good - alert);
                double low = alert - (good - alert);
                if (point < low) {
                    low = point;
                } else if (point > high) {
                    high = point;
                }
                result.put("min", Double.toString(low));
                result.put("alert", Double.toString(alert));
                result.put("good", Double.toString(good));
                result.put("point", Double.toString(point));
                result.put("max", Double.toString(high));
            } else if (alert > good) {
                message = KEY_EDGE_TYPE_DOWN.equals(edgeType) ? "\u3010\u4e0b\u9650\u5371\u9669\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0b\u9650\u4e0d\u826f\u3011\uff01" : "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u5371\u9669\u3011\uff01";
            }
        } else if (KEY_EDGE_TYPE_UP.equals(edgeType)) {
            double good;
            double point = fact.doubleValue();
            double alert = KEY_EDGE_TYPE_UP.equals(edgeType) ? upAlert.doubleValue() : downDanger.doubleValue();
            double d = good = KEY_EDGE_TYPE_UP.equals(edgeType) ? upDanger.doubleValue() : downAlert.doubleValue();
            if (alert < good) {
                double high = good + (good - alert);
                double low = alert - (good - alert);
                if (point > high) {
                    high = point;
                } else if (point < low) {
                    low = point;
                }
                result.put("min", Double.toString(low));
                result.put("alert", Double.toString(alert));
                result.put("good", Double.toString(good));
                result.put("point", Double.toString(point));
                result.put("max", Double.toString(high));
            } else if (alert > good) {
                message = KEY_EDGE_TYPE_DOWN.equals(edgeType) ? "\u3010\u4e0b\u9650\u5371\u9669\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0b\u9650\u4e0d\u826f\u3011\uff01" : "\u3010\u4e0a\u9650\u4e0d\u826f\u3011\u5fc5\u987b\u5c0f\u4e8e\u3010\u4e0a\u9650\u5371\u9669\u3011\uff01";
            }
        } else {
            message = "\u6ca1\u6709\u8bbe\u5b9a\u8fb9\u754c\u7c7b\u578b\uff01";
        }
        if (result.get("point") == null && message == null) {
            message = "\u6570\u636e\u4e0d\u5b58\u5728\u6216\u6709\u8bef\uff01";
        }
        result.put("message", message);
        return result;
    }

    public static String getFactDatasSQL(Connection cn, String kpiMonitorId, Map filterParamMap) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        Map m5 = KPIMonitorUtil.getMeasure5Map(cn, kpiMonitorId);
        String factTableName = KPIMonitorUtil.getFactTableName(cn, kpiMonitorId);
        String metricTableName = KPIMonitorUtil.getMetricTableName(cn, kpiMonitorId);
        String orgTableName = KPIMonitorUtil.getOrgTableName(cn, kpiMonitorId);
        if (factTableName == null) {
            return sb.toString();
        }
        sb.append("select F.FmetricID,M.FNumber as FMetricNumber,M.FName as FMetricName,O.FNumber as FOrgNumber,O.FName as FOrgName");
        String measureFactColumn = ",F.FM_" + m5.get(KEY_FACT);
        String measureDown1Column = ",F.FM_" + (m5.get(KEY_DOWN_DANGER) == null ? "" : m5.get(KEY_DOWN_DANGER));
        String measureDown2Column = ",F.FM_" + (m5.get(KEY_DOWN_ALERT) == null ? "" : m5.get(KEY_DOWN_ALERT));
        String measureUp1Column = ",F.FM_" + (m5.get(KEY_UP_ALERT) == null ? "" : m5.get(KEY_UP_ALERT));
        String measureUp2Column = ",F.FM_" + (m5.get(KEY_UP_DANGER) == null ? "" : m5.get(KEY_UP_DANGER));
        sb.append(measureFactColumn);
        if (measureDown1Column.length() > 6 && measureDown2Column.length() > 6) {
            sb.append(measureDown1Column);
            sb.append(measureDown2Column);
        }
        if (measureUp1Column.length() > 6 && measureUp2Column.length() > 6) {
            sb.append(measureUp1Column);
            sb.append(measureUp2Column);
        }
        sb.append(" from ").append(factTableName).append(" F,").append(orgTableName);
        sb.append(" O,").append(metricTableName).append(" M ");
        String paramYear = (String)filterParamMap.get("paramYear");
        String paramPeriod = (String)filterParamMap.get("paramPeriod");
        String paramOrg = (String)filterParamMap.get("paramOrg");
        String paramMetric = (String)filterParamMap.get("paramMetric");
        sb.append(" where F.FyearID in ").append(paramYear);
        sb.append(" and F.FperiodID in ").append(paramPeriod);
        sb.append(" and F.ForgID=O.FID and O.FNumber in ").append(paramOrg);
        sb.append(" and F.FmetricID=M.FID and M.FNumber in ").append(paramMetric);
        return sb.toString();
    }

    public static Map getEdgeTypes(Connection cn, String kpiMonitorId) throws KPIMonitorException {
        StringBuffer sqlEdgeType = new StringBuffer();
        sqlEdgeType.append("select A.FMetric,A.FEdgeType from T_BI_KPI_Metric A,T_BI_KPI_MON B where A.FID=B.FKPIID and B.FID='");
        sqlEdgeType.append(kpiMonitorId).append("'");
        KPIMonitorUtil.excuteQuery_N2(cn, sqlEdgeType.toString(), new String[]{"FMetric", "FEdgeType"});
        return KPIMonitorUtil.excuteQuery_N2(cn, sqlEdgeType.toString(), new String[]{"FMetric", "FEdgeType"});
    }

    public static Map getDashBoardColor(Connection cn) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String goodColor = "0XFF1313";
        String warningColor = "0XFEDE00";
        String dangerColor = "0X00FF00";
        Statement st = null;
        ResultSet rs = null;
        String sql = "SELECT FParamvalue FROM T_BI_SystemConfigure WHERE FConfigureType='" + Constants.CONFIGURETYPE_KPICOLOR + "'";
        st = cn.createStatement();
        rs = st.executeQuery(sql);
        if (rs.next()) {
            String paramvalue = rs.getString("fparamvalue");
            dangerColor = paramvalue.split(SPLIT_DASHBOARD_COLOR)[2].toUpperCase().replaceAll("#", "0X");
            warningColor = paramvalue.split(SPLIT_DASHBOARD_COLOR)[1].toUpperCase().replaceAll("#", "0X");
            goodColor = paramvalue.split(SPLIT_DASHBOARD_COLOR)[0].toUpperCase().replaceAll("#", "0X");
        }
        map.put("dangerColor", dangerColor);
        map.put("warningColor", warningColor);
        map.put("goodColor", goodColor);
        return map;
    }

    public static List getShowList(Map OrgCacher, String kpiMonitorId, String kpiMonitorType, String kpiMonitorNumber) throws KPIMonitorException {
        List orgList;
        ArrayList<String> result = new ArrayList<String>();
        if ("org".equals(kpiMonitorType) && (orgList = (List)OrgCacher.get(kpiMonitorNumber)) != null) {
            Iterator it = orgList.iterator();
            while (it.hasNext()) {
                result.add(((OrgDimensionNode)it.next()).getOrgModel().getNumber());
            }
        }
        return result;
    }

    public static List getShowList(Connection cn, String kpiMonitorId, String kpiMonitorType, String kpiMonitorNumber) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        if ("org".equals(kpiMonitorType)) {
            // empty if block
        }
        sb.append("select FNumber from ").append(KPIMonitorUtil.getOrgTableName(cn, kpiMonitorId));
        sb.append(" where FParentNumber='").append(kpiMonitorNumber).append("'");
        return KPIMonitorUtil.excuteQuery_N1(cn, sb.toString());
    }

    public static String getDimInfo(Map mapTree, String dimType, String parentNum) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        List children = (List)mapTree.get(parentNum);
        AbstractMainModel model = null;
        AbstractTreeNode node2 = null;
        for (AbstractTreeNode node2 : children) {
            model = node2.getModel();
            sb.append(dimType);
            sb.append("\u0001");
            sb.append(model.getName());
            sb.append("\u0001");
            sb.append(model.getName() + (node2.canSelect() ? "" : "(\u65e0\u6743\u67e5\u770b)"));
            sb.append("\u0001");
            sb.append(model.getNumber());
            sb.append("\u0001");
            sb.append(mapTree.containsKey(model.getNumber()) ? "0" : "1");
            sb.append("\u0001");
            sb.append(node2.canSelect() ? "1" : "0");
            sb.append("\u0001");
        }
        return sb.deleteCharAt(sb.lastIndexOf("\u0001")).toString();
    }

    public static String getDimInfo(Connection cn, String kpiMonitorId, String dimType, String parentNum) throws KPIMonitorException {
        StringBuffer sql = new StringBuffer();
        if ("org".equals(dimType)) {
            sql.append("select FNumber,FParentNumber,FName,FIsLeaf from ");
            sql.append(KPIMonitorUtil.getOrgTableName(cn, kpiMonitorId));
            if (parentNum != null) {
                sql.append(" where FParentNumber='");
                sql.append(parentNum);
                sql.append("'");
            } else {
                sql.append(" where FParentNumber is null  or FParentNumber=FNumber");
            }
            sql.append(" order by FID");
            return KPIMonitorUtil.excuteQuery(cn, dimType, sql.toString(), dimType, new String[]{"FNumber", "FName", "FIsLeaf"});
        }
        if ("year".equals(dimType)) {
            sql.append("select FYear from ");
            sql.append(KPIMonitorUtil.getYearTableName(cn, kpiMonitorId));
            sql.append(" order by FYear");
            return KPIMonitorUtil.excuteQuery(cn, dimType, sql.toString(), dimType, new String[]{"FYear"});
        }
        if ("period".equals(dimType)) {
            sql.append("select FPeriod,FPeriodParent from ");
            sql.append(KPIMonitorUtil.getPeriodTableName(cn, kpiMonitorId));
            if (parentNum != null) {
                sql.append(" where FPeriodParent=");
                sql.append(parentNum);
                sql.append(" and FPeriodParent!=FPeriod ");
            } else {
                sql.append(" where FPeriodParent is null or FPeriodParent=FPeriod");
            }
            sql.append(" order by FPeriod");
            return KPIMonitorUtil.excuteQuery(cn, dimType, sql.toString(), dimType, new String[]{"FPeriod"});
        }
        return new StringBuffer().toString();
    }

    public static String getDimName(Connection cn, String kpiMonitorId, String dimType, String dimNum) throws KPIMonitorException {
        StringBuffer sql = new StringBuffer();
        if ("org".equals(dimType)) {
            sql.append("select FName from ");
            sql.append(KPIMonitorUtil.getOrgTableName(cn, kpiMonitorId));
            sql.append(" where FNumber='");
            sql.append(dimNum);
            sql.append("'");
            sql.append(" order by FID");
            return KPIMonitorUtil.excuteQuery_11_String(cn, sql.toString());
        }
        if ("year".equals(dimType)) {
            return dimNum + "\u5e74";
        }
        if ("period".equals(dimType)) {
            if (Integer.parseInt(dimNum) < 100) {
                return "\u7b2c" + dimNum + "\u671f";
            }
            return "\u7b2c" + (Integer.parseInt(dimNum) - 100) + "\u5b63\u5ea6";
        }
        if ("metric".equals(dimType)) {
            sql.append("select FName from ");
            sql.append(KPIMonitorUtil.getMetricTableName(cn, kpiMonitorId));
            sql.append(" where FNumber='");
            sql.append(dimNum);
            sql.append("'");
            sql.append(" order by FID");
            return KPIMonitorUtil.excuteQuery_11_String(cn, sql.toString());
        }
        return "unknow";
    }

    public static String getPublishNumber(Connection cn, String metricMonitorId) throws KPIMonitorException {
        StringBuffer sb = new StringBuffer();
        sb.append("select A.FPublishNumber from T_BI_KPI_MON M,T_BI_AM_KPI K,T_BI_AppModel A where M.FID='");
        sb.append(metricMonitorId);
        sb.append("'and M.FKPIID=K.FID and K.FAMID=A.FID");
        return KPIMonitorUtil.excuteQuery_11_String(cn, sb.toString());
    }

    public static String getFactTableName(Connection cn, String kpiMonitorId) throws KPIMonitorException {
        return "T_BI_F_" + KPIMonitorUtil.getPublishNumber(cn, kpiMonitorId);
    }

    public static String getMetricTableName(Connection cn, String kpiMonitorId) throws KPIMonitorException {
        return "T_BI_D_" + KPIMonitorUtil.getPublishNumber(cn, kpiMonitorId) + "_metric";
    }

    public static String getOrgTableName(Connection cn, String kpiMonitorId) throws KPIMonitorException {
        return "T_BI_D_" + KPIMonitorUtil.getPublishNumber(cn, kpiMonitorId) + "_org";
    }

    public static String getYearTableName(Connection cn, String kpiMonitorId) throws KPIMonitorException {
        return "T_BI_D_" + KPIMonitorUtil.getPublishNumber(cn, kpiMonitorId) + "_year";
    }

    public static String getPeriodTableName(Connection cn, String kpiMonitorId) throws KPIMonitorException {
        return "T_BI_D_" + KPIMonitorUtil.getPublishNumber(cn, kpiMonitorId) + "_period";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map excuteQuery_N2(Connection cn, String sql, String[] cloums) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                map.put(rs.getObject(cloums[0]), rs.getObject(cloums[1]));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String excuteQuery_11_String(Connection cn, String sql) {
        PreparedStatement stmt;
        ResultSet rs;
        String str;
        block4: {
            str = null;
            rs = null;
            stmt = null;
            try {
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                str = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return str == null ? "" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List excuteQuery_N1(Connection cn, String sql) {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int excuteQuery_11_Int(Connection cn, String sql) {
        Statement stmt;
        ResultSet rs;
        int value;
        block4: {
            value = -1;
            rs = null;
            stmt = null;
            try {
                stmt = cn.createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                value = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map excuteQuery_1N(Connection cn, String sql, String[] cloums) {
        Statement stmt;
        ResultSet rs;
        HashMap<String, Object> map;
        block5: {
            map = new HashMap<String, Object>();
            rs = null;
            stmt = null;
            try {
                stmt = cn.createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block5;
                int n = cloums.length;
                for (int i = 0; i < n; ++i) {
                    map.put(cloums[i].toLowerCase(), rs.getObject(cloums[i]));
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map excuteQuery_NN_Map(Connection cn, String sql, String[] cloums, String[] keys) {
        HashMap map = new HashMap();
        HashMap<String, Object> m = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                m = new HashMap<String, Object>();
                int n = keys.length;
                for (int i = 0; i < n; ++i) {
                    m.put(keys[i].toLowerCase(), rs.getObject(cloums[i]));
                }
                map.put(rs.getObject(cloums[cloums.length - 1]), m);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List excuteQuery_NN_List(Connection cn, String sql, String[] cloums, String[] keys) {
        ArrayList list = new ArrayList();
        HashMap<String, Object> m = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                m = new HashMap<String, Object>();
                int n = keys.length;
                for (int i = 0; i < n; ++i) {
                    m.put(keys[i].toLowerCase(), rs.getObject(cloums[i]));
                }
                list.add(m);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String excuteQuery(Connection cn, String dimType, String sql, String type, String[] keys) {
        PreparedStatement stmt;
        ResultSet rs;
        StringBuffer sb;
        block11: {
            sb = new StringBuffer();
            rs = null;
            stmt = null;
            try {
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery(sql);
                if ("org".equals(dimType)) {
                    while (rs.next()) {
                        sb.append(type);
                        sb.append("\u0001");
                        sb.append(rs.getString(keys[1]));
                        sb.append("\u0001");
                        sb.append(rs.getString(keys[0]));
                        sb.append("\u0001");
                        sb.append(rs.getString(keys[2]));
                        sb.append("\u0001");
                    }
                    break block11;
                }
                if ("year".equals(dimType)) {
                    while (rs.next()) {
                        sb.append(type);
                        sb.append("\u0001");
                        sb.append(rs.getString(keys[0]) + "\u5e74");
                        sb.append("\u0001");
                        sb.append(rs.getString(keys[0]));
                        sb.append("\u0001");
                        sb.append("1");
                        sb.append("\u0001");
                    }
                    break block11;
                }
                if (!"period".equals(dimType)) break block11;
                while (rs.next()) {
                    int number = 0;
                    String name = null;
                    String isLeaf = null;
                    number = rs.getInt(keys[0]);
                    if (number < 100) {
                        name = "\u7b2c" + number + "\u671f";
                        isLeaf = "1";
                    } else {
                        name = "\u7b2c" + (number - 100) + "\u5b63\u5ea6";
                        isLeaf = "0";
                    }
                    sb.append(type);
                    sb.append("\u0001");
                    sb.append(name);
                    sb.append("\u0001");
                    sb.append(number);
                    sb.append("\u0001");
                    sb.append(isLeaf);
                    sb.append("\u0001");
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff01", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return sb.deleteCharAt(sb.lastIndexOf("\u0001")).toString();
    }

    public static String getAppModelId(Connection cn, String metricMonitorId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select K.FAMID from T_BI_KPI_MON M,T_BI_AM_KPI K where M.FID='");
        sb.append(metricMonitorId).append("'and M.FKPIID=K.FID");
        return KPIMonitorUtil.excuteQuery_11_String(cn, sb.toString());
    }

    public static void checkRowDatasPermissions(Map factDatas, String monitorType, List toShowList, Map m5, Map filterMap, Context ctx, AppModel appmodel) throws BIModelRemoteException, SQLException {
        int n = toShowList.size();
        for (int i = 0; i < n; ++i) {
            String kpimonitornumber = (String)((Map)toShowList.get(i)).get("kpimonitornumber");
            String kpimonitorname = (String)((Map)toShowList.get(i)).get("kpimonitorname");
            HashMap _currentFilterValues = new HashMap();
            if ("metric".equalsIgnoreCase(monitorType)) {
                _currentFilterValues.put("org", filterMap.get("defaultOrg"));
                _currentFilterValues.put("year", filterMap.get("defaultYear"));
                _currentFilterValues.put("period", filterMap.get("defaultPeriod"));
                _currentFilterValues.put("metric", kpimonitornumber);
            } else if ("org".equalsIgnoreCase(monitorType)) {
                _currentFilterValues.put("org", kpimonitornumber);
                _currentFilterValues.put("year", filterMap.get("defaultYear"));
                _currentFilterValues.put("period", filterMap.get("defaultPeriod"));
                _currentFilterValues.put("metric", filterMap.get("defaultMetric"));
            }
            Map.Entry entry2 = null;
            String value = null;
            for (Map.Entry entry2 : m5.entrySet()) {
                Map dataMap;
                value = (String)entry2.getValue();
                if (StringUtil.isEmpty(value) || (dataMap = (Map)factDatas.get(kpimonitornumber)) == null || !SecureUtil.cellIsForbidden((BigDecimal)dataMap.get(entry2.getKey()), ctx, appmodel, _currentFilterValues, value)) continue;
                dataMap.put("message", KPIMonitorMessage.formatMessage("\u65e0\u6570\u636e\u67e5\u770b\u6743\u9650!", new String[]{kpimonitorname}));
            }
        }
    }

    public static String getKPI(String key) {
        if (KEY_FACT.equalsIgnoreCase(key)) {
            return "\u5b9e\u9645\u503c";
        }
        if (KEY_DOWN_DANGER.equalsIgnoreCase(key)) {
            return "\u4e0b\u9650\u5371\u9669";
        }
        if (KEY_DOWN_ALERT.equalsIgnoreCase(key)) {
            return "\u4e0b\u9650\u4e0d\u826f";
        }
        if (KEY_UP_ALERT.equalsIgnoreCase(key)) {
            return "\u4e0a\u9650\u4e0d\u826f";
        }
        if (KEY_UP_DANGER.equalsIgnoreCase(key)) {
            return "\u4e0a\u9650\u5371\u9669";
        }
        return "";
    }

    public static void main(String[] args) {
        String pi = " -3.1415927";
        System.out.println(new DecimalFormat("0.000%").format(pi));
    }
}

