/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.common.mm.customdim.CustomDimUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.actions.AbstractMCAction;
import com.kingdee.bos.bi.model.ui.actions.DeleteAction;
import com.kingdee.bos.bi.model.ui.actions.EditAction;
import com.kingdee.bos.bi.model.ui.actions.ViewAction;
import com.kingdee.bos.bi.model.ui.content.AbstractCSTMLeafViewUI;
import com.kingdee.bos.bi.model.ui.content.AbstractContent;
import com.kingdee.bos.bi.model.ui.content.AbstractLeafViewUI;
import com.kingdee.bos.bi.model.ui.content.ContentTable;
import com.kingdee.bos.bi.model.ui.content.IBranchViewOperator;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.util.Util;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.console.ConsolePane;
import com.kingdee.bos.ctrl.common.ui.console.content.IBranchContent;
import com.kingdee.bos.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.ILeafContent;
import com.kingdee.bos.ctrl.common.ui.console.event.BranchListener;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public abstract class AbstractBranchViewUI
extends AbstractContent
implements IBranchViewOperator,
IBranchContent {
    private ContentTable bcTable;
    private DefaultKingdeeTreeNode branchNode;
    ConsolePane consolePane = null;

    public AbstractBranchViewUI(String caption) {
        super(caption);
        this.addMenuItem(new EditAction());
        this.addMenuItem(new ViewAction());
        this.addMenuItem(new DeleteAction());
    }

    protected void addMenuItem(AbstractMCAction action) {
        action.setUI((IConsoleContent)this);
        this.getTable().getPopMenu().add((JMenuItem)new KDMenuItem((Action)((Object)action)));
    }

    @Override
    protected ContentTable getTable() {
        if (this.bcTable == null) {
            this.bcTable = new ContentTable();
            this.bcTable.addColumns(new String[]{"ID", "NAME", "NUMBER", "TYPE", "CREATOR", "LASTUPDATE", "DISCRIPTION"});
            this.bcTable.setHeadText("ID", "ID");
            this.bcTable.setHeadText("NAME", "\u7ef4\u5ea6\u540d\u79f0");
            this.bcTable.setHeadText("NUMBER", "\u7ef4\u5ea6\u7f16\u7801");
            this.bcTable.setHeadText("TYPE", "\u7ef4\u5ea6\u7c7b\u578b");
            this.bcTable.setHeadText("CREATOR", "\u521b\u5efa\u4eba");
            this.bcTable.setHeadText("LASTUPDATE", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
            this.bcTable.setHeadText("DISCRIPTION", "\u8bf4\u660e");
            this.bcTable.setColumnWidth("ID", 0);
            this.bcTable.setColumnWidth("NAME", 200);
            this.bcTable.setColumnWidth("NUMBER", 100);
            this.bcTable.setColumnWidth("TYPE", 100);
            this.bcTable.setColumnWidth("CREATOR", 100);
            this.bcTable.setColumnWidth("LASTUPDATE", 170);
            this.bcTable.setColumnWidth("DISCRIPTION", 200);
            this.bcTable.getStyleAttributes().setLocked(true);
            this.sort(this.bcTable);
        }
        return this.bcTable;
    }

    @Override
    protected void updateTable(Map allAttrs) {
        ContentTable t = this.getTable();
        String[] ids = (String[])allAttrs.get("ID");
        int r = 0;
        for (int i = 0; i < ids.length; ++i) {
            HashMap attrs = Util.makeRowAtts((int)i, (HashMap)((HashMap)allAttrs));
            t.addRow(r);
            t.setRowUserObject(r, attrs);
            t.setCellValue(r, "ID", attrs.get("ID"));
            t.setCellValue(r, "NAME", attrs.get("NAME"));
            t.setCellValue(r, "NUMBER", attrs.get("NUMBER"));
            t.setCellValue(r, "TYPE", "time".equalsIgnoreCase((String)attrs.get("TYPE")) ? "\u65f6\u95f4" : "\u666e\u901a");
            t.setCellValue(r, "CREATOR", attrs.get("CREATOR"));
            t.setCellValue(r, "LASTUPDATE", attrs.get("LASTUPDATE"));
            t.setCellValue(r, "DISCRIPTION", attrs.get("DISCRIPTION"));
            ++r;
        }
    }

    protected boolean getPubFlag() {
        int r = this.getTable().getSelectionRow();
        if (r != -1) {
            return this.isPublish(r);
        }
        return false;
    }

    @Override
    protected void selChanged(Map rowAttrs) {
    }

    protected boolean checkDimIdExist(String viewId) throws BIModelRemoteException, SQLException {
        return CustomDimUtil.checkDimIdExist(this.getManFacade(), this.getViewType(), viewId);
    }

    @Override
    public void addNew(String type) {
    }

    @Override
    public void edit() {
        String title = "\u7f16\u8f91" + this.getCaption();
        int rowIdx = this.checkTableSingleSelection(title);
        if (rowIdx < 0) {
            return;
        }
        String viewId = this.getRowID(rowIdx);
        String viewType = this.getRowType(rowIdx);
        String viewName = this.getRowName(rowIdx);
        String viewNumber = this.getRowNumber(rowIdx);
        try {
            if (!this.checkDimIdExist(viewId)) {
                WindowUtil.msgboxWarning((Object)(viewName + "\r\n\u8be5\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002"), (String)title, (Component)this.getRootCtrl());
                return;
            }
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"", (Throwable)((Object)ex));
            return;
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            return;
        }
        this.doEdit(viewType, viewId, viewName, viewNumber);
    }

    @Override
    public void view() {
        int rowIdx = this.checkTableSingleSelection("\u67e5\u770b" + this.getCaption());
        if (rowIdx >= 0) {
            this.viewDetail(rowIdx);
        }
    }

    @Override
    public void delete() {
        List indexList = this.getSelectedRow();
        if (indexList == null || indexList.size() == 0) {
            return;
        }
        String title = "\u5220\u9664" + this.getCaption();
        StringBuffer viewNameSb = new StringBuffer();
        ArrayList<String> viewIdList = new ArrayList<String>();
        ArrayList<String> viewNumberList = new ArrayList<String>();
        ArrayList<String> viewTypeList = new ArrayList<String>();
        ArrayList<String> viewNameList = new ArrayList<String>();
        for (int i = 0; i < indexList.size(); ++i) {
            int rowIdx = Integer.parseInt((String)indexList.get(i));
            viewNameSb.append(this.getRowName(rowIdx)).append(",");
            viewNameList.add(this.getRowName(rowIdx));
            viewIdList.add(this.getRowID(rowIdx));
            viewTypeList.add(this.getRowType(rowIdx));
            viewNumberList.add(this.getRowNumber(rowIdx));
        }
        viewNameSb.deleteCharAt(viewNameSb.length() - 1);
        if (!WindowUtil.msgboxYesNo((Component)this.getRootCtrl(), (Object)("\u60a8\u771f\u7684\u8981\u5220\u9664\u3010" + viewNameSb.toString() + "\u3011\u5417\uff1f"), (String)title)) {
            return;
        }
        try {
            IManagementFacade facade = this.getManFacade();
            String viedId = null;
            int m = viewIdList.size();
            for (int k = 0; k < m; ++k) {
                viedId = (String)viewIdList.get(k);
                if (CustomDimUtil.checkHasUsedView(facade, viedId)) {
                    WindowUtil.msgboxInfo((Object)("\u7ef4\u5ea6\u3010" + viewNameList.get(k) + "\u3011\u4e0b\u5b58\u5728\u5df2\u7ecf\u53d1\u5e03\u7684\u89c6\u56fe\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01"), (String)title, (Component)this.getRootCtrl());
                    continue;
                }
                this.removeUINode(viedId);
                CustomDimUtil.deleteViewList(facade, viedId);
                facade.delView(this.getViewType(), viedId);
                facade.dropCustomDimensionTable((String)viewTypeList.get(k), (String)viewNumberList.get(k));
            }
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            WindowUtil.msgboxError((Object)("\u5220\u9664\u7ef4\u5ea6\u3010" + viewNameSb.toString() + "\u3011\u7684\u8868\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage()), (String)title, (Component)this.getRootCtrl());
        }
        catch (BIModelRemoteException e) {
            log.error((Object)"", (Throwable)((Object)e));
            WindowUtil.msgboxError((Object)("\u5220\u9664\u7ef4\u5ea6\u3010" + viewNameSb.toString() + "\u3011\u7684\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage()), (String)title, (Component)this.getRootCtrl());
            return;
        }
        this.refresh();
    }

    protected void removeUINode(String dimId) {
        DefaultKingdeeTreeNode node = null;
        AbstractCSTMLeafViewUI ui = null;
        int n = this.branchNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            node = (DefaultKingdeeTreeNode)this.branchNode.getChildAt(i);
            ui = (AbstractCSTMLeafViewUI)node.getUserObject();
            if (!dimId.equals(ui.getDimId())) continue;
            this.consolePane.removeNode(node);
            break;
        }
    }

    private List getSelectedRow() {
        ContentTable t = this.getTable();
        ArrayList selectBlocks = t.getSelectManager().getBlocks();
        KDTSelectBlock selectBlock = null;
        ArrayList<String> lst = null;
        int sum = 0;
        for (int i = 0; i < selectBlocks.size(); ++i) {
            if (lst == null) {
                lst = new ArrayList<String>();
            }
            selectBlock = (KDTSelectBlock)selectBlocks.get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                if (!this.isPublish(j)) {
                    lst.add(j + "");
                }
                ++sum;
            }
        }
        String title = "\u5220\u9664" + this.getCaption();
        if (sum == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u5728\u5217\u8868\u4e2d\u9009\u4e2d\u64cd\u4f5c\u7684\u76ee\u6807\u884c\u3002", (String)title, (Component)this.getRootCtrl());
        } else if (sum > 0 && lst.size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u5df2\u53d1\u5e03\u7684\u6761\u76ee\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)title, (Component)this.getRootCtrl());
            return null;
        }
        return lst;
    }

    protected Map getAddNewParam() {
        return null;
    }

    protected abstract void doEdit(String var1, String var2, String var3, String var4);

    protected abstract boolean innerEdit(String var1, String var2, String var3, String var4, boolean var5, Object var6);

    protected String createTitle(String operate, String viewName) {
        return operate + this.getCaption() + "  " + viewName;
    }

    public void addBranchListener(BranchListener l) {
    }

    public void removeBranchListener(BranchListener l) {
    }

    public void setBranchNode(DefaultKingdeeTreeNode branchNode) {
        this.branchNode = branchNode;
    }

    protected String getRowType(int r) {
        return (String)this.getRowAttrs(r).get("TYPE");
    }

    protected String getRowNumber(int r) {
        return (String)this.getRowAttrs(r).get("NUMBER");
    }

    public void setConsolePane(ConsolePane cp) {
        this.consolePane = cp;
    }

    public void addLeaf(AbstractLeafViewUI view, ImageIcon icon) {
        if (this.consolePane == null || this.branchNode == null) {
            return;
        }
        this.consolePane.addLeaf(this.branchNode, (ILeafContent)view, view.getCaption(), icon);
    }

    @Override
    public void addNew() {
    }

    @Override
    public void rename() {
    }

    @Override
    public void publish() {
    }

    protected abstract void addLeafContent(String var1, String var2, String var3, String var4);

    @Override
    public void importData() {
    }
}

