/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.client;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.cubemodel.RDCubeModelNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsSqlNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.BaseReport;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.IReportNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.XReport;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider.RDTableForCubeModelProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IRDReportActor;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IRDReportContentPanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.n.INormalReportAllProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.n.NormalReportAllProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.n.RDReportPanelN;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitlePanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitleScriptExecutor;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x.RDReportContentPanelX;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.bireport.client.AbstractBIWorkBenchReportTemplateUI;
import com.kingdee.eas.framework.bireport.client.publish.ReportPublishUIClassParam;
import com.kingdee.eas.framework.bireport.util.PaltformWorkBenchContextHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Map;
import org.apache.log4j.Logger;

public class BIWorkBenchReportTemplateUI
extends AbstractBIWorkBenchReportTemplateUI
implements IRDReportActor {
    private static final Logger logger = CoreUIObject.getLogger(BIWorkBenchReportTemplateUI.class);
    private IRDReportContentPanel cp;

    public void onLoad() throws Exception {
        super.onLoad();
        String params = (String)this.getUIContext().get("UIClassParam");
        ReportPublishUIClassParam p = new ReportPublishUIClassParam(params);
        if (p.isBIReportParam()) {
            this.launchBIReport(p.getReportId());
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)"\u83dc\u5355\u53c2\u6570\u4e0d\u6b63\u786e\uff01(Only for BI-REPORT)");
            SysUtil.abort();
        }
    }

    private void launchBIReport(String refId) throws Exception {
        PaltformWorkBenchContext ctx = PaltformWorkBenchContextHelper.createDefaultPaltformWorkBenchContext();
        IReportNode rptItem = (IReportNode)ctx.getPlatformFacade().getCatalogNodeById(refId);
        if (rptItem == null) {
            throw new Exception("\u62a5\u8868\u6240\u5f15\u7528\u7684\u5185\u5bb9'" + refId + "'\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        this.setUITitle(rptItem.getName());
        BaseReport xc = rptItem.getReportConfig();
        Frame parent = (Frame)this.getUIContext().get("Owner");
        FilterDialog fd = new FilterDialog(xc, ctx, parent);
        FilterItemCollection fc = fd.showQueryDialog();
        if (fc != null) {
            if (xc instanceof XReport) {
                RDCubeModelNode cmItem = (RDCubeModelNode)ctx.getPlatformFacade().getCatalogNodeById(xc.getDsId());
                RDTableForCubeModelProvider provider = new RDTableForCubeModelProvider((RDBaseNode)cmItem);
                CubeModel cm = cmItem.getCubeModelConfig().getCubeModel();
                if (cm != null) {
                    RDReportContentPanelX content = new RDReportContentPanelX((IRDReportActor)this);
                    this.cp = content;
                    content.setPaltformWorkBenchContext(ctx);
                    Component[] barcc = content.getToolBarComponentForEmbed();
                    for (int i = 0; i < barcc.length; ++i) {
                        this.toolBar.add(barcc[i]);
                    }
                    content.refreshContent(cm, provider, ((XReport)xc).getMdx(), fc, xc.getName(), fd);
                    this.executeTitleScript(xc, new RDRowSet(), content.getTitlePanel(), ctx, fc.toVarMap());
                    this.setLayout(new BorderLayout());
                    this.add((Component)content, "Center");
                }
            } else {
                RDReportPanelN content = new RDReportPanelN(xc.getName(), (IRDReportActor)this, ctx);
                this.cp = content;
                Component[] barcc = content.getToolBarComponentForEmbed();
                for (int i = 0; i < barcc.length; ++i) {
                    this.toolBar.add(barcc[i]);
                }
                RDdsSqlNode dsNode = (RDdsSqlNode)ctx.getPlatformFacade().getCatalogNodeById(xc.getDsId());
                NormalReportAllProvider p = new NormalReportAllProvider(dsNode, fc, ctx);
                p.requestData();
                this.executeTitleScript(xc, p.getRowSet(), content.getTitlePanel(), ctx, fc.toVarMap());
                content.refreshContent((INormalReportAllProvider)p, fd);
                this.setLayout(new BorderLayout());
                this.add((Component)content, "Center");
            }
        } else {
            SysUtil.abort();
        }
    }

    private void executeTitleScript(BaseReport n, RDRowSet rs, TitlePanel tp, PaltformWorkBenchContext ctx, Map varMap) throws Exception {
        String script = n.getUIScript();
        if (script != null && script.trim().length() > 0) {
            TitleScriptExecutor ts = new TitleScriptExecutor(ctx);
            tp.setPaltformWorkBenchContext(ctx);
            ts.putVar(varMap);
            ts.setRowSet(rs);
            ts.setTitlePanel(tp);
            ts.execute(script);
        }
    }

    protected KDTable getTableForPrintSetting() {
        return this.cp == null ? null : this.cp.getTable();
    }

    protected KDTable getTableForOA() {
        return this.getTableForPrintSetting();
    }

    protected KDTable getTableForCommon() {
        return this.getTableForPrintSetting();
    }

    public void exit() {
        super.disposeUIWindow();
    }

    protected void disposeUIWindow() {
        if (this.cp != null) {
            this.cp.exit();
        }
        super.disposeUIWindow();
    }

    public void showQueryDialog() throws Exception {
        if (this.cp != null) {
            this.cp.showQueryDialog();
        }
    }

    public void refresh() throws Exception {
        if (this.cp != null) {
            this.cp.refresh();
        }
    }
}

