/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.client;

import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.BIModelManageConsole;
import com.kingdee.bos.bi.model.ui.context.BIModelConsoleContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.IDesktopCallBack;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.RDWorkBenchFrame;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.ETLManageConsole;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.context.ETLConsoleContext;
import com.kingdee.bos.ctrl.etl.server.facade.ETLServerFacade;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.bireport.EASUIBIBenchContext;
import com.kingdee.eas.framework.bireport.IETLServerFacade;
import com.kingdee.eas.framework.bireport.client.AbstractBIWorkBenchUI;
import com.kingdee.eas.framework.bireport.client.BIWorkBenchRemoteObjectFactory;
import com.kingdee.eas.framework.bireport.util.PaltformWorkBenchContextHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;

public class BIWorkBenchUI
extends AbstractBIWorkBenchUI
implements EASUIBIBenchContext {
    private static final Logger logger = CoreUIObject.getLogger(BIWorkBenchUI.class);
    private static RDWorkBenchFrame benchFrame = null;
    private static ETLManageConsole eltConsole = null;
    private static BIModelManageConsole bimodelConsole = null;
    private MySwitchOrgListener mySwitchOrgListener = null;
    private static final String TITLE_BIMODEL = "\u4f01\u4e1a\u6307\u6807\u5efa\u6a21\u63a7\u5236\u53f0";
    private BIWorkBenchUI workBenchUI;
    private IMetaDataPK metaPK;

    public void onLoad() throws Exception {
        this.workBenchUI = this;
        String params = (String)this.getUIContext().get("UIClassParam");
        if ("bimodel".equalsIgnoreCase(params)) {
            this.metaPK = MetaDataPK.create((String)"com.kingdee.bos.bi.model.ui", (String)"BIModelManageConsole");
        } else if (benchFrame == null && eltConsole == null) {
            this.metaPK = MetaDataPK.create((String)"com.kingdee.eas.framework.bireport.client", (String)"BIWorkBenchUI");
        }
        super.onLoad();
        MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (bimodelConsole != null) {
                    bimodelConsole.exit();
                }
            }
        });
        MainFrameCallBack.addPropertyChangeListener((String)"HRSwitchOrg", (PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        if ("bimodel".equalsIgnoreCase(params)) {
            if (bimodelConsole == null) {
                this.showBiModelConsole();
            } else {
                MsgBox.showWarning((String)"\u4f01\u4e1a\u6307\u6807\u5efa\u6a21\u63a7\u5236\u53f0\u5df2\u6253\u5f00\u3002");
                bimodelConsole.getOwnerWindow().requestFocus();
            }
        } else if (benchFrame == null && eltConsole == null) {
            this.addOrgChangeListener();
            this.showDesign();
        } else {
            MsgBox.showWarning((String)(this.getUITitle() + "\u5df2\u6253\u5f00\u3002"));
            if (benchFrame != null) {
                benchFrame.requestFocus();
            } else if (eltConsole != null) {
                eltConsole.getOwnerWindow().requestFocus();
            }
        }
        this.getUIContext().put("checkLicense", "false");
        SysUtil.abort();
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return this.metaPK;
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    @Override
    protected void btnRptDesign_actionPerformed(ActionEvent e) throws Exception {
        this.showDesign();
    }

    @Override
    protected void btnETLConsole_actionPerformed(ActionEvent e) throws Exception {
        this.showETLConsole();
    }

    private void showETLConsole() throws Exception {
        try {
            IETLServerFacade etlServerFacade = (IETLServerFacade)BIWorkBenchRemoteObjectFactory.createRemoteInstance(IETLServerFacade.class);
            etlServerFacade.setDatacenter(SysContext.getSysContext().getDcName());
            if (!etlServerFacade.serverIsRun()) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u672a\u627e\u5230ETL Server\uff0c\u65e0\u6cd5\u542f\u52a8\u7ba1\u7406\u63a7\u5236\u53f0\uff01");
                return;
            }
            this.btnETLConsole.setEnabled(false);
            eltConsole = new ETLManageConsole();
            eltConsole.setContext(new ETLConsoleContext());
            eltConsole.getContext().setETLServerFacade((ETLServerFacade)etlServerFacade);
            eltConsole.showConsole();
            eltConsole.getOwnerWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    BIWorkBenchUI.this.doExit();
                }
            });
        }
        catch (Exception e) {
            eltConsole = null;
            this.btnETLConsole.setEnabled(true);
            throw e;
        }
    }

    private void showBiModelConsole() throws Exception {
        try {
            IManagementFacade bimodelServerFacade = (IManagementFacade)BIWorkBenchRemoteObjectFactory.createRemoteInstance(IManagementFacade.class);
            bimodelConsole = new BIModelManageConsole();
            bimodelConsole.setContext(new BIModelConsoleContext());
            bimodelConsole.getContext().setManFacade(bimodelServerFacade);
            bimodelConsole.showConsole();
            bimodelConsole.addDesktopCallBackListener(new MyDesktopCallBack());
            bimodelConsole.getOwnerWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    bimodelConsole = null;
                }
            });
        }
        catch (Exception e) {
            bimodelConsole = null;
            logger.error((Object)TITLE_BIMODEL, (Throwable)e);
            throw e;
        }
    }

    private void doExit() {
        this.btnETLConsole.setEnabled(true);
        eltConsole = null;
    }

    private void showDesign() throws Exception {
        try {
            this.btnRptDesign.setEnabled(false);
            benchFrame = new RDWorkBenchFrame(PaltformWorkBenchContextHelper.createDefaultPaltformWorkBenchContext());
            benchFrame.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    benchFrame = null;
                    BIWorkBenchUI.this.btnRptDesign.setEnabled(true);
                }
            });
            benchFrame.addDesktopCallBackListener((IDesktopCallBack)new MyDesktopCallBack());
            benchFrame.onLoad();
            benchFrame.setVisible(true);
        }
        catch (Exception e) {
            benchFrame = null;
            this.btnRptDesign.setEnabled(true);
            logger.error((Object)"\u62a5\u8868\u8bbe\u8ba1\u5e73\u53f0", (Throwable)e);
            throw e;
        }
    }

    private void addOrgChangeListener() {
        if (this.mySwitchOrgListener == null) {
            this.mySwitchOrgListener = new MySwitchOrgListener();
            MainFrameCallBack.addPropertyChangeListener((String)"HRSwitchOrg", (PropertyChangeListener)this.mySwitchOrgListener);
            MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)this.mySwitchOrgListener);
        }
    }

    private void removeOrgChangeListener() {
        if (this.mySwitchOrgListener != null) {
            MainFrameCallBack.removePropertyChangeListener((String)"HRSwitchOrg", (PropertyChangeListener)this.mySwitchOrgListener);
            MainFrameCallBack.removePropertyChangeListener((String)"ReLogin", (PropertyChangeListener)this.mySwitchOrgListener);
        }
    }

    class MySwitchOrgListener
    implements PropertyChangeListener {
        MySwitchOrgListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("HRSwitchOrg") || evt.getPropertyName().equals("ReLogin")) {
                if (benchFrame != null) {
                    benchFrame.exit();
                }
                if (eltConsole != null) {
                    eltConsole.exit();
                }
                if (bimodelConsole != null) {
                    bimodelConsole.exit();
                }
            }
        }
    }

    class MyDesktopCallBack
    implements IDesktopCallBack {
        MyDesktopCallBack() {
        }

        public void beforeExit() {
            BIWorkBenchUI.this.removeOrgChangeListener();
            benchFrame = null;
            eltConsole = null;
            bimodelConsole = null;
            BIWorkBenchUI.this.getUIContext().put("checkLicense", "true");
            BIWorkBenchUI.this.workBenchUI.destroyWindow();
        }
    }
}

