/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.GetCurProjectFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.IGetCurProjectFacade;
import com.kingdee.eas.framework.bireport.bimanager.basedata.BIDataBaseFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.BIDataBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.basedata.client.AbstractBIBaseListUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BIBaseListUI
extends AbstractBIBaseListUI {
    private static final Logger logger = CoreUIObject.getLogger(BIBaseListUI.class);
    BIProjectSchemeInfo BIProjectSchemeInfo;

    public BIBaseListUI() throws Exception {
        IGetCurProjectFacade iGetCurProjectFacade = GetCurProjectFacadeFactory.getRemoteInstance();
        this.BIProjectSchemeInfo = iGetCurProjectFacade.getBIProjectSchemeByUserID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
    }

    protected BIDataBaseInfo getSelectBIBaseInfo() throws Exception {
        ICoreBase bi;
        this.checkSelected();
        IRow row = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        String id = null;
        if (null != row && (id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        if (null != (bi = this.getBizInterface())) {
            return (BIDataBaseInfo)bi.getValue((IObjectPK)new ObjectUuidPK(id));
        }
        return null;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRow row = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        Boolean isUsed = false;
        if (row.getCell("isUsed") == null) {
            super.actionRemove_actionPerformed(e);
        } else {
            isUsed = (Boolean)row.getCell("isUsed").getValue();
            if (isUsed.booleanValue()) {
                MsgBox.showInfo((String)Constant.isUsedCanNotRemove);
                SysUtil.abort();
            } else {
                super.actionRemove_actionPerformed(e);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IRow row = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        Boolean isUsed = false;
        if (row.getCell("isUsed") == null) {
            super.actionEdit_actionPerformed(e);
        } else {
            isUsed = (Boolean)row.getCell("isUsed").getValue();
            if (isUsed.booleanValue()) {
                MsgBox.showInfo((String)Constant.isUsedCanNotModify);
                SysUtil.abort();
            } else {
                super.actionEdit_actionPerformed(e);
            }
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            String[] selectIDs = this.getSelectIDs();
            BIDataBaseFactory.getRemoteInstance().setEnable(selectIDs, false, this.getBizType().toString());
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            String[] selectIDs = this.getSelectIDs();
            BIDataBaseFactory.getRemoteInstance().setEnable(selectIDs, true, this.getBizType().toString());
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.refresh(e);
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        IRow row = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            return;
        }
        BIDataBaseInfo info = this.getSelectBIBaseInfo();
        if (info.isIsUsed()) {
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
        } else {
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        FilterInfo fi = new FilterInfo();
        String BIProjectSchemeString = null;
        try {
            BIProjectSchemeString = this.BIProjectSchemeInfo.getId().toString();
        }
        catch (NullPointerException e) {
            MsgBox.showWarning((String)Constant.HasNotProjectScheme);
            SysUtil.abort();
        }
        fi.getFilterItems().add(new FilterItemInfo("BIProjectScheme.id", (Object)BIProjectSchemeString));
        this.mainQuery.setFilter(fi);
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData};
        BiManagerUtil.setActionsEnabledStatus(itemActions, false);
        itemActions = new ItemAction[]{this.actionAddNew, this.actionView, this.actionEdit, this.actionRemove, this.actionRefresh, this.actionQuery, this.actionLocate};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)0);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private String[] getSelectIDs() {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectedRows == null || selectedRows.length == 0) {
            return null;
        }
        String[] ids = new String[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            ids[i] = this.tblMain.getRow(selectedRows[i]).getCell("id").getValue().toString();
        }
        return ids;
    }

    protected String getEditUIName() {
        return null;
    }
}

