/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.BiManagerException;
import com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.client.AbstractBaseDataPlaneViewUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.log4j.Logger;

public class BaseDataPlaneViewUI
extends AbstractBaseDataPlaneViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataPlaneViewUI.class);
    private String searchDataSql;
    private String baseDataTableName;
    private BaseDataAcquisitionTempletInfo baseDataTempletInfo;
    private MasterDataModelEntryCollection col;
    private String baseDataId;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initTable();
        this.showInfo();
    }

    private void init() throws BOSException, EASBizException {
        this.tblMain.setEditable(false);
        String company = this.getUIContext().get("company.name").toString();
        String baseDataTempletName = this.getUIContext().get("baseDataTemplet.name").toString();
        this.baseDataId = this.getUIContext().get(Constant.ID).toString();
        this.txtCompany.setText(company);
        this.txtTemplet.setText(baseDataTempletName);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("masterData.name");
        selector.add("masterData.MasterDataModel.name");
        selector.add("masterData.baseDataTableName");
        selector.add("masterData.MasterDataModel.*");
        selector.add("masterData.MasterDataModel.Entry.*");
        this.baseDataTempletInfo = BaseDataAcquisitionTempletFactory.getRemoteInstance().getBaseDataAcquisitionTempletInfo((IObjectPK)new ObjectUuidPK(this.getUIContext().get("baseDataTemplet.id").toString()), selector);
        Boolean isRemark = (Boolean)this.getUIContext().get("isRemark");
        if (isRemark != null && isRemark.booleanValue()) {
            this.baseDataTableName = (String)this.getUIContext().get("tableName");
        } else {
            ITableIndex iTableIndex = TableIndexFactory.getRemoteInstance();
            String masterDataId = this.baseDataTempletInfo.getMasterData().getId().toString();
            this.baseDataTableName = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.BaseDataTable);
        }
        this.txtMasterDataModel.setText(this.baseDataTempletInfo.getMasterData().getMasterDataModel().getName());
    }

    private void initTable() throws Exception {
        for (int i = this.tblMain.getColumnCount(); i > 0; --i) {
            this.tblMain.removeColumn(i);
        }
        IRow headRow = this.tblMain.addHeadRow();
        this.col = this.baseDataTempletInfo.getMasterData().getMasterDataModel().getEntry();
        if (this.col == null || this.col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        MasterDataModelEntryInfo entry = null;
        IColumn column = null;
        String fieldName = null;
        int size = this.col.size();
        for (int i = 0; i < size; ++i) {
            entry = this.col.get(i);
            fieldName = entry.getId().toString();
            column = this.tblMain.addColumn();
            column.setKey(fieldName);
            headRow.getCell(fieldName).setValue((Object)entry.getAlias());
            if (!entry.getAlias().equals("ID")) continue;
            column.getStyleAttributes().setHided(true);
        }
    }

    private String getSearchDataSql() throws Exception {
        StringBuffer sb = new StringBuffer("select ");
        if (this.col == null || this.col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        MasterDataModelEntryInfo entry = null;
        String fieldName = null;
        int size = this.col.size();
        for (int i = 0; i < size; ++i) {
            entry = this.col.get(i);
            fieldName = entry.getAttribute();
            sb.append("F").append(fieldName).append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        sb.append(" from ").append(this.baseDataTableName).append(" where F").append(Constant.BaseDataID).append(" = '").append(this.baseDataId).append("' order by F").append(Constant.Number);
        return sb.toString();
    }

    private void showInfo() throws Exception {
        if (this.searchDataSql == null) {
            this.searchDataSql = this.getSearchDataSql();
        }
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)this.searchDataSql).executeSQL();
        for (int i = this.tblMain.getRowCount(); i >= 0; --i) {
            this.tblMain.removeRow(i);
        }
        IRow row = null;
        Object value = null;
        String fieldName = null;
        FieldTypeEnum fieldType = null;
        MasterDataModelEntryInfo entry = null;
        String attribute = null;
        String columnName = null;
        while (rs.next()) {
            row = this.tblMain.addRow();
            int size = this.tblMain.getColumnCount();
            for (int i = 0; i < size; ++i) {
                columnName = this.tblMain.getColumnKey(i);
                entry = this.col.get(i);
                attribute = entry.getAttribute();
                fieldName = "F" + attribute;
                fieldType = entry.getFieldType();
                if (FieldTypeEnum.Integer.equals((Object)fieldType)) {
                    value = new Integer(rs.getInt(fieldName));
                } else if (FieldTypeEnum.Decimal.equals((Object)fieldType)) {
                    value = rs.getBigDecimal(fieldName);
                } else if (FieldTypeEnum.Date.equals((Object)fieldType)) {
                    value = rs.getDate(fieldName);
                } else if (FieldTypeEnum.DateTime.equals((Object)fieldType)) {
                    value = rs.getTimestamp(fieldName);
                } else if (FieldTypeEnum.Text.equals((Object)fieldType)) {
                    value = rs.getString(fieldName);
                }
                row.getCell(columnName).setValue(value);
            }
        }
    }
}

