/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.bireport.bimanager.da.AutoAuditStateCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.AutoAuditStateFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.AutoAuditStateInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletTreeFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.client.AbstractFactDataAuditListUI;
import com.kingdee.eas.framework.bireport.bimanager.da.client.FactDataTempletTreeEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FactDataAuditListUI
extends AbstractFactDataAuditListUI {
    private static final Logger logger = CoreUIObject.getLogger(FactDataAuditListUI.class);
    private CompanyOrgUnitInfo company;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FactDataFactory.getRemoteInstance();
    }

    @Override
    protected ITreeBase getTreeInterface() throws Exception {
        return FactDataTempletTreeFactory.getRemoteInstance();
    }

    @Override
    protected String getGroupEditUIName() {
        return FactDataTempletTreeEditUI.class.getName();
    }

    @Override
    protected String getQueryFieldName() {
        return "factDataTempletTreeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return Constant.FactDataTempletType;
    }

    @Override
    protected IObjectValue createNewData() {
        FactDataInfo objectValue = new FactDataInfo();
        return objectValue;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData, this.actionGroupAddNew, this.actionGroupEdit, this.actionGroupMoveTree, this.actionGroupRemove, this.actionGroupView};
        BiManagerUtil.setActionsEnabledStatus(itemActions, false);
        itemActions = new ItemAction[]{this.actionAudit, this.actionUnAudit, this.actionAutoAudit, this.actionUnAutoAudit, this.actionRefresh, this.actionQuery, this.actionLocate};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        this.plTitle.setPreferredSize(new Dimension(10, 30));
        this.prmtCompany.setSelector((KDPromptSelector)new CompanyF7());
        this.btnAutoAudit.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnUnAutoAudit.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.setButtonDefaultStyl(this.btnAutoAudit);
        this.setButtonDefaultStyl(this.btnUnAutoAudit);
        this.treeView.setShowControlPanel(false);
        AutoAuditStateCollection autoAuditStateCollection = AutoAuditStateFactory.getRemoteInstance().getAutoAuditStateCollection();
        AutoAuditStateInfo autoAuditStateInfo = null;
        if (autoAuditStateCollection != null && autoAuditStateCollection.size() > 0) {
            autoAuditStateInfo = autoAuditStateCollection.get(0);
            boolean isAuto = autoAuditStateInfo.isIsAuto();
            if (isAuto) {
                this.btnAutoAudit.setEnabled(false);
                this.btnUnAutoAudit.setEnabled(true);
            } else {
                this.btnAutoAudit.setEnabled(true);
                this.btnUnAutoAudit.setEnabled(false);
            }
        } else {
            this.btnAutoAudit.setEnabled(true);
            this.btnUnAutoAudit.setEnabled(false);
        }
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row != null) {
            Boolean isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue();
            if (isInWarehouse != null && isInWarehouse.booleanValue()) {
                this.btnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(true);
            } else {
                this.btnAudit.setEnabled(true);
                this.btnUnAudit.setEnabled(false);
            }
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.buildTreeFilter();
        FilterInfo filter = this.mainQuery.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
        }
        filter = (FilterInfo)filter.clone();
        this.mainQuery.setFilter(filter);
        this.company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (this.company != null) {
            String companyLongNumber = this.company.getLongNumber();
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)companyLongNumber));
            newFilter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)(companyLongNumber + "!%"), CompareType.LIKE));
            newFilter.setMaskString("#0 or #1");
            try {
                filter.mergeFilter(newFilter, "AND");
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
        this.execQuery();
    }

    @Override
    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        if (filter == null) {
            filter = new FilterInfo();
        }
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3)));
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        if (this.company != null) {
            String companyLongNumber = this.company.getLongNumber();
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)companyLongNumber));
            newFilter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)(companyLongNumber + "!%"), CompareType.LIKE));
            newFilter.setMaskString("#0 or #1");
            try {
                filter.mergeFilter(newFilter, "AND");
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return filter;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isInWarehouse;
        String id;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        if ((isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue()) != null && isInWarehouse.booleanValue()) {
            MsgBox.showInfo((String)Constant.ReportIsInWarehouse);
            return;
        }
        FactDataFactory.getRemoteInstance().audit(id);
        MsgBox.showInfo((String)Constant.InWarehouseSuccess);
        this.refresh(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isInWarehouse;
        String id;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        if ((isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue()) == null || !isInWarehouse.booleanValue()) {
            MsgBox.showInfo((String)Constant.ReportIsNotInWarehouse);
            return;
        }
        FactDataFactory.getRemoteInstance().unAudit(id);
        MsgBox.showInfo((String)Constant.UnInWarehouseSuccess);
        this.refresh(e);
    }

    @Override
    public void actionAutoAudit_actionPerformed(ActionEvent e) throws Exception {
        FactDataFactory.getRemoteInstance().autoAudit(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        this.refresh(e);
        MsgBox.showInfo((String)Constant.UsedAutoAudit);
        this.btnAutoAudit.setEnabled(false);
        this.btnUnAutoAudit.setEnabled(true);
    }

    @Override
    public void actionUnAutoAudit_actionPerformed(ActionEvent e) throws Exception {
        FactDataFactory.getRemoteInstance().unAutoAudit();
        MsgBox.showInfo((String)Constant.UnUsedAutoAudit);
        this.btnAutoAudit.setEnabled(true);
        this.btnUnAutoAudit.setEnabled(false);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            return;
        }
        Boolean isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue();
        if (isInWarehouse != null && isInWarehouse.booleanValue()) {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(true);
        } else {
            this.btnAudit.setEnabled(true);
            this.btnUnAudit.setEnabled(false);
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"factDataTemplet.name", "company.name", "periodDescrip"};
        return locateNames;
    }
}

