/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.OrgF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.GatherFrequencyEnum;
import com.kingdee.eas.framework.bireport.bimanager.ReportSourceEnum;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletTreeInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.client.AbstractFactDataTempletEditUI;
import com.kingdee.eas.framework.bireport.bimanager.da.client.FactDataModelListUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.client.F7ListUISelector;
import com.kingdee.eas.framework.client.ListUI;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FactDataTempletEditUI
extends AbstractFactDataTempletEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FactDataTempletEditUI.class);

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FactDataTempletFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.setGatherFrequency(GatherFrequencyEnum.Month);
            this.editData.setReportSource(ReportSourceEnum.HandCollected);
            this.editData.put("treeid", (FactDataTempletTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        FactDataTempletInfo objectValue = new FactDataTempletInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        this.prmtcompany.setEnabledMultiSelection(true);
        OrgF7 companyF7 = new OrgF7();
        companyF7.setOrgTypes(new OrgType[]{OrgType.Company});
        if (this.getOprtState().equals(OprtState.EDIT)) {
            companyF7.setMultiSelect(false);
        } else {
            companyF7.setMultiSelect(true);
        }
        this.prmtcompany.setSelector((KDPromptSelector)companyF7);
        this.prmtcompany.setEditable(false);
        this.prmtfactDataModel.setEditable(false);
        this.prmtfactDataModel.setQueryInfo("com.kingdee.eas.framework.bireport.bimanager.da.app.FactDataModelQuery");
        F7ListUISelector.setListToPrmtF7(this.prmtfactDataModel, (ListUI)new FactDataModelListUI());
        this.reportSource.setRequired(true);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object company = this.prmtcompany.getValue();
        if (company instanceof Object[]) {
            Object[] obj = (Object[])this.prmtcompany.getValue();
            if (obj.length > 1) {
                this.doBeforeSave(e);
                IObjectPK pk = null;
                int length = obj.length;
                for (int i = 0; i < length; ++i) {
                    FactDataTempletInfo info = (FactDataTempletInfo)this.editData.clone();
                    CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)obj[i];
                    info.setNumber(info.getNumber() + "_" + companyInfo.getNumber());
                    info.setName(info.getName() + "_" + companyInfo.getName());
                    info.setCompany(companyInfo);
                    pk = FactDataTempletFactory.getRemoteInstance().submit((CoreBaseInfo)info);
                }
                this.setMessageText(Constant.SaveSuccess);
                this.showMessage();
                this.doAfterSubmit(pk);
                return;
            }
            this.editData.setCompany((CompanyOrgUnitInfo)obj[0]);
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }
}

