/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.BillStatusEnum;
import com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.GatherFrequencyEnum;
import com.kingdee.eas.framework.bireport.bimanager.ReportSourceEnum;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryFactDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryFactDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.client.AbstractFactDataViewUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.ItemEntry;
import com.kingdee.eas.framework.bireport.bimanager.util.PeriodSetUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.UIHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.WeekHelper;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class FactDataViewUI
extends AbstractFactDataViewUI {
    private static final Logger logger = CoreUIObject.getLogger(FactDataViewUI.class);
    private UIContext uiCtx;
    private String tempTableQuerySql;
    private String odsTableQuerySql;
    private String dwTableQuerySql;
    private ArrayList totalFieldList;
    private GatherFrequencyEnum gatherFrequency;
    private String bIProjectSchemeId;
    private IRow footRow;

    public FactDataViewUI() throws Exception {
        this.setPreferredSize(new Dimension(900, 650));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void onLoad() throws Exception {
        this.uiCtx = new UIContext((Object)this);
        this.uiCtx.putAll(this.getUIContext());
        BizEnumValueDTO bizEnum = (BizEnumValueDTO)this.uiCtx.get((Object)"factDataTemplet.gatherFrequency");
        if (bizEnum != null) {
            this.gatherFrequency = GatherFrequencyEnum.getEnum(bizEnum.getInt());
            this.lblGatherFrequency.setText(Constant.GatherFrequency + ":" + this.gatherFrequency.getAlias());
        }
        this.tblMain.checkParsed();
        this.initWorkButton();
        this.initUI();
        this.initTable();
        this.bIProjectSchemeId = (String)this.uiCtx.get((Object)"BIProjectScheme.id");
        this.btnSearch_actionPerformed(null);
    }

    private void initUI() {
        int i;
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData};
        BiManagerUtil.setActionsEnabledStatus(itemActions, false);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        this.toolBar.setVisible(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.cbFromYear.setEditable(true);
        this.cbToYear.setEditable(true);
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        for (i = 0; i <= 10; ++i) {
            int showYear = year - i;
            this.cbFromYear.addItem((Object)new ItemEntry(new Integer(showYear), new Integer(showYear)));
            this.cbToYear.addItem((Object)new ItemEntry(new Integer(showYear), new Integer(showYear)));
        }
        this.cbFromYear.setSelectedIndex(-1);
        this.cbToYear.setSelectedIndex(-1);
        switch (this.gatherFrequency.getValue()) {
            case 1: {
                this.cbFromYear.setVisible(false);
                this.cbToYear.setVisible(false);
                this.cbFromPeriod.setVisible(false);
                this.cbToPeriod.setVisible(false);
                this.lblFromYear.setVisible(false);
                this.lblToYear.setVisible(false);
                break;
            }
            case 2: {
                this.dpFromDate.setVisible(false);
                this.dpToDate.setVisible(false);
                break;
            }
            case 3: {
                this.dpFromDate.setVisible(false);
                this.dpToDate.setVisible(false);
                for (i = 1; i <= 12; ++i) {
                    this.cbFromPeriod.addItem((Object)new ItemEntry(new Integer(i), i + Constant.Month));
                    this.cbToPeriod.addItem((Object)new ItemEntry(new Integer(i), i + Constant.Month));
                }
                this.cbFromPeriod.setSelectedIndex(-1);
                this.cbToPeriod.setSelectedIndex(-1);
                break;
            }
            case 4: {
                this.dpFromDate.setVisible(false);
                this.dpToDate.setVisible(false);
                for (i = 1; i <= 4; ++i) {
                    this.cbFromPeriod.addItem((Object)new ItemEntry(new Integer(i), i + Constant.Quarter));
                    this.cbToPeriod.addItem((Object)new ItemEntry(new Integer(i), i + Constant.Quarter));
                }
                this.cbFromPeriod.setSelectedIndex(-1);
                this.cbToPeriod.setSelectedIndex(-1);
                break;
            }
            case 5: {
                this.dpFromDate.setVisible(false);
                this.dpToDate.setVisible(false);
                this.cbFromPeriod.addItem((Object)new ItemEntry(new Integer(1), Constant.HalfYear1));
                this.cbFromPeriod.addItem((Object)new ItemEntry(new Integer(2), Constant.HalfYear2));
                this.cbToPeriod.addItem((Object)new ItemEntry(new Integer(1), Constant.HalfYear1));
                this.cbToPeriod.addItem((Object)new ItemEntry(new Integer(2), Constant.HalfYear2));
                this.cbFromPeriod.setSelectedIndex(-1);
                this.cbToPeriod.setSelectedIndex(-1);
                break;
            }
            case 6: {
                this.dpFromDate.setVisible(false);
                this.dpToDate.setVisible(false);
                this.cbFromPeriod.setVisible(false);
                this.cbToPeriod.setVisible(false);
                this.kDLabel3.setBounds(new Rectangle(527, 10, 33, 19));
                this.cbToYear.setBounds(new Rectangle(563, 10, 80, 19));
                this.lblToYear.setBounds(new Rectangle(645, 10, 15, 19));
                this.btnSearch.setBounds(new Rectangle(665, 10, 73, 21));
                break;
            }
        }
    }

    @Override
    protected void cbFromYear_itemStateChanged(ItemEvent e) throws Exception {
        super.cbFromYear_itemStateChanged(e);
        if (2 != this.gatherFrequency.getValue()) {
            SysUtil.abort();
        }
        this.cbFromPeriod.removeAllItems();
        Object str = this.cbFromYear.getSelectedItem();
        if (str == null || str.toString().length() <= 0) {
            SysUtil.abort();
        }
        int year = Integer.parseInt(str.toString());
        int week = WeekHelper.getMaxWeekNumOfYear(year);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 1; i <= week; ++i) {
            Date date = WeekHelper.getFirstDayOfWeek(year, i);
            String strStart = format.format(date);
            date = WeekHelper.getLastDayOfWeek(year, i);
            String strEnd = format.format(date);
            this.cbFromPeriod.addItem((Object)(strStart + "~" + strEnd + "(\u7b2c" + i + "\u5468)"));
        }
    }

    @Override
    protected void cbToYear_itemStateChanged(ItemEvent e) throws Exception {
        super.cbToYear_itemStateChanged(e);
        if (2 != this.gatherFrequency.getValue()) {
            SysUtil.abort();
        }
        this.cbToPeriod.removeAllItems();
        Object str = this.cbToYear.getSelectedItem();
        if (str == null || str.toString().length() <= 0) {
            SysUtil.abort();
        }
        int year = Integer.parseInt(str.toString());
        int week = WeekHelper.getMaxWeekNumOfYear(year);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 1; i <= week; ++i) {
            Date date = WeekHelper.getFirstDayOfWeek(year, i);
            String strStart = format.format(date);
            date = WeekHelper.getLastDayOfWeek(year, i);
            String strEnd = format.format(date);
            this.cbToPeriod.addItem((Object)(strStart + "~" + strEnd + "(\u7b2c" + i + "\u5468)"));
        }
    }

    private void initTable() throws Exception {
        String factDataEasTable;
        String factDataOdsTable;
        for (int i = this.tblMain.getColumnCount(); i >= 0; --i) {
            this.tblMain.removeColumn(i);
        }
        this.totalFieldList = new ArrayList();
        IRow headRow = this.tblMain.getHeadRow(0);
        String factDataTempletId = (String)this.uiCtx.get((Object)"factDataTemplet.id");
        FactDataTempletInfo factDataTempletInfo = FactDataTempletFactory.getRemoteInstance().getFactDataTempletInfo((IObjectPK)new ObjectUuidPK(factDataTempletId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("EntryFactData.*");
        selector.add("EntryMasterData.*");
        selector.add("EntryMasterData.MasterData.*");
        FactDataModelInfo dataModel = FactDataModelFactory.getRemoteInstance().getFactDataModelInfo((IObjectPK)new ObjectUuidPK(factDataTempletInfo.getFactDataModel().getId()), selector);
        FactDataModelEntryFactDataCollection col = dataModel.getEntryFactData();
        if (col == null || col.size() <= 0) {
            MsgBox.showInfo((String)Constant.ModelNotCompleted);
            SysUtil.abort();
        }
        String factDataId = dataModel.getId().toString();
        ITableIndex iTableIndex = TableIndexFactory.getRemoteInstance();
        String factDataDwTable = iTableIndex.getTableNameById(factDataId, TableTypeEnum.FactDataDwTable);
        if (factDataDwTable == null) {
            MsgBox.showInfo((String)Constant.FactDataDwTableNotExist);
            SysUtil.abort();
        }
        if ((factDataOdsTable = iTableIndex.getTableNameById(factDataId, TableTypeEnum.FactDataOdsTable)) == null) {
            MsgBox.showInfo((String)Constant.FactDataOdsTableNotExist);
            SysUtil.abort();
        }
        if ((factDataEasTable = iTableIndex.getTableNameById(factDataId, TableTypeEnum.FactDataEasTable)) == null) {
            MsgBox.showInfo((String)Constant.FactDataEasTableNotExist);
            SysUtil.abort();
        }
        FactDataModelEntryFactDataInfo entry = null;
        IColumn column = null;
        String fieldName = null;
        FieldTypeEnum fieldType = null;
        column = this.tblMain.addColumn();
        column.setKey(Constant.ReportDate);
        headRow.getCell(Constant.ReportDate).setValue((Object)Constant.ReportDateName);
        column.getStyleAttributes().setNumberFormat("YYYY-mm-DD");
        StringBuffer fieldSb = new StringBuffer();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            fieldName = entry.getNumber();
            fieldSb.append("F").append(fieldName).append(",");
            column = this.tblMain.addColumn();
            column.setKey(fieldName);
            headRow.getCell(fieldName).setValue((Object)entry.getName());
            fieldType = entry.getFieldType();
            if (FieldTypeEnum.Decimal.equals((Object)fieldType) || FieldTypeEnum.Integer.equals((Object)fieldType)) {
                this.totalFieldList.add(fieldName);
            }
            if (!FieldTypeEnum.Date.equals((Object)fieldType)) continue;
            column.getStyleAttributes().setNumberFormat("YYYY-mm-DD");
        }
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            this.footRow = footRowManager.addFootRow(0);
            this.footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            this.footRow = footRowManager.getFootRow(0);
        }
        this.footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        FactDataModelEntryMasterDataCollection MasterDataCol = dataModel.getEntryMasterData();
        if (MasterDataCol != null && MasterDataCol.size() > 0) {
            FactDataModelEntryMasterDataInfo MasterDataEntry = null;
            MasterDataInfo masterDataInfo = null;
            int size2 = MasterDataCol.size();
            for (int i = 0; i < size2; ++i) {
                MasterDataEntry = MasterDataCol.get(i);
                masterDataInfo = MasterDataEntry.getMasterData();
                fieldName = masterDataInfo.getNumber();
                fieldSb.append("F").append(fieldName).append(",");
                column = this.tblMain.addColumn();
                column.setKey(fieldName);
                headRow.getCell(fieldName).setValue((Object)masterDataInfo.getName());
            }
        }
        fieldSb.append("F").append(Constant.ReportDate);
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(fieldSb).append(" from ").append(factDataEasTable);
        this.tempTableQuerySql = sql.toString();
        sql.setLength(0);
        sql.append("select ").append(fieldSb).append(" from ").append(factDataOdsTable);
        this.odsTableQuerySql = sql.toString();
        sql.setLength(0);
        sql.append("select ").append(fieldSb).append(" from ").append(factDataDwTable);
        this.dwTableQuerySql = sql.toString();
    }

    private void showInfo(List list) throws Exception {
        int i;
        for (i = this.tblMain.getRowCount(); i >= 0; --i) {
            this.tblMain.removeRow(i);
        }
        int size = this.totalFieldList.size();
        for (i = 0; i < size; ++i) {
            String filedName = (String)this.totalFieldList.get(i);
            this.footRow.getCell(filedName).setValue(null);
        }
        if (list == null || list.size() <= 0) {
            return;
        }
        IRow row = null;
        String fieldName = null;
        int size2 = list.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            HashMap objMap = (HashMap)list.get(i2);
            row = this.tblMain.addRow();
            int columns = this.tblMain.getColumnCount();
            for (int j = 0; j < columns; ++j) {
                fieldName = this.tblMain.getColumnKey(j);
                row.getCell(fieldName).setValue(objMap.get("F" + fieldName.toUpperCase()));
            }
        }
        UIHelper.calculateTotalRow((CoreUIObject)this, this.tblMain, this.footRow, this.totalFieldList);
    }

    private void showInfo(RptRowSet rs) throws Exception {
        for (int i = this.tblMain.getRowCount(); i >= 0; --i) {
            this.tblMain.removeRow(i);
        }
        IRow row = null;
        String fieldName = null;
        while (rs.next()) {
            row = this.tblMain.addRow();
            int size = this.tblMain.getColumnCount();
            for (int i = 0; i < size; ++i) {
                fieldName = this.tblMain.getColumnKey(i);
                row.getCell(fieldName).setValue((Object)rs.getString("F" + fieldName));
            }
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        int selectIndex;
        ReportSourceEnum reportSource;
        FilterInfo filter = new FilterInfo();
        Date fromDate = null;
        Date toDate = null;
        switch (this.gatherFrequency.getValue()) {
            case 1: {
                fromDate = (Date)this.dpFromDate.getValue();
                toDate = (Date)this.dpToDate.getValue();
                break;
            }
            case 2: {
                Object yearObj = null;
                int yearInt = 0;
                int week = 0;
                yearObj = this.cbFromYear.getSelectedItem();
                if (yearObj != null && yearObj.toString().trim().length() > 0) {
                    yearInt = Integer.parseInt(yearObj.toString());
                    week = this.cbFromPeriod.getSelectedIndex() + 1;
                    if (week > 0) {
                        fromDate = WeekHelper.getFirstDayOfWeek(yearInt, week);
                    }
                }
                if ((yearObj = this.cbToYear.getSelectedItem()) == null || yearObj.toString().trim().length() <= 0) break;
                yearInt = Integer.parseInt(yearObj.toString());
                week = this.cbToPeriod.getSelectedIndex() + 1;
                if (week <= 0) break;
                toDate = WeekHelper.getFirstDayOfWeek(yearInt, week);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Object fromYearObj = this.cbFromYear.getSelectedItem();
                Object fromPeriodObj = this.cbFromPeriod.getSelectedItem();
                if (fromYearObj != null || fromPeriodObj != null) {
                    if (fromYearObj == null) {
                        MsgBox.showInfo((String)Constant.ChooseBeginYear);
                        return;
                    }
                    if (fromPeriodObj == null) {
                        MsgBox.showInfo((String)Constant.ChooseBeginPeriod);
                        return;
                    }
                    int year = 0;
                    if (fromYearObj instanceof ItemEntry) {
                        year = (Integer)((ItemEntry)fromYearObj).getKey();
                    } else {
                        try {
                            year = Integer.valueOf(fromYearObj.toString());
                        }
                        catch (Exception e1) {
                            MsgBox.showInfo((String)Constant.BeginYearMustInteger);
                            return;
                        }
                    }
                    int period = 0;
                    if (fromPeriodObj instanceof ItemEntry) {
                        period = (Integer)((ItemEntry)fromPeriodObj).getKey();
                    } else {
                        try {
                            period = Integer.valueOf(fromPeriodObj.toString());
                        }
                        catch (Exception e1) {
                            MsgBox.showInfo((String)Constant.BeginPeriodMustInteger);
                            return;
                        }
                    }
                    fromDate = PeriodSetUtil.getDateFromPeriod(year, period, this.gatherFrequency);
                }
                Object toYearObj = this.cbToYear.getSelectedItem();
                Object toPeriodObj = this.cbToPeriod.getSelectedItem();
                if (toYearObj == null && toPeriodObj == null) break;
                if (toYearObj == null) {
                    MsgBox.showInfo((String)Constant.ChooseEndYear);
                    return;
                }
                if (toPeriodObj == null) {
                    MsgBox.showInfo((String)Constant.ChooseEndPeriod);
                    return;
                }
                int year = 0;
                if (toYearObj instanceof ItemEntry) {
                    year = (Integer)((ItemEntry)toYearObj).getKey();
                } else {
                    try {
                        year = Integer.valueOf(toYearObj.toString());
                    }
                    catch (Exception e1) {
                        MsgBox.showInfo((String)Constant.EndYearMustInteger);
                        return;
                    }
                }
                int period = 0;
                if (toPeriodObj instanceof ItemEntry) {
                    period = (Integer)((ItemEntry)toPeriodObj).getKey();
                } else {
                    try {
                        period = Integer.valueOf(toPeriodObj.toString());
                    }
                    catch (Exception e1) {
                        MsgBox.showInfo((String)Constant.EndPeriodMustInteger);
                        return;
                    }
                }
                toDate = PeriodSetUtil.getDateFromPeriod(year, period, this.gatherFrequency);
                break;
            }
            case 6: {
                Object toYear;
                Object fromYear = this.cbFromYear.getSelectedItem();
                if (fromYear != null) {
                    int year = 0;
                    if (fromYear instanceof ItemEntry) {
                        year = (Integer)((ItemEntry)fromYear).getKey();
                    } else {
                        try {
                            year = Integer.valueOf(fromYear.toString());
                        }
                        catch (Exception e1) {
                            MsgBox.showInfo((String)Constant.BeginYearMustInteger);
                            return;
                        }
                    }
                    fromDate = PeriodSetUtil.getDateFromPeriod(year, 0, this.gatherFrequency);
                }
                if ((toYear = this.cbToYear.getSelectedItem()) == null) break;
                int year = 0;
                if (toYear instanceof ItemEntry) {
                    year = (Integer)((ItemEntry)toYear).getKey();
                } else {
                    try {
                        year = Integer.valueOf(toYear.toString());
                    }
                    catch (Exception e1) {
                        MsgBox.showInfo((String)Constant.EndYearMustInteger);
                        return;
                    }
                }
                toDate = PeriodSetUtil.getDateFromPeriod(year, 0, this.gatherFrequency);
                break;
            }
        }
        if (fromDate != null) {
            if (toDate != null && toDate.getTime() < fromDate.getTime()) {
                MsgBox.showInfo((String)Constant.EndTimeNotLessBeginTime);
                return;
            }
            filter.getFilterItems().add(new FilterItemInfo("reportTime", (Object)fromDate, CompareType.GREATER_EQUALS));
        }
        if (toDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportTime", (Object)toDate, CompareType.LESS_EQUALS));
        }
        if ((reportSource = (ReportSourceEnum)((Object)this.cbReportSource.getSelectedItem())) != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportSource", (Object)reportSource));
        }
        if ((selectIndex = this.cbDataSource.getSelectedIndex()) == 1) {
            FilterInfo f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("isInWarehouse", (Object)new Boolean(false)));
            f.getFilterItems().add(new FilterItemInfo("isInWarehouse", null));
            f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3)));
            f.setMaskString("(#0 or #1) and #2");
            filter.mergeFilter(f, "AND");
        } else if (selectIndex == 2) {
            filter.getFilterItems().add(new FilterItemInfo("isInWarehouse", (Object)new Boolean(true)));
        } else {
            FilterInfo f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("isInWarehouse", (Object)new Boolean(true), CompareType.NOTEQUALS));
            f.getFilterItems().add(new FilterItemInfo("isInWarehouse", null));
            f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)BillStatusEnum.Audited, CompareType.NOTEQUALS));
            f.getFilterItems().add(new FilterItemInfo("billStatus", null));
            f.setMaskString("(#0 or #1) and (#2 or #3)");
            filter.mergeFilter(f, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        FactDataCollection factDataCollection = FactDataFactory.getRemoteInstance().getFactDataCollection(view);
        StringBuffer filterSql = new StringBuffer("");
        List list = null;
        if (factDataCollection != null && factDataCollection.size() > 0) {
            filterSql.append(" where F").append(Constant.FactDataID).append(" in (");
            int size = factDataCollection.size();
            for (int i = 0; i < size; ++i) {
                filterSql.append("'").append(factDataCollection.get(i).getId().toString()).append("',");
            }
            filterSql.replace(filterSql.length() - 1, filterSql.length(), "");
            filterSql.append(" )");
            list = selectIndex == 1 ? FactDataFactory.getRemoteInstance().queryFactDatas(this.odsTableQuerySql + filterSql.toString(), null, Constant.OdsFactData, this.bIProjectSchemeId) : (selectIndex == 2 ? FactDataFactory.getRemoteInstance().queryFactDatas(this.dwTableQuerySql + filterSql.toString(), null, Constant.DwFactData, this.bIProjectSchemeId) : FactDataFactory.getRemoteInstance().queryFactDatas(this.tempTableQuerySql + filterSql.toString(), null, Constant.TempFactData, this.bIProjectSchemeId));
        }
        this.showInfo(list);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void refresh(ActionEvent e) throws Exception {
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public List getFieldSumList() {
        return this.totalFieldList;
    }
}

