/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.dbpool.pool;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.eas.framework.bireport.bimanager.dbpool.IDBConnectionPool;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public abstract class AbstractDBConnectionPool
implements IDBConnectionPool {
    protected static final Logger log = Logger.getLogger(AbstractDBConnectionPool.class);
    private static final String KSQL_DRIVER = "com.kingdee.bos.sql.shell.Driver";
    private static final String POOLING_DRIVER = "org.apache.commons.dbcp.PoolingDriver";
    private static final String DBCP_URL = "jdbc:apache:commons:dbcp:";
    private ObjectPool connectionPool = null;
    protected String dbCenterId = null;
    protected DBCenterModel dbCenterModel = null;
    protected String ksqlUrl = null;
    protected String userName = null;
    protected String passWord = null;
    private int maxIdle = 8;
    private int minIdle = 0;
    private int maxActive = 8;
    private long maxWait = -1L;
    private byte whenExhausted = (byte)2;

    public AbstractDBConnectionPool(DBCenterModel dbCenterModel) {
        this.dbCenterId = dbCenterModel.getDbCenterId();
        this.dbCenterModel = dbCenterModel;
    }

    @Override
    public void prepare() {
        this.userName = this.dbCenterModel.getUserName();
        this.passWord = this.dbCenterModel.getPassWord();
        this.maxActive = this.dbCenterModel.getMaxActive();
        this.maxIdle = this.dbCenterModel.getMaxIdle();
        this.minIdle = this.dbCenterModel.getMinIdle();
        this.maxWait = this.dbCenterModel.getMaxWait();
        this.whenExhausted = this.dbCenterModel.getWhenExhausted();
    }

    @Override
    public synchronized void startPool() {
        if (this.connectionPool != null) {
            this.shutdownPool();
        }
        this.registerKSqlDriver();
        this.connectionPool = new GenericObjectPool(null, this.maxActive, this.whenExhausted, this.maxWait, this.maxIdle, true, false, -1L, 3, 1800000L, false);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.ksqlUrl, this.userName, this.passWord);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, this.connectionPool, null, null, false, true);
        this.registerPoolDriver();
        PoolingDriver driver = (PoolingDriver)this.getDriver();
        driver.registerPool(this.dbCenterId, this.connectionPool);
    }

    @Override
    public synchronized Connection getConnection() {
        if (StringUtils.isEmpty(this.dbCenterId)) {
            throw new RuntimeException("\u83b7\u53d6\u8fde\u63a5\u51fa\u9519\uff0c\u6570\u636e\u4e2d\u5fc3id\u4e3a\u7a7a!");
        }
        if (this.connectionPool == null) {
            this.startPool();
        }
        Connection con = null;
        try {
            con = DriverManager.getConnection(DBCP_URL + this.dbCenterId);
        }
        catch (SQLException e) {
            log.error((Object)("\u4ece\u8fde\u63a5\u6c60\u83b7\u53d6\u8fde\u63a5\u51fa\u9519\uff1a" + e.getMessage()));
            throw new RuntimeException("\u4ece\u8fde\u63a5\u6c60\u83b7\u53d6\u8fde\u63a5\u51fa\u9519\uff1a" + e.getMessage());
        }
        return con;
    }

    @Override
    public void printPoolStatus() {
        ObjectPool connectionPool = this.getConnectionPool();
        if (connectionPool == null) {
            return;
        }
        StringBuffer info = new StringBuffer();
        info.append("Current DBCenterInfo : dbCenterID is ").append(this.dbCenterId).append(", dbCenterName is ").append(this.dbCenterModel.getDbCenterName());
        info.append(", NumActive/NumBorrowed is ").append(connectionPool.getNumActive()).append(", NumIdle/NumSleeping is ").append(connectionPool.getNumIdle()).append(". \n");
        System.out.println(info.toString());
    }

    @Override
    public int getPoolNumActive() {
        ObjectPool connectionPool = this.getConnectionPool();
        return connectionPool == null ? 0 : connectionPool.getNumActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void shutdownPool() {
        PoolingDriver driver = (PoolingDriver)this.getDriver();
        if (driver == null) {
            return;
        }
        if (this.connectionPool != null && this.connectionPool.getNumActive() > 0) {
            AbstractDBConnectionPool.waitTime(10000L);
        }
        try {
            if (this.connectionPool != null) {
                this.connectionPool.clear();
            }
        }
        catch (UnsupportedOperationException e) {
            System.out.println("\u6e05\u7a7a\u5bf9\u8c61\u6c60\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("\u6e05\u7a7a\u5bf9\u8c61\u6c60\u51fa\u9519\uff1a" + e.getMessage());
        }
        finally {
            try {
                driver.closePool(this.dbCenterId);
            }
            catch (SQLException e) {
                throw new RuntimeException("\u5173\u95ed\u8fde\u63a5\u6c60\u51fa\u9519\uff1a" + e.getMessage());
            }
            finally {
                this.connectionPool = null;
            }
        }
        System.out.println("\u8fde\u63a5\u6c60\u5df2\u7ecf\u6210\u529f\u5173\u95ed,\u6570\u636e\u4e2d\u5fc3id=" + this.dbCenterId);
    }

    @Override
    public void updatePool(String dbCenterId, DBCenterModel model) {
        this.dbCenterId = dbCenterId;
        this.dbCenterModel = model;
        this.shutdownPool();
        this.prepare();
        this.startPool();
    }

    private void registerKSqlDriver() {
        this.registerDriver(KSQL_DRIVER);
    }

    private void registerPoolDriver() {
        this.registerDriver(POOLING_DRIVER);
    }

    private void registerDriver(String driveName) {
        try {
            Class.forName(driveName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("\u6ce8\u518cDriver\u51fa\u9519\uff0c\u627e\u4e0d\u5230\u7c7b\uff1a" + driveName + e.getMessage()));
            throw new RuntimeException("\u6ce8\u518cDriver\u51fa\u9519\uff0c\u627e\u4e0d\u5230\u7c7b\uff1a" + driveName + e.getMessage());
        }
    }

    private ObjectPool getConnectionPool() {
        return this.connectionPool;
    }

    private Driver getDriver() {
        Driver driver = null;
        try {
            driver = DriverManager.getDriver(DBCP_URL);
        }
        catch (SQLException e) {
            System.out.println("\u83b7\u53d6Driver\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u83b7\u53d6Driver\u51fa\u9519\uff1a" + e.getMessage());
        }
        return driver;
    }

    private static void waitTime(long milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            System.out.println("\u5173\u95ed\u8fde\u63a5\u6c60\u7ebf\u7a0b\u7b49\u5f85\u51fa\u9519\uff1a" + e.getMessage());
        }
    }
}

