/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlExecuteLogCollection;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlExecuteLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlExecuteLogInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlStrategyFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.AbstractEtlDispatchLogViewUI;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class EtlDispatchLogViewUI
extends AbstractEtlDispatchLogViewUI {
    private static final Logger logger = CoreUIObject.getLogger(EtlDispatchLogViewUI.class);
    String dispatchID = null;
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlClientResource";

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("dispatchID");
        if (obj != null) {
            this.dispatchID = obj.toString();
            this.initControl(this.dispatchID);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionView, this.actionEdit, this.actionPrint, this.actionPrintPreview, this.actionLocate, this.actionImportData, this.actionAttachment, this.actionExportData, this.actionToExcel, this.actionStartWorkFlow, this.actionPublishReport, this.actionCancel, this.actionCancelCancel, this.actionQueryScheme};
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setVisible(false);
        }
        this.btnRemove.setVisible(true);
    }

    public void initControl(String dispatchID) throws Exception {
        this.kDContainer1.setEnableActive(false);
        this.kDContainer2.setEnableActive(false);
        this.kDContainer3.setEnableActive(false);
        this.kDContainer4.setEnableActive(false);
        this.labNum.setEnabled(false);
        this.labName.setEnabled(false);
        this.labStatus.setEnabled(false);
        this.tblExecute.checkParsed();
        this.tblExecute.getSelectManager().setSelectMode(2);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblExecute.getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.txtLogContent.setEditable(false);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("isExecute");
        view.getSelector().add("status");
        view.getSelector().add("number");
        view.getSelector().add("entry.scheme.name");
        view.getSelector().add("entry.scheme.number");
        EtlDispatchManagerInfo disManInfo = EtlDispatchManagerFactory.getRemoteInstance().getEtlDispatchManagerInfo((IObjectPK)new ObjectStringPK(dispatchID), view.getSelector());
        if (disManInfo != null) {
            this.labNum.setText(disManInfo.getNumber());
            this.labName.setText(disManInfo.getName());
            this.labStatus.setText(disManInfo.getStatus().getAlias());
            EtlDispatchManagerEntryCollection entry = disManInfo.getEntry();
            LinkedList<EtlSchemeManagerInfo> list = new LinkedList<EtlSchemeManagerInfo>();
            for (int i = 0; i < entry.size(); ++i) {
                list.add(entry.get(i).getScheme());
            }
            this.kdSchemeList.setListData(list.toArray());
        }
    }

    public void initListener() {
        super.initListener();
        this.kdSchemeList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    Object obj = EtlDispatchLogViewUI.this.kdSchemeList.getSelectedValue();
                    String schemeID = null;
                    if (obj instanceof IObjectValue) {
                        schemeID = ((IObjectValue)obj).get("id").toString();
                        String dispatchLogID = "";
                        int rowIndex = KDTableUtil.getSelectedRow((KDTable)EtlDispatchLogViewUI.this.tblMain);
                        if (rowIndex >= 0) {
                            IRow row = EtlDispatchLogViewUI.this.tblMain.getRow(rowIndex);
                            dispatchLogID = row.getCell("id").getValue().toString();
                            try {
                                EtlDispatchLogViewUI.this.initTblExecute(schemeID, dispatchLogID);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                logger.error((Object)"error", (Throwable)e1);
                            }
                        }
                        try {
                            String strategy = EtlStrategyFacadeFactory.getRemoteInstance().getStrategy(schemeID, dispatchLogID);
                            EtlDispatchLogViewUI.this.txtLogContent.setText(strategy);
                        }
                        catch (EASBizException e1) {
                            e1.printStackTrace();
                        }
                        catch (BOSException e1) {
                            e1.printStackTrace();
                        }
                        EtlDispatchLogViewUI.this.kDContainer4.setTitle(EASResource.getString((String)EtlDispatchLogViewUI.resourceFileName, (String)"etlSchemeLog"));
                    }
                }
            }
        });
    }

    @Override
    protected void tblExecute_tableClicked(KDTMouseEvent e) throws Exception {
        this.txtLogContent.setText(null);
        int rowIndex = e.getRowIndex();
        IRow row = this.tblExecute.getRow(rowIndex);
        if (row != null && row.getCell("logContent").getValue() != null) {
            String logContent = row.getCell("logContent").getValue().toString();
            this.txtLogContent.setText(logContent);
            this.kDContainer4.setTitle(EASResource.getString((String)resourceFileName, (String)"etlExecuteLog"));
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.txtLogContent.setText(null);
        int rowIndex = e.getRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && row.getCell("logContent").getValue() != null) {
            String logContent = row.getCell("logContent").getValue().toString();
            this.txtLogContent.setText(StringUtils.str2str(logContent));
            this.kDContainer4.setTitle(EASResource.getString((String)resourceFileName, (String)"etlDispatchLog"));
        }
        if (row != null && row.getCell("id").getValue() != null) {
            String dispatchLogID = row.getCell("id").getValue().toString();
            Object obj = this.kdSchemeList.getSelectedValue();
            String schemeID = null;
            if (obj instanceof IObjectValue) {
                schemeID = ((IObjectValue)obj).get("id").toString();
                try {
                    this.initTblExecute(schemeID, dispatchLogID);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    logger.error((Object)"error", (Throwable)e1);
                }
            }
        }
    }

    public void initTblExecute(String schemeID, String dispatchLogID) throws BOSException {
        this.tblExecute.checkParsed();
        this.tblExecute.removeRows();
        EtlExecuteLogCollection executeLogcoll = EtlExecuteLogFactory.getRemoteInstance().getEtlExecuteLogCollection(" where etlSchemeID = '" + schemeID + "' and dispatchLogID = '" + dispatchLogID + "' order by startTime ");
        for (int i = 0; i < executeLogcoll.size(); ++i) {
            EtlExecuteLogInfo executeLog = executeLogcoll.get(i);
            IRow row = this.tblExecute.addRow();
            row.getCell("logTime").setValue((Object)executeLog.getStartTime());
            row.getCell("startTime").setValue((Object)executeLog.getStartTime());
            row.getCell("endTime").setValue((Object)executeLog.getEndTime());
            row.getCell("status").setValue((Object)executeLog.getStatus());
            row.getCell("company").setValue((Object)executeLog.getCompany());
            row.getCell("dataCenter").setValue((Object)executeLog.getDataCenter());
            row.getCell("id").setValue((Object)executeLog.getId());
            try {
                row.getCell("logContent").setValue((Object)new String(executeLog.getLogContent(), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Object obj = this.getUIContext().get("dispatchID");
        if (obj != null) {
            this.dispatchID = obj.toString();
        }
        if (this.dispatchID != null) {
            FilterInfo filter = super.getDefaultFilterForQuery();
            filter.getFilterItems().add(new FilterItemInfo("etlDispatchID", (Object)this.dispatchID));
            return filter;
        }
        return super.getDefaultFilterForQuery();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EtlDispatchLogFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }
}

