/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver;

import com.kingdee.eas.framework.bireport.bimanager.etl.LogForDebug;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver.KettleMessageListener;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver.MsgHandleDefaultImpl;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.client.ClearConnection;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.client.IMsgReceivedListener;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.transport.socket.AcceptListener;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.transport.socket.SocketServer;
import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class KettleServer {
    private static KettleServer self = new KettleServer();
    public Map listenerMap = new HashMap();
    public Map dbproxyMap = new HashMap();
    public SocketServer acceptor;
    public String clientID;
    public AtomicInteger clientCount = new AtomicInteger(0);
    private Map map = new Hashtable();

    public KettleServer() {
        this.clientID = UUID.randomUUID().toString();
    }

    public static boolean containsBillID(String billID) {
        return KettleServer.self.map.containsKey(billID);
    }

    public static KettleServer getInstance() {
        return self;
    }

    public static String getEasClientID() {
        return KettleServer.self.clientID;
    }

    public static int getPort() {
        return KettleServer.self.acceptor.getPort();
    }

    public void decrementConnection() {
        this.clientCount.decrementAndGet();
    }

    public void incrementConnection() {
        this.clientCount.incrementAndGet();
    }

    public int getClientCount() {
        return KettleServer.self.map.size();
    }

    public static void startServer() throws IOException {
        if (KettleServer.self.acceptor != null && KettleServer.self.acceptor.isRunning()) {
            return;
        }
        LogForDebug.info("\u5f00\u542f\u4e00\u4e2aserver \uff01");
        if (KettleServer.self.acceptor != null) {
            KettleServer.self.acceptor.stop();
        }
        KettleServer.self.acceptor = new SocketServer(new MsgHandleDefaultImpl(), new AcceptListener(){

            @Override
            public void accept(SocketChannel socketChannel) {
                self.incrementConnection();
                LogForDebug.info("\u65b0\u589e\u4e00\u4e2asocket\u5ba2\u6237\u7aef\u8fde\u63a5\uff01");
            }

            @Override
            public void close(SocketChannel socketChannal) {
                self.decrementConnection();
                LogForDebug.info("\u65ad\u5f00\u4e00\u4e2asocket\u5ba2\u6237\u7aef\u8fde\u63a5\uff01");
            }
        });
        new Thread(KettleServer.self.acceptor).start();
        KettleServer.self.acceptor.isStart();
    }

    public static void setMessageListener(String id, KettleMessageListener listener) {
        KettleServer.self.listenerMap.put(id, listener);
    }

    public static void addMessageListener(IMsgReceivedListener listener) {
        KettleServer.self.dbproxyMap.put(listener.getListenerID(), listener);
    }

    public static void removeMessageListener(String id) {
        KettleServer.self.listenerMap.remove(id);
    }

    public static void removeConnectionProxy() {
    }

    public static boolean canStopServer() {
        Iterator iterator = KettleServer.self.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Long lastUpdate = (Long)KettleServer.self.map.get(key);
            long dd = System.currentTimeMillis() - lastUpdate;
            if (dd <= 120000L) continue;
            iterator.remove();
        }
        if (self.getClientCount() == 0) {
            ClearConnection.closeServerForClient(KettleServer.self.clientID);
        }
        return self.getClientCount() == 0;
    }

    public static void closeAclient(String kettleID) {
        KettleServer.self.map.remove(kettleID);
        if (KettleServer.self.acceptor != null && self.getClientCount() == 0) {
            KettleServer.self.acceptor.stop();
            ClearConnection.closeServerForClient(KettleServer.self.clientID);
        }
    }

    public static void stopServer() {
        if (KettleServer.self.acceptor != null && self.getClientCount() == 0) {
            KettleServer.self.acceptor.stop();
        }
    }

    public static void main(String[] args) throws IOException {
    }

    public static void addClient(String kettleID) {
        KettleServer.self.map.put(kettleID, new Long(System.currentTimeMillis()));
    }

    public static void updateClientAccess(String kettleID) throws Exception {
        if (!KettleServer.self.map.containsKey(kettleID)) {
            throw new Exception("kettlt has Closed");
        }
        KettleServer.self.map.put(kettleID, new Long(System.currentTimeMillis()));
    }
}

