/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.BaseResultSet;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.IFetchData;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.SimpleResultSetMetaData;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.TransportRowSetProxy;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ProxyResultSet
extends BaseResultSet
implements Serializable {
    private ResultSetMetaData metaData;
    public IFetchData fetch;

    protected ProxyResultSet(ResultSet rs) {
        this.setResultSet(rs);
    }

    protected ProxyResultSet() {
    }

    public ProxyResultSet(ResultSet rowSet, String resultSetID) {
        this.setResultSet(rowSet);
        try {
            this.metaData = new SimpleResultSetMetaData(rowSet.getMetaData());
            this.fetch = new TransportRowSetProxy(rowSet, resultSetID, this.metaData);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public TransportRowSetProxy getResultRowNode() {
        return (TransportRowSetProxy)this.fetch;
    }

    public void setResultSetProxy(Object proxy) {
        if (proxy instanceof ResultSet) {
            this.setResultSet((ResultSet)proxy);
        }
        if (proxy instanceof IFetchData) {
            this.fetch = (IFetchData)proxy;
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this.fetch.getRow();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public boolean next() throws SQLException {
        int flag = this.fetch.nextRow();
        if (flag == -1) {
            return false;
        }
        if (flag == 0) {
            this.fetch.fetchDataRemote(5000);
            return !this.fetch.isEmpty();
        }
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        return this.fetch.previous();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.fetch.beforeFirst();
    }

    @Override
    public boolean first() throws SQLException {
        return this.fetch.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this.fetch.last();
    }

    @Override
    public void afterLast() throws SQLException {
        this.fetch.afterLast();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.fetch.wasNull();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.fetch.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.fetch.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.fetch.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.fetch.isLast();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.fetch.absolute(row);
    }
}

