/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.kettle;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.domain.MethodMessageInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.kettle.ETLProxyFactory;
import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;

public abstract class AbstractETLNIOHandle
implements InvocationHandler {
    public String connectionID;
    public String statmentID;
    public String remoteObjID;
    public String rsID;
    private static final long DEAD_LOCK_CHECK_INTERVAL = 5000L;
    private int waiters;

    public AbstractETLNIOHandle(MethodMessageInfo info) {
        if (info == null) {
            return;
        }
        this.connectionID = info.connectionID;
        this.statmentID = info.statementID;
        this.rsID = info.rsID;
        this.remoteObjID = info.remoteObjID;
    }

    protected Object handleResult(MethodMessageInfo methodInfo, Connection conn) {
        if ("DatabaseMetaData".equals(methodInfo.result.className)) {
            methodInfo.remoteObjID = methodInfo.result.targetObjectID;
            return this.createMetaDataProxy(methodInfo, conn);
        }
        if ("ResultSet".equals(methodInfo.result.className)) {
            this.createResultSetProxy(methodInfo);
            return methodInfo.getResultValue();
        }
        if ("Statement".equals(methodInfo.getResultValue())) {
            methodInfo.statementID = methodInfo.result.targetObjectID;
            return this.createStatementProxy(methodInfo, conn);
        }
        methodInfo.remoteObjID = methodInfo.result.targetObjectID;
        return this.createObjectProxy(methodInfo);
    }

    public Object createStatementProxy(MethodMessageInfo info, Connection conn) {
        return ETLProxyFactory.createStatementProxy(info, conn);
    }

    public Object createMetaDataProxy(MethodMessageInfo info, Connection conn) {
        return ETLProxyFactory.createMetaDataProxy(info, conn);
    }

    public Object createObjectProxy(MethodMessageInfo info) {
        return ETLProxyFactory.createRemoteProxy(info);
    }

    public Object createResultSetProxy(MethodMessageInfo methodInfo) {
        return ETLProxyFactory.createResultSetProxy(methodInfo);
    }

    public abstract String getType();

    public String getConnectionID() {
        return this.connectionID;
    }

    public String getRemoteID() {
        return this.remoteObjID;
    }

    public String getStatementID() {
        return this.statmentID;
    }

    public String getResultID() {
        return this.rsID;
    }

    public abstract String getSourceClassName();

    protected MethodMessageInfo getMethodInfo(Method method, Object[] args) {
        MethodMessageInfo info = new MethodMessageInfo(method.getParameterTypes());
        info.methodName = method.getName();
        info.methodSendID = UUID.randomUUID().toString();
        info.objType = this.getType();
        info.connectionID = this.getConnectionID();
        info.rsID = this.getResultID();
        info.statementID = this.getStatementID();
        info.params = args;
        info.sourceClassName = this.getSourceClassName();
        info.remoteObjID = this.getRemoteID();
        info.returnType = method.getReturnType();
        return info;
    }
}

