/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.mdm.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexCollection;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataTreeInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.AbstractMasterDataEditUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.MasterDataModelListUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.client.F7ListUISelector;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MasterDataEditUI
extends AbstractMasterDataEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MasterDataEditUI.class);

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MasterDataFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (MasterDataTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        MasterDataInfo objectValue = new MasterDataInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnSubmit.setEnabled(true);
        }
        F7ListUISelector.setListToPrmtF7(this.prmtMasterDataModel, (ListUI)new MasterDataModelListUI());
        this.prmtMasterDataModel.setEditable(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
        String number = this.txtNumber.getText();
        int maxLength = 12;
        if (number.length() > maxLength) {
            MsgBox.showWarning((String)(Constant.NumberChineseName + number + Constant.LengthExceed + maxLength));
            SysUtil.abort();
        }
        if (!number.matches("[a-zA-Z]\\w*")) {
            MsgBox.showWarning((String)(Constant.NumberChineseName + number + Constant.NumberFormatError));
            SysUtil.abort();
        }
        if ("id".equals(number)) {
            MsgBox.showWarning((String)(Constant.NumberChineseName + number + Constant.IsDefault));
            SysUtil.abort();
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean isUsed = this.editData.isIsUsed();
        if (isUsed) {
            MsgBox.showInfo((String)Constant.isUsedCanNotModify);
            SysUtil.abort();
        }
        String id = this.editData.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("parent");
        selector.add("MasterData.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MasterData.id", (Object)id));
        view.setFilter(filter);
        FactDataModelEntryMasterDataCollection factDataModelEntryMasterDataCollection = FactDataModelEntryMasterDataFactory.getRemoteInstance().getFactDataModelEntryMasterDataCollection(view);
        if (factDataModelEntryMasterDataCollection == null || factDataModelEntryMasterDataCollection.size() == 0) {
            super.actionEdit_actionPerformed(e);
            return;
        }
        HashSet<String> idsSet = new HashSet<String>();
        int size = factDataModelEntryMasterDataCollection.size();
        for (int i = 0; i < size; ++i) {
            idsSet.add(factDataModelEntryMasterDataCollection.get(i).getParent().getId().toString());
        }
        view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        selector.add("tableName");
        selector.add("tableType");
        selector.add("quoteID");
        view.setSelector(selector);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("quoteID", idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        TableIndexCollection tableIndexCollection = TableIndexFactory.getRemoteInstance().getTableIndexCollection(view);
        if (tableIndexCollection == null || tableIndexCollection.size() == 0) {
            super.actionEdit_actionPerformed(e);
            return;
        }
        MsgBox.showInfo((String)Constant.MasterDataCannotModify);
        SysUtil.abort();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }
}

