/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.mdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodesDropedEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodesDropedListener;
import com.kingdee.bos.ctrl.swing.event.TreeNodesPreDroppedListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.MasterDataStructureEnum;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.AbstractMasterDataInputListUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.MasterDataInputEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class MasterDataInputListUI
extends AbstractMasterDataInputListUI {
    private static final Logger logger = CoreUIObject.getLogger(MasterDataInputListUI.class);
    private UIContext uiCtx;
    private HashMap uiMap = new HashMap();
    private String editState = OprtState.VIEW;
    private String searchDataSql;
    private DefaultKingdeeTreeNode rootNode;
    private String selectedNodeId;
    private HashMap nodeTreeMap;
    private HashMap oldData;
    private String tableName;
    private int maxNumber;
    private TableIndexInfo tableIndexInfo;
    private KDLabel barLabel;
    private boolean hasParent = false;

    public MasterDataInputListUI() throws Exception {
        this.setPreferredSize(new Dimension(790, 590));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return MasterDataInputEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        this.uiCtx = new UIContext((Object)this);
        this.uiCtx.putAll(this.getUIContext());
        this.tableName = TableIndexFactory.getRemoteInstance().getTableNameById((String)this.uiCtx.get((Object)"id"), TableTypeEnum.MasterDataEasTable);
        if (this.tableName == null) {
            MsgBox.showInfo((String)Constant.TargetTableIsNull);
            SysUtil.abort();
        }
        this.initWorkButton();
        this.initUI();
        this.initTree();
    }

    private String getSearchDataSql() throws Exception {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("Entry.*");
        MasterDataModelInfo dataModel = MasterDataModelFactory.getRemoteInstance().getMasterDataModelInfo((IObjectPK)new ObjectUuidPK(this.uiCtx.get((Object)"MasterDataModel.id").toString()), selector);
        StringBuffer sb = new StringBuffer("select ");
        MasterDataModelEntryCollection col = dataModel.getEntry();
        if (col == null || col.size() <= 0) {
            MsgBox.showInfo((String)Constant.ModelNotCompleted);
            SysUtil.abort();
        }
        this.uiCtx.put((Object)"dataModel", (Object)dataModel);
        MasterDataModelEntryInfo entry = null;
        String fieldName = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            fieldName = entry.getAttribute();
            sb.append("F").append(fieldName).append(",");
        }
        sb.append("Fintid");
        if (MasterDataStructureEnum.Tree.equals((Object)dataModel.getMasterDataStructu())) {
            sb.append(",FintparentID");
        }
        sb.append(" from ").append(this.tableName).append(" order by F").append(Constant.Order);
        return sb.toString();
    }

    private void initTree() throws Exception {
        int i;
        int size;
        this.nodeTreeMap = new HashMap();
        ArrayList<String> idsList = new ArrayList<String>();
        ArrayList<String> treeIdsList = new ArrayList<String>();
        HashMap<String, HashMap> nodeMap = new HashMap<String, HashMap>();
        Object row = null;
        HashMap objMap = null;
        String id = null;
        String parentID = null;
        FieldTypeEnum fieldType = null;
        Object value = null;
        String rootNodeName = this.uiCtx.get((Object)"name").toString();
        this.rootNode = new DefaultKingdeeTreeNode((Object)rootNodeName);
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)this.rootNode);
        if (this.searchDataSql == null) {
            this.searchDataSql = this.getSearchDataSql();
        }
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)this.searchDataSql).executeSQL();
        MasterDataModelInfo dataModel = (MasterDataModelInfo)this.uiCtx.get((Object)"dataModel");
        MasterDataModelEntryCollection col = dataModel.getEntry();
        MasterDataModelEntryInfo entry = null;
        String fieldName = null;
        String attribute = null;
        while (rs.next()) {
            objMap = new HashMap();
            size = col.size();
            for (i = 0; i < size; ++i) {
                entry = col.get(i);
                attribute = entry.getAttribute();
                fieldName = "F" + attribute;
                fieldType = entry.getFieldType();
                if (FieldTypeEnum.Integer.equals((Object)fieldType)) {
                    value = rs.getObject(fieldName);
                } else if (FieldTypeEnum.Decimal.equals((Object)fieldType)) {
                    value = rs.getBigDecimal(fieldName);
                } else if (FieldTypeEnum.Date.equals((Object)fieldType)) {
                    value = rs.getDate(fieldName);
                } else if (FieldTypeEnum.DateTime.equals((Object)fieldType)) {
                    value = rs.getTimestamp(fieldName);
                } else if (FieldTypeEnum.Text.equals((Object)fieldType)) {
                    value = rs.getString(fieldName);
                }
                objMap.put(attribute, value);
                if (!Constant.ID.equals(attribute)) continue;
                id = rs.getString(fieldName);
            }
            objMap.put("intid", new Integer(rs.getInt("Fintid")));
            if (MasterDataStructureEnum.Tree.equals((Object)dataModel.getMasterDataStructu())) {
                objMap.put("intparentID", new Integer(rs.getInt("FintparentID")));
                this.hasParent = true;
            }
            nodeMap.put(id, objMap);
            idsList.add(id);
            treeIdsList.add(id);
        }
        size = idsList.size();
        for (i = 0; i < size; ++i) {
            objMap = (HashMap)nodeMap.get(idsList.get(i));
            parentID = (String)objMap.get(Constant.ParentID);
            id = (String)objMap.get(Constant.ID);
            if (parentID == null || !nodeMap.containsKey(parentID)) continue;
            HashMap parentObjMap = (HashMap)nodeMap.get(parentID);
            ArrayList list = null;
            list = parentObjMap.get("childIDs") == null ? new ArrayList() : (ArrayList)parentObjMap.get("childIDs");
            list.add(id);
            parentObjMap.put("childIDs", list);
            treeIdsList.remove(idsList.get(i));
        }
        size = treeIdsList.size();
        for (i = 0; i < size; ++i) {
            objMap = (HashMap)nodeMap.get(treeIdsList.get(i));
            this.addNode(objMap, nodeMap, this.rootNode);
        }
        this.treeMain.expandAllNodes(true, (TreeNode)this.rootNode);
        if (this.selectedNodeId == null) {
            if (this.rootNode.getChildCount() > 0) {
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.rootNode.getFirstChild());
            }
        } else {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.nodeTreeMap.get(this.selectedNodeId));
        }
    }

    private void addNode(HashMap objMap, HashMap nodeMap, DefaultKingdeeTreeNode rootNode) {
        String number = (String)objMap.get(Constant.Number);
        String name = (String)objMap.get(Constant.Name);
        String nodeStr = number + "(" + name + ")";
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)nodeStr);
        node.setUserObject((Object)objMap);
        this.nodeTreeMap.put(objMap.get(Constant.ID), node);
        if (objMap.get("childIDs") != null) {
            ArrayList list = (ArrayList)objMap.get("childIDs");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                this.addNode((HashMap)nodeMap.get(list.get(i)), nodeMap, node);
            }
        }
        rootNode.add((MutableTreeNode)node);
    }

    private void showInfo() {
        KDLabelContainer label;
        this.plMain.removeAll();
        this.uiMap.clear();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() instanceof String && !this.editState.equals(OprtState.ADDNEW)) {
            this.repaint();
            return;
        }
        MasterDataModelInfo dataModel = (MasterDataModelInfo)this.uiCtx.get((Object)"dataModel");
        MasterDataModelEntryCollection col = dataModel.getEntry();
        if (col == null || col.size() <= 0) {
            MsgBox.showInfo((String)Constant.ModelNotCompleted);
            SysUtil.abort();
        }
        int x = 10;
        int y = 10;
        MasterDataModelEntryInfo entry = null;
        FieldTypeEnum fieldType = null;
        KDFormattedTextField component = null;
        String attribute = null;
        this.oldData = this.editState.equals(OprtState.VIEW) || this.editState.equals(OprtState.EDIT) ? (HashMap)node.getUserObject() : null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            KDFormattedTextField comp;
            entry = col.get(i);
            attribute = entry.getAttribute();
            fieldType = entry.getFieldType();
            label = new KDLabelContainer();
            label.setBoundLabelText(entry.getAlias());
            label.setBoundLabelLength(100);
            label.setBoundLabelUnderline(true);
            label.setBounds(new Rectangle(x, y, 270, 19));
            this.plMain.add((Component)label, null);
            if (Constant.ID.equals(attribute) || Constant.ParentID.equals(attribute)) {
                label.setVisible(false);
            } else {
                y += 22;
            }
            if (FieldTypeEnum.Integer.equals((Object)fieldType)) {
                comp = new KDFormattedTextField();
                comp.setHorizontalAlignment(2);
                comp.setDataType(0);
                comp.setName(attribute);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
                if (this.editState.equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.Decimal.equals((Object)fieldType)) {
                comp = new KDFormattedTextField();
                comp.setHorizontalAlignment(2);
                comp.setDataType(1);
                comp.setMinimumValue((Comparable)new BigDecimal("-1.0E18"));
                comp.setMaximumValue((Comparable)new BigDecimal("1.0E18"));
                comp.setPrecision(10);
                comp.setName(attribute);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
                if (this.editState.equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.Date.equals((Object)fieldType)) {
                comp = new KDDatePicker();
                comp.setName(attribute);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
                if (this.editState.equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.DateTime.equals((Object)fieldType)) {
                comp = new KDDatePicker();
                comp.setTimeEnabled(true);
                comp.setName(attribute);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
                if (this.editState.equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.Text.equals((Object)fieldType)) {
                comp = new KDTextField();
                comp.setMaxLength(80);
                comp.setName(attribute);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setText((String)this.oldData.get(attribute));
                }
                if (this.editState.equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
                if (Constant.ID.equals(attribute)) {
                    comp.setEnabled(false);
                    comp.setVisible(false);
                    if (this.oldData == null) {
                        comp.setText(Uuid.create().toString());
                    } else {
                        comp.setText((String)this.oldData.get(Constant.ID));
                    }
                }
                if (Constant.ParentID.equals(attribute)) {
                    comp.setEnabled(false);
                    comp.setVisible(false);
                    if (this.oldData == null) {
                        if (node.getUserObject() instanceof HashMap) {
                            comp.setText((String)((HashMap)node.getUserObject()).get(Constant.ID));
                        }
                    } else {
                        comp.setText((String)this.oldData.get(Constant.ParentID));
                    }
                }
            }
            this.uiMap.put(attribute, component);
        }
        attribute = "intid";
        label = new KDLabelContainer();
        label.setBoundLabelText("intid");
        label.setBoundLabelLength(100);
        label.setBoundLabelUnderline(true);
        label.setBounds(new Rectangle(x, y += 22, 270, 19));
        this.plMain.add((Component)label, null);
        label.setVisible(false);
        KDFormattedTextField comp = new KDFormattedTextField();
        comp.setHorizontalAlignment(2);
        comp.setDataType(0);
        comp.setName(attribute);
        label.setBoundEditor((JComponent)comp);
        component = comp;
        if (this.oldData != null) {
            comp.setValue(this.oldData.get(attribute));
        } else {
            try {
                this.tableIndexInfo = TableIndexFactory.getRemoteInstance().getTableIndexInfo(" where tableName='" + this.tableName + "'");
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            int number = this.tableIndexInfo.getNumber();
            this.maxNumber = number + 1;
            comp.setValue((Object)new Integer(this.maxNumber));
        }
        this.uiMap.put(attribute, component);
        if (MasterDataStructureEnum.Tree.equals((Object)dataModel.getMasterDataStructu())) {
            attribute = "intparentID";
            label = new KDLabelContainer();
            label.setBoundLabelText("intparentID");
            label.setBoundLabelLength(100);
            label.setBoundLabelUnderline(true);
            label.setBounds(new Rectangle(x, y += 22, 270, 19));
            this.plMain.add((Component)label, null);
            label.setVisible(false);
            comp = new KDFormattedTextField();
            comp.setHorizontalAlignment(2);
            comp.setDataType(0);
            comp.setName(attribute);
            label.setBoundEditor((JComponent)comp);
            component = comp;
            if (this.oldData != null) {
                comp.setValue(this.oldData.get(attribute));
            } else if (node.getUserObject() instanceof HashMap) {
                comp.setValue((Object)((Integer)((HashMap)node.getUserObject()).get("intid")));
            }
            this.uiMap.put(attribute, component);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnRemove.setVisible(false);
            this.btnEdit.setVisible(false);
        }
        this.plMain.setPreferredSize(new Dimension(540, y));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit.setEnabled(true);
        this.actionSubmit.setVisible(true);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.editState = OprtState.ADDNEW;
        this.showInfo();
        KDTextField number = (KDTextField)this.uiMap.get("number");
        if (number != null) {
            number.requestFocusInWindow();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() instanceof String) {
            MsgBox.showInfo((String)Constant.ChooseChild);
            return;
        }
        this.actionSubmit.setEnabled(true);
        this.actionSubmit.setVisible(true);
        this.editState = OprtState.EDIT;
        this.showInfo();
        KDTextField number = (KDTextField)this.uiMap.get("number");
        number.requestFocusInWindow();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() instanceof String) {
            MsgBox.showInfo((String)Constant.ChooseChild);
            return;
        }
        if (!node.isLeaf()) {
            MsgBox.showInfo((String)Constant.DeleteChildFirst);
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)Constant.DeleteConfirm))) {
            return;
        }
        HashMap oldData = (HashMap)node.getUserObject();
        StringBuffer sb = new StringBuffer();
        SqlParams params = new SqlParams();
        if (oldData != null) {
            sb.append("delete from ").append(this.tableName).append(" where fid=?");
            params.addString((String)oldData.get(Constant.ID));
            MasterDataFactory.getRemoteInstance().executeSql(sb.toString(), params);
            this.setMessageText(Constant.DeleteSuccess);
            this.showMessage();
        }
        this.selectedNodeId = null;
        this.refresh(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editState = OprtState.EDIT;
        this.verifyInput(e);
        StringBuffer sb = new StringBuffer();
        SqlParams params = new SqlParams();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.oldData != null) {
            sb.append("delete from ").append(this.tableName).append(" where fid=?");
            params.addString((String)this.oldData.get(Constant.ID));
            map.put("deleteOldSql", sb.toString());
            map.put("deleteOldParams", params);
        }
        sb = new StringBuffer();
        params = new SqlParams();
        sb.append("insert into ").append(this.tableName).append(" (");
        StringBuffer valueSb = new StringBuffer();
        Component[] components = this.plMain.getComponents();
        Component comp2 = null;
        IKDComponent c = null;
        String attribute = null;
        String fieldName = null;
        Object id = null;
        Object number = null;
        Object order = null;
        for (Component comp2 : components) {
            Object obj;
            KDTextField txtEditor;
            if (!(comp2 instanceof KDLabelContainer)) continue;
            KDLabelContainer ct = (KDLabelContainer)comp2;
            JComponent editor = ct.getBoundEditor();
            attribute = editor.getName();
            fieldName = "F" + attribute;
            if (!this.uiMap.containsKey(attribute)) continue;
            c = (IKDComponent)editor;
            if (editor instanceof KDTextField) {
                txtEditor = (KDTextField)editor;
                obj = txtEditor.getText();
                if (obj == null) continue;
                sb.append(fieldName).append(",");
                valueSb.append("?,");
                params.addString((String)obj);
                if (Constant.ID.equals(attribute)) {
                    this.selectedNodeId = obj;
                    id = obj;
                }
                if (!Constant.Number.equals(attribute)) continue;
                number = obj;
                continue;
            }
            if (editor instanceof KDDatePicker) {
                txtEditor = (KDDatePicker)editor;
                obj = txtEditor.getTimestamp();
                if (obj == null) continue;
                sb.append(fieldName).append(",");
                valueSb.append("?,");
                params.addObject(obj);
                continue;
            }
            if (!(editor instanceof KDFormattedTextField) || (obj = (txtEditor = (KDFormattedTextField)editor).getNumberValue()) == null) continue;
            sb.append(fieldName).append(",");
            valueSb.append("?,");
            params.addObject((Object)new Double(((Number)obj).doubleValue()));
            if (!Constant.Order.equals(attribute)) continue;
            order = obj;
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        valueSb.replace(valueSb.length() - 1, valueSb.length(), "");
        sb.append(") values (").append(valueSb).append(")");
        map.put("checkNumberSql", "select * from " + this.tableName + " where fnumber='" + number + "' and fid not in ('" + id + "')");
        map.put("number", number);
        map.put("tableName", this.tableName);
        map.put("order", order);
        map.put("id", id);
        map.put("insertSql", sb.toString());
        map.put("insertParams", params);
        if (this.tableIndexInfo != null) {
            this.tableIndexInfo.setNumber(this.maxNumber);
            map.put("tableIndexInfo", this.tableIndexInfo);
        }
        MasterDataFactory.getRemoteInstance().insertData(map);
        this.setMessageText(Constant.SaveSuccess);
        this.showMessage();
        this.refresh(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.initTree();
    }

    private void initUI() {
        MainStatusBar mainStatusBar = this.getMainStatusBar();
        if (mainStatusBar == null) {
            this.setMainStatusBar(MainStatusBar.getMainStatusBar());
        }
        this.barLabel = mainStatusBar.getMsgLabel();
        super.lockAction();
        ItemAction[] itemActions = null;
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setUITitle(Constant.MasterDataView);
            this.barLabel.setText(Constant.MasterDataView);
        } else {
            itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove};
            this.barLabel.setText(Constant.MasterDataInput);
        }
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)MasterDataInputListUI.this.treeMain.getLastSelectedPathComponent();
                if (MasterDataInputListUI.this.selectedNodeId == null) {
                    MasterDataInputListUI.this.editState = OprtState.VIEW;
                    MasterDataInputListUI.this.actionSubmit.setEnabled(false);
                    MasterDataInputListUI.this.actionSubmit.setVisible(false);
                    if (node != null && !node.isRoot()) {
                        MasterDataInputListUI.this.actionEdit.setEnabled(true);
                        MasterDataInputListUI.this.actionEdit.setVisible(true);
                        MasterDataInputListUI.this.actionRemove.setEnabled(true);
                        MasterDataInputListUI.this.actionRemove.setVisible(true);
                    } else {
                        MasterDataInputListUI.this.actionEdit.setEnabled(false);
                        MasterDataInputListUI.this.actionEdit.setVisible(false);
                        MasterDataInputListUI.this.actionRemove.setEnabled(false);
                        MasterDataInputListUI.this.actionRemove.setVisible(false);
                    }
                } else if (node != null && node.getUserObject() instanceof HashMap && !MasterDataInputListUI.this.selectedNodeId.equals((String)((HashMap)node.getUserObject()).get(Constant.ID))) {
                    MasterDataInputListUI.this.editState = OprtState.VIEW;
                    MasterDataInputListUI.this.actionSubmit.setEnabled(false);
                    MasterDataInputListUI.this.actionSubmit.setVisible(false);
                    MasterDataInputListUI.this.actionEdit.setEnabled(true);
                    MasterDataInputListUI.this.actionEdit.setVisible(true);
                    MasterDataInputListUI.this.actionRemove.setEnabled(true);
                    MasterDataInputListUI.this.actionRemove.setVisible(true);
                }
                MasterDataInputListUI.this.showInfo();
            }
        });
        this.treeMain.addTreeNodesPreDroppedListener(new TreeNodesPreDroppedListener(){

            public void preDropped(TreeNodesDropedEvent eve) {
                if (OprtState.VIEW.equals(MasterDataInputListUI.this.getOprtState())) {
                    eve.veto();
                    return;
                }
                if (!MasterDataInputListUI.this.hasParent) {
                    eve.veto();
                    return;
                }
                if (MsgBox.showConfirm2((String)"\u4f60\u786e\u5b9a\u8981\u79fb\u52a8\u8282\u70b9\u5417\uff1f") != 0) {
                    eve.veto();
                    return;
                }
            }
        });
        this.treeMain.setDragEnabled(true);
        this.treeMain.setDragNodeEnabled(true);
        this.treeMain.addTreeNodesDropedListener(new TreeNodesDropedListener(){

            public void droped(TreeNodesDropedEvent e) {
                MasterDataInputListUI.this.drag(e);
            }
        });
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.putAll(this.getUIContext());
        NewMainFrame frame = (NewMainFrame)uiCtx.get((Object)"OwnerWindow");
        frame.getRootPane().setWindowDecorationStyle(0);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drag(TreeNodesDropedEvent event) {
        KDTree theTree = (KDTree)event.getSource();
        if (event.getNodesCount() == 0) {
            return;
        }
        Map dragMap = null;
        Map toMap = null;
        Map fromMap = null;
        try {
            theTree.setCursor(Cursor.getPredefinedCursor(3));
            IMainMenuItem mainMenuItem = MainMenuItemFactory.getRemoteInstance();
            for (int i = 0; i < event.getNodesCount(); ++i) {
                KingdeeTreeModel treeModel = (KingdeeTreeModel)theTree.getModel();
                DefaultKingdeeTreeNode dragNode = event.getNodes()[i].getDragNode();
                DefaultKingdeeTreeNode toParentNode = event.getNodes()[i].getToParent();
                DefaultKingdeeTreeNode fromParentNode = event.getNodes()[i].getFromParent();
                dragMap = (Map)dragNode.getUserObject();
                if (toParentNode.getUserObject() != null && toParentNode.getUserObject() instanceof Map) {
                    toMap = (Map)toParentNode.getUserObject();
                }
                if (fromParentNode.getUserObject() != null && fromParentNode.getUserObject() instanceof Map) {
                    fromMap = (Map)fromParentNode.getUserObject();
                }
                if (toMap == null) {
                    if (this.hasParent) {
                        dragMap.put("parentID", null);
                    }
                } else if (this.hasParent) {
                    dragMap.put("parentID", toMap.get("id"));
                    dragMap.put("intparentID", toMap.get("intid"));
                }
                this.updateNodeDate(dragMap);
                KingdeeTreeModel model = (KingdeeTreeModel)theTree.getModel();
                model.reload((TreeNode)dragNode);
            }
        }
        catch (Exception exc) {
            super.handUIException((Throwable)exc);
            return;
        }
        finally {
            theTree.setCursor(Cursor.getDefaultCursor());
        }
        MsgBox.showInfo((Component)((Object)this), (String)"\u8282\u70b9\u79fb\u52a8\u6210\u529f");
    }

    private void updateNodeDate(Map objMap) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.hasParent) {
            sql.append("update ").append(this.tableName).append(" set");
            sql.append(" FparentID=?,FintparentID=?");
            sql.append(" where fid=?");
            SqlParams params = new SqlParams();
            params.addString((String)objMap.get("parentID"));
            Object parentObj = objMap.get("intparentID");
            if (parentObj == null) {
                params.addObject(null);
            } else {
                params.addInt(((Integer)parentObj).intValue());
            }
            params.addString((String)objMap.get("id"));
            MasterDataFactory.getRemoteInstance().executeSql(sql.toString(), params);
        }
    }
}

