/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.mdm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.bireport.bimanager.MasterDataTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexCollection;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataTreeFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.AbstractMasterDataListUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.MasterDataInputListUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.MasterDataTreeEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.ExampleFileFilter;
import com.kingdee.eas.framework.bireport.bimanager.util.ExcelHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class MasterDataListUI
extends AbstractMasterDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(MasterDataListUI.class);
    private UIContext uiCtx;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MasterDataFactory.getRemoteInstance();
    }

    @Override
    protected ITreeBase getTreeInterface() throws Exception {
        return MasterDataTreeFactory.getRemoteInstance();
    }

    @Override
    protected String getGroupEditUIName() {
        return MasterDataTreeEditUI.class.getName();
    }

    @Override
    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return Constant.MasterDataCategory;
    }

    @Override
    protected IObjectValue createNewData() {
        MasterDataInfo objectValue = new MasterDataInfo();
        return objectValue;
    }

    @Override
    public void onLoad() throws Exception {
        this.uiCtx = new UIContext((Object)this);
        this.uiCtx.putAll(this.getUIContext());
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData};
        BiManagerUtil.setActionsEnabledStatus(itemActions, false);
        itemActions = new ItemAction[]{this.actionAddNew, this.actionView, this.actionEdit, this.actionRemove, this.actionRefresh, this.actionQuery, this.actionLocate, this.actionDataView, this.actionCancel, this.actionCancelCancel, this.actionAudit, this.actionUnAudit, this.actionExcelImport, this.actionExcelExport};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        this.btnAudit.setText(Constant.AuditInWarehouse);
        this.btnAudit.setToolTipText(Constant.AuditInWarehouse);
        this.btnUnAudit.setText(Constant.UnAuditInWarehouse);
        this.btnUnAudit.setToolTipText(Constant.UnAuditInWarehouse);
        this.btnDataView.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnDataImport.setIcon(EASResource.getIcon((String)"imgTbtn_inputmetadata"));
        this.btnDataInput.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnExcelImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExcelExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.setButtonDefaultStyl(this.btnDataView);
        this.setButtonDefaultStyl(this.btnDataImport);
        this.setButtonDefaultStyl(this.btnDataInput);
        this.setButtonDefaultStyl(this.btnExcelImport);
        this.setButtonDefaultStyl(this.btnExcelExport);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row != null) {
            Boolean isInWarehouse;
            if (row.getCell("MasterDataModel.MasterDataType").getValue() != null) {
                String structure = row.getCell("MasterDataModel.MasterDataType").getValue().toString();
                if (MasterDataTypeEnum.EASMasterData.getAlias().equals(structure)) {
                    this.btnDataImport.setVisible(true);
                    this.btnDataImport.setEnabled(true);
                    this.btnDataInput.setVisible(false);
                    this.btnDataInput.setEnabled(false);
                } else {
                    this.btnDataImport.setVisible(false);
                    this.btnDataImport.setEnabled(false);
                    this.btnDataInput.setVisible(true);
                    this.btnDataInput.setEnabled(true);
                }
            }
            if ((isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue()) != null && isInWarehouse.booleanValue()) {
                this.btnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(true);
            } else {
                this.btnAudit.setEnabled(true);
                this.btnUnAudit.setEnabled(false);
            }
            Boolean isUsed = (Boolean)row.getCell("isUsed").getValue();
            if (isUsed != null && isUsed.booleanValue()) {
                this.btnCancelCancel.setEnabled(false);
                this.btnCancel.setEnabled(true);
            } else {
                this.btnCancelCancel.setEnabled(true);
                this.btnCancel.setEnabled(false);
            }
        }
    }

    @Override
    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionDataImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmDialog(Constant.ImportDataConfirm)) {
            String masterDataId;
            Boolean isUsed;
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (row == null) {
                MsgBox.showInfo((String)Constant.ChooseRow);
                SysUtil.abort();
            }
            if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) == null || !isUsed.booleanValue()) {
                MsgBox.showInfo((String)Constant.pleaseUsed);
                SysUtil.abort();
            }
            if ((masterDataId = (String)row.getCell("id").getValue()) == null) {
                MsgBox.showInfo((String)Constant.MasterDataModelIsNull);
                SysUtil.abort();
            }
            MasterDataFactory.getRemoteInstance().importData(masterDataId);
            MsgBox.showInfo((String)Constant.DataImportSuccess);
        }
    }

    @Override
    public void actionDataInput_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) == null || !isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.pleaseUsed);
            SysUtil.abort();
        }
        this.uiCtx.put((Object)"id", row.getCell("id").getValue());
        this.uiCtx.put((Object)"name", row.getCell("name").getValue());
        this.uiCtx.put((Object)"MasterDataModel.id", row.getCell("MasterDataModel.id").getValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(MasterDataInputListUI.class.getName(), (Map)this.uiCtx, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionDataView_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) == null || !isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.pleaseUsed);
            SysUtil.abort();
        }
        this.uiCtx.put((Object)"id", row.getCell("id").getValue());
        this.uiCtx.put((Object)"name", row.getCell("name").getValue());
        this.uiCtx.put((Object)"MasterDataModel.id", row.getCell("MasterDataModel.id").getValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MasterDataInputListUI.class.getName(), (Map)this.uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        Boolean isInWarehouse;
        super.tblMain_tableSelectChanged(e);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            return;
        }
        if (row.getCell("MasterDataModel.MasterDataType").getValue() == null) {
            return;
        }
        String structure = row.getCell("MasterDataModel.MasterDataType").getValue().toString();
        if (!this.getUIContext().containsKey("filterForF7")) {
            if (MasterDataTypeEnum.EASMasterData.getAlias().equals(structure)) {
                this.btnDataImport.setVisible(true);
                this.btnDataImport.setEnabled(true);
                this.btnDataInput.setVisible(false);
                this.btnDataInput.setEnabled(false);
            } else {
                this.btnDataImport.setVisible(false);
                this.btnDataImport.setEnabled(false);
                this.btnDataInput.setVisible(true);
                this.btnDataInput.setEnabled(true);
            }
        }
        if ((isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue()) != null && isInWarehouse.booleanValue()) {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(true);
        } else {
            this.btnAudit.setEnabled(true);
            this.btnUnAudit.setEnabled(false);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) != null && isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.isUsedCanNotModify);
            SysUtil.abort();
        }
        String id = (String)row.getCell("id").getValue();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("parent");
        selector.add("MasterData.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MasterData.id", (Object)id));
        view.setFilter(filter);
        FactDataModelEntryMasterDataCollection factDataModelEntryMasterDataCollection = FactDataModelEntryMasterDataFactory.getRemoteInstance().getFactDataModelEntryMasterDataCollection(view);
        if (factDataModelEntryMasterDataCollection == null || factDataModelEntryMasterDataCollection.size() == 0) {
            super.actionEdit_actionPerformed(e);
            return;
        }
        HashSet<String> idsSet = new HashSet<String>();
        int size = factDataModelEntryMasterDataCollection.size();
        for (int i = 0; i < size; ++i) {
            idsSet.add(factDataModelEntryMasterDataCollection.get(i).getParent().getId().toString());
        }
        view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        selector.add("tableName");
        selector.add("tableType");
        selector.add("quoteID");
        view.setSelector(selector);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("quoteID", idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        TableIndexCollection tableIndexCollection = TableIndexFactory.getRemoteInstance().getTableIndexCollection(view);
        if (tableIndexCollection == null || tableIndexCollection.size() == 0) {
            super.actionEdit_actionPerformed(e);
            return;
        }
        MsgBox.showInfo((String)Constant.MasterDataCannotModify);
        SysUtil.abort();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean isRemove;
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) != null && isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.isUsedCanNotRemove);
            SysUtil.abort();
        }
        if (!(isRemove = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)Constant.DeleteDataConfirm)))) {
            return;
        }
        this.Remove();
        this.refresh(e);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            String id;
            this.checkSelected();
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (row == null) {
                MsgBox.showInfo((String)Constant.ChooseRow);
                SysUtil.abort();
            }
            if ((id = (String)row.getCell("id").getValue()) == null) {
                MsgBox.showInfo((String)Constant.IdIsNoll);
                SysUtil.abort();
            }
            MasterDataFactory.getRemoteInstance().cancelCancel((IObjectPK)new ObjectUuidPK(id), null);
        }
        this.refresh(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isInWarehouse;
        String id;
        Boolean isUsed;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) == null || !isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.pleaseUsed);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        if ((isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue()) != null && isInWarehouse.booleanValue() && !this.confirmDialog(Constant.InWarehouseConfirm)) {
            return;
        }
        MasterDataFactory.getRemoteInstance().audit(id);
        this.refresh(e);
        MsgBox.showInfo((String)Constant.InWarehouseSuccess);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isInWarehouse;
        String id;
        Boolean isUsed;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) == null || !isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.pleaseUsed);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        if ((isInWarehouse = (Boolean)row.getCell("isInWarehouse").getValue()) == null || !isInWarehouse.booleanValue()) {
            MsgBox.showInfo((String)Constant.ReportNotInWarehouse);
            return;
        }
        MasterDataFactory.getRemoteInstance().unAudit(id);
        MsgBox.showInfo((String)Constant.UnInWarehouseSuccess);
        this.refresh(e);
    }

    @Override
    public void actionExcelImport_actionPerformed(ActionEvent e) throws Exception {
        String id;
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) == null || !isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.pleaseUsed);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        KDFileChooser chooser = new KDFileChooser();
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("xls");
        filter.setDescription("Excel File");
        chooser.setFileFilter((FileFilter)filter);
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            int result;
            File file = chooser.getSelectedFile();
            if (!file.exists()) {
                MsgBox.showInfo((String)Constant.FileNotExist);
                SysUtil.abort();
            }
            if (MsgBox.isCancel((int)(result = MsgBox.showConfirm3((String)"\u662f\u5426\u4ee5Excel\u6587\u6863\u4e3a\u51c6\uff0c\u5c06\u6587\u6863\u4e2d\u4e0d\u5b58\u5728\u7684\u6570\u636e\u5220\u9664\uff1f")))) {
                SysUtil.abort();
            }
            boolean deleteOld = MsgBox.isYes((int)result);
            Workbook book = Workbook.getWorkbook((File)file);
            Sheet sheet = book.getSheet(0);
            HashMap<String, String> numberMap = new HashMap<String, String>();
            int rows = sheet.getRows();
            int columns = sheet.getColumns();
            ArrayList<String> fieldNameList = new ArrayList<String>();
            ArrayList dataList = new ArrayList();
            StringBuffer numbers = new StringBuffer();
            for (int j = 0; j < columns; ++j) {
                Cell cell = sheet.getCell(j, 1);
                if (cell.getContents() == null || cell.getContents().equals("")) continue;
                fieldNameList.add(cell.getContents());
            }
            for (int i = 2; i < rows; ++i) {
                HashMap<String, Object> objMap = new HashMap<String, Object>();
                boolean valid = false;
                int line = 2;
                for (int j = 0; j < fieldNameList.size(); ++j) {
                    if (this.getExcelDate(sheet.getCell(j, i)) == null || this.getExcelDate(sheet.getCell(j, i)).toString().trim().length() <= 0) continue;
                    valid = true;
                    break;
                }
                if (!valid) continue;
                String number = null;
                for (int j = 0; j < fieldNameList.size(); ++j) {
                    Cell cell = sheet.getCell(j, i);
                    String columnName = (String)fieldNameList.get(j);
                    objMap.put(columnName, this.getExcelDate(cell));
                    if (!Constant.NumberChineseName.equals(columnName)) continue;
                    number = cell.getContents();
                }
                if (numberMap.containsKey(number)) {
                    MsgBox.showInfo((String)(Constant.Di + (i + 1) + Constant.Row + Constant.NumberChineseName + number + Constant.DoubleName));
                    book.close();
                    SysUtil.abort();
                }
                objMap.put("line", new Integer(i + 1));
                dataList.add(objMap);
                numberMap.put(number, "");
                numbers.append("'").append((Object)number).append("',");
            }
            if (numbers.length() > 0) {
                numbers.deleteCharAt(numbers.length() - 1);
            }
            book.close();
            if (dataList.size() > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dataList", dataList);
                map.put("fieldNameList", fieldNameList);
                map.put("numbers", numbers.toString());
                map.put("deleteOld", new Boolean(deleteOld));
                MasterDataFactory.getRemoteInstance().excelImport(id, map);
                MsgBox.showInfo((String)"Excel\u5bfc\u5165\u6210\u529f!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionExcelExport_actionPerformed(ActionEvent e) throws Exception {
        int value;
        String id;
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) == null || !isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.pleaseUsed);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        JFileChooser chooser = new JFileChooser();
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("xls");
        filter.setDescription("Excel File");
        chooser.addChoosableFileFilter(filter);
        int result = chooser.showSaveDialog((Component)((Object)this));
        if (result == 1) {
            return;
        }
        File saveFile = null;
        String filePath = null;
        File selectedFile = chooser.getSelectedFile();
        String selectedFileName = selectedFile.getName();
        String saveFileName = this.addExtension(selectedFileName, ".xls");
        if (saveFileName == null) {
            return;
        }
        saveFile = new File(selectedFile.getParentFile(), saveFileName);
        filePath = saveFile.getAbsolutePath();
        String sureCover = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Exists");
        while (saveFile.exists() && (value = JOptionPane.showConfirmDialog((Component)((Object)this), filePath + sureCover, "", 0, 1)) != 0) {
            chooser = new JFileChooser();
            chooser.setSelectedFile(saveFile);
            chooser.addChoosableFileFilter(filter);
            result = chooser.showSaveDialog((Component)((Object)this));
            if (result == 1) {
                return;
            }
            saveFile = chooser.getSelectedFile();
            saveFileName = this.addExtension(saveFile.getName(), ".xls");
            saveFile = new File(saveFile.getParentFile(), saveFileName);
            filePath = saveFile.getAbsolutePath();
        }
        OutputStream os = null;
        WritableWorkbook workbook = null;
        try {
            String masterDataName = (String)row.getCell("name").getValue();
            String masterDataNumber = (String)row.getCell("number").getValue();
            os = new FileOutputStream(saveFile);
            workbook = Workbook.createWorkbook((OutputStream)os);
            WritableSheet sheet = workbook.createSheet(Constant.MasterData + "-" + masterDataName, 0);
            int line = 0;
            Label label = new Label(0, line, Constant.TempletName + ": " + masterDataName + "   " + Constant.TempletNumber + ": " + masterDataNumber, (CellFormat)ExcelHelper.getTitleCellFormat2());
            sheet.addCell((WritableCell)label);
            Map map = MasterDataFactory.getRemoteInstance().excelExport(id);
            List fieldNameList = (List)map.get("fieldNameList");
            ++line;
            int size = fieldNameList.size();
            for (int i = 0; i < size; ++i) {
                label = new Label(i, line, (String)fieldNameList.get(i), (CellFormat)ExcelHelper.getTitleCellFormat2());
                sheet.addCell((WritableCell)label);
            }
            List dataList = (List)map.get("dataList");
            int size2 = dataList.size();
            for (int i = 0; i < size2; ++i) {
                ++line;
                Map objMap = (Map)dataList.get(i);
                int columns = fieldNameList.size();
                for (int j = 0; j < columns; ++j) {
                    label = new Label(j, line, (String)objMap.get(fieldNameList.get(j)));
                    sheet.addCell((WritableCell)label);
                }
            }
            sheet.setRowView(0, 600);
            if (fieldNameList.size() > 0) {
                sheet.mergeCells(0, 0, fieldNameList.size() - 1, 0);
            }
        }
        catch (IOException e1) {
            this.handleException(e1);
        }
        finally {
            if (null != workbook) {
                workbook.write();
                workbook.close();
            }
            if (null != os) {
                os.flush();
                ((FileOutputStream)os).close();
            }
        }
    }

    private String addExtension(String fileName, String ext) {
        if (fileName != null) {
            int dotIndex = fileName.indexOf(".");
            fileName = dotIndex >= 0 ? fileName.substring(0, dotIndex) + ext : fileName + ext;
        }
        return fileName;
    }

    private String getExcelDate(Cell cell) {
        if (CellType.DATE.equals(cell.getType())) {
            DateCell d = (DateCell)cell;
            SimpleDateFormat dataTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dataTimeFormat.format(d.getDate());
        }
        return cell.getContents();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("MasterDataModel.Entry.*"));
        return sic;
    }
}

