/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.CompanyUtils;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.tree.TreeBaseRender;
import com.kingdee.eas.framework.bireport.bimanager.util.tree.TreeTableRenderUtil;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.List;

public class UIHelper {
    public static void verifyTableRequire(CoreUIObject ui, KDTable table) {
        UIHelper.verifyTableRequire(ui, table, null);
    }

    public static void verifyTableRequire(CoreUIObject ui, KDTable table, String tableName) {
        if (ui == null || table == null) {
            return;
        }
        if (tableName == null) {
            tableName = "";
        }
        IColumn column = null;
        ICell cell = null;
        int columns = table.getColumnCount();
        int rows = table.getRowCount();
        for (int i = 0; i < columns; ++i) {
            column = table.getColumn(i);
            if (column == null || !column.isRequired()) continue;
            for (int j = 0; j < rows; ++j) {
                cell = table.getCell(j, i);
                if (cell != null && cell.getValue() != null) continue;
                MsgBox.showWarning((Component)ui, (String)(tableName + Constant.Di + (j + 1) + Constant.Row + table.getHeadRow(0).getCell(i).getValue() + Constant.NotBeNull));
                SysUtil.abort();
            }
        }
    }

    public static void calculateTotalRow(CoreUIObject ui, KDTable table, IRow footRow, List totalFieldList) {
        int size = totalFieldList.size();
        for (int i = 0; i < size; ++i) {
            String filedName = (String)totalFieldList.get(i);
            double total = 0.0;
            int rows = table.getBody().size();
            for (int j = 0; j < rows; ++j) {
                Object value = table.getCell(j, filedName).getValue();
                try {
                    if (value instanceof Number) {
                        total += ((Number)value).doubleValue();
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    total += new Double((String)value).doubleValue();
                    continue;
                }
                catch (Exception e) {
                    MsgBox.showInfo((Component)ui, (String)"\u5408\u8ba1\u5217\u503c\u4e0d\u6b63\u786e");
                    SysUtil.abort();
                }
            }
            footRow.getCell(filedName).setValue((Object)new Double(total));
        }
    }

    public static void setTableTitle(DetailPanel detailPanel, String title, int titleLength) {
        KDPanel controlPanel = null;
        Component[] comp = detailPanel.getComponents();
        int size = comp.length;
        block0: for (int i = 0; i < size; ++i) {
            if (!"controlPanel".equals(comp[i].getName())) continue;
            controlPanel = (KDPanel)comp[i];
            Component[] conComp = controlPanel.getComponents();
            int length = conComp.length;
            for (int j = 0; j < length; ++j) {
                if (!"kdDetailCon".equals(conComp[j].getName())) continue;
                controlPanel.remove(conComp[j]);
                break block0;
            }
            break;
        }
        KDContainer kdConTitle = new KDContainer();
        kdConTitle.setName("kdDetailCon");
        kdConTitle.setBounds(0, 5, titleLength, 24);
        kdConTitle.setContainerType(2);
        kdConTitle.setTitle(title);
        kdConTitle.setTitleStyle(1);
        if (null != controlPanel) {
            controlPanel.add((Component)kdConTitle, (Object)new KDLayout.Constraints(0, 5, titleLength, 19, 5));
        }
    }

    public static boolean isAllFalse(KDTable tbl, String columnKey) {
        int[] selects = KDTableUtil.getSelectedRows((KDTable)tbl);
        if (selects == null || selects.length == 0) {
            return false;
        }
        IColumn column = tbl.getColumn(columnKey);
        if (column == null) {
            return false;
        }
        for (int i = 0; i < selects.length; ++i) {
            Object value = tbl.getRow(selects[i]).getCell(columnKey).getValue();
            if ("false".equals(value.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllTrue(KDTable tbl, String columnKey) {
        int[] selects = KDTableUtil.getSelectedRows((KDTable)tbl);
        if (selects == null || selects.length == 0) {
            return false;
        }
        IColumn column = tbl.getColumn(columnKey);
        if (column == null) {
            return false;
        }
        for (int i = 0; i < selects.length; ++i) {
            Object value = tbl.getRow(selects[i]).getCell(columnKey).getValue();
            if ("true".equals(value.toString())) continue;
            return false;
        }
        return true;
    }

    public static void initCompanyTree(final KDTable tbl) throws Exception {
        tbl.removeRows();
        FullOrgUnitCollection collections = CompanyUtils.getUserOrgRangeOUs();
        UIHelper.initTree(collections, tbl);
        TreeTableRenderUtil.setTreeDisplayStyle(tbl, 0, tbl.getRowCount(), true);
        final TreeBaseRender treeRenderForCostAccount = new TreeBaseRender();
        tbl.getColumn("number").setRenderer((IBasicRender)treeRenderForCostAccount);
        tbl.getColumn("number").getStyleAttributes().setNumberFormat("@");
        tbl.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    TreeTableRenderUtil.tableClicked(e, tbl, treeRenderForCostAccount);
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        });
    }

    private static void initTree(FullOrgUnitCollection collections, KDTable tbl) {
        for (int i = 0; i < collections.size(); ++i) {
            FullOrgUnitInfo info = collections.get(i);
            IRow row = tbl.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("isLeaf").setValue((Object)(info.isIsLeaf() ? Boolean.TRUE : Boolean.FALSE));
            row.getCell("level").setValue((Object)new Integer(info.getLevel()));
            row.getCell("parent.id").setValue(info.getParent() == null ? null : info.getParent().getId().toString());
            row.getCell("longNumber").setValue((Object)info.getLongNumber());
            CompanyOrgUnitInfo comp = new CompanyOrgUnitInfo();
            comp.setId(info.getId());
            comp.setName(info.getName());
            row.getCell("company").setValue((Object)comp);
            row.getCell("simpleName").setValue((Object)info.getSimpleName());
        }
    }

    public static boolean isSame(Object newValue, Object oldValue) {
        if (newValue == null && oldValue == null) {
            return true;
        }
        if (newValue != null) {
            return newValue.equals(oldValue);
        }
        if (oldValue != null) {
            return oldValue.equals(newValue);
        }
        return false;
    }
}

