/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.client;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.util.LostStrategy;
import com.kingdee.eas.framework.bireport.bimanager.util.PeriodSetUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.client.F7ListUISelector;
import com.kingdee.eas.framework.bireport.bimanager.ws.LostStrategy_WS;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.AbstractWsDispatchSchemeEditUI;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.WSLostStrategyUI;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.WsExtractSchemeListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class WsDispatchSchemeEditUI
extends AbstractWsDispatchSchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WsDispatchSchemeEditUI.class);
    private WsDispatchSchemeGroupInfo groupInfo = null;
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.ws.client.WsClientResource";
    String periodXml = null;

    @Override
    public void onLoad() throws Exception {
        this.initTable();
        super.onLoad();
        this.txtPeriod.setEditable(false);
        this.periodXml = this.editData.getPeriod();
        if (this.periodXml != null) {
            this.txtPeriod.setText(PeriodSetUtil.toScheduleTime(this.periodXml));
        }
        this.btnAdd.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_AddLine"));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnMinus.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_RemoveLine"));
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDContainer1.addButton((JButton)this.btnAdd);
        this.kDContainer1.addButton((JButton)this.btnMinus);
        this.tblScheme.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                String columnKey = WsDispatchSchemeEditUI.this.tblScheme.getColumnKey(colIndex);
                if ("wsScheme".equalsIgnoreCase(columnKey)) {
                    WsDispatchSchemeEditUI.this.tblScheme.getRow(rowIndex).getCell("lostStra").setValue(null);
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPeriod.setIcon(EASResource.getIcon((String)"imgTbtn_slackentimesetting"));
    }

    @Override
    protected void btnPeriod_actionPerformed(ActionEvent e) throws Exception {
        try {
            PeriodSetUtil util = new PeriodSetUtil();
            this.periodXml = util.getPeriodXml((CoreUI)this, this.periodXml);
            this.txtPeriod.setText(PeriodSetUtil.toScheduleTime(this.periodXml));
            this.txtPeriodBind.setText(this.periodXml);
        }
        catch (LinkageError e1) {
            WindowUtil.msgboxWarning((Object)"\u975eEAS\u73af\u5883\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u8c03\u5ea6\u65f6\u95f4\u5468\u671f\uff01", (String)"\u7cfb\u7edf\u63d0\u793a", (Component)((Object)this));
            logger.error((Object)"error", (Throwable)e1);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e2);
            logger.error((Object)"error", (Throwable)e2);
        }
    }

    @Override
    public void storeFields() {
        for (int i = 0; i < this.tblScheme.getRowCount(); ++i) {
            Object value = this.tblScheme.getRow(i).getCell("lostStra").getValue();
            if (!(value instanceof LostStrategy)) continue;
            this.tblScheme.getRow(i).getCell("lostStra").setValue((Object)((LostStrategy)value).toSaveString());
        }
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setLostStrategy();
    }

    private void setLostStrategy() {
        for (int i = 0; i < this.tblScheme.getRowCount(); ++i) {
            Object value = this.tblScheme.getRow(i).getCell("lostStra").getValue();
            if (value == null) continue;
            try {
                LostStrategy str2LostStrategy = LostStrategy_WS.str2LostStrategy(value.toString());
                this.tblScheme.getRow(i).getCell("lostStra").setValue((Object)str2LostStrategy);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initTable() throws Exception {
        this.tblScheme.checkParsed();
        this.tblScheme.getSelectManager().setSelectMode(2);
        KDBizPromptBox f7wsScheme = new KDBizPromptBox();
        f7wsScheme.setQueryInfo("com.kingdee.eas.framework.bireport.bimanager.ws.app.WsExtractSchemeQuery");
        f7wsScheme.setVisible(true);
        f7wsScheme.setEditable(false);
        f7wsScheme.setDisplayFormat("$name$");
        f7wsScheme.setEditFormat("$name$");
        F7ListUISelector.setListToPrmtF7HasSelector(f7wsScheme, (ListUI)new WsExtractSchemeListUI());
        KDTDefaultCellEditor schemeEditor = new KDTDefaultCellEditor((IKDEditor)f7wsScheme);
        this.tblScheme.getColumn("wsScheme").setEditor((ICellEditor)schemeEditor);
        KDBizPromptBox f7lostStra = new KDBizPromptBox();
        f7lostStra.setSelector(new KDPromptSelector(){
            private WSLostStrategyUI lostStraUI = null;

            public Object getData() {
                Object data = null;
                if (this.lostStraUI != null) {
                    data = this.lostStraUI.getData();
                }
                return data;
            }

            public boolean isCanceled() {
                if (this.lostStraUI != null) {
                    return this.lostStraUI.isCancel;
                }
                return false;
            }

            public void show() {
                try {
                    UIContext uiContext = new UIContext((Object)WsDispatchSchemeEditUI.this);
                    int row = KDTableUtil.getSelectedRow((KDTable)WsDispatchSchemeEditUI.this.tblScheme);
                    if (row > -1) {
                        Object value = WsDispatchSchemeEditUI.this.tblScheme.getRow(row).getCell("lostStra").getValue();
                        uiContext.put((Object)"strategy", value);
                        value = WsDispatchSchemeEditUI.this.tblScheme.getRow(row).getCell("wsScheme").getValue();
                        if (value instanceof WsExtractSchemeInfo) {
                            WsExtractSchemeInfo wsInfo = (WsExtractSchemeInfo)value;
                            uiContext.put((Object)"isBatch", (Object)("" + wsInfo.isIsBatch()));
                        } else {
                            uiContext.put((Object)"isBatch", (Object)"false");
                        }
                    }
                    IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WSLostStrategyUI.class.getName(), (Map)uiContext, null);
                    window.show();
                    this.lostStraUI = (WSLostStrategyUI)window.getUIObject();
                }
                catch (UIException e) {
                    WsDispatchSchemeEditUI.this.handUIException(e);
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        f7lostStra.setEditable(false);
        KDTDefaultCellEditor lostEditor = new KDTDefaultCellEditor((IKDEditor)f7lostStra);
        this.tblScheme.getColumn("lostStra").setEditor((ICellEditor)lostEditor);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblScheme.addRow();
    }

    @Override
    protected void btnMinus_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblScheme.getSelectManager().size() == 0 || this.isTableColumnSelected(this.tblScheme)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"notSelect"));
            return;
        }
        int top = this.tblScheme.getSelectManager().get().getTop();
        if (this.tblScheme.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"notSelect"));
            return;
        }
        this.tblScheme.removeRow(top);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception e1) {
            this.setLostStrategy();
            throw e1;
        }
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.txtPeriod.setText(null);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String period;
        super.verifyInput(e);
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"numberIsNotNull"));
            SysUtil.abort();
        } else {
            char[] chs = number.trim().toCharArray();
            Pattern p = Pattern.compile("[a-zA-Z_0-9]");
            for (int i = 0; i < chs.length; ++i) {
                Matcher m = p.matcher(Character.toString(chs[i]));
                if (m.matches()) continue;
                this.txtNumber.requestFocus(true);
                MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"onlyCharOANum"));
                SysUtil.abort();
            }
        }
        Object objName = this.txtName.getDefaultLangItemData();
        if (objName == null || StringUtils.isEmpty((String)objName.toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"nameIsNotNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(period = this.txtPeriod.getText()))) {
            this.txtPeriod.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"periodIsNotNull"));
            SysUtil.abort();
        }
        if (this.tblScheme.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"schemeIsNotNull"));
            SysUtil.abort();
        }
        for (int r = this.tblScheme.getRowCount() - 1; r >= 0; --r) {
            IRow row = this.tblScheme.getRow(r);
            for (int c = this.tblScheme.getColumnCount() - 1; c >= 0; --c) {
                ICell cell = row.getCell(c);
                if (cell.getValue() != null) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"dataNotIntegrity"));
                SysUtil.abort();
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.tblScheme.getRowCount(); ++i) {
            IRow row = this.tblScheme.getRow(i);
            Object value = row.getCell("wsScheme").getValue();
            if (!(value instanceof IObjectValue)) continue;
            String cellID = ((IObjectValue)value).get("id").toString();
            if (map.containsKey(cellID)) {
                MsgBox.showInfo((String)("\u7b2c" + ((Integer)map.get(cellID) + 1) + "\u884c\u4e0e\u7b2c" + (i + 1) + "\u884cWeb Service\u65b9\u6848\u4e00\u81f4!"));
                SysUtil.abort();
            }
            map.put(cellID, new Integer(i));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        WsDispatchSchemeInfo info = new WsDispatchSchemeInfo();
        info.setIsUsed(false);
        info.setIsExecute(false);
        Object objGroup = this.getUIContext().get("groupInfo");
        if (objGroup instanceof WsDispatchSchemeGroupInfo) {
            info.setGroup((WsDispatchSchemeGroupInfo)objGroup);
        }
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WsDispatchSchemeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }
}

