/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSEngineInvokeFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.AbstractWsExtractSchmePKDefineUI;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.TTableColumnType;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class WsExtractSchmePKDefineUI
extends AbstractWsExtractSchmePKDefineUI {
    private static final Logger logger = CoreUIObject.getLogger(WsExtractSchmePKDefineUI.class);

    @Override
    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.refreshTable();
        this.loadPKField();
        this.txtWSName.setEnabled(false);
        this.txtWSNumber.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                for (int i = 0; i < WsExtractSchmePKDefineUI.this.tblMain.getRowCount(); ++i) {
                    if (i == rowIndex) continue;
                    WsExtractSchmePKDefineUI.this.tblMain.getRow(i).getCell("isPK").setValue((Object)Boolean.FALSE);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadPKField();
    }

    private void loadPKField() {
        if (this.editData.getPKfieldNames() != null) {
            String[] spilt = this.editData.getPKfieldNames().split(";");
            if (spilt == null || spilt.length == 0) {
                return;
            }
            block0: for (int i = 0; i < spilt.length; ++i) {
                String string = spilt[i];
                for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
                    Object value = this.tblMain.getRow(j).getCell("fieldName").getValue();
                    if (!string.startsWith(value.toString().toUpperCase() + ",")) continue;
                    this.tblMain.getRow(j).getCell("isPK").setValue((Object)Boolean.TRUE);
                    continue block0;
                }
            }
        }
    }

    public void refreshTable() throws Exception {
        String storeTable = this.editData.getODSStoreTable(null);
        if (storeTable == null) {
            WSEngineInvokeFacadeFactory.getRemoteInstance().checkSchemeTableColumn(this.editData.getId().toString());
            storeTable = this.editData.getODSStoreTable(null);
        }
        String schemeID = this.editData.getBIProjectScheme().getId().toString();
        Map map = WSEngineInvokeFacadeFactory.getRemoteInstance().getTableStruct(storeTable, schemeID, "ods");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String fieldName = iterator.next().toString();
            if ("FUrgeLoadTime".equalsIgnoreCase(fieldName) || "FUrgeCompanyID".equalsIgnoreCase(fieldName) || "FwsfactDataID".equalsIgnoreCase(fieldName)) continue;
            IRow row = this.tblMain.addRow();
            row.getCell("fieldName").setValue((Object)fieldName);
            row.getCell("type").setValue((Object)TTableColumnType.getTypeDescription(map.get(fieldName).toString()));
            row.getCell("isPK").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object cell = this.tblMain.getRow(i).getCell("isPK").getValue();
            if (Boolean.FALSE.equals(cell)) continue;
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append(this.tblMain.getRow(i).getCell("fieldName").getValue());
            sb.append(",");
            sb.append(TTableColumnType.getTypeByDescription(this.tblMain.getRow(i).getCell("type").getValue().toString()));
        }
        this.editData.setPKfieldNames(sb.toString());
    }

    @Override
    protected IObjectValue createNewData() {
        return super.createNewData();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WsExtractSchemeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("pKfieldNames"));
        sic.add(new SelectorItemInfo("BIProjectScheme"));
        return sic;
    }
}

