/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.engine;

import com.kingdee.eas.framework.bireport.bimanager.util.CleanStreamUtils;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.PageDataStoreHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.Task;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.WebServiceLogger;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.WSPageData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;

public class PageDataFileStoreHandler
implements PageDataStoreHandler {
    private String path = "pagedata";

    public PageDataFileStoreHandler() {
        new File(this.path).mkdir();
    }

    private String getFileName(Task task, WSPageData pageData) {
        return this.getFileName(task, pageData.getPageIndex());
    }

    private String getFileName(Task task, int pageIndex) {
        String name = this.path + File.separator + task.getTaskId() + "_" + task.getRequestId() + "." + pageIndex;
        return FilenameUtils.normalize((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePage(Task task, WSPageData pageData) throws Exception {
        FileOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            String fileName = this.getFileName(task, pageData);
            WebServiceLogger.logTask(task, "\u4fdd\u5b58\u5206\u9875\u6587\u4ef6:" + new File(fileName).getAbsolutePath());
            bos = new FileOutputStream(fileName);
            os = new ObjectOutputStream(bos);
            os.writeObject(pageData);
        }
        catch (Throwable throwable) {
            CleanStreamUtils.close(os, bos);
            throw throwable;
        }
        CleanStreamUtils.close(os, bos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WSPageData loadPage(Task task, int pageIndex) throws Exception {
        WSPageData wSPageData;
        String fileName = this.getFileName(task, pageIndex);
        WebServiceLogger.logTask(task, "\u52a0\u8f7d\u5206\u9875\u6587\u4ef6:" + new File(fileName).getAbsolutePath());
        FileInputStream bis = new FileInputStream(fileName);
        ObjectInputStream is = null;
        try {
            is = new ObjectInputStream(bis);
            wSPageData = (WSPageData)is.readObject();
        }
        catch (Throwable throwable) {
            CleanStreamUtils.close(bis, is);
            throw throwable;
        }
        CleanStreamUtils.close(bis, is);
        return wSPageData;
    }

    @Override
    public Iterator loadPages(final Task task) throws Exception {
        return new Iterator(){
            private int curPageIndex = 0;

            @Override
            public boolean hasNext() {
                return new File(PageDataFileStoreHandler.this.getFileName(task, this.curPageIndex)).exists();
            }

            public Object next() {
                try {
                    return PageDataFileStoreHandler.this.loadPage(task, this.curPageIndex++);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5206\u5305\u6570\u636e\u4e0d\u5b58\u5728\u3002", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator iterator(final WSPageData data) throws Exception {
        return new Iterator(){
            private int curPageIndex = 0;

            @Override
            public boolean hasNext() {
                return this.curPageIndex == 0;
            }

            public Object next() {
                ++this.curPageIndex;
                if (this.curPageIndex == 1) {
                    return data;
                }
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }
}

