/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.engine;

import com.kingdee.eas.framework.bireport.bimanager.ws.engine.Task;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.TaskLoggerHandler;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WebServiceLogger {
    private static SimpleDateFormat sdf = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static TaskLoggerHandler handler;

    public static void initHandler(String handlerCls) {
        if (handler == null && handlerCls != null) {
            try {
                WebServiceLogger.setHandler((TaskLoggerHandler)Class.forName(handlerCls.trim()).newInstance());
            }
            catch (Exception e) {
                WebServiceLogger.consoleLogError(e.getMessage());
            }
        }
    }

    public static void setHandler(TaskLoggerHandler handler) {
        WebServiceLogger.handler = handler;
    }

    public static void consoleLogInfo(String msg) {
        System.out.println(msg);
    }

    public static void consoleLogError(String msg) {
        System.err.println(msg);
    }

    public static void logTask(Task task, String msg) {
        if (handler == null) {
            WebServiceLogger.consoleLogInfo(sdf.format(new Date()) + "\u4efb\u52a1=" + task.getName() + "\uff0c\u6d88\u606f\uff1a" + msg);
        } else {
            handler.log(new Date(), task, msg);
        }
    }
}

