/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit;

import com.kingdee.eas.framework.bireport.bimanager.ws.engine.CallBackHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.Task;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.InvokeMethodFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.WSPageData;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.util.UUIDUtil;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientConfig;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientInstance;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.RemoteObjectFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientAgent {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.etl.app.ClientAgent");
    private ClientInstance instance;
    private long sessionId = 0L;

    public String getURL() {
        return this.instance.getConfig().getUrl();
    }

    public String getConfigFileName() {
        return System.getProperty("EAS_INSTANCE_CONFIG_PATH") + "/" + "biKettleConfig.properties";
    }

    public ClientAgent(long sessionId) {
        this("default", sessionId, "biKettleConfig.properties");
    }

    public ClientAgent(String instanceName, long sessionId, String configFile) {
        this.sessionId = sessionId;
        this.instance = new ClientInstance(instanceName, sessionId, configFile);
    }

    public ClientAgent(long sessionId, String url, String user, String psw) {
        this.sessionId = sessionId;
        ClientConfig config = new ClientConfig("biKettleConfig.properties");
        config.setUrl(url);
        config.setUser(user);
        config.setPassword(psw);
        this.instance = new ClientInstance("default", sessionId, config);
    }

    public ClientAgent(long sessionId, String url) {
        this.sessionId = sessionId;
        ClientConfig config = new ClientConfig("biKettleConfig.properties");
        config.setUrl(url);
        this.instance = new ClientInstance("default", sessionId, config);
    }

    public ClientInstance client() {
        return this.instance;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public static Task createBaseTask(String name, long sessionId) {
        logger.info((Object)"TestForHL creatTask");
        Task task = new Task();
        task.setName(name);
        task.setSessionId(sessionId);
        task.setTaskId(UUIDUtil.uuid());
        task.setRequestId(UUIDUtil.uuid());
        logger.info((Object)"TestForHL creatTask complite!");
        return task;
    }

    public List getDataBases() throws Exception {
        Task task = ClientAgent.createBaseTask("\u83b7\u53d6\u6570\u636e\u5e93", this.sessionId);
        task.setMethod(InvokeMethodFactory.getDataBases());
        logger.info((Object)"TestForHL  getDataBase");
        return (List)this.instance.execute(task);
    }

    public Object getWSDL() throws Exception {
        Task task = ClientAgent.createBaseTask("\u83b7\u53d6WSDLURL", this.sessionId);
        task.setMethod(InvokeMethodFactory.getWSDLURL());
        return this.instance.execute(task);
    }

    public List getTables(String dbId) throws Exception {
        Task task = ClientAgent.createBaseTask("\u83b7\u53d6\u6570\u636e\u5e93(" + dbId + ")\u6240\u6709\u8868", this.sessionId);
        task.setMethod(InvokeMethodFactory.getTables(dbId));
        return (List)this.instance.execute(task);
    }

    public List getTableColumns(String dbId, String tableName) throws Exception {
        Task task = ClientAgent.createBaseTask("\u83b7\u53d6\u8868" + tableName + "\u7ed3\u6784", this.sessionId);
        task.setMethod(InvokeMethodFactory.getTableColumns(dbId, tableName));
        return (List)this.instance.execute(task);
    }

    public void queryByBizMethod(String dbId, String methodName, Map params, CallBackHandler cb, Object userObject) throws Exception {
        Task task = ClientAgent.createBaseTask("\u8c03\u7528\u4e1a\u52a1\u65b9\u6cd5(" + methodName + ")", this.sessionId);
        task.setMethod(InvokeMethodFactory.queryByBizMethod(dbId, methodName, params));
        task.setUserObject(userObject);
        this.instance.execute(task, cb);
    }

    public List getBizMethods() throws Exception {
        Task task = ClientAgent.createBaseTask("\u83b7\u53d6\u6240\u6709\u4e1a\u52a1\u670d\u52a1\u65b9\u6cd5", this.sessionId);
        task.setMethod(InvokeMethodFactory.getBizMethods());
        return (List)this.instance.execute(task);
    }

    public void queryByTable(String dbId, String tableName, String timestampField, Timestamp fromTs, Timestamp toTs, CallBackHandler cb, Object userObject) throws Exception {
        Task task = ClientAgent.createBaseTask("\u6839\u636e\u8868\u540d(" + tableName + ")\u67e5\u8be2\u6570\u636e", this.sessionId);
        task.setMethod(InvokeMethodFactory.queryByTable(dbId, tableName, timestampField, fromTs, toTs));
        task.setUserObject(userObject);
        this.instance.execute(task, cb);
    }

    public void queryBySql(String dbId, String sql, CallBackHandler cb, Object userObject) throws Exception {
        Task task = ClientAgent.createBaseTask("\u6839\u636eSQL(" + sql.hashCode() + ")\u67e5\u8be2\u6570\u636e", this.sessionId);
        task.setMethod(InvokeMethodFactory.queryBySql(dbId, sql));
        task.setUserObject(userObject);
        this.instance.execute(task, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map queryBySql(String dbId, String sql, int limit) throws Exception {
        Task task = ClientAgent.createBaseTask("\u6839\u636eSQL(" + sql.hashCode() + ")\u67e5\u8be2\u6570\u636e", this.sessionId);
        Object lock = new Object();
        HashMap map = new HashMap();
        SQLCallBackHandler handler = new SQLCallBackHandler(lock, map, limit);
        task.setMethod(InvokeMethodFactory.queryBySql(dbId, sql));
        this.instance.execute(task, handler);
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
        return map;
    }

    public Object createRemoteInstance(Class cls) {
        return RemoteObjectFactory.getRemoteInstance(cls, this);
    }

    public Object createRemoteInstance(Class cls, CallBackHandler allCallBackHandler) {
        return RemoteObjectFactory.getRemoteInstance(cls, this, allCallBackHandler);
    }

    class SQLCallBackHandler
    implements CallBackHandler {
        private Object lock = null;
        private Map map;
        private int limit = 0;

        SQLCallBackHandler(Object lock, Map map, int limit) {
            this.lock = lock;
            this.map = map;
            this.limit = limit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void error(Task task, Exception e) {
            this.map.put("exception", e);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void success(Task task, Object data) {
            Iterator iter = (Iterator)data;
            boolean first = true;
            ArrayList<Object> list = new ArrayList<Object>();
            boolean huaFull = false;
            block3: while (iter.hasNext() && !huaFull) {
                WSPageData pageData = (WSPageData)iter.next();
                if (first) {
                    this.map.put("columnNames", pageData.getColumnNames());
                    this.map.put("type", pageData.getType());
                }
                first = false;
                for (int i = 0; i < pageData.getRowCount(); ++i) {
                    list.add(pageData.getRecordRow(i));
                    if (list.size() >= this.limit) {
                        huaFull = true;
                    }
                    if (huaFull) continue block3;
                }
            }
            this.map.put("rowSet", list);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }
}

