/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.util;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.eas.framework.report.util.RptRowSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;

public class UIUtil {
    public static KDContainer createContainer(String title, Component comp) {
        KDContainer c = new KDContainer();
        c.setTitleStyle(1);
        c.setEnableActive(false);
        c.setTitle(title);
        c.getContentPane().setLayout(new BorderLayout(0, 0));
        c.getContentPane().add(comp, "Center");
        return c;
    }

    public static Frame peekFrame(Component c) {
        Component p = c;
        while (!(p instanceof Frame)) {
            if ((p = p.getParent()) != null) continue;
            return null;
        }
        return (Frame)p;
    }

    public static Dialog peekDialog(Component c) {
        Component p = c;
        while (!(p instanceof Dialog)) {
            if ((p = p.getParent()) != null) continue;
            return null;
        }
        return (Dialog)p;
    }

    public static void center(Window w) {
        Dimension dd = Toolkit.getDefaultToolkit().getScreenSize();
        w.setLocation((dd.width - w.getWidth()) / 2, (dd.height - w.getHeight()) / 2);
    }

    public static void refreshTable(RptRowSet rowSet, KDTable tbl, int limit) {
        String[] columnNames = rowSet.getColumnNames();
        int length = columnNames.length;
        tbl.removeColumns();
        for (int i = 0; i < length; ++i) {
            IColumn addColumn = tbl.addColumn();
            addColumn.setKey(columnNames[i]);
            addColumn.getStyleAttributes().setLocked(true);
        }
        IRow headRow = tbl.addHeadRow();
        for (int i = 0; i < length; ++i) {
            headRow.getCell(i).setValue((Object)columnNames[i]);
        }
        while (rowSet.next() && limit > 0) {
            --limit;
            IRow row = tbl.addRow();
            for (int i = 0; i < length; ++i) {
                row.getCell(i).setValue(rowSet.getObject(i));
            }
        }
    }
}

