/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.base.util;

import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipFileUtils {
    private static Logger logger = Logger.getLogger(ZipFileUtils.class);

    public static void zipFile(String inputPath, String basePath, String zipFileName, int compressLevel) throws Exception {
        ZipFileUtils.zipFile(inputPath, basePath, zipFileName, compressLevel, null);
    }

    public static void zipFile(String inputPath, String zipFileName, int compressLevel) throws Exception {
        ZipFileUtils.zipFile(inputPath, inputPath, zipFileName, compressLevel, null);
    }

    public static void zipFile(String inputPath, String zipFileName, int compressLevel, FileFilter filter) throws Exception {
        ZipFileUtils.zipFile(inputPath, inputPath, zipFileName, compressLevel, filter);
    }

    public static void zipFile(String inputPath, String basePath, String zipFileName, int compressLevel, FileFilter filter) throws Exception {
        File zf = new File(zipFileName);
        zf.getParentFile().mkdirs();
        compressLevel = ZipFileUtils.checkZipLevel(compressLevel);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFileName));){
            zos.setLevel(compressLevel);
            basePath = new File(basePath).getCanonicalPath();
            if (basePath.endsWith(File.separator)) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            ZipFileUtils.recurse(new File(inputPath), filter, zos, basePath);
        }
    }

    private static int checkZipLevel(int level) {
        if (level < 0 || level > 9) {
            level = -1;
        }
        return level;
    }

    private static void recurse(File file, FileFilter filter, ZipOutputStream zos, String basePath) throws Exception {
        if (!file.exists()) {
            logger.warn((Object)(file + " not exists!"));
            return;
        }
        File[] children = (file = file.getCanonicalFile()).listFiles(filter);
        if (children == null) {
            logger.warn((Object)(file + " hasn't files!"));
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.getCanonicalPath().indexOf(basePath) < 0) continue;
            if (child.isDirectory()) {
                ZipFileUtils.recurse(child, filter, zos, basePath);
                continue;
            }
            String parentPath = child.getParent();
            String curPath = parentPath.substring(basePath.length());
            if (curPath.startsWith(File.separator)) {
                curPath = curPath.substring(1);
            }
            if (!"".equals(curPath) && !curPath.endsWith(File.separator)) {
                curPath = curPath + File.separator;
            }
            String entryName = curPath + child.getName();
            entryName = entryName.replace('\\', '/');
            ZipEntry entry = new ZipEntry(entryName);
            zos.putNextEntry(entry);
            byte[] buf = new byte[1024];
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(child));){
                int len;
                while ((len = in.read(buf)) >= 0) {
                    zos.write(buf, 0, len);
                }
            }
            entry.setTime(child.lastModified());
            zos.closeEntry();
        }
    }

    public static void zipFile(String inputPath, String basePath, String zipFileName) throws Exception {
        ZipFileUtils.zipFile(inputPath, basePath, zipFileName, -1);
    }

    public static void zipFile(String inputPath, String zipFileName) throws Exception {
        ZipFileUtils.zipFile(inputPath, inputPath, zipFileName, -1);
    }

    public static void zipFile(String inputPath, String basePath, String zipFileName, FileFilter filter) throws Exception {
        ZipFileUtils.zipFile(inputPath, basePath, zipFileName, -1, filter);
    }

    public static void zipFile(String inputPath, String zipFileName, FileFilter filter) throws Exception {
        ZipFileUtils.zipFile(inputPath, inputPath, zipFileName, -1, filter);
    }

    public static void jarFile(String inputPath, String basePath, String jarFileName, int compressLevel, Manifest man, FileFilter filter) throws Exception {
        ZipFileUtils.jarFile(inputPath, basePath, jarFileName, compressLevel, man, filter, -1L);
    }

    public static void jarFile(String inputPath, String basePath, String jarFileName, int compressLevel, Manifest man, FileFilter filter, long time) throws Exception {
        File jf = new File(jarFileName);
        jf.getParentFile().mkdirs();
        compressLevel = ZipFileUtils.checkZipLevel(compressLevel);
        try (JarOutputStream zos = new JarOutputStream((OutputStream)new FileOutputStream(jf), man);){
            zos.setLevel(compressLevel);
            basePath = new File(basePath).getCanonicalPath();
            if (basePath.endsWith(File.separator)) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            ZipFileUtils.recurse(new File(inputPath), filter, zos, basePath);
            if (time > 0L) {
                jf.setLastModified(time);
            }
        }
    }

    public static void jarFile(String inputPath, String jarFileName, Manifest man, FileFilter filter) throws Exception {
        ZipFileUtils.jarFile(inputPath, inputPath, jarFileName, -1, man, filter);
    }

    public static void jarFile(String inputPath, String jarFileName, Manifest man, FileFilter filter, long time) throws Exception {
        ZipFileUtils.jarFile(inputPath, inputPath, jarFileName, -1, man, filter, time);
    }

    public static void jarFile(String inputPath, String basePath, String jarFileName, int compressLevel, Manifest man) throws Exception {
        ZipFileUtils.jarFile(inputPath, basePath, jarFileName, compressLevel, man, null);
    }

    public static void jarFile(String inputPath, String basePath, String jarFileName, Manifest man) throws Exception {
        ZipFileUtils.jarFile(inputPath, basePath, jarFileName, -1, man);
    }

    private static void unZipFile(String zipFileName, String outPath, boolean replace, String ignoreDirName) throws Exception {
        ZipFileUtils.unZipFile(zipFileName, outPath, replace, ignoreDirName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(String zipFileName, String outPath, boolean replace, String ignoreDirName, String suffix) throws Exception {
        File infile = new File(zipFileName);
        try (ZipFile zip = null;){
            zip = new ZipFile(infile);
        }
        File newdir = new File(outPath);
        if (!newdir.exists()) {
            newdir.mkdirs();
        }
        ZipInputStream in = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(infile);
            in = new ZipInputStream(fis);
            ZipEntry entry = in.getNextEntry();
            if (!StringUtils.isEmpty(ignoreDirName)) {
                while (entry != null && entry.getName().indexOf(ignoreDirName) != -1) {
                    entry = in.getNextEntry();
                }
            }
            if (!StringUtils.isEmpty(suffix)) {
                while (entry != null && !entry.getName().endsWith(suffix)) {
                    entry = in.getNextEntry();
                }
            }
            byte[] c = new byte[1024];
            while (entry != null) {
                if (entry.isDirectory()) {
                    File dirs = new File(outPath + File.separator + entry.getName());
                    if (!dirs.exists()) {
                        dirs.mkdirs();
                        dirs.setLastModified(entry.getTime());
                    }
                } else {
                    String sFileName = outPath + File.separator + entry.getName();
                    File curFile = new File(sFileName);
                    if (curFile.exists() && replace || !curFile.exists()) {
                        if (!curFile.getParentFile().exists()) {
                            curFile.getParentFile().mkdirs();
                        }
                        FileOutputStream out = null;
                        try {
                            int slen;
                            out = new FileOutputStream(curFile);
                            while ((slen = in.read(c, 0, c.length)) != -1) {
                                out.write(c, 0, slen);
                            }
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException e) {
                                    logger.error((Object)e.getMessage());
                                }
                            }
                        }
                        curFile.setLastModified(entry.getTime());
                    }
                }
                entry = in.getNextEntry();
                if (!StringUtils.isEmpty(ignoreDirName)) {
                    while (entry != null && entry.getName().indexOf(ignoreDirName) != -1) {
                        entry = in.getNextEntry();
                    }
                }
                if (StringUtils.isEmpty(suffix)) continue;
                while (entry != null && !entry.getName().endsWith(suffix)) {
                    entry = in.getNextEntry();
                }
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in, fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in, fis});
    }

    public static void unZipFile(String zipFileName, String outPath, boolean replace) throws Exception {
        ZipFileUtils.unZipFile(zipFileName, outPath, replace, null);
    }

    public static void unZipFile(String zipFileName, String outPath) throws Exception {
        ZipFileUtils.unZipFile(zipFileName, outPath, true);
    }

    public static void unZipFile(String zipFileName, String outPath, String suffix) throws Exception {
        ZipFileUtils.unZipFile(zipFileName, outPath, true, null, suffix);
    }

    public static void unJarFile(String jarFileName, String outPath, boolean replace) throws Exception {
        ZipFileUtils.unZipFile(jarFileName, outPath, replace, "META-INF");
    }

    public static void unJarFile(String jarFileName, String outPath) throws Exception {
        ZipFileUtils.unZipFile(jarFileName, outPath, true, "META-INF");
    }

    public static void main(String[] args) throws Exception {
        ZipFileUtils.zipFile("D:/temp2/bd", "D:/temp2/bd", "D:/temp2/jm.jar");
    }
}

