/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata;

import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BaseDataSynInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MidBillDefiner {
    private static Logger logger = Logger.getLogger(MidBillDefiner.class);
    private static final MidBillDefiner billDefiner = new MidBillDefiner();
    private Map<String, BaseDataSynInfo> billMappings = Collections.synchronizedMap(new LinkedHashMap());

    private MidBillDefiner() {
    }

    public static final MidBillDefiner getInstance() {
        return billDefiner;
    }

    private void sleep() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBillMappingUpdated(String number) {
        logger.info((Object)("\u5355\u636e" + number + "\u5df2\u8fc7\u671f..."));
        Map<String, BaseDataSynInfo> map = this.billMappings;
        synchronized (map) {
            this.billMappings.remove(number);
        }
    }

    private void ensurePkTableCreate(BaseDataSynInfo baseDataSynInfo) {
        Connection con = null;
        try {
            con = null;
            if (SQLUtil.isTableExists(con, baseDataSynInfo.getPkTableName())) {
                return;
            }
            BaseDataSynInfo.ColumnEntry pkColumn = baseDataSynInfo.getPkColumn();
            int colPrecision = Integer.parseInt(pkColumn.getcolDataPrecision());
            int colScale = Integer.parseInt(pkColumn.getcolDataScale());
            int colLength = Integer.parseInt(pkColumn.getcolDataLength());
            StringBuilder sb = new StringBuilder("create table  " + baseDataSynInfo.getPkTableName());
            sb.append(" (");
            sb.append("headpk").append(" ").append(SQLUtil.getDefinedDataType(pkColumn.getcolDataType(), colLength, colPrecision, colScale));
            sb.append(", transmitSerialNumber varchar(44)");
            sb.append(", transmitChunkedNumber int");
            sb.append(", hashCode varchar(64)");
            sb.append(", status int");
            sb.append(");");
            String mappingId = baseDataSynInfo.getPkTableName().replace("T_Z_", "").replace("\"", "");
            String createPkIndexSql = "create index \"IDX_EIP_" + mappingId + "\" on " + baseDataSynInfo.getPkTableName() + "(" + "headpk" + ");";
            String createTransmitSerialNumberIndexSql = "create index \"IDX_EIP_" + mappingId + "_SN\" on " + baseDataSynInfo.getPkTableName() + "(transmitSerialNumber);";
            SQLUtil.executeUpdate(con, new String[]{sb.toString(), createPkIndexSql, createTransmitSerialNumberIndexSql});
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            SQLUtil.cleanup(con);
        }
    }
}

