/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.model;

import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StructuredDataModel
implements Serializable {
    private static final long serialVersionUID = 2357973549216849724L;
    private boolean isCompleted;
    private TableModel[] tables;
    private TableModel hostTable;
    private TableModel[] priorityTables;
    private List priorityTablesRelation;
    public static final int DATASOURCE_DB = 1;
    public static final int DATASOURCE_FILE = 2;
    private int datasourceType;
    private String modelName;
    private String modelAlias;
    private Map modelProperties;

    public StructuredDataModel(String modelName, String modelAlias, Map modelProperties) {
        this.modelName = modelName;
        this.modelAlias = modelAlias;
        this.modelProperties = modelProperties == null ? new HashMap() : modelProperties;
    }

    public StructuredDataModel(String modelName, String modelAlias, TableModel[] tables) {
        this(modelName, modelAlias, new HashMap());
        this.tables = tables;
    }

    public StructuredDataModel(String modelName, String modelAlias, Map modelProperties, TableModel[] tables) {
        this(modelName, modelAlias, modelProperties);
        this.tables = tables;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelAlias() {
        return this.modelAlias;
    }

    public int getDatasourceType() {
        return this.datasourceType;
    }

    public Object getProperty(String name) {
        return this.modelProperties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.modelProperties.put(name, value);
    }

    public synchronized void addTable(TableModel table) throws Exception {
        this.checkReady();
        if (this.tables == null) {
            this.tables = new TableModel[1];
        } else {
            TableModel[] _tables = new TableModel[this.tables.length + 1];
            System.arraycopy(this.tables, 0, _tables, 0, this.tables.length);
            this.tables = _tables;
        }
        this.tables[this.tables.length - 1] = table;
    }

    public synchronized void addTableRelation(TableModel table1, TableModel table2, int relation) throws Exception {
        this.checkReady();
        table1.addRelation(table2, relation);
        switch (relation) {
            case 2: {
                table2.addRelation(table1, 1);
                break;
            }
            case 1: {
                table2.addRelation(table1, 2);
                break;
            }
        }
    }

    private void checkReady() throws Exception {
        if (this.isCompleted) {
            throw new Exception("forbidden modify the completed DataModel");
        }
    }

    public synchronized boolean isCompleted() {
        return this.isCompleted;
    }

    public TableModel[] getPriorityTables() {
        return this.tables;
    }

    public List getPriorityTablesRelation() {
        return this.priorityTablesRelation;
    }

    public TableModel[] getTables() {
        return this.tables;
    }

    public synchronized void setCompleted() throws Exception {
        if (this.tables == null || this.tables.length == 0) {
            throw new Exception("\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728\u8868\u6a21\u578b");
        }
        this.checkReady();
        HashSet<TableModel> existTables = new HashSet<TableModel>();
        for (int i = 0; i < this.tables.length; ++i) {
            if (existTables.contains(this.tables[i])) {
                throw new Exception("\u6a21\u578b\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u8868\u540d'" + this.tables[i].name + "'");
            }
            existTables.add(this.tables[i]);
            this.checkTableModel(this.tables[i]);
            Map relations = this.tables[i].getTableRelations();
            if (relations == null || relations.size() == 0) {
                this.hostTable = this.tables[i];
                continue;
            }
            if (this.hostTable != null) continue;
            Set keySet = relations.keySet();
            boolean hasManyToOne = false;
            for (TableModel tableModel : keySet) {
                int relation = (Integer)relations.get(tableModel);
                if (2 != relation) continue;
                hasManyToOne = true;
                break;
            }
            if (hasManyToOne) continue;
            this.hostTable = this.tables[i];
        }
        if (this.hostTable == null) {
            throw new Exception("\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb\u4e0d\u6b63\u786e!");
        }
        ArrayList traversalPath = new ArrayList(this.tables.length);
        ArrayList priorityPath = new ArrayList(this.tables.length);
        this.processTableRelation(this.hostTable, traversalPath, priorityPath);
        if (priorityPath.size() != this.tables.length) {
            throw new Exception("\u6570\u636e\u6e90\u6570\u636e\u8868\u5173\u8054\u5173\u7cfb\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb!");
        }
        this.priorityTables = priorityPath.toArray(new TableModel[0]);
        this.priorityTablesRelation = this.prepareTableRelation(this.priorityTables);
        this.isCompleted = true;
    }

    private List prepareTableRelation(TableModel[] tableModels) {
        ArrayList<int[]> priorityTablesRelation = new ArrayList<int[]>();
        for (int i = 0; i < tableModels.length; ++i) {
            Map relations = tableModels[i].getTableRelations();
            Set entrySet = relations.entrySet();
            block1: for (Map.Entry entry : entrySet) {
                TableModel tableModel = (TableModel)entry.getKey();
                int relation = (Integer)entry.getValue();
                if (relation != 1) continue;
                for (int j = 0; j < tableModels.length; ++j) {
                    if (!tableModels[j].name.equals(tableModel.name)) continue;
                    int[] tablesRelation = new int[]{i, j, relation};
                    priorityTablesRelation.add(tablesRelation);
                    continue block1;
                }
            }
        }
        return priorityTablesRelation;
    }

    private void checkTableModel(TableModel tableModel) throws Exception {
    }

    private void processTableRelation(TableModel tableModel, List traversalPath, List priorityPath) {
        Map tRelations;
        if (traversalPath.size() == 0) {
            traversalPath.add(tableModel);
            priorityPath.add(tableModel);
        }
        if ((tRelations = tableModel.getTableRelations()) == null || tRelations.size() == 0) {
            return;
        }
        Set tEntrySet = tRelations.entrySet();
        for (Map.Entry tEntry : tEntrySet) {
            TableModel tTableModel = (TableModel)tEntry.getKey();
            if (traversalPath.contains(tTableModel)) continue;
            Map relations = tTableModel.getTableRelations();
            Set pEntrySet = relations.entrySet();
            for (Map.Entry entry : pEntrySet) {
                TableModel pTableModel = (TableModel)entry.getKey();
                int pRelation = (Integer)entry.getValue();
                if (pRelation != 2) continue;
                int index = priorityPath.indexOf(tTableModel);
                if (index != -1) {
                    if (priorityPath.contains(pTableModel)) continue;
                    priorityPath.add(index, pTableModel);
                    continue;
                }
                if (priorityPath.contains(pTableModel)) continue;
                priorityPath.add(pTableModel);
            }
            if (!priorityPath.contains(tTableModel)) {
                priorityPath.add(tTableModel);
            }
            traversalPath.add(tTableModel);
            if (tTableModel.getTableRelations() == null) continue;
            this.processTableRelation(tTableModel, traversalPath, priorityPath);
        }
    }

    public String toString() {
        return this.modelName + "(" + this.modelAlias + ")";
    }

    public int hashCode() {
        return this.modelName.hashCode();
    }

    public static class TableModel
    implements Serializable {
        private static final long serialVersionUID = 4984100858533057477L;
        public static final int RELATION_NONE = -1;
        public static final int RELATION_ONE_TO_MANY = 1;
        public static final int RELATION_MANY_TO_ONE = 2;
        public final String name;
        public final ColumnModel[] columns;
        public final ColumnModel pkColumn;
        public ColumnModel[] baseDataTypes;
        private transient Map tableRelations;

        public TableModel(String name, ColumnModel[] columns) {
            this.name = name;
            ColumnModel pkColumn = null;
            ArrayList<ColumnModel> _columns = new ArrayList<ColumnModel>();
            ArrayList<ColumnModel> baseDataTypes = new ArrayList<ColumnModel>();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].isPk) {
                    pkColumn = columns[i];
                    _columns.add(0, columns[i]);
                } else {
                    _columns.add(columns[i]);
                }
                if (columns[i].isPk || columns[i].baseDataType == null) continue;
                baseDataTypes.add(columns[i]);
            }
            this.columns = _columns.toArray(new ColumnModel[0]);
            this.pkColumn = pkColumn;
            this.baseDataTypes = baseDataTypes.toArray(new ColumnModel[0]);
        }

        void addRelation(TableModel relationTable, int relation) throws Exception {
            switch (relation) {
                case 1: 
                case 2: {
                    if (this.tableRelations == null) {
                        this.tableRelations = new HashMap();
                    }
                    this.tableRelations.put(relationTable, new Integer(relation));
                    break;
                }
                default: {
                    throw new Exception("\u672a\u77e5\u5173\u7cfb\u503c'" + relation + "'");
                }
            }
        }

        Map getTableRelations() {
            return this.tableRelations;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return ((TableModel)obj).name.equals(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

