/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.IBaseDataSaver;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataBatchInsertHelper;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataBatchUpdateHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynCheckUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseDataSaver
implements IBaseDataSaver {
    private static final Logger logger = Logger.getLogger(BaseDataSaver.class);
    private Connection connection;
    private PreparedStatement readBaseDataStm;
    private Connection currConn = null;
    private PreparedStatement currStatement = null;
    private Set<String> successNumber = new HashSet<String>();
    private Set<String> failureNumber = new HashSet<String>();
    private Set<String> existNumber = new HashSet<String>();
    private ConnectionInfo connInfo = null;
    public static Map<String, String> logMap = new HashMap<String, String>();
    private Set<String> existIdSet = new HashSet<String>();
    private List<String> reInsertIdList = new ArrayList<String>();
    public static int Page = 488;
    private WSServiceInfo wsserviceInfo;
    private BaseDataSynWebServiceInfo webServiceInfo;

    public BaseDataSaver(WSServiceInfo serviceInfo) {
        this.wsserviceInfo = serviceInfo;
    }

    public WSServiceInfo getWSService() {
        return this.wsserviceInfo;
    }

    public BaseDataSaver(ConnectionInfo connInfo) {
        this.connInfo = connInfo;
    }

    public BaseDataSaver(BaseDataSynWebServiceInfo webServiceInfo) {
        this.webServiceInfo = webServiceInfo;
    }

    @Override
    public void open() throws Exception {
        try {
            if (this.connection == null) {
                this.connection = this.getKSQLConnection();
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new Exception("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    public void open(Context ctx) throws Exception {
        try {
            if (this.currConn == null) {
                this.currConn = DBUtils.getConnection(ctx);
                this.currConn.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new Exception("\u6253\u5f00EAS\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    public Connection getKSQLConnection() throws SQLException, ClassNotFoundException {
        DataBaseType dbType = DataBaseType.getInstance(this.connInfo.getDBType().getName());
        this.connection = KSQLUtil.getKSQLConnection(dbType, this.connInfo.getIP(), this.connInfo.getPort(), this.connInfo.getInstance(), this.connInfo.getUsername(), this.connInfo.getPassword());
        return this.connection;
    }

    public String getSuccessNumber() {
        return BaseDataSaver.tranSet2String(this.successNumber);
    }

    public String getFailureNumber() {
        return BaseDataSaver.tranSet2String(this.failureNumber);
    }

    public String getExistNumber() {
        return BaseDataSaver.tranSet2String(this.existNumber);
    }

    public void setSuccessNumber(Set<String> successNumber) {
        this.successNumber = successNumber;
    }

    public void setFailureNumber(Set<String> failureNumber) {
        this.failureNumber = failureNumber;
    }

    public void setExistNumber(Set<String> existNumber) {
        this.existNumber = existNumber;
    }

    public static String tranSet2String(Set<String> set) {
        StringBuffer result = new StringBuffer();
        for (String val : set) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(val);
        }
        return result.toString();
    }

    public PreparedStatement getStatement() {
        return this.readBaseDataStm;
    }

    public void resetStatement() {
        this.readBaseDataStm = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() throws Exception {
        SQLUtils.cleanup((Statement)this.readBaseDataStm, (Connection)this.connection);
        SQLUtils.cleanup((Statement)this.currStatement, (Connection)this.currConn);
        this.connection = null;
    }

    public synchronized void insertByNativeJDBCBatch(List<Map<String, Object>> dataList, String tableName, List<ColumnModel> colNameList, BaseDataBatchInsertHelper insertHelper, Map<String, String> colType) throws SQLException, BOSException, Exception {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        this.existIdSet.clear();
        HashSet<String> existsIds = new HashSet<String>();
        HashSet<String> execIds = new HashSet<String>();
        ArrayList<String> idList = new ArrayList();
        List<Object> existIds = new ArrayList();
        boolean isSuccess = false;
        try {
            this.open();
            this.successNumber = new HashSet<String>();
            this.failureNumber = new HashSet<String>();
            StringBuffer dataIds = new StringBuffer();
            if (this.reInsertIdList.size() == 0) {
                this.existNumber = new HashSet<String>();
                for (int i = 0; i < dataList.size(); ++i) {
                    Map<String, Object> dataMap = dataList.get(i);
                    String str = dataMap.get("FID") + "";
                    idList.add(str);
                }
                existIds = this.getExistsIDs(tableName, idList);
            } else {
                idList = this.reInsertIdList;
            }
            String insertSql = insertHelper.getInsertSql();
            if (this.readBaseDataStm == null) {
                this.readBaseDataStm = this.connection.prepareStatement(insertSql);
            }
            for (int i = 0; i < dataList.size(); ++i) {
                Map<String, Object> dataMap = dataList.get(i);
                Object id = dataMap.get("FID") == null ? dataMap.get("fid") : dataMap.get("FID");
                dataMap.put("fid", id);
                String fid = id.toString();
                if (!idList.contains(fid)) continue;
                String number = BaseDataSaver.getRecordNumber(dataMap);
                if (existIds.contains(fid)) {
                    existsIds.add(fid);
                    this.existNumber.add(number);
                    continue;
                }
                execIds.add(fid);
                this.successNumber.add(number);
                insertHelper.setParameters(colNameList, this.readBaseDataStm, dataMap, colType);
                this.readBaseDataStm.addBatch();
            }
            this.readBaseDataStm.executeBatch();
            this.connection.commit();
            isSuccess = true;
            this.existIdSet.addAll(existsIds);
        }
        catch (Exception e) {
            try {
                try {
                    this.connection.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)"EIP:\u56de\u6eda\u5931\u8d25");
                }
                try {
                    SQLUtils.cleanup((Statement)this.readBaseDataStm);
                    this.readBaseDataStm = null;
                }
                catch (Exception e1) {
                    logger.error((Object)"EIP:\u91ca\u653ereadBaseDataStm\u5931\u8d25");
                }
                this.failureNumber.addAll(this.successNumber);
                this.successNumber.clear();
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close();
                logger.info((Object)("\u65b0\u589e(" + tableName + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + BaseDataSaver.set2String(this.successNumber)));
                logger.info((Object)("\u5df2\u5b58\u5728\u7684\u7f16\u7801/ID\uff1a" + BaseDataSaver.set2String(this.existNumber)));
                throw throwable;
            }
        }
        this.close();
        logger.info((Object)("\u65b0\u589e(" + tableName + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + BaseDataSaver.set2String(this.successNumber)));
        logger.info((Object)("\u5df2\u5b58\u5728\u7684\u7f16\u7801/ID\uff1a" + BaseDataSaver.set2String(this.existNumber)));
    }

    public synchronized void deleteByNativeJDBCBatch(BaseDataSynTableInfo tableInfo, List<String> fids) throws SQLException, BOSException, Exception {
        String tableName = tableInfo.getDestTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = tableInfo.getTableName();
        }
        boolean isSuccess = false;
        try {
            StringBuffer deleteSQL = new StringBuffer();
            deleteSQL.append("delete from ").append(tableName).append(" where fid = ?");
            if (this.connection == null) {
                this.open();
            }
            this.readBaseDataStm = this.connection.prepareStatement(deleteSQL.toString());
            int n = fids.size();
            for (int i = 0; i < n; ++i) {
                String param = fids.get(i);
                if (param instanceof Object[]) {
                    Object[] arryParam = (Object[])param;
                    int m = arryParam.length;
                    for (int j = 0; j < m; ++j) {
                        this.readBaseDataStm.setObject(j + 1, arryParam[j]);
                    }
                } else {
                    this.readBaseDataStm.setObject(1, param);
                }
                this.readBaseDataStm.addBatch();
            }
            this.readBaseDataStm.executeBatch();
            this.connection.commit();
            isSuccess = true;
        }
        catch (Exception e) {
            try {
                this.connection.rollback();
                this.failureNumber.addAll(this.successNumber);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close();
                logger.info((Object)("\u5220\u9664(" + tableName + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + fids));
                StringBuffer buff = new StringBuffer();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long time = System.currentTimeMillis();
                Date date = new Date(time);
                Timestamp timeStamp = new Timestamp(date.getTime());
                buff.append("\u5f00\u59cb\u65f6\u95f4\uff1a" + timeStamp);
                for (int i = 0; i < fids.size(); ++i) {
                    buff.append("\u5220\u9664\u6267\u884c\u7684sql\u7684id\u96c6\u5408\uff1a" + fids.get(i)).append(",");
                }
                logger.error((Object)buff.toString());
                throw throwable;
            }
        }
        this.close();
        logger.info((Object)("\u5220\u9664(" + tableName + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + fids));
        StringBuffer buff = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        Timestamp timeStamp = new Timestamp(date.getTime());
        buff.append("\u5f00\u59cb\u65f6\u95f4\uff1a" + timeStamp);
        for (int i = 0; i < fids.size(); ++i) {
            buff.append("\u5220\u9664\u6267\u884c\u7684sql\u7684id\u96c6\u5408\uff1a" + fids.get(i)).append(",");
        }
        logger.error((Object)buff.toString());
    }

    public synchronized boolean deleteDestDBData(BaseDataSynTableInfo tableInfo, List<String> fids) throws SQLException, BOSException, Exception {
        String tableName = tableInfo.getDestTableName();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = tableInfo.getTableName();
        }
        boolean isSuccess = false;
        try {
            StringBuffer deleteSQL = new StringBuffer();
            deleteSQL.append("delete from ").append(tableName).append(" where fid = ?");
            if (this.connection == null) {
                this.open();
            }
            this.readBaseDataStm = this.connection.prepareStatement(deleteSQL.toString());
            int n = fids.size();
            for (int i = 0; i < n; ++i) {
                String param = fids.get(i);
                if (param instanceof Object[]) {
                    Object[] arryParam = (Object[])param;
                    int m = arryParam.length;
                    for (int j = 0; j < m; ++j) {
                        this.readBaseDataStm.setObject(j + 1, arryParam[j]);
                    }
                } else {
                    this.readBaseDataStm.setObject(1, param);
                }
                this.readBaseDataStm.addBatch();
            }
            this.readBaseDataStm.executeBatch();
            isSuccess = true;
        }
        catch (Exception e) {
            try {
                this.connection.rollback();
                this.failureNumber.addAll(this.successNumber);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close();
                logger.info((Object)("\u5220\u9664(" + tableName + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + fids));
                StringBuffer buff = new StringBuffer();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long time = System.currentTimeMillis();
                Date date = new Date(time);
                Timestamp timeStamp = new Timestamp(date.getTime());
                buff.append("\u5f00\u59cb\u65f6\u95f4\uff1a" + timeStamp);
                for (int i = 0; i < fids.size(); ++i) {
                    buff.append("\u5220\u9664\u6267\u884c\u7684sql\u7684id\u96c6\u5408\uff1a" + fids.get(i)).append(",");
                }
                logger.error((Object)buff.toString());
                throw throwable;
            }
        }
        this.close();
        logger.info((Object)("\u5220\u9664(" + tableName + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + fids));
        StringBuffer buff = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        Timestamp timeStamp = new Timestamp(date.getTime());
        buff.append("\u5f00\u59cb\u65f6\u95f4\uff1a" + timeStamp);
        for (int i = 0; i < fids.size(); ++i) {
            buff.append("\u5220\u9664\u6267\u884c\u7684sql\u7684id\u96c6\u5408\uff1a" + fids.get(i)).append(",");
        }
        logger.error((Object)buff.toString());
        return isSuccess;
    }

    public Connection getDestJDBCConn() throws BOSException {
        if (this.connection == null) {
            try {
                this.open();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return this.connection;
    }

    public synchronized void deletePKTableRecords(Context ctx, BaseDataSynTableInfo tableInfo, String fids, String connectionId) throws SQLException, BOSException, Exception {
        boolean isSuccess = false;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            int i;
            StringBuffer deleteSQL = new StringBuffer();
            deleteSQL.append("delete from ").append(tableInfo.getPkTableName()).append(" where headpk in (");
            String[] fidArray = fids.split(",");
            for (i = 0; i < fidArray.length; ++i) {
                if (i != fidArray.length - 1) {
                    deleteSQL.append("?,");
                    continue;
                }
                deleteSQL.append("?");
            }
            deleteSQL.append(") and agentid = ?");
            connection = DBUtils.getConnection(ctx);
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(deleteSQL.toString());
            for (i = 0; i < fidArray.length; ++i) {
                ps.setString(i + 1, fidArray[i]);
            }
            ps.setString(fidArray.length + 1, connectionId);
            ps.executeUpdate();
            isSuccess = true;
            connection.commit();
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                logger.info((Object)("\u5220\u9664(" + tableInfo.getTableName() + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + fids));
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        logger.info((Object)("\u5220\u9664(" + tableInfo.getTableName() + ")" + (isSuccess ? "\u6210\u529f" : "\u5931\u8d25") + "\u7684\u7f16\u7801/ID\uff1a" + fids));
    }

    public static final String set2String(Set<String> set) {
        StringBuffer sb = new StringBuffer();
        for (String o : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static final String getRecordNumber(Map<String, Object> map) {
        Object FID = map.get("FID");
        if (FID == null) {
            FID = map.get("fid");
        }
        String fid = FID == null ? null : FID.toString();
        Object number = map.get("FNumber");
        if (number == null) {
            number = map.get("Fnumber");
        }
        if (number == null) {
            number = map.get("fnumber");
        }
        if (number == null || "".equals(number.toString().trim())) {
            number = fid;
        }
        return String.valueOf(number);
    }

    public static final StringBuffer deleteLastSplit(StringBuffer obj) {
        if (obj != null && obj.lastIndexOf(",") > -1) {
            return obj.deleteCharAt(obj.lastIndexOf(","));
        }
        return new StringBuffer();
    }

    public void updateByNativeJDBCBatch(List<Map<String, Object>> dataList, String tableName, List<String> colNameList, BaseDataBatchUpdateHelper updateHelper, Map<String, String> colTyle) throws SQLException, BOSException, Exception {
        String updateSql = null;
        try {
            this.open();
            this.successNumber = new HashSet<String>();
            this.failureNumber = new HashSet<String>();
            updateSql = updateHelper.getUpdateSql();
            if (this.readBaseDataStm == null) {
                this.readBaseDataStm = this.connection.prepareStatement(updateSql);
            }
            HashMap bigFieldDataModelMap = new HashMap();
            for (int i = 0; i < dataList.size(); ++i) {
                Map<String, Object> dataMap = dataList.get(i);
                updateHelper.setParameters(colNameList, this.readBaseDataStm, dataMap, colTyle);
                String number = BaseDataSaver.getRecordNumber(dataMap);
                this.successNumber.add(number);
                this.readBaseDataStm.addBatch();
            }
            this.readBaseDataStm.executeBatch();
            this.connection.commit();
        }
        catch (Exception e) {
            this.failureNumber = this.successNumber;
            this.successNumber = new HashSet<String>();
            logger.error((Object)("updateSql error:" + updateSql));
            throw new BOSException("updateSql error:" + updateSql, (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    private List<String> getExistsIDs(String tableName, List<String> idList) throws Exception {
        ArrayList<String> existIds = new ArrayList<String>();
        StringBuffer checkExistSQL = new StringBuffer();
        checkExistSQL.append("select fid from " + tableName).append(" where");
        int idListSize = idList.size();
        if (idListSize > 0) {
            int count = (idListSize - 1) / Page + 1;
            int beginIndex = 0;
            int endIndex = 0;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                StringBuffer newStr = new StringBuffer(" ( fid in ( ");
                beginIndex = i * Page;
                endIndex = (i + 1) * Page > idList.size() ? idList.size() : (i + 1) * Page;
                List<String> subList = idList.subList(beginIndex, endIndex);
                newStr.append(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(subList, ",", "'"));
                checkExistSQL.append(newStr.toString()).append(") ) ").append("or");
            }
            checkExistSQL.delete(checkExistSQL.length() - 2, checkExistSQL.length());
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            if (this.connection == null) {
                this.connection = this.getKSQLConnection();
            }
            try {
                statement = this.connection.prepareStatement(checkExistSQL.toString());
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    existIds.add(resultSet.getString("fid"));
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"error", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, statement);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement);
        }
        return existIds;
    }

    public List<String> checkBeforeSQLCheckIfNeed(List<String> idList, String tableName) throws Exception {
        Context ctx = BaseDataResourceholder.getContext();
        BaseDataSynTableInfo basedataSynTableInfo = BaseDataResourceholder.getBaseDataSynTableInfo();
        StringBuffer checkExistSQL = new StringBuffer("select * from ");
        checkExistSQL.append(tableName).append(" where ");
        int idListSize = idList.size();
        if (idListSize > 0) {
            int count = (idListSize - 1) / Page + 1;
            int beginIndex = 0;
            int endIndex = 0;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                StringBuffer newStr = new StringBuffer(" ( fid in ( ");
                beginIndex = i * Page;
                endIndex = (i + 1) * Page > idList.size() ? idList.size() : (i + 1) * Page;
                List<String> subList = idList.subList(beginIndex, endIndex);
                newStr.append(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(subList, ",", "'"));
                checkExistSQL.append(newStr.toString()).append(") ) ").append("or");
            }
        }
        checkExistSQL.delete(checkExistSQL.length() - 2, checkExistSQL.length());
        String connId = MonitorManager.getCurrent().getExtendedProperty("connId");
        ArrayList<String> addNewtList = new ArrayList<String>();
        BaseDataSynCheckUtil.addBeforeSQLCheckIfNeed((Context)ctx, (BaseDataSynTableInfo)basedataSynTableInfo, (String)checkExistSQL.toString(), addNewtList, (String)connId, (String)basedataSynTableInfo.getBeforeSQL());
        return addNewtList;
    }

    public static void updateData(Context ctx, String sql, String connId, List<String> idList) throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = DBUtils.getConnection(ctx);
            statement = connection.prepareStatement(sql.toString());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < idList.size(); ++i) {
                statement.setString(1, idList.get(i).replace("'", ""));
                statement.setString(2, connId);
                long time = System.currentTimeMillis();
                Date date = new Date(time);
                Timestamp timeStamp = new Timestamp(date.getTime());
                statement.setTimestamp(3, timeStamp);
                statement.addBatch();
            }
            statement.executeBatch();
            try {
                connection.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(statement, connection);
                throw throwable;
            }
        }
        SQLUtil.cleanup(statement, connection);
    }

    public Set<String> getexistIdSet() {
        return this.existIdSet;
    }
}

