/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

public class AgentUpdateServlet
extends RequestProcessor {
    private static Logger logger = Logger.getLogger(AgentUpdateServlet.class);
    private static String agentServiceUpdateFileMD5;
    private static File agentServiceUpdateFile;
    private static long agentServiceUpdateFileDate;
    private static long agentServiceUpdateFileLength;

    public AgentUpdateServlet() {
        AgentUpdateServlet.initUpdateFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initUpdateFile(boolean refresh) {
        if (!refresh && agentServiceUpdateFileMD5 != null) {
            return;
        }
        Class<AgentUpdateServlet> clazz = AgentUpdateServlet.class;
        synchronized (AgentUpdateServlet.class) {
            if (agentServiceUpdateFileMD5 == null) {
                String eas_home = System.getProperty("EAS_HOME");
                if (StringUtils.isEmpty((String)eas_home)) {
                    throw new NullPointerException("system property 'EAS_HOME' is empty!");
                }
                String agentServiceUpdateFilePath = eas_home + "/server/properties/eip/eip_agent_service.zip";
                agentServiceUpdateFile = new File(agentServiceUpdateFilePath);
                agentServiceUpdateFileDate = agentServiceUpdateFile.lastModified();
                agentServiceUpdateFileLength = agentServiceUpdateFile.length();
                try {
                    agentServiceUpdateFileMD5 = MD5.asHex((byte[])MD5.getHash((File)agentServiceUpdateFile));
                }
                catch (IOException e) {
                    logger.error((Object)("\u8ba1\u7b97\u6587\u4ef6" + agentServiceUpdateFilePath + "\u7684MD5\u503c\u5931\u8d25!"), (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getTargetURI() {
        return "/agent-update";
    }

    @Override
    public String process(Map<String, String> params, String reqBody) throws Exception {
        String file = params.get("file");
        String refresh = params.get("refresh");
        if (StringUtils.isEmpty((String)file)) {
            throw new NullPointerException("\u7f3a\u5c11\u53c2\u6570'file'");
        }
        if (Boolean.valueOf(refresh).booleanValue()) {
            AgentUpdateServlet.initUpdateFile(true);
        }
        if (agentServiceUpdateFileMD5 == null) {
            throw new Exception("\u521d\u59cb\u5316\u66f4\u65b0\u6587\u4ef6\u5931\u8d25!");
        }
        if (file.equals("agent-service")) {
            String oldMd5 = this.request.getHeader("If-None-Match");
            if (oldMd5 == null) {
                oldMd5 = params.get("If-None-Match");
            }
            this.response.setDateHeader("Last-Modified", agentServiceUpdateFileDate);
            this.response.setHeader("ETag", agentServiceUpdateFileMD5);
            if (StringUtils.isEmpty((String)oldMd5) || !agentServiceUpdateFileMD5.equals(oldMd5)) {
                this.response.setStatus(200);
                this.response.setHeader("Content-Type", "application/octet-stream");
                this.response.setHeader("Content-Disposition", "attachment;filename=" + agentServiceUpdateFile.getName());
                this.response.setHeader("Content-Length", String.valueOf(agentServiceUpdateFileLength));
                try (FileInputStream fis = new FileInputStream(agentServiceUpdateFile);){
                    IOUtils.copy(fis, (OutputStream)this.response.getOutputStream());
                }
            } else {
                this.response.setStatus(304);
            }
        } else {
            this.response.sendError(404, "file not found : " + file);
        }
        return null;
    }
}

