/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.base.TaskInfo;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.agent.task.TaskType;
import com.kingdee.eas.csinterface.agent.util.DataChecker;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.json.JSONException;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;

public class TaskServlet
extends RequestProcessor {
    @Override
    public String getTargetURI() {
        return "/task";
    }

    @Override
    public String process(Map<String, String> params, String reqBody) throws Exception {
        return null;
    }

    public String get(Map<String, String> params, String reqBody) throws Exception {
        boolean isPassed = false;
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        try {
            EIPLicenseCheckUtil.checkLicenseEnough((Context)this.ctx);
            isPassed = true;
        }
        catch (Exception e) {
            resultInfo.setStatus("error");
            resultInfo.setStatusMsg(e.getMessage());
        }
        if (isPassed) {
            List<TaskInfo> taskList = EipTaskManager.receiveTask(this.ctx, this.ctx.get((Object)"agentId").toString());
            resultInfo.setTaskList(taskList);
        }
        return JSONObject.toJSONString((Object)resultInfo);
    }

    public String getBaseDataDown(Map<String, String> params, String reqBody) throws Exception {
        boolean isPassed = false;
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        try {
            isPassed = true;
        }
        catch (Exception e) {
            resultInfo.setStatus("error");
            resultInfo.setStatusMsg(e.getMessage());
        }
        if (isPassed) {
            List<TaskInfo> taskList = EipTaskManager.receiveTaskForBaseData(this.ctx, this.ctx.get((Object)"agentId").toString(), TaskType.BASEDATASYN);
            resultInfo.setTaskList(taskList);
        }
        return JSONObject.toJSONString((Object)resultInfo);
    }

    public String report(Map<String, String> params, String reqBody) throws Exception {
        long version;
        try {
            EIPLicenseCheckUtil.checkLicenseEnough((Context)this.ctx);
        }
        catch (Exception e) {
            ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_ERROR.clone();
            resultInfo.setStatusMsg(e.getMessage());
            return JSONObject.toJSONString((Object)resultInfo);
        }
        if (StringUtils.isEmpty((String)reqBody)) {
            throw new JSONException("uri='" + this.request.getRequestURI() + "'\u8bf7\u6c42\u62a5\u6587\u4f53\u4e3a\u7a7a");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)reqBody);
        String status = jsonObject.getString("status");
        String data = jsonObject.getString("data");
        TaskInfo taskInfo = new TaskInfo().parse(data);
        DataChecker.checkNotEmpty(taskInfo.getVersion(), "'version' \u4e3a\u7a7a!");
        try {
            version = Long.parseLong(taskInfo.getVersion());
        }
        catch (NumberFormatException e) {
            throw new JSONException("'" + taskInfo.getVersion() + "' \u65e0\u6cd5\u8f6c\u6362\u4e3along");
        }
        DataChecker.checkNotEmpty(taskInfo.getResult(), "'result' \u4e3a\u7a7a!");
        DataChecker.checkNotEmpty(status, "'status' \u4e3a\u7a7a!");
        ResultInfo resultInfo = EipTaskManager.reportTask(this.ctx, taskInfo.getTaskID(), version, status, taskInfo.getResult());
        return JSONObject.toJSONString((Object)resultInfo);
    }
}

