/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipTaskInfo;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.TaskManagerFactory;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.base.TaskInfo;
import com.kingdee.eas.csinterface.agent.task.TaskAction;
import com.kingdee.eas.csinterface.agent.task.TaskConfigParams;
import com.kingdee.eas.csinterface.agent.task.TaskType;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingHelper;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.json.JSONException;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.schedule.ScheduleActionEnum;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EipTaskManager {
    private static List<TaskType> taskTypes;
    private static Map<TaskType, List<TaskAction>> taskTypeActionMap;
    public static final int PRIORITY_DEFAULT = 0;

    private static void initTaskType() {
        taskTypes = EipTaskManager.getStaticFieldObject(TaskType.class);
    }

    private static void initTaskAction() {
        List list = EipTaskManager.getStaticFieldObject(TaskAction.class);
        taskTypeActionMap = new HashMap<TaskType, List<TaskAction>>();
        for (TaskAction taskAction : list) {
            List<TaskAction> taskActionList = taskTypeActionMap.get(taskAction.taskType);
            if (taskActionList == null) {
                taskActionList = new ArrayList<TaskAction>();
                taskTypeActionMap.put(taskAction.taskType, taskActionList);
            }
            taskActionList.add(taskAction);
        }
    }

    private static List getStaticFieldObject(Class clazz) {
        Field[] fields = clazz.getFields();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(clazz)) continue;
            try {
                list.add(field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public static String generateTaskID(String type, String action, String id) {
        MD5 md52 = new MD5((Object)(type + "_" + action + "_" + id));
        return md52.asHex();
    }

    public static List<TaskType> getDefinedTaskTypes() {
        return taskTypes;
    }

    public static List<TaskAction> getDefinedTaskActionsByTaskType(TaskType taskType) {
        return taskTypeActionMap.get(taskType);
    }

    public static void orderTask(Context ctx, String taskID, TaskType taskType, TaskAction taskAction, String param, String taskDes, EipUserInfo executor, ScheduleInfo scheduleInfo) throws BOSException, EASBizException {
        TaskManagerFactory.getLocalInstance(ctx).orderTask(taskID, taskType, taskAction, param, taskDes, executor, scheduleInfo);
    }

    public static List<TaskInfo> receiveTask(Context ctx, String userID) throws BOSException, EASBizException {
        IObjectCollection taskCollection = TaskManagerFactory.getLocalInstance(ctx).receiveTask(userID);
        LinkedList<TaskInfo> taskList = new LinkedList<TaskInfo>();
        if (taskCollection.size() > 0) {
            for (int i = 0; i < taskCollection.size(); ++i) {
                EipTaskInfo eipTaskInfo = (EipTaskInfo)taskCollection.getObject(i);
                TaskInfo taskInfo = new TaskInfo();
                taskInfo.setTaskID(eipTaskInfo.getNumber());
                taskInfo.setAction(eipTaskInfo.getAction());
                taskInfo.setDepend(eipTaskInfo.getDepend());
                taskInfo.setParams(eipTaskInfo.getParams());
                taskInfo.setType(eipTaskInfo.getType());
                taskInfo.setVersion(String.valueOf(eipTaskInfo.getOrderTime().getTime()));
                taskList.add(taskInfo);
            }
        }
        return taskList;
    }

    public static List<TaskInfo> receiveTaskForBaseData(Context ctx, String userID, TaskType taskType) throws BOSException, EASBizException {
        LinkedList<TaskInfo> taskList = new LinkedList<TaskInfo>();
        IObjectCollection taskCollection = TaskManagerFactory.getLocalInstance(ctx).receiveTask(userID);
        if (taskCollection.size() > 0) {
            for (int i = 0; i < taskCollection.size(); ++i) {
                EipTaskInfo eipTaskInfo = (EipTaskInfo)taskCollection.getObject(i);
                if (!StringUtils.equals((String)taskType.type, (String)eipTaskInfo.getType())) continue;
                TaskInfo taskInfo = new TaskInfo();
                taskInfo.setTaskID(eipTaskInfo.getNumber());
                taskInfo.setAction(eipTaskInfo.getAction());
                taskInfo.setDepend(eipTaskInfo.getDepend());
                taskInfo.setParams(eipTaskInfo.getParams());
                taskInfo.setType(eipTaskInfo.getType());
                taskInfo.setVersion(String.valueOf(eipTaskInfo.getOrderTime().getTime()));
                taskList.add(taskInfo);
            }
        }
        return taskList;
    }

    public static ResultInfo reportTask(Context ctx, String taskID, long taskVersion, String status, String result) throws BOSException, EASBizException {
        return TaskManagerFactory.getLocalInstance(ctx).reportTask(taskID, taskVersion, status, result);
    }

    public static void orderModifyPulsConfig(Context ctx, EipUserInfo userInfo) throws EASBizException, BOSException {
        String taskID = EipTaskManager.generateTaskID(TaskType.CONFIG.type, TaskAction.CONFIG_MODIFY.action, userInfo.getNumber());
        String taskDes = "\u3010" + TaskType.CONFIG.toString() + " - " + TaskAction.CONFIG_MODIFY.toString() + "\u3011\u8f6e\u8be2\u9891\u7387\u4fee\u6539\u4e3a'" + userInfo.getPulsInterval() + "'\u79d2";
        HashMap<String, String> configItems = new HashMap<String, String>();
        TaskConfigParams configParams = new TaskConfigParams("TaskPulsConfig");
        configParams.setConfigItems(configItems);
        configItems.put("timer_expression", "f:" + userInfo.getPulsInterval());
        JSONObject configParamsJson = new JSONObject(configParams);
        EipTaskManager.orderTask(ctx, taskID, TaskType.CONFIG, TaskAction.CONFIG_MODIFY, configParamsJson.toString(), taskDes, userInfo, null);
    }

    public static String generateCreateViewTaskID(EipUserInfo userInfo, String mainViewName) {
        String key = userInfo.getId().toString() + "_" + mainViewName;
        return EipTaskManager.generateTaskID(TaskType.VIEW.type, TaskAction.VIEW_CREATE.action, key);
    }

    public static String generateSaveDataTaskID(EipUserInfo userInfo, String number) {
        String key = userInfo.getId().toString() + "_" + number;
        return EipTaskManager.generateTaskID(TaskType.BASEDATASYN.type, TaskAction.BASEDATA_SYN.action, key);
    }

    public static void orderViewCreate(Context ctx, EipUserInfo userInfo, String[] ksqls, String[] viewNames, String mainViewName) throws EASBizException, BOSException {
        String taskID = EipTaskManager.generateCreateViewTaskID(userInfo, mainViewName);
        String taskDes = "\u3010" + TaskType.VIEW.toString() + " - " + TaskAction.VIEW_CREATE.toString() + "\u3011\u8981\u521b\u5efa\u7684\u89c6\u56fe: " + StringUtils.arrayToString((Object[])viewNames, (String)",");
        HashMap<String, Object> viewInfos = new HashMap<String, Object>();
        viewInfos.put("mainViewName", mainViewName);
        viewInfos.put("viewNames", viewNames);
        viewInfos.put("viewSqls", ksqls);
        JSONObject viewInfoJson = new JSONObject(viewInfos);
        EipTaskManager.orderTask(ctx, taskID, TaskType.VIEW, TaskAction.VIEW_CREATE, viewInfoJson.toString(), taskDes, userInfo, null);
    }

    public static void orderViewDrop(Context ctx, EipUserInfo userInfo, String[] ksqls, String[] viewNames, String mainViewName) throws EASBizException, BOSException {
        String taskID = EipTaskManager.generateCreateViewTaskID(userInfo, mainViewName);
        String taskDes = "\u3010" + TaskType.VIEW.toString() + " - " + TaskAction.VIEW_DELETE.toString() + "\u3011\u8981\u5220\u9664\u7684\u89c6\u56fe: " + StringUtils.arrayToString((Object[])viewNames, (String)",");
        HashMap<String, Object> viewInfos = new HashMap<String, Object>();
        viewInfos.put("mainViewName", mainViewName);
        viewInfos.put("viewNames", viewNames);
        viewInfos.put("viewSqls", ksqls);
        JSONObject viewInfoJson = new JSONObject(viewInfos);
        EipTaskManager.orderTask(ctx, taskID, TaskType.VIEW, TaskAction.VIEW_DELETE, viewInfoJson.toString(), taskDes, userInfo, null);
    }

    @Deprecated
    public static void orderBaseDataSynTaskToAgent(Context ctx, EipUserInfo userInfo, String[] synTables, String number) throws EASBizException, BOSException {
        String taskID = EipTaskManager.generateSaveDataTaskID(userInfo, number);
        String taskDes = "\u3010" + TaskType.BASEDATASYN.toString() + " - " + TaskAction.BASEDATA_SYN.toString() + "\u3011\u8981\u540c\u6b65\u7684\u8868: " + StringUtils.arrayToString((Object[])synTables, (String)",");
        HashMap<String, Object> viewInfos = new HashMap<String, Object>();
        viewInfos.put("number", number);
        viewInfos.put("synTables", synTables);
        viewInfos.put("per_count", "1000");
        JSONObject viewInfoJson = new JSONObject(viewInfos);
        EipTaskManager.orderTask(ctx, taskID, TaskType.BASEDATASYN, TaskAction.BASEDATA_SYN_ONCE, viewInfoJson.toString(), taskDes, userInfo, null);
    }

    public static String orderOnceTaskToAgent(Context ctx, BaseDataSynHeadInfo headInfo) throws EASBizException, BOSException {
        try {
            EipUserInfo userInfo = EipUserFactory.getLocalInstance(ctx).getEipUserInfo(CommonUtil.convert2PK(headInfo.getExtendedProperty("extAgentId")));
            if (userInfo == null) {
                userInfo = headInfo.getAgent();
            }
            String taskID = EipTaskManager.generateSaveDataTaskID(userInfo, headInfo.getNumber());
            BaseDataSynTableCollection tables = headInfo.getTableEntrys();
            Object[] tableNames = new String[tables.size()];
            for (int i = 0; i < tables.size(); ++i) {
                BaseDataSynTableInfo table = tables.get(i);
                tableNames[i] = table.getId().toString();
            }
            String taskDes = "\u3010" + TaskType.BASEDATASYN.toString() + " - " + TaskAction.BASEDATA_SYN.toString() + "\u3011\u8981\u540c\u6b65\u7684\u8868: " + StringUtils.arrayToString((Object[])tableNames, (String)",");
            HashMap<String, String> configItems = new HashMap<String, String>();
            boolean baseDataDown = headInfo.getDirection().getValue() == "ParentToBranch";
            boolean isMultiPlan = headInfo.isMultiPlan();
            String configType = baseDataDown ? (isMultiPlan ? "base_data_multi_down" : "base_data_down") : "base_data_up";
            TaskConfigParams configParams = new TaskConfigParams("base_data_down_scheduler", configType, taskID);
            String startTimeStr = DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            configItems.put("timer_expression", "");
            configItems.put("baseDataName", headInfo.getNumber());
            configItems.put("baseDataAlias", headInfo.getName());
            configItems.put("baseDataSynHeadId", headInfo.getId().toString());
            configItems.put("per_count", "1000");
            configItems.put("startTime", startTimeStr);
            configItems.put("scheduleID", taskID);
            configItems.put("dataFinishMark", "false");
            configParams.setConfigItems(configItems);
            JSONObject configParamsJson = new JSONObject(configParams);
            TaskType type = isMultiPlan ? TaskType.MULTIBASEDATASYN : TaskType.BASEDATASYN;
            EipTaskManager.orderTask(ctx, taskID, type, TaskAction.BASEDATA_SYN_ONCE, configParamsJson.toString(), taskDes, userInfo, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    public static void orderBaseDataSynConfig(Context ctx, ScheduleInfo scheduleInfo, ScheduleActionEnum actionType) throws EASBizException, BOSException {
        boolean baseDataDown;
        BaseDataSynHeadInfo baseDataSynHeadInfo = scheduleInfo.getBaseDataSyn();
        baseDataSynHeadInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(baseDataSynHeadInfo.getId().toString()));
        String cron = scheduleInfo.getTimerRuleExpresssion().replaceAll("[^:]+:", "").trim();
        String taskID = EipTaskManager.generateTaskID(TaskType.CONFIG.type, TaskAction.CONFIG_MODIFY.action, scheduleInfo.getId().toString());
        String taskDes = "\u3010" + TaskType.CONFIG.toString() + " - " + TaskAction.CONFIG_MODIFY.toString() + "\u3011" + actionType.getAlias() + "(" + baseDataSynHeadInfo.getNumber() + ")\uff0c\u5b9a\u65f6\u8868\u8fbe\u5f0f:" + cron;
        HashMap<String, String> configItems = new HashMap<String, String>();
        boolean isMultiPlan = baseDataSynHeadInfo.isMultiPlan();
        boolean bl = baseDataDown = actionType.getValue() == 400;
        String configType = baseDataDown ? (isMultiPlan ? "base_data_multi_down" : "base_data_down") : (isMultiPlan ? "base_data_multi_down_change" : "base_data_down_change");
        TaskConfigParams configParams = new TaskConfigParams("base_data_down_scheduler", configType, scheduleInfo.getId().toString());
        Timestamp startDate = scheduleInfo.getTimerStartDate();
        Pattern p = Pattern.compile("(\\d{1,2}) (\\d{1,2}) (\\d{1,2}).*");
        Matcher matcher = p.matcher(cron);
        String startTimeStr = null;
        if (matcher.find()) {
            String time = matcher.group(3) + ":" + matcher.group(2) + ":" + matcher.group(1);
            startTimeStr = DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " " + time;
        } else {
            startTimeStr = DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss");
        }
        configItems.put("timer_expression", cron);
        configItems.put("baseDataName", baseDataSynHeadInfo.getNumber());
        configItems.put("baseDataAlias", baseDataSynHeadInfo.getName());
        BaseDataSynTableCollection tables = baseDataSynHeadInfo.getTableEntrys();
        StringBuffer tableName = new StringBuffer();
        for (int i = 0; i < tables.size(); ++i) {
            BaseDataSynTableInfo table = tables.get(i);
            tableName.append(table.getId().toString()).append(",");
        }
        if (tableName.lastIndexOf(",") > -1) {
            tableName = tableName.deleteCharAt(tableName.lastIndexOf(","));
        }
        configItems.put("baseDataSynHeadId", baseDataSynHeadInfo.getId().toString());
        configItems.put("per_count", "1000");
        configItems.put("startTime", startTimeStr);
        configItems.put("scheduleID", scheduleInfo.getId().toString());
        configItems.put("dataFinishMark", "false");
        configParams.setConfigItems(configItems);
        JSONObject configParamsJson = new JSONObject(configParams);
        TaskType type = isMultiPlan ? TaskType.MULTIBASEDATASYN : TaskType.BASEDATASYN;
        EipUserInfo userInfo = scheduleInfo.getAgent() == null ? baseDataSynHeadInfo.getAgent() : scheduleInfo.getAgent();
        EipTaskManager.orderTask(ctx, taskID, type, TaskAction.CONFIG_MODIFY, configParamsJson.toString(), taskDes, userInfo, scheduleInfo);
    }

    public static void orderDeleteBaseDataConfig(Context ctx, ScheduleInfo scheduleInfo) throws EASBizException, BOSException {
        BaseDataSynHeadInfo baseDataInfo = scheduleInfo.getBaseDataSyn();
        baseDataInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(baseDataInfo.getId().toString()));
        String taskID = EipTaskManager.generateTaskID(TaskType.CONFIG.type, TaskAction.CONFIG_MODIFY.action, scheduleInfo.getId().toString());
        String taskDesc = "\u5220\u9664(\u7981\u7528)" + TaskAction.BASEDATA_SYN.toString() + baseDataInfo.getNumber() + "\u7684\u201c" + (scheduleInfo.getActionType() != null ? scheduleInfo.getActionType().getAlias() : "\u672a\u77e5") + "\u201d\u5b9a\u65f6\u4efb\u52a1";
        String configType = "base_data_down";
        boolean baseDataDown = scheduleInfo.getActionType().getValue() == 400;
        boolean isMultiPlan = baseDataInfo.isMultiPlan();
        configType = baseDataDown ? (isMultiPlan ? "base_data_multi_down" : "base_data_down") : (isMultiPlan ? "base_data_multi_down_change" : "base_data_down_change");
        TaskType taskType = isMultiPlan ? TaskType.MULTIBASEDATASYN : TaskType.BASEDATASYN;
        EipUserInfo userInfo = scheduleInfo.getAgent() == null ? baseDataInfo.getAgent() : scheduleInfo.getAgent();
        EipTaskManager.orderDeleteBaseDataConfig(ctx, taskID, taskDesc, userInfo, "base_data_down_scheduler", configType, scheduleInfo.getId().toString(), taskType, scheduleInfo);
    }

    public static void orderBillDataConfig(Context ctx, ScheduleInfo scheduleInfo, ScheduleActionEnum actionType) throws EASBizException, BOSException {
        BillMappingInfo billMappingInfo = scheduleInfo.getStrategy();
        String cron = scheduleInfo.getTimerRuleExpresssion().replaceAll("[^:]+:", "").trim();
        String taskID = EipTaskManager.generateTaskID(TaskType.CONFIG.type, TaskAction.CONFIG_MODIFY.action, scheduleInfo.getId().toString());
        String taskDes = "\u3010" + TaskType.CONFIG.toString() + " - " + TaskAction.CONFIG_MODIFY.toString() + "\u3011" + actionType.getAlias() + "(" + billMappingInfo.getNumber() + ")\uff0c\u5b9a\u65f6\u8868\u8fbe\u5f0f:" + cron;
        HashMap<String, String> configItems = new HashMap<String, String>();
        boolean actionTypeDataChange = actionType.getValue() == 200;
        String configType = actionTypeDataChange ? "bill_data_change" : "bill_data";
        TaskConfigParams configParams = new TaskConfigParams("bill_data_scheduler", configType, scheduleInfo.getId().toString());
        Timestamp startDate = scheduleInfo.getTimerStartDate();
        Pattern p = Pattern.compile("(\\d{1,2}) (\\d{1,2}) (\\d{1,2}).*");
        Matcher matcher = p.matcher(cron);
        String startTimeStr = null;
        if (matcher.find()) {
            String time = matcher.group(3) + ":" + matcher.group(2) + ":" + matcher.group(1);
            startTimeStr = DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " " + time;
        } else {
            startTimeStr = DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss");
        }
        configParams.setConfigItems(configItems);
        configItems.put("timer_expression", cron);
        configItems.put("billName", billMappingInfo.getNumber());
        configItems.put("billAlias", billMappingInfo.getBillMappingName());
        configItems.put("startTime", startTimeStr);
        if (!actionTypeDataChange) {
            configItems.put("scheduleID", scheduleInfo.getId().toString());
            configItems.put("dataFinishMark", String.valueOf(actionType.getValue() == 100));
        }
        JSONObject configParamsJson = new JSONObject(configParams);
        EipTaskManager.orderTask(ctx, taskID, TaskType.CONFIG, TaskAction.CONFIG_MODIFY, configParamsJson.toString(), taskDes, billMappingInfo.getAgentUser(), scheduleInfo);
    }

    public static void orderDeleteBillDataConfig(Context ctx, ScheduleInfo scheduleInfo) throws EASBizException, BOSException {
        BillMappingInfo billMappingInfo = scheduleInfo.getStrategy();
        String taskID = EipTaskManager.generateTaskID(TaskType.CONFIG.type, TaskAction.CONFIG_MODIFY.action, scheduleInfo.getId().toString());
        String taskDesc = "\u5220\u9664(\u7981\u7528)\u5355\u636e" + billMappingInfo.getNumber() + "\u7684\u201c" + (scheduleInfo.getActionType() != null ? scheduleInfo.getActionType().getAlias() : "\u672a\u77e5") + "\u201d\u5b9a\u65f6\u4efb\u52a1";
        String configType = "bill_data";
        if (scheduleInfo.getActionType().getValue() == 200) {
            configType = "bill_data_change";
        }
        EipTaskManager.orderDeleteConfig(ctx, taskID, taskDesc, billMappingInfo.getAgentUser(), "bill_data_scheduler", configType, scheduleInfo.getId().toString(), scheduleInfo);
    }

    public static void orderDeleteConfig(Context ctx, String taskID, String taskDesc, EipUserInfo agentUser, String configSetName, String configType, String configName, ScheduleInfo scheduleInfo) throws EASBizException, BOSException {
        taskDesc = "\u3010" + TaskType.CONFIG.toString() + " - " + TaskAction.CONFIG_DELETE.toString() + "\u3011" + taskDesc;
        TaskConfigParams configParams = new TaskConfigParams(configSetName, configType, configName);
        JSONObject configParamsJson = new JSONObject(configParams);
        EipTaskManager.orderTask(ctx, taskID, TaskType.CONFIG, TaskAction.CONFIG_DELETE, configParamsJson.toString(), taskDesc, agentUser, scheduleInfo);
    }

    public static void orderDeleteBaseDataConfig(Context ctx, String taskID, String taskDesc, EipUserInfo agentUser, String configSetName, String configType, String configName, TaskType taskType, ScheduleInfo scheduleInfo) throws EASBizException, BOSException {
        taskDesc = "\u3010" + TaskType.CONFIG.toString() + " - " + TaskAction.CONFIG_DELETE.toString() + "\u3011" + taskDesc;
        TaskConfigParams configParams = new TaskConfigParams(configSetName, configType, configName);
        JSONObject configParamsJson = new JSONObject(configParams);
        EipTaskManager.orderTask(ctx, taskID, taskType, TaskAction.CONFIG_DELETE, configParamsJson.toString(), taskDesc, agentUser, scheduleInfo);
    }

    public static void orderDeleteBillData(Context ctx, BillMappingInfo billMappingInfo, String[] ids, String[] srcIds) throws EASBizException, BOSException {
        String taskID = EipTaskManager.generateTaskID(TaskType.BILLDATA.type, TaskAction.BILLDATA_DELETE.action, billMappingInfo.getNumber());
        String taskDes = "\u3010" + TaskType.BILLDATA.toString() + " - " + TaskAction.BILLDATA_DELETE.toString() + "\u3011\u8981\u5220\u9664\u7684\u5355\u636e\u4e00\u5171 " + ids.length + " \u4e2a";
        JSONObject paramJSON = new JSONObject();
        try {
            paramJSON.put("number", billMappingInfo.getNumber());
            paramJSON.put("pkTableName", "\u672a\u751f\u6210\u589e\u91cf\u8868".equals(billMappingInfo.getPkTableName()) ? BillMappingHelper.calc2PkTableName(billMappingInfo.getId().toString()) : billMappingInfo.getPkTableName());
            paramJSON.put("srcIdList", srcIds);
            paramJSON.put("midIdList", ids);
            boolean flag = (Boolean)(ctx.get((Object)"reGenerate") == null ? Boolean.valueOf(false) : ctx.get((Object)"reGenerate"));
            paramJSON.put("reGenerate", flag);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        EipTaskManager.orderTask(ctx, taskID, TaskType.BILLDATA, TaskAction.BILLDATA_DELETE, paramJSON.toString(), taskDes, billMappingInfo.getAgentUser(), null);
    }

    public static void orderReGenerateBillData(Context ctx, BillMappingInfo billMappingInfo, String[] headpks, String[] midIds) throws EASBizException, BOSException {
        String taskID = EipTaskManager.generateTaskID(TaskType.BILLDATA.type, TaskAction.BILLDATA_REGENERATE.action, billMappingInfo.getNumber());
        String taskDes = "\u3010" + TaskType.BILLDATA.toString() + " - " + TaskAction.BILLDATA_REGENERATE.toString() + "\u3011\u8981\u91cd\u65b0\u5904\u7406\u7684\u5355\u636e\u4e00\u5171 " + headpks.length + " \u4e2a";
        JSONObject paramJSON = new JSONObject();
        try {
            paramJSON.put("billMappingNumber", billMappingInfo.getNumber());
            paramJSON.put("pkTableName", "\u672a\u751f\u6210\u589e\u91cf\u8868".equals(billMappingInfo.getPkTableName()) ? BillMappingHelper.calc2PkTableName(billMappingInfo.getId().toString()) : billMappingInfo.getPkTableName());
            paramJSON.put("srcIdList", headpks);
            paramJSON.put("midIdList", midIds);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        EipTaskManager.orderTask(ctx, taskID, TaskType.BILLDATA, TaskAction.BILLDATA_REGENERATE, paramJSON.toString(), taskDes, billMappingInfo.getAgentUser(), null);
    }

    public static void orderObtainTableStructure(Context ctx, String sql, String agentid, Set<String> tables) throws EASBizException, BOSException {
        String taskID = EipTaskManager.generateTaskID(TaskType.BASEDATASYN.type, TaskAction.BASEDATA_SYN_ONCE.action, agentid);
        String taskDes = "\u3010" + TaskType.BASEDATASYN.toString() + " - " + TaskAction.BILLDATA_REGENERATE.toString() + "\u3011\u8981\u91cd\u65b0\u5904\u7406\u7684\u5355\u636e\u4e00\u5171 " + tables.size() + " \u4e2a";
        JSONObject paramJSON = new JSONObject();
        try {
            paramJSON.put("sql", sql);
            paramJSON.put("tables", tables);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        EipUserInfo agent = EipUserFactory.getLocalInstance(ctx).getEipUserInfo("where id='" + agentid + "'");
        EipTaskManager.orderTask(ctx, taskID, TaskType.BASEDATASYN, TaskAction.TABLESTRUCTURE_OBTAIN, paramJSON.toString(), taskDes, agent, null);
    }

    static {
        EipTaskManager.initTaskType();
        EipTaskManager.initTaskAction();
    }
}

