/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.task.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipTaskInfo;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.TaskStatus;
import com.kingdee.eas.csinterface.agent.task.TaskAction;
import com.kingdee.eas.csinterface.agent.task.TaskReportHandler;
import com.kingdee.eas.csinterface.agent.task.TaskType;
import com.kingdee.eas.csinterface.basedatasyn.ITableStructure;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureCollection;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureFactory;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import java.util.Iterator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class TableStructureHandler
extends TaskReportHandler {
    private static Logger logger = Logger.getLogger(TableStructureHandler.class);

    @Override
    public TaskType getType() {
        return TaskType.BASEDATASYN;
    }

    @Override
    public TaskAction getAction() {
        return TaskAction.TABLESTRUCTURE_OBTAIN;
    }

    @Override
    public void handle(Context ctx, EipTaskInfo taskInfo, long taskVersion, TaskStatus taskStatus, String result) throws BOSException, EASBizException {
        try {
            JSONObject object = JSONObject.fromObject((Object)result);
            EipUserInfo agent = EipUserFactory.getLocalInstance(ctx).getEipUserInfo("where id='" + taskInfo.getExecutor().getId().toString() + "'");
            ITableStructure instance = TableStructureFactory.getLocalInstance(ctx);
            Iterator ite = object.keys();
            while (ite.hasNext()) {
                TableStructureInfo tableStructureInfo;
                String tableName = (String)ite.next();
                JSONArray o = object.getJSONArray(tableName);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                ev.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("IP", (Object)agent.getDBIP(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("port", (Object)agent.getDBPort(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("instance", (Object)agent.getDbName(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("tableName", (Object)tableName, CompareType.EQUALS));
                TableStructureCollection coll = instance.getTableStructureCollection(ev);
                if (!coll.isEmpty()) {
                    tableStructureInfo = coll.get(0);
                    tableStructureInfo.setColumnModel(o.toString());
                    instance.update(CommonUtil.convert2PK(coll.get(0).getId().toString()), tableStructureInfo);
                    continue;
                }
                tableStructureInfo = new TableStructureInfo();
                tableStructureInfo.setIP(agent.getDBIP());
                tableStructureInfo.setPort(Integer.valueOf(agent.getDBPort()));
                tableStructureInfo.setInstance(agent.getDbName());
                tableStructureInfo.setTableName(tableName);
                tableStructureInfo.setColumnModel(o.toString());
                instance.addnew(tableStructureInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u96c6\u6210\u5e73\u53f0\u56de\u5199\u8868\u7ed3\u6784\u51fa\u9519\u3011", (Throwable)e);
        }
    }
}

