/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.ant;

import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.eas.csinterface.util.PropertiesUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class EIPSsoParameterTask
extends Task {
    private static final String URL_PATTERN = "cas.client.UrlPattern";
    private String filePath;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void execute() throws BuildException {
        if (null == this.filePath || this.filePath.trim().length() == 0) {
            return;
        }
        File file = new File(this.filePath);
        if (!file.exists()) {
            this.log("File[" + file + "] not found!", 0);
            throw new BuildException("File[" + file + "] not exist!");
        }
        FileOutputStream out = null;
        try {
            PropertiesUtils p = new PropertiesUtils();
            p.loadProperties(this.filePath);
            Properties properties = p.getProperties();
            String value = p.getValue(URL_PATTERN);
            if (null == value) {
                value = "/eip";
            } else {
                int index = value.indexOf("/eip");
                if (-1 == index) {
                    value = value + ";/eip";
                }
            }
            properties.setProperty(URL_PATTERN, value);
            out = new FileOutputStream(new File(this.filePath));
            properties.store(out, null);
        }
        catch (Exception ex) {
            try {
                this.log("Modify File[" + file + "] error!" + ex.getMessage(), 0);
                throw new BuildException("Modify File[" + file + "] error!" + ex.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeOutputStreamQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeOutputStreamQuietly(out);
    }
}

