/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.standardImpl.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.app.DynamicBillBatchInsertHelper;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherInfo;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillUtil {
    private static Logger logger = Logger.getLogger(BillUtil.class);
    public static final String SOURCE_BILLID = "eipsrcid";
    public static final String OPEN_ID = "openid";
    public static final String SOURCE_ENTITYID = "srcEntity";
    private String billNumber;
    private BOSObjectType bosType;
    private IMetaDataPK metaDataPK;
    private Context ctx;
    private JSONArray arrayData;
    private StructuredDataModel dataModel;
    private CoreBillBaseCollection middleColl = new CoreBillBaseCollection();
    private String midBillTableName = null;
    private Map<String, String> srcId2MidIdMap = new HashMap<String, String>();
    private String srcEntityId = null;

    public void createDestBill(Context ctx, String billNumber, JSONArray arrayData, OpenAPIDispatcherInfo openAPIDispatcher) throws Exception {
        try {
            this.billNumber = billNumber;
            this.ctx = ctx;
            this.arrayData = arrayData;
            this.initialBillMetaData(billNumber);
            BillMappingInfo billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where number = '" + billNumber + "'");
            if (billMappingInfo == null) {
                throw new Exception("\u5bf9\u5e94\u7684\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u65b9\u6848\u7f16\u7801\u4e3a\uff1a" + billNumber);
            }
            this.dataModel = DataModelUtil.convert(billMappingInfo);
            this.createMidBills();
        }
        catch (Exception e) {
            throw new Exception(ThrowableHelper.toString(e));
        }
    }

    private void createMidBills() throws Exception {
        if (this.arrayData == null || this.arrayData.size() == 0) {
            return;
        }
        StructuredDataModel.TableModel headerModel = this.dataModel.getPriorityTables()[0];
        StructuredDataModel.ColumnModel[] headerColumns = headerModel.columns;
        JSONObject eachData = null;
        HashMap<String, String> lowerPorp = new HashMap<String, String>();
        int j = this.arrayData.size();
        for (int i = 0; i < j; ++i) {
            eachData = this.arrayData.getJSONObject(i);
            Set fieldSet = eachData.keySet();
            if (fieldSet == null) continue;
            for (String key : fieldSet) {
                lowerPorp.put(key.toLowerCase(), key);
            }
            this.srcEntityId = eachData.getString(SOURCE_ENTITYID);
            DynamicBillTemplateInfo billInfo = new DynamicBillTemplateInfo();
            billInfo.setBizDate(new Date(System.currentTimeMillis()));
            billInfo.setBOSType(this.bosType);
            billInfo.setPK(this.metaDataPK);
            billInfo.setId(BOSUuid.create((BOSObjectType)this.bosType));
            Object sourceBillId = eachData.get(lowerPorp.get(SOURCE_BILLID));
            if (sourceBillId != null) {
                billInfo.setSourceBillId(sourceBillId.toString());
                this.srcId2MidIdMap.put(billInfo.getId().toString(), sourceBillId.toString());
            }
            for (StructuredDataModel.ColumnModel colModel : headerColumns) {
                Object value = eachData.get(lowerPorp.get(colModel.name.toLowerCase()));
                billInfo.put(colModel.destName, value);
            }
            this.middleColl.add((CoreBillBaseInfo)billInfo);
        }
        try {
            this._addBatchMidBill(this.middleColl);
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u6b21\u5904\u7406\u7684\u5355\u636e(" + this.billNumber + "),\u5904\u7406\u7684\u6570\u636e\u4e3a\uff1a" + this.arrayData.toJSONString()));
            throw new DIPException("\u6570\u636e\u66f4\u65b0\u5230\u4e2d\u95f4\u8868\u5f02\u5e38:" + e.getMessage(), e);
        }
    }

    private void initialBillMetaData(String billNumber) {
        DIPMetadata dm = new DIPMetadata(billNumber);
        String fullName = dm.getHeaderEntityPK();
        this.metaDataPK = MetaDataPK.create((String)fullName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        EntityObjectInfo entity = loader.getEntity(this.metaDataPK);
        this.bosType = entity.getType();
        this.midBillTableName = DIPMetadata.getShortName(dm.getHeaderTablePK());
    }

    protected void _addBatchMidBill(CoreBillBaseCollection middleColl) throws Exception {
        DynamicBillBatchInsertHelper.prepare((Context)this.ctx, (String)this.billNumber, null);
        DynamicBillBatchInsertHelper insertHelper = DynamicBillBatchInsertHelper.getInstance();
        this.insertByNativeJDBCBatch(middleColl, insertHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertByNativeJDBCBatch(CoreBillBaseCollection middleColl, DynamicBillBatchInsertHelper insertHelper) throws SQLException, BOSException {
        Connection con = EJBFactory.getConnection((Context)this.ctx);
        PreparedStatement insertHeadStatement = null;
        PreparedStatement insertEntryStatement = null;
        try {
            insertHeadStatement = con.prepareStatement(insertHelper.getInsertHeaderSql());
            insertEntryStatement = con.prepareStatement(insertHelper.getInsertEntrySql());
            for (int i = 0; i < middleColl.size(); ++i) {
                DynamicBillTemplateInfo headInfo = (DynamicBillTemplateInfo)middleColl.get(i);
                DynamicBillTemplateEntryCollection entryColl = headInfo.getEntrys();
                insertHelper.setHeaderParameters(insertHeadStatement, headInfo);
                insertHeadStatement.addBatch();
                for (int j = 0; j < entryColl.size(); ++j) {
                    DynamicBillTemplateEntryInfo entryInfo = entryColl.get(j);
                    insertHelper.setEntryParameters(insertEntryStatement, entryInfo, j + 1);
                    insertEntryStatement.addBatch();
                }
            }
            insertHelper.updateTransmitChunked(con);
            insertHeadStatement.executeBatch();
            insertEntryStatement.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(insertEntryStatement);
            SQLUtils.cleanup((Statement)insertHeadStatement);
            SQLUtils.cleanup((Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)insertEntryStatement);
        SQLUtils.cleanup((Statement)insertHeadStatement);
        SQLUtils.cleanup((Connection)con);
    }
}

