/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.base.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.csinterface.base.cache.session.IORMRPCSessionCache;
import com.kingdee.eas.csinterface.base.cache.session.impl.ORMRPCSessionCache;
import org.apache.log4j.Logger;

public class SessionUtil {
    private static Logger logger = Logger.getLogger(SessionUtil.class);
    public static final String LICENSE_SERVER_LOCATION = "license";

    public static Context getContext() {
        return ORMRPCSessionCache.getContext();
    }

    public static Context login(String user, String password, String dataCenter, String language, String solution, String userAuthPattern) throws BOSException {
        Context ctx = SessionUtil.getORMRPCBosObject()._login(user, password, dataCenter, language, solution, userAuthPattern);
        ORMRPCSessionCache.setContext(ctx);
        return ctx;
    }

    public static Context loginLocal(String user, String password, String dataCenter, String language, String solution, String userAuthPattern) throws BOSException {
        Context ctx = new ORMRPCSessionCache()._login(user, password, dataCenter, language, solution, userAuthPattern);
        ORMRPCSessionCache.setContext(ctx);
        return ctx;
    }

    public static String getTokenId(String user, String password, String dataCenter, String language, String solution, String userAuthPattern) throws BOSException {
        return SessionUtil.getORMRPCBosObject()._getTokenId(user, password, dataCenter, language, solution, userAuthPattern);
    }

    public static Context getContextBySession(String sessionId) throws BOSException {
        Context ctx = SessionUtil.getORMRPCBosObject()._getContextBySession(sessionId);
        ORMRPCSessionCache.setContext(ctx);
        return ctx;
    }

    public static Context getContextByToken(String tokenId) throws BOSException {
        tokenId = tokenId.replaceAll(" ", "+");
        Context ctx = SessionUtil.getORMRPCBosObject()._getContextByToken(tokenId);
        ORMRPCSessionCache.setContext(ctx);
        return ctx;
    }

    private static String getORMRPCServerURL() throws BOSException {
        ORMServiceLocation loc = new ORMServiceLocation(LICENSE_SERVER_LOCATION);
        try {
            return loc.getServiceURL();
        }
        catch (Exception err) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!", (Throwable)err);
        }
    }

    private static IORMRPCSessionCache getORMRPCBosObject() throws BOSException {
        String url = SessionUtil.getORMRPCServerURL();
        ORMRPCSessionCache bosObject = null;
        bosObject = url == null || url.trim().equals("") || url.equalsIgnoreCase("tcp://127.0.0.1") ? new ORMRPCSessionCache() : RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.csinterface.base.cache.session.impl.ORMRPCSessionCache", IORMRPCSessionCache.class);
        return bosObject;
    }
}

