/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboBoxMultiColumnItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractAllTableRelationEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynLaunchedEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.TableRelation;
import com.kingdee.eas.csinterface.basedatasyn.client.TableRelationNeedUI;
import com.kingdee.eas.csinterface.syncdatabase.client.BDRMappingGroupEditUI;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class AllTableRelationEditUI
extends AbstractAllTableRelationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AllTableRelationEditUI.class);
    private String mainTable = "";
    private List<String> allTableList = new ArrayList<String>();
    private TableRelationNeedUI parentUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.kDTable.checkParsed();
        Object obj = this.getUIContext().get("Owner");
        if (obj != null && obj instanceof TableRelationNeedUI) {
            this.parentUI = (TableRelationNeedUI)obj;
        } else if (obj != null && obj instanceof BaseDataSynLaunchedEditUI) {
            this.parentUI = (BaseDataSynLaunchedEditUI)obj;
        }
        this.initTable();
        super.onLoad();
        this.kDTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopping(KDTEditEvent e) {
                if (e.getColIndex() == 2) {
                    AllTableRelationEditUI.this.initColumn(e.getValue() + "", e.getRowIndex());
                }
            }
        });
        if (this.parentUI instanceof BDRMappingGroupEditUI) {
            MyKDTableUtil.setColumnLocked(this.kDTable, "relateField");
            MyKDTableUtil.setColumnLockedBackground(this.kDTable, "relateField");
        }
    }

    public void initTable() throws ParserException, BOSException {
        KDComboBox comboBox = new KDComboBox();
        comboBox.setRequired(true);
        List<String> tableList = this.parentUI.getAllTables();
        for (int i = 0; i < tableList.size(); ++i) {
            comboBox.addItem((Object)new KDComboBoxMultiColumnItem(new String[]{tableList.get(i)}));
        }
        IColumn destIDColumn = this.kDTable.getColumn("relateTable");
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)comboBox);
        destIDColumn.setEditor((ICellEditor)editor);
    }

    public void initSelfField() throws ParserException, BOSException {
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            KDComboBox comboBox = new KDComboBox();
            comboBox.setRequired(true);
            String tableName = this.kDTable.getCell(i, "tableName").getValue().toString();
            ICell selfField = this.kDTable.getCell(i, "selfField");
            List<String> columnList = this.parentUI.getTableColumns(tableName);
            Object value = selfField.getValue();
            int valueIndex = 0;
            for (int j = 0; j < columnList.size(); ++j) {
                String colValue = columnList.get(j);
                if (value != null && colValue.equalsIgnoreCase(value.toString())) {
                    valueIndex = j;
                }
                comboBox.addItem((Object)new KDComboBoxMultiColumnItem(new String[]{colValue}));
            }
            comboBox.setSelectedIndex(valueIndex);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            selfField.setEditor((ICellEditor)editor);
        }
    }

    public void initRelateTable(ICell relateCell, String self) throws ParserException, BOSException {
        KDComboBox comboBox = new KDComboBox();
        comboBox.setRequired(true);
        List<String> tableList = this.parentUI.getAllTables();
        tableList.remove(self);
        for (int i = 0; i < tableList.size(); ++i) {
            comboBox.addItem((Object)new KDComboBoxMultiColumnItem(new String[]{tableList.get(i)}));
        }
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)comboBox);
        relateCell.setEditor((ICellEditor)editor);
    }

    public void initColumn(String tableName, int rowIndex) {
        ICell cell = null;
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = this.kDTable.getCell(rowIndex, "tableName").getValue().toString();
            cell = this.kDTable.getCell(rowIndex, "selfField");
        } else {
            cell = this.kDTable.getCell(rowIndex, "relateField");
        }
        List<String> columnList = this.parentUI.getTableColumns(tableName);
        KDComboBox comboBox = new KDComboBox();
        Object value = cell.getValue();
        int valueIndex = 0;
        for (int i = 0; i < columnList.size(); ++i) {
            String colValue = columnList.get(i);
            if (value != null && colValue.equalsIgnoreCase(value.toString())) {
                valueIndex = i;
            }
            comboBox.addItem((Object)new KDComboBoxMultiColumnItem(new String[]{colValue}));
        }
        comboBox.adjustDimension();
        comboBox.setRequired(true);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)comboBox);
        cell.setValue((Object)"");
        cell.setEditor((ICellEditor)editor);
        comboBox.setSelectedIndex(valueIndex);
        if (this.parentUI instanceof BDRMappingGroupEditUI) {
            String field = ((BDRMappingGroupEditUI)((Object)this.parentUI)).getRelateFiledByNumber(tableName);
            cell.setValue((Object)field);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        Object obj = this.getUIContext().get("Owner");
        if (obj != null && obj instanceof TableRelationNeedUI) {
            TableRelationNeedUI editUI;
            this.parentUI = editUI = (TableRelationNeedUI)obj;
            int lockRow = editUI.getMainTableRowIndex();
            List<TableRelation> list = editUI.getAllTablesNow(editUI.getKDTable());
            for (int i = 0; i < list.size(); ++i) {
                TableRelation relate = list.get(i);
                IRow row = this.kDTable.addRow();
                ICell selfTable = row.getCell("tableName");
                ICell selfField = row.getCell("selfField");
                ICell relateTable = row.getCell("relateTable");
                ICell relateField = row.getCell("relateField");
                this.allTableList.add(relate.getSelfTable());
                selfTable.setValue((Object)relate.getSelfTable());
                selfField.setValue((Object)relate.getSelfField());
                relateTable.setValue((Object)relate.getRelateTable());
                relateField.setValue((Object)relate.getRelateField());
                row.setUserObject((Object)relate);
                this.lockCell(selfTable);
                if (i == lockRow) {
                    this.mainTable = selfTable.getValue().toString();
                    this.lockCell(selfField);
                    this.lockCell(relateTable);
                    this.lockCell(relateField);
                    selfField.setValue((Object)"");
                    relateTable.setValue((Object)"");
                    relateField.setValue((Object)"");
                }
                this.initRelateTable(relateTable, relate.getSelfTable());
            }
        }
        this.initSelfField();
    }

    private void lockCell(ICell cell) {
        cell.getStyleAttributes().setLocked(true);
        cell.getStyleAttributes().setBackground(MyKDTableUtil.LOCKED_BACKGROUND_COLOR);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String relateMainTableSQL = " where " + this.mainTable + ".FID in( ${fid} ) ";
        Object obj = this.getUIContext().get("Owner");
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> tableRelateMap = new HashMap<String, String>();
        TreeMap<String, TableRelation> tableEntityMap = new TreeMap<String, TableRelation>();
        int rowCount = this.kDTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kDTable.getRow(i);
            TableRelation relation = (TableRelation)row.getUserObject();
            Object selfTable = row.getCell("tableName");
            ICell selfField = row.getCell("selfField");
            ICell relateTable = row.getCell("relateTable");
            ICell relateField = row.getCell("relateField");
            relation.setSelfField(this.trimObject(selfField.getValue()));
            relation.setRelateTable(this.trimObject(relateTable.getValue()));
            relation.setRelateField(this.trimObject(relateField.getValue()));
            if (!StringUtils.equals((String)this.mainTable, (String)this.trimObject(selfTable.getValue()))) {
                relation.setSql(this.createOne2OneSQL(relation));
            }
            list.add(relation);
            tableRelateMap.put(relation.getSelfTable(), relation.getRelateTable());
            tableEntityMap.put(relation.getSelfTable(), relation);
        }
        HashMap<ICell, Integer> tableLevelMap = new HashMap<ICell, Integer>();
        block1: for (int i = 0; i < rowCount; ++i) {
            for (Object selfTable : tableRelateMap.keySet()) {
                String relateTable = (String)tableRelateMap.get(selfTable);
                TableRelation relation = (TableRelation)tableEntityMap.get(selfTable);
                if (StringUtils.equals((String)selfTable, (String)this.mainTable)) {
                    relation.setLevel(0);
                    tableLevelMap.put((ICell)selfTable, 0);
                } else if (StringUtils.equals((String)relateTable, (String)this.mainTable)) {
                    relation.setLevel(1);
                    tableLevelMap.put((ICell)selfTable, 1);
                } else if (tableLevelMap.containsKey(relateTable)) {
                    relation.setLevel((Integer)tableLevelMap.get(relateTable) + 1);
                    if (!tableLevelMap.containsKey(selfTable)) {
                        tableLevelMap.put((ICell)selfTable, (Integer)tableLevelMap.get(relateTable) + 1);
                        relation.setSql(relation.getSql() + ((TableRelation)tableEntityMap.get(relateTable)).getSql());
                    }
                }
                if (tableLevelMap.size() != rowCount) continue;
                continue block1;
            }
        }
        for (String selfTable : tableRelateMap.keySet()) {
            TableRelation relation = (TableRelation)tableEntityMap.get(selfTable);
            if (tableLevelMap.get(selfTable) == null) {
                MsgBox.showInfo((String)(selfTable + "\u914d\u7f6e\u7684\u5173\u8054\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002"));
                SysUtil.abort();
            }
            if (Integer.valueOf((Integer)tableLevelMap.get(selfTable)) == 0) continue;
            relation.setSql(relation.getSql() + relateMainTableSQL);
        }
        if (obj != null && obj instanceof TableRelationNeedUI) {
            TableRelationNeedUI editUI = (TableRelationNeedUI)obj;
            editUI.setEntity2Table(tableEntityMap);
        }
        super.destroyWindow();
    }

    public String createOne2OneSQL(TableRelation relation) {
        String sql = " inner join " + relation.getRelateTable() + " on " + relation.getSelfTable() + "." + relation.getSelfField() + " = " + relation.getRelateTable() + "." + relation.relateField + " ";
        return sql;
    }

    public String trimObject(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

