/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureFactory;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractTableNameEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.AllTableListUI;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.ComponentHelper;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.csinterface.utils.IKSQLFacade;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class TableNameEditUI
extends AbstractTableNameEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TableNameEditUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ComponentHelper.setVisible(new JComponent[]{this.btnAddNew, this.btnEdit, this.btnCopy, this.btnRemove, this.btnAttachment, this.btnFirst, this.btnPre, this.btnNext, this.btnLast, this.btnPrint, this.btnPrintPreview, this.btnSave, this.btnCancelCancel, this.btnCancel}, false);
        this.kdtEntrys.checkParsed();
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys == null) {
            return;
        }
        if (this.kdtEntrys.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.kdtEntrys.getSelectManager().get().getTop();
        if (this.kdtEntrys.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)this.kdtEntrys.getRow(top).getUserObject();
        this.kdtEntrys.removeRow(top);
        IObjectCollection collection = (IObjectCollection)this.kdtEntrys.getUserObject();
        if (collection == null) {
            logger.error((Object)"collection not be binded to table");
        } else if (detailData != null) {
            collection.removeObject(top);
        }
    }

    @Override
    protected void chose_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, TableNameEditUI> uiContext = new HashMap<String, TableNameEditUI>();
        uiContext.put("Owner", this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AllTableListUI.class.getName(), uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e1) {
            e1.printStackTrace();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Map uiContext = this.getUIContext();
        DataSourceType dsType = (DataSourceType)((Object)uiContext.get("dsType"));
        ConnectionInfo conn = (ConnectionInfo)uiContext.get("conn");
        EipUserInfo agent = (EipUserInfo)uiContext.get("agent");
        HashSet<String> tableNames = new HashSet<String>();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            ICell cell = this.kdtEntrys.getRow(i).getCell("TableName");
            String tableName = (String)cell.getValue();
            tableNames.add(tableName.trim());
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            this.destroyWindow();
            this.obtainTables(conn, tableNames, (Component)uiContext.get("Owner"));
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            DBType destDBType = DBType.getEnum(agent.getDBType());
            DataTypeConverter converter = DataTypeConverter.getConverter(destDBType);
            String sql = converter.getColumnDefinedSql("?");
            IKSQLFacade ksqlFacade = (IKSQLFacade)RpcProxy.wrapRequired(IKSQLFacade.class, (String)"com.kingdee.eas.csinterface.utils.KSQLFacade");
            String msg = ksqlFacade.obtainTableAssignToAgent(agent, sql, tableNames);
            if (!StringUtils.isEmpty((String)msg)) {
                MsgBox.showWarning((String)msg);
            } else {
                MsgBox.showInfo((String)("\u4efb\u52a1\u5df2\u6210\u529f\u5206\u914d\u7ed9\u5ba2\u6237\u4ee3\u7406'" + agent.getNumber() + "'"));
            }
            this.destroyWindow();
        }
    }

    private void obtainTables(ConnectionInfo connectionInfo, final Set<String> tableNames, final Component component) throws Exception {
        final ConnectionInfo conn = connectionInfo;
        if (conn == null) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5");
            SysUtil.abort();
        }
        if (tableNames == null || tableNames.isEmpty()) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u83b7\u53d6\u7684\u8868\u540d");
            SysUtil.abort();
        }
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u5904\u7406\u66f4\u65b0\u4e2d", "\u8bf7\u7a0d\u540e");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;
            String excMsg = "";
            StringBuilder error = new StringBuilder();

            @Override
            public Object exec() throws Exception {
                try {
                    int sum = tableNames.size();
                    int i = 0;
                    for (String tableName : tableNames) {
                        dialog.updateMsg("\u6b63\u5728\u6267\u884c\u66f4\u65b0(" + (i + 1) + "/" + sum + ")  \u8868:" + tableName);
                        try {
                            TableStructureFactory.getRemoteInstance().getColumnsByInfo(tableName, conn);
                        }
                        catch (Exception e) {
                            this.error.append("\u8868" + tableName + "\u66f4\u65b0\u5931\u8d25:" + e.getMessage());
                        }
                        ++i;
                    }
                    return "success";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.exception = e;
                    return this.excMsg;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (!StringUtils.isEmpty((String)this.error.toString())) {
                    Exception ca = new Exception(this.error.toString());
                    MsgBox.showDetailAndOK((Component)component, (String)"\u90e8\u5206\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)ca), (int)1);
                } else {
                    MsgBox.showInfo((String)"\u6267\u884c\u6210\u529f");
                }
            }
        });
        dialog.show();
    }
}

