/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynHead;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PlanLevelUtil {
    public static final int PLAN_MAX_LEVEL = 2;

    public static void updatePlanLevel(BaseDataSynHeadInfo headInfo, KDTable kdtEntrys) throws Exception {
        PlanLevelUtil.checkSelfLevel(headInfo, kdtEntrys);
    }

    public static void checkSelfLevel(BaseDataSynHeadInfo headInfo, KDTable kdtEntrys) throws Exception {
        int nowLevel = headInfo.getPlanLevel() == 0 ? 1 : headInfo.getPlanLevel();
        Map<String, String[]> parentPlan = PlanLevelUtil.getParentNum(headInfo);
        BaseDataSynHeadInfo subPlan = null;
        for (int i = 0; i < kdtEntrys.getRowCount(); ++i) {
            ICell planIdCell = kdtEntrys.getCell(i, "planId");
            String subPlanId = planIdCell.getValue().toString();
            subPlan = BaseDataSynHeadFactory.getRemoteInstance().getBaseDataSynHeadInfo(CommonUtil.convert2PK(subPlanId));
            int subLevel = subPlan.getPlanLevel() + 1;
            if (subLevel > 1 && parentPlan.size() > 0) {
                String parentNum = StringUtils.arrayToString((Object[])parentPlan.get("number"), (String)",");
                MsgBox.showInfo((String)("\u65b9\u6848\u5df2\u88ab\u7ec4\u5408\u65b9\u6848\u3010" + parentNum + "\u3011\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5c42\u7ea7\u4e3a1\u7684\u7ec4\u5408\u65b9\u6848\u3010" + subPlan.getNumber() + "\u3011\u3002"));
                SysUtil.abort();
            }
            if (subLevel <= nowLevel) continue;
            headInfo.setPlanLevel(subLevel);
        }
        headInfo.setPlanLevel(headInfo.getPlanLevel() < 1 ? 1 : headInfo.getPlanLevel());
    }

    private static void updateParentPlanLevel(String[] parentIds, int selfLevel) throws BOSException, EASBizException {
        IBaseDataSynHead instance = BaseDataSynHeadFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtils.arrayToString((Object[])parentIds, (String)","), CompareType.INCLUDE));
        CoreBaseCollection colls = instance.getCollection(viewInfo);
        for (BaseDataSynHeadInfo plan : colls) {
            plan.setPlanLevel(selfLevel + 1);
        }
        instance.update(colls);
    }

    public static Map<String, String[]> getParentNum(BaseDataSynHeadInfo headInfo) throws Exception {
        BaseDataSynSubPlanCollection coll;
        HashMap<String, String[]> parentPlan = new HashMap<String, String[]>();
        if (headInfo.getId() != null && (coll = BaseDataSynSubPlanFactory.getRemoteInstance().getBaseDataSynSubPlanCollection("where subPlanId = '" + headInfo.getId().toString() + "'")).size() > 0) {
            String[] parentIds = new String[coll.size()];
            String[] parentNums = new String[coll.size()];
            int index = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                BaseDataSynSubPlanInfo subPlan = (BaseDataSynSubPlanInfo)it.next();
                BaseDataSynHeadInfo parent = BaseDataSynHeadFactory.getRemoteInstance().getBaseDataSynHeadInfo(CommonUtil.convert2PK(subPlan.getParent().getId().toString()));
                parentIds[index++] = parent.getId().toString();
                parentNums[index++] = parent.getNumber();
            }
            parentPlan.put("id", parentIds);
            parentPlan.put("number", parentNums);
        }
        return parentPlan;
    }
}

